<?php

namespace App\Http\Controllers\BackOffice\Currency;

use App\Http\Controllers\ApiController;
use App\Models\Curdt;
use App\Models\currency;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class CurrencyController extends ApiController
{
    public function fetchCurrency(Request $request)
    {
        $currency = DB::table('currency')
            ->select('currency.currency_code', 'currency.currency_name',
                'currency.currency_id',
                DB::raw("DATE_FORMAT((SELECT MAX(Curdt_date) FROM curdt WHERE Currency_code=currency.currency_code),'%Y-%m-%d') AS date"),
                DB::raw("(SELECT  Curdt_rate AS rate FROM curdt WHERE Currency_code=currency.currency_code AND
        Curdt_date= DATE LIMIT 1) AS rate"),
        )
            ->orderBy('currency.currency_code')
            ->get();
        return ApiController::successResponse($currency, 200);
    }


    public function insertCurrency(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'currencyCode' => 'required',
            'currencyName' => 'required',

        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $checkCurrencyExistance = currency::where(
            [
                ['currency_code', '=', $request->currencyCode]
            ])
            ->first();
        if ($checkCurrencyExistance) {
            return ApiController::errorResponse('codeExist', 409);
        }
        $currency = array(
            'currency_code' => $request->currencyCode,
            'currency_name' => $request->currencyName,

        );
        $newCurrency = currency::create($currency);
        if ($newCurrency) {
            return ApiController::successResponse($newCurrency, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }


    public function updateCurrency(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'currencyCode' => 'required',
            'currencyName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $checkCurrencyExistance = Currency::where(
            [
                ['currency_code', '=', $request->currencyCode],
                ['currency_id', '!=', $request->currencyId],
            ])
            ->first();

        if ($checkCurrencyExistance) {
            return ApiController::errorResponse('codeExist', 409);
        }

        $currency = array(
            'currency_code' => $request->currencyCode,
            'currency_name' => $request->currencyName,

        );

        $updateCurrency = currency::where('currency_id', $request->currencyId)->update($currency);
        if ($updateCurrency) {
            return ApiController::successResponse($updateCurrency, 200);
        }
        return ApiController::errorResponse('no update', 200);
    }


    public function removeCurrency(Request $request)
    {
        $removeCurrency = currency::where('currency_id', '=', $request->currencyId)->delete();
        if ($removeCurrency)
            return ApiController::successResponse($removeCurrency, 200);
        else
            return ApiController::errorResponse('currrencyUsed', 409);
    }


    public function fetchCurrencyDt(Request $request)
    {
        $currency = DB::table('curdt')
            ->where('curdt.Currency_code', '=', $request->currencyCode)
            //->whereBetween('Curdt_date',[$request->fromDate." 00:00:00",$request->toDate." 23:59:59"])
            ->select('curdt.Currency_code', 'curdt.Curdt_rate',
                'curdt.Curdt_parity', 'curdt.curdt_id',
                DB::raw("DATE_FORMAT(curdt.Curdt_date,'%Y-%m-%d') AS Curdt_date"))
            ->orderBy('curdt.Curdt_date', 'DESC')
            ->get();
        return ApiController::successResponse($currency, 200);
    }


    public function updateCurrencyDt(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'currencyCode' => 'required',
            'currencyDtDate' => 'required',
            "currencyDtRate" => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $checkCurrencyExistance = Curdt::where(
            [
                ['Currency_code', '=', $request->currencyCode],
                ['curdt_id', '!=', $request->currencyDtId],
            ])
            ->whereBetween('Curdt_date', [$request->currencyDtDate . " 00:00:00", $request->currencyDtDate . " 23:59:59"])
            ->first();
        if ($checkCurrencyExistance) {
            return ApiController::errorResponse('rateExist', 409);
        }
        $currencydt = array(
            'Currency_code' => $request->currencyCode,
            'Curdt_date' => $request->currencyDtDate,
            'Curdt_rate' => $request->currencyDtRate,
            'currency_id' => $request->currencyId,
        );
        $newCurrencyDt = Curdt::where(
            [
                ['curdt_id', '=', $request->currencyDtId],

            ])
            ->update($currencydt);
        if ($newCurrencyDt) {
            return ApiController::successResponse($newCurrencyDt, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }


    public function insertCurrencyDt(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'currencyCode' => 'required',
            'currencyDtDate' => 'required',
            "currencyDtRate" => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $checkCurrencyExistance = Curdt::where(
            [
                ['Currency_code', '=', $request->currencyCode],

            ])
            ->whereBetween('Curdt_date', [$request->currencyDtDate . " 00:00:00", $request->currencyDtDate . " 23:59:59"])
            ->first();
        if ($checkCurrencyExistance) {
            return ApiController::errorResponse('rateExist', 409);
        }
        $currencydt = array(
            'Currency_code' => $request->currencyCode,
            'Curdt_date' => $request->currencyDtDate,
            'Curdt_rate' => $request->currencyDtRate,
            'currency_id' => $request->currencyId,
        );
        $newCurrencyDt = Curdt::create($currencydt);

        return ApiController::successResponse($newCurrencyDt, 200);

        return ApiController::errorResponse($validator->errors(), 422);
    }


    public function removeCurrencyDt(Request $request)
    {
        $removeCurrencyDt = Curdt::where('curdt_id', '=', $request->currencyDtId)->delete();
        if ($removeCurrencyDt)
            return ApiController::successResponse($removeCurrencyDt, 200);
        else
            return ApiController::errorResponse('currrencyRateUsed', 409);
    }
}
