<?php

namespace App\Http\Controllers\BackOffice\GoodsIn;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\items;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use File;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use Illuminate\Support\Facades\Log;

class GoodsInFunctions extends ApiController
{
    public function getOriginalTransactionExistance($transactionTmpId)
    {
        return transactions::where('transaction_id', '=', $transactionTmpId)->first();
    }

    public function getCurrentTransaction($transactionTmpId)
    {
        return transactiontmp::where('transactiontmp_id', '=', $transactionTmpId)->first();
    }

    public function updateTransactionDts($getCurrentTransaction, $transactionTmp, $transactionTmpId)
    {
        // if ($getCurrentTransaction?->transactiontmp_rate != $transactionTmp['transactiontmp_rate']) {
        $transactionDts = transactiondttmp::where('transactiontmp_id', '=', $transactionTmpId)->get();

        $transactionDtsToUpdate = [];
        foreach ($transactionDts as $transactionDt) {
            $transactionDtsToUpdate[] = $transactionDt->transactiondttmp_id;
        }

        if (!empty($transactionDtsToUpdate)) {
            transactiondttmp::whereIn('transactiondttmp_id', $transactionDtsToUpdate)->update([
                "transactiondttmp_priceBase" => DB::raw("transactiondttmp_price * {$transactionTmp['transactiontmp_rate']}"),
                "client_id" => $transactionTmp['transactiontmp_clientId']

            ]);
        }
        //  }
    }

    public function updateOrCreateTransactionTmp($transactionTmpId, $transactionTmp)
    {
        return transactiontmp::updateOrCreate(
            ['transactiontmp_id' => $transactionTmpId],
            $transactionTmp
        );
    }

    public function getTransactionTmpAfterUpdate($updatedTransactionTmp)
    {
        return transactiontmp::where('transactiontmp_id', '=', $updatedTransactionTmp->transactiontmp_id)->first();
    }

    public function updateTransactionDttmp($transactionTmpAfterUpdate)
    {
        if ($transactionTmpAfterUpdate['transactiontmp_type'] == 'GOODS_IN' || $transactionTmpAfterUpdate['transactiontmp_type'] == 'RMA_IN') {
            transactiondttmp::where('transactiontmp_id', '=', $transactionTmpAfterUpdate->transactiontmp_id)->update([
                "transactiontmpdt_billOfEntry" => $transactionTmpAfterUpdate->transactiontmp_billOfEntry,
                "transactiontmpdt_BOE" => $transactionTmpAfterUpdate->transactiontmp_BOE,
                "supplier_invoice_number" => $transactionTmpAfterUpdate->transactiontmp_supplierInvoice,
                "supplier_id" => $transactionTmpAfterUpdate->transactiontmp_supplierId,

            ]);
        }
    }

    public function checkBOEDECEXist($transactionTmpId, $transactionTmp)
    {

        $BEC = $transactionTmp['transactiontmp_billOfEntry'];
        $BOE = $transactionTmp['transactiontmp_BOE'];

        if ($BEC || $BOE != '-') {
            $checkDECtmp = transactiontmp::where(function ($query) use ($BEC) {
                $query->Where([
                    ['transactiontmp_billOfEntry', $BEC],
                    ['transactiontmp_billOfEntry', '!=', null],
                    ['transactiontmp_type', 'GOODS_IN']
                ])
                    ->orwhere(
                        [
                            ['transactiontmp_billOfEntry', $BEC],
                            ['transactiontmp_billOfEntry', '!=', null],
                            ['transactiontmp_type', 'RMA_IN']
                        ]

                    );
            });

            $checkBOEtmp = transactiontmp::where(function ($query) use ($BEC, $BOE) {
                $query->Where([
                    ['transactiontmp_BOE', $BOE],
                    ['transactiontmp_BOE', '!=', transactions::emptyBoe],
                    ['transactiontmp_BOE', '!=', null],

                    ['transactiontmp_type', 'GOODS_IN']
                ])
                    ->orwhere(
                        [
                            ['transactiontmp_BOE', $BOE],
                            ['transactiontmp_BOE', '!=', transactions::emptyBoe],
                            ['transactiontmp_type', 'RMA_IN'],
                            ['transactiontmp_BOE', '!=', null],

                        ]

                    );
            });


            $checkDEC = transactions::where(function ($query) use ($BEC) {
                $query->Where([
                    ['transaction_billOfEntry', $BEC],
                    ['transaction_type', 'GOODS_IN']
                ])
                    ->orwhere(
                        [
                            ['transaction_billOfEntry', $BEC],
                            ['transaction_type', 'RMA_IN']
                        ]
                    );
            });

            $checkBOE = transactions::where(function ($query) use ($BEC, $BOE) {
                $query->Where([
                    ['transaction_BOE', $BOE],
                    ['transaction_type', 'GOODS_IN'],
                    ['transaction_BOE', '!=', transactions::emptyBoe],
                    ['transaction_BOE', '!=', null],
                ])
                    ->orwhere(
                        [
                            ['transaction_BOE', $BOE],
                            ['transaction_type', 'RMA_IN'],
                            ['transaction_BOE', '!=', null],
                        ]
                    );
            });

            $checkDECtmp = $checkDECtmp->when($transactionTmpId, function ($query) use ($transactionTmpId) {
                return $query->where('transactiontmp_id', '!=', $transactionTmpId);
            })->first();

            $checkBOEtmp = $checkBOEtmp->when($transactionTmpId, function ($query) use ($transactionTmpId) {
                return $query->where('transactiontmp_id', '!=', $transactionTmpId);
            })->first();
            $checkDEC = $checkDEC->when($transactionTmpId, function ($query) use ($transactionTmpId) {
                return $query->where('transaction_id', '!=', $transactionTmpId);
            })->first();
            $checkBOE = $checkBOE->when($transactionTmpId, function ($query) use ($transactionTmpId) {
                return $query->where('transaction_id', '!=', $transactionTmpId);
            })->first();

            if ($checkDECtmp || $checkDEC) {
                return ApiController::errorResponse('DECExist', 422);
            }

            if ($checkBOEtmp || $checkBOE) {
                return ApiController::errorResponse('BOEExist', 422);
            }
        }

        return ApiController::successResponse('Access', 200);
    }

    public function prepareTransactionDtTmp($getBillOfEntryInCaseOfGoodsIn, $element, $goodsInBillOfEntry, $transactionTmpId, $item)
    {
        $utilitiesController = new UtilitiesController();
        $element = $utilitiesController->checkGoodsInDetailsModules($element);
        if(isset($element['itemQtyPerPack'])){
            $itemQtyPerPack = $element['itemQtyPerPack'];
        }else{
            $itemQtyPerPack = items::where('item_id',$item)->first()->item_qtyPerPack;
        }
      

        $grossWeight = isset($element['transactiondttmpItemWeight']) ? $element['transactiondttmpItemWeight'] : 0;
        $totalGrossWeight = isset($element['transactionDetailItemTotalWeight']) ? $element['transactionDetailItemTotalWeight'] : 0;
        if (isset($element['transactionDetailItemTotalGrossWeight']) && $utilitiesController->grossWeightModule()===1 && $element['transactionDetailItemQty'] > 0) {
            $grossWeight = $element['transactionDetailItemTotalGrossWeight'] / $element['transactionDetailItemQty'];
            $totalGrossWeight = isset($element['transactionDetailItemTotalGrossWeight']) ? $element['transactionDetailItemTotalGrossWeight'] : '0';
        }

        return [
            'transactiontmp_id' => $transactionTmpId,
            'transactiontmpdt_BOE' => $getBillOfEntryInCaseOfGoodsIn->transactiontmp_BOE,
            'item_id' => $item,
            'group_id' => isset($element['itemGroup']) ? $element['itemGroup'] : null,
            'transactiondt_item_description' => isset($element['transactionDetailItemDesc']) ? $element['transactionDetailItemDesc'] : null,
            'item_quantity' => $element['transactionDetailItemQty'],
            'transactiontmpdt_billOfEntry' => isset($element['DEC']) ? $element['DEC'] : $goodsInBillOfEntry,
            'transactiondttmp_locationid' => isset($element['transactionDetailLocation']) ? $element['transactionDetailLocation'] : null,
            'transactiondttmp_countryOfOrigin' => $element['transactionDetailCountryOfOrigin'],
            'transactiondttmp_price' => isset($element['transactiondttmpPrice']) ? $element['transactiondttmpPrice'] : 0,
            'transactiondttmp_priceBase' => $getBillOfEntryInCaseOfGoodsIn->transactiontmp_rate != 1 ? $element['transactiondttmpPriceBase'] : $element['transactiondttmpPrice'],
            'id_reference_dt' => isset($element['idReferenceDt']) ? $element['idReferenceDt'] : null,
            'raw_in_grid' => isset($element['rawInGrid']) ? $element['rawInGrid'] : null,
            'palet_no' => isset($element['paletNo']) ? $element['paletNo'] : null,
            'item_weight' => isset($element['transactiondttmpItemWeight']) ? $element['transactiondttmpItemWeight'] : 0,
            'item_qtyPerPack' => $itemQtyPerPack,
            'item_pack' => isset($element['itemPack']) ? $element['itemPack'] : " ",
            'transactiondttmp_nbOfCarton' => isset($element['transactiondttmp_nbOfCarton']) ? $element['transactiondttmp_nbOfCarton'] : 0,
            'transactiondttmp_cellMerge' => isset($element['transactiondt_cellMerge']) ? $element['transactiondt_cellMerge'] : " ",
            'item_unit' => isset($element['itemUnit']) ? $element['itemUnit'] : null,
            'client_id' => $getBillOfEntryInCaseOfGoodsIn ? $getBillOfEntryInCaseOfGoodsIn->transactiontmp_clientId : null,
            'transactiondttmp_fprice' => isset($element['transactionDetailFinalPrice']) ? $element['transactionDetailFinalPrice'] : 0,
            'transactiondttmp_fpriceBase' => isset($element['transactionDetailFinalPrice']) ? $element['transactionDetailFinalPrice'] : 0,
            'hscode' => isset($element['transactionDetailItemHsCode']) ? $element['transactionDetailItemHsCode'] : null,
            'supplier_invoice_number' => isset($getBillOfEntryInCaseOfGoodsIn->transactiontmp_supplierInvoice) ? $getBillOfEntryInCaseOfGoodsIn->transactiontmp_supplierInvoice : null,
            'total_price' => isset($element['transactionDetailItemTotalPrice']) ? $element['transactionDetailItemTotalPrice'] : 0,
            'total_weight' => isset($element['transactionDetailItemTotalWeight']) ? $element['transactionDetailItemTotalWeight'] : 0,

            'item_pack' => isset($element['transactionDetailItemPack']) ? $element['transactionDetailItemPack'] : '-',


            'state' => 'updated',
            'supplier_id' => isset($getBillOfEntryInCaseOfGoodsIn->transactiontmp_supplierId) ? $getBillOfEntryInCaseOfGoodsIn->transactiontmp_supplierId : null,
            'dt_transaction_type' => isset($element['type']) ? $element['type'] : 'GOODS_IN',
            'total_gross_weight' => $totalGrossWeight,
            'gross_weight' => $grossWeight,



        ];
    }

    public function getTransactionDetailsTmp($transactionTmpId)
    {
        return transactiondttmp::join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
            ->leftjoin('client_suppliers', 'client_suppliers.supplier_id', '=', 'transactiondttmps.supplier_id')
            ->select(
                'client_items.item_barcode',
                'client_suppliers.supplier_name',
                'transactiondttmps.item_quantity',
                'transactiondttmps.supplier_invoice_number',
                'transactiondttmps.item_price',
                'transactiondttmps.item_id',
                'transactiondttmps.supplier_id',
                'transactiontmp_id',
                'transactiondttmp_id',
                'client_items.item_code',
                'client_items.item_description',
                'transactiondttmps.transactiontmpdt_billOfEntry',
                'transactiondttmps.transactiontmpdt_BOE',

                'transactiondttmps.transactiondttmp_locationid',
                'transactiondttmps.transactiondttmp_countryOfOrigin',
                'client_items.item_hasSerial',
                'transactiondttmps.item_weight',
                'transactiondttmps.transactiondttmp_price',
                'transactiondttmps.id_reference_dt',
                'transactiondttmps.raw_in_grid'
            )
            ->where('transactiontmp_id', '=', $transactionTmpId)
            ->get();
    }
}
