<?php

namespace App\Http\Controllers\mobile\Delivery;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\client;
use App\Models\companies;
use App\Models\SetUp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;

class DeliveryController extends ApiController
{

    public function fetchDeliveryOrders(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        $company = DB::table('companies')
            ->first();
        $isShipment = $company->company_onlyShipment;
        $limit = $request->limit;
        $page = $request->page;

        $client_id = client::where('user_id', $user_id)->first()->client_id;

        $itemsCount = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->join('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->where([
                ['transaction_dts.client_id', '=', $client_id],
                ['transaction_type', '=', 'DO'],
            ]);

        if ($request->onlyMobile == true) {
            $itemsCount->where('transaction_mobileReference', '!=', null);
        }
        $itemsCount = $itemsCount
            ->groupBy('transaction_dts.transaction_id')
            ->get()
            ->count();




        $items = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')

            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->join('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->where([
                ['transaction_dts.client_id', '=', $client_id],
                ['transaction_type', '=', 'DO'],
            ])
            ->select('transactions.*', 'client_customers.*', 'currency.*', 'transaction_arrived as transaction_status', 'transaction_dts.*')
            ->when($isShipment == 1, function ($query) {
                return $query->where('transaction_released', 1);
            })
            ->selectRaw("(case when $isShipment THEN (null) else (transaction_date*1) END ) as transaction_date")

            ->selectRaw("(case when (transaction_mobileReference) is null THEN ('-')
        else (transaction_mobileReference) END ) as transaction_mobileReference")
            ->selectRaw("(case when (transaction_remark) is null THEN ('-')
        else (transaction_remark) END ) as transaction_remark")
            ->groupBy('transaction_dts.transaction_id')
            ->orderBy('transactions.transaction_date', 'desc')
            ->limit($limit)
            ->skip($page * $limit);

        if ($request->onlyMobile == true) {
            $items->where('transaction_mobileReference', '!=', null);
        }
        $items = $items
            ->get();

        $filteredItems = [];

        foreach ($items as $subItems) {
            $subItems->transactionDt = DB::table('transaction_dts')
                ->join('items', 'items.item_id', '=', 'transaction_dts.item_id')
                ->select('transaction_dts.*', 'items.*')
                ->where([
                    ['transaction_dts.transaction_id', '=', $subItems->transaction_id],
                    ['transaction_dts.client_id', '=', $client_id],
                    ['item_quantity', '>', 0],
                ])
                ->addselect(
                    DB::raw('(SELECT IFNULL(SUM(item_quantity_to_delivery+item_quantity_to_cancel), 0) FROM transaction_dts as td WHERE td.reference_from_do = transaction_dts.transactiondt_id AND td.dt_transaction_type = "DQ") as Delivered_Qty'),
                )
                ->havingRaw('item_quantity-Delivered_Qty >0')

                ->get();
            if ($isShipment == 1) {
                if (!$subItems->transactionDt->isEmpty()) {
                    $filteredItems[] = $subItems;
                }
            } else {
                $filteredItems[] = $subItems;
            }
        }

        $data['count'] = $itemsCount;
        $data['items'] = $filteredItems;
        return ApiController::successResponse($data, 200);
    }

    public function fetchPendingDeliveryOrders(Request $request)
    {
        $user_id = JWTAuth::user()->id;

        $clientId = client::where('user_id', $user_id)->first()->client_id;
        $items = DB::table('transactiontmps')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->select('transactiontmps.*', 'client_customers.*', 'transaction_arrived as transaction_status')
            ->where([
                ['transactiontmp_clientID', '=', $clientId],
                ['transactiontmp_type', '=', 'DO'],
                ['transactiontmp_mobileReference', '!=', null],
                ['transactiontmp_reference', '=', null],

            ])
            ->orderBy('transactiontmp_date', 'desc')
            ->get();

        foreach ($items as $subItems) {
            $subItems->transactiontmpDt = DB::table('transactiondttmps')
                ->join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
                ->where('transactiondttmps.transactiontmp_id', '=', $subItems->transactiontmp_id)
                ->get();
        }
        return ApiController::successResponse($items, 200);
    }


    public function fetchTransactionDtPerItem(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        if ($request->clientId) {
            $user_id = $request->clientId;
        }
        $items = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->where([
                ['transaction_clientID', '=', $user_id],
                ['transaction_dts.item_id', '=', $request->itemId],
                ['transaction_type', '=', 'DO'],
            ])
            ->limit(3)
            ->get();
        return ApiController::successResponse($items, 200);
    }

    public function fetchDeliveryItems(Request $request)
    {

        $user_id = JWTAuth::user()->id;
        $totalQuantity = 0;
        $usedQuantity = 0;
        $clientId = DB::table('clients')
            ->where('user_id', $user_id)
            ->first()->client_id;


        $data = DB::table('transaction_dts')
            ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
            ->where([
                ['transaction_dts.client_id', $clientId],
            ])->get();

        foreach ($data as $dataQty) {
            $dataQty->totalQuantity = $totalQuantity;
            $dataQty->totalQuantityUsed = $usedQuantity;
            $dataQty->totalQuantityAvailable = $totalQuantity - $usedQuantity;
        }


        return $data;
    }


    public function searchDeliveryItem(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'user_id' => 'required',

        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $items = DB::table('client_items')
            ->where([
                ['item_related_client_id', '=', $request->user_id]

            ]);
        if ($request->search_key) {
            $items->where([
                ['item_barcode', 'like', '%' . $request->search_key . '%']
            ]);
        }
        $items = $items->get();


        return ApiController::successResponse($items, 200);
    }

    public function newDeliveryItem(Request $request)
    {
        $user_id = JWTAuth::user()->id;

        $validator = Validator::make($request->all(), [
            'item_code' => 'required',
            'item_description' => 'required',
            'item_barcode' => 'required',
            'item_hsCode' => 'required',
            'itemPack' => 'required',
            'itemQuantityPerPack' => 'required',
            'itemWeight' => 'required',

        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $newItem = DB::table('client_items')
            ->insertGetId([
                'item_code' => $request->item_code,
                'item_description' => $request->item_description,
                'item_barcode' => $request->item_barcode,
                'item_related_client_id' => $user_id,
                'item_weight' => $request->itemWeight,
                'item_pack' => $request->itemPack,
                'item_hscode' => $request->item_hsCode,
                'item_qtyPerPack' => $request->itemQuantityPerPack,
                'item_unit' => $request->itemUnit,
            ]);
        return ApiController::successResponse($newItem, 200);
    }


    public function newDeliveryTransaction(Request $request)
    {

        $user_id = JWTAuth::user()->id;
        $company_id = JWTAuth::user()->company_id;
        $validator = Validator::make($request->all(), [
            'transactionType' => 'required',
            'transaction_date' => 'required',
            'clientCustomer_id' => 'required',
            'forwarder_id' => 'required',


        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        //     $sequence = sequence::where('sequence_transactionType','like',$request->transactionType)
        // ->max('sequence_transactionRef') + 1;


        $sequence = DB::table('clients')
            ->where([
                ['clients.user_id', '=', $user_id]
            ])
            ->max('client_delivery_reference') + 1;


        $client_id = DB::table('clients')
            ->where([
                ['clients.user_id', '=', $user_id]
            ])->first()->client_id;
        // $sequence = clients::where('client_id','like',$user_id)
        // ->max('client_delivery_reference') + 1;
        // if( !$sequence )
        // {
        //    // return ApiController::errorResponse($sequence,422);
        // }
        //  return ApiController::successResponse($sequence,200);
        $utilitiesController = new UtilitiesController();

        $deliveryOrderType = null;
        $checkDeliveryOrderType = SetUp::where([
            ['setup_id', $request->deliveryType],
            ['setup_key', 'like', 'Shipment']
        ])
            ->select('setup_id')->first();


        if ($checkDeliveryOrderType) {
            $deliveryOrderType = SetUp::where([
                ['setup_key', 'like', 'outward'],
                ['setup_type', 'like', 'shipment_type']
            ])
                ->select('setup_id')->first();
        } else {
            $request->byShip = null;
            $deliveryOrderType = SetUp::where([
                ['setup_key', 'like', 'inward'],
                ['setup_type', 'like', 'shipment_type']
            ])
                ->select('setup_id')->first();
        }
        $deliveryExitPoint = companies::where([
            ['company_id', $company_id],
        ])
            ->select('company_exitCode')->first();
        $newItem = DB::table('transactiontmps')
            ->insertGetId([
                // 'transaction_reference' => $sequence,

                'transactiontmp_typeOfDeliveryId' => $request->deliveryType,
                'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transaction_date . "" . date('H:i:s')),
                'transactiontmp_clientId' => $client_id,
                'transactiontmp_type' => $request->transactionType,
                'transactiontmp_remark' => $request->transaction_remark,
                'transactiontmp_currencyId' => $request->transactiontmp_currencyId,

                'transactiontmp_mobileReference' => $sequence,
                'clientCustomer_id' => $request->clientCustomer_id,
                'forwarder_id' => $request->forwarder_id,
                'company_id' => $company_id,
                'transactiontmp_shipmentTypeId' => isset($deliveryOrderType->setup_id) ? $deliveryOrderType->setup_id : null,
                'transactiontmp_shipById' => $request->byShip,
                'transactiontmp_exitPoint' => $deliveryExitPoint->company_exitCode,

            ]);
        $rawGrid = 0;
        foreach ($request->transactiondt as $detailsdt) {

            $itemDetails = DB::table('client_items')
                ->where('item_id', $detailsdt['item_id'])
                ->first();
            $newItemDetails = DB::table('transactiondttmps')
                ->insertGetId([
                    'item_id' => $detailsdt['item_id'],
                    'item_quantity' => $detailsdt['selectedQuantity'],
                    'transactiondttmp_price' => $detailsdt['price'],
                    'transactiontmp_id' => $newItem,
                    'raw_in_grid' => $rawGrid,
                    'isMobile' => true,
                    'client_id' => $client_id,
                    'transactiondttmp_cellMerge' => $rawGrid + 1,
                    'item_pack' => $itemDetails->item_pack,
                    'group_id' => $itemDetails->group_id,
                    'item_qtyPerPack' => $itemDetails->item_qtyPerPack,
                    'item_weight' => $itemDetails->item_weight,
                    'item_unit' => $itemDetails->item_unit,


                ]);

            $rawGrid = $rawGrid + 1;
        }

        // if($sequence ==1){
        //     sequence::where('sequence_transactionType','like','DO')->insert([
        //         'sequence_transactionRef' => "1",
        //         'branch_id' => "1",
        //         'sequence_transactionType' => $request->transactionType
        //     ]);
        // }else{
        //     sequence::where('sequence_transactionType','like','DO')->increment('sequence_transactionRef',1);
        // }
        $updateUser = DB::table('clients')
            ->where([
                ['clients.user_id', '=', $user_id]
            ])->increment('client_delivery_reference', 1);
        // ->update([
        //     'client_delivery_reference'   => $sequence+1,
        // ]);
        $type = "Delivery Order";
        $notificationKey = "delivery";
        $admins = DB::table('users')
            ->join('useraccess', 'useraccess.user_id', 'users.id')
            ->where([
                ["useraccess.useraccess_formcode", $notificationKey],
            ])
            ->get();

        foreach ($admins as $admindt) {

            if ($admindt->user_pushToken) {

                $notificationArray = array(
                    'title' => $type,
                    'message' => 'New ' . $type . ' Transaction was created',
                    'seen' => 0,
                    'related_userid' =>  $admindt->id,
                    'trans_id' => null,
                    'key' => null,
                    'code' => "Delivery_Created_mobile",
                    'notificationToken' => $admindt->user_pushToken,
                    'transType' => "DO"
                );
                $utilitiesController->sendNotification($notificationArray);
            }
        }
        if ($updateUser) {
            return ApiController::successResponse("success", 200);
        }

        return ApiController::errorResponse($updateUser, 422);


        return ApiController::successResponse($newItem, 200);
    }


    public function check_serial(Request $request)
    {
        $user_id = JWTAuth::user()->id;
        $checkSerial = DB::table('transaction_dtsns')
            ->join('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
            ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->join('clients', 'clients.client_id', 'transactions.transaction_clientId')
            ->where([
                ['transaction_dtsns.transaction_item_serial', $request->sn],
                ['transactions.transaction_type', 'GOODS_IN'],
                ['clients.user_id', $user_id]
            ])
            ->get();


        if (count($checkSerial) != 0) {
            return ApiController::successResponse("Serial number $request->sn valid", 200);
        }
        return ApiController::successResponse("Serial number $request->sn invalid", 204);
    }

    public function fetchMobileInventoryItems(Request $request)
    {


        $user_id = JWTAuth::user()->id;
        $company_id = JWTAuth::user()->company_id;
        $limit = $request->limit;
        $page = $request->page;
        $type = $request->navigationType;
        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeOUT = 'DO';
        $user_id = client::where('user_id', $user_id)->first();
        $client_id = $user_id->client_id;
        if ($type == 'RMA') {
            $navigationTypeEntry = 'RMA_IN';
            $navigationTypeOUT = 'RMA_OUT';
        }

        $items = DB::table('items')
            ->join('transaction_dts', 'transaction_dts.item_id', 'items.item_id')
            ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->select('items.*',)
            ->where([
                ['transaction_dts.client_id', $client_id],
                //   ['item_related_clientId', $client_id],
                // ['transactions.transaction_type', $navigationTypeEntry]
            ])
            ->selectRaw("SUM(
                CASE WHEN (transaction_type = '" . $navigationTypeEntry . "'  )
                THEN  (transaction_dts.item_quantity)
                ELSE (
                    CASE WHEN (transaction_type = '" . $navigationTypeOUT . "' )
                    THEN  (-transaction_dts.item_quantity)
                    ELSE (0) END
                    ) END
                )
                AS totalQuantityAvailable
            ")
            ->when($request->withZero == false, function ($query) {
                return $query->having("totalQuantityAvailable", ">", 0);
            })
            ->groupBy('items.item_id');


        if ($request->searchKey) {
            $items->where([
                ['items.item_code', 'like', '%' . $request->searchKey . '%']
            ])
                ->orwhere(
                    [
                        ['items.item_description', 'like', '%' . $request->searchKey . '%']
                    ]
                )->groupBy('item_id');
        }
        $itermsCount = $items->get()->count();
        $items->limit($limit)
            ->skip($page * $limit);


        $items = $items->get();
        $data['count'] = $itermsCount;
        $data['items'] = $items;
        return ApiController::successResponse($data, 200);
    }


    public function fetchItems(Request $request)
    {


        $utilitiesController = new UtilitiesController();

        $user_id = JWTAuth::user()->id;
        $limit = $request->limit;
        $page = $request->page;
        $dateFromTimeStamp = $utilitiesController->convertTodayToTimetsamp($request->date . "" . date('H:i:s'));

        $totalQuantity = 0;
        $usedQuantity = 0;
        $clientId = DB::table('clients')
            ->where('user_id', $user_id)
            ->first()->client_id;

        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeOUT = 'DO';
        $items = DB::table('items')
            ->join('transaction_dts', 'transaction_dts.item_id', '=', 'items.item_id')
            ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
            ->where([
                ['transaction_dts.client_id', $clientId],

            ])
            ->groupBy('transaction_dts.item_id')
            ->selectRaw("SUM(
            CASE WHEN (transaction_dts.client_id = '" . $clientId . "' and transaction_type = '" . $navigationTypeEntry . "' and transaction_date <=  '" . $dateFromTimeStamp . "' )
            THEN  (transaction_dts.item_quantity)
            ELSE (
                CASE WHEN (transaction_dts.client_id = '" . $clientId . "' and transaction_type = '" . $navigationTypeOUT . "' and transaction_date <=  '" . $dateFromTimeStamp . "')
                THEN  (-transaction_dts.item_quantity)
                ELSE (0) END
            ) END
        ) AS existQty")
            ->addSelect(
                'items.item_id',
                'transaction_dts.client_id',
                'items.item_code',
                'items.item_description',
                'items.item_barcode'
            )
            ->havingRaw("existQty != 0")
            ->limit($limit)
            ->skip($limit * $page)
            ->when($request->searchKey, function ($query) use ($request) {
                return $query->where([
                    ['items.item_code', 'like', '%' . $request->searchKey . '%']
                ])
                    ->orwhere(
                        [
                            ['items.item_description', 'like', '%' . $request->searchKey . '%']
                        ]
                    );
            })->get();
        return ApiController::successResponse($items, 200);


        if ($request->searchKey) {
            $items->where([
                ['client_items.item_code', 'like', '%' . $request->searchKey . '%']
            ])
                ->orwhere(
                    [
                        ['client_items.item_description', 'like', '%' . $request->searchKey . '%']
                    ]
                );
        }
        $items = $items->get();

        $filterItems = array();
        foreach ($items as $itemsQty) {
            $qtyIn = DB::table('transaction_dts')
                ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
                ->join('items', 'items.item_id', 'transaction_dts.item_id')
                ->select('items.item_id', 'items.item_code', 'transactions.transaction_type', 'transaction_dts.client_id', 'transaction_dts.item_id')
                ->where([
                    ['transaction_dts.client_id', $clientId],
                    ['transactions.transaction_type', 'GOODS_IN'],
                    ['transaction_dts.item_id', $itemsQty->item_id]
                ])
                ->selectRaw(' SUM(item_quantity) as item_quantity')
                ->groupBy('transaction_dts.item_id', 'transactions.transaction_type')
                ->first();
            $itemsQty->totalQuantity = isset($qtyIn->item_quantity) ? $qtyIn->item_quantity : 0;

            $qtyOut = DB::table('transaction_dts')
                ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
                ->join('items', 'items.item_id', 'transaction_dts.item_id')
                ->select('items.item_id', 'items.item_code', 'transactions.transaction_type', 'transaction_dts.client_id', 'transaction_dts.item_id')
                ->where([
                    ['transaction_dts.client_id', $clientId],
                    ['transactions.transaction_type', 'DO'],
                    ['transaction_dts.item_id', $itemsQty->item_id]
                ])
                ->selectRaw(' SUM(item_quantity) as item_quantity')
                ->groupBy('transaction_dts.item_id', 'transactions.transaction_type')
                ->first();
            $itemsQty->totalQuantityUsed = isset($qtyOut->item_quantity) ? $qtyOut->item_quantity : 0;
            $itemsQty->totalQuantityAvailable = $itemsQty->totalQuantity - $itemsQty->totalQuantityUsed;
            if ((int)$itemsQty->totalQuantityAvailable > 0) {
                array_push($filterItems, $itemsQty);
            }
        }


        return ApiController::successResponse($filterItems, 200);
    }

    //   public function fetchInventoryItems(Request $request){


    //     $user_id = JWTAuth::user()->id;
    //     $company_id = JWTAuth::user()->company_id;


    //     $client_id=client::where('user_id',$user_id)->first()->client_id;
    //     $items = DB::table('client_items')

    //     ->join('items','items.item_code','client_items.item_code')
    //     ->select('client_items.*')
    //     ->where('item_related_client_id',$client_id);


    //     $items =  $items  ->get();


    //     foreach($items as $quantity){
    //         $quantity ->totalQuantity ='0';
    //         $quantity ->totalQuantityUsed ='0';
    //         $DO =  $this->getDataDo($quantity->item_id,'DO',$quantity->item_code,);
    //         $GOODSIN = $this->getDataDo($quantity->item_id,'GOODS_IN',$quantity->item_code);

    //         $quantity ->DO = $DO;
    //         $quantity ->GOODSIN = $GOODSIN;
    //         $totalQuantity=0;
    //         $usedQuantity  =0 ;

    //         $quantity ->totalQuantity =0;
    //         $quantity ->totalQuantityUsed =0;
    //         foreach( $quantity->GOODSIN  as $calculateTotal){

    //             // if( $calculateTotal->transaction_type =='GOODS_IN'){
    //                 $totalQuantity = $totalQuantity + $calculateTotal->item_quantity;
    //                 $itemsDetais2 = DB::table('transaction_dts')
    //                 ->join('transactions','transactions.transaction_id','=','transaction_dts.transaction_id')


    //             ->where('transaction_dts.id_reference_dt',$calculateTotal->transactiondt_id);

    //             if($request->reference_id){
    //                 $itemsDetais2    ->where('transactions.transaction_reference','!=',$request->reference_id);
    //             }


    //             //->select('transactions.transaction_type','transaction_dts.item_quantity')
    //             $itemsDetais2    =   $itemsDetais2     ->get();

    //             $totalQuantityPerBill=0;
    //             foreach( $itemsDetais2  as $calculateTotal2){

    //                     $totalQuantityPerBill =  $totalQuantityPerBill+ $calculateTotal2->item_quantity;
    //             }
    //             $calculateTotal -> totalUsedPerBill =$totalQuantityPerBill;
    //             $calculateTotal -> totalAvailablePerBill = $calculateTotal->item_quantity-$totalQuantityPerBill;
    //             $usedQuantity = $usedQuantity+$totalQuantityPerBill;


    //         }
    //         $quantity ->totalQuantity =  $totalQuantity;
    //         $quantity ->totalQuantityUsed =   $usedQuantity;
    //         $quantity ->totalQuantityAvailable =  $totalQuantity - $usedQuantity;

    //     }

    //     return ApiController::successResponse($items,200);
    //   }


    public function getDataDo($itemId, $type, $code)
    {
        $data = DB::table('transaction_dts')
            ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin');
        if ($type == 'GOODS_IN') {
            $items = DB::table('items')
                ->where('item_code', $code);
            $items = $items->first();

            $itemId2 = $items->item_id;
            $data->join('items', 'items.item_id', '=', 'transaction_dts.item_id');
            $data->where([
                ['items.item_id', '=', $itemId2]
            ]);
        } else {
            $data->where([
                ['transaction_dts.item_id', $itemId]
            ]);
        }
        $data = $data->where('transactions.transaction_type', $type);
        $data = $data->orderBy('raw_in_grid');
        //->select('transactions.transaction_type','transaction_dts.item_quantity')
        $data = $data->get();
        return $data;
    }


    public function tmpApi(Request $request)
    {


        $encrypt_method = "AES-256-CBC";
        $secret_key = '7aE3OKIZxusugQdpk3gwNi9x63MRAFLgkMJ4nyil88ZYMyjqTSE3FIo8L5KJghfi';
        $secret_iv = '7aE3OKIZxusugQdpk3gwNi9x63MRAFLgkMJ4nyil88ZYMyjqTSE3FIo8L5KJghfi';
        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);


        $string = 'abbbbbbbbbbbbbbbas';
        // encrypt token;
        $encryptToken = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
        $encryptToken = base64_encode($encryptToken);

        return $encryptToken;


        $d = 'MowR3kLBGfQDPAKSvqMsuOf3PUmBFHGwOLDrFVhlf1w=';
        $decryptToken = openssl_decrypt(base64_decode($d), $encrypt_method, $key, 0, $iv);

        return $decryptToken;
    }
}
