<?php

use App\Models\roles;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->bigincrements('role_id');
            $table->string('role_code', 60);
            $table->string('role_name', 60);
            $table->string('role_defaultPath', 60);
        });

        roles::query()->create([
            'role_code' => "superAdmin",
            'role_name' => "superAdmin",
            'role_defaultPath' => "/dashboard",
        ]);


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roles');
    }
}
