<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AddCreatedUpdatedTrigger extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactiontmps', function (Blueprint $table) {
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
        Schema::table('transactions', function (Blueprint $table) {
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
        Schema::connection('mysql2')->table('transactions', function (Blueprint $table) {
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    public function down()
    {
        Schema::table('transactiontmps', function (Blueprint $table) {
            $table->dropColumn(['created_at', 'updated_at']);
        });
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn(['created_at', 'updated_at']);
        });
    }
}
