<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class FillGoodsInBOE extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();

        try {
            // Update transaction_dts.transactiondt_boe to be consistent with transactions.transaction_boe
            DB::table('transaction_dts')
                ->join('transactions', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
                ->where([
                    ['transactions.transaction_type', 'GOODS_IN'],
                    ['transactions.internal_transfer', 0],
                    ['transactions.transaction_BOE', '!=', 'transaction_dts.transactiondt_BOE']
                ])
                ->update([
                    'transaction_dts.transactiondt_BOE' => DB::raw('transactions.transaction_BOE')
                ]);

            // Commit the transaction if everything runs smoothly
            DB::commit();
        } catch (\Exception $e) {
            // Rollback if an error occurs
            DB::rollBack();

            // Optionally, you can log the error or handle it as needed
            throw $e;
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('b_o_e', function (Blueprint $table) {
            //
        });
    }
}
