<html dir="{{$moduleKeys['direction'][$language]}}">

<head>
    <meta charset="utf-8">
    <title>{{$moduleKeys['statementOfItem'][$language]}}</title>


</head>

<body dir="{{$moduleKeys['direction'][$language]}}">
    <div class="frame">
        <header>

            @section('content')
            <div>
                @include('./components/logo' ,['company' => $company] )
            </div>
            @endsection
            <x-logo :company="$company"></x-logo>

            <div class="logo">
            </div>
            <h1><u>{{$moduleKeys['statementOfItem'][$language]}}</u></h1>
        </header>
        @if(isset($data) && count($data)>0)
        <table class="inventory">

            <tr>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>

                <th width="10%"><span>{{$moduleKeys['from'][$language]}}</span></th>
                <td width="20%"><span>{{$transactionFromDate}}</span></td>
            </tr>



            <tr>
            <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>

                <td class="nullclass"></td>
                <th width="10%"><span>{{$moduleKeys['to'][$language]}}</span></th>
                <td width="20%"><span>{{$transactionToDate}}</span></td>
            </tr>
            @if( $clientId =="all")
            <tr>
            <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>

                <td class="nullclass"></td>
                <th width="10%"><span>{{$moduleKeys['clients'][$language]}}</span></th>
                <td width="20%"><span>{{$moduleKeys['allclients'][$language]}}</span></td>
            </tr>
               
                @endif
                @if( $customer =="all")
            <tr>
            <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>
                <td class="nullclass"></td>

                <td class="nullclass"></td>
                <th width="10%"><span>{{$moduleKeys['customers'][$language]}}</span></th>
                <td width="20%"><span>{{$moduleKeys['allclients'][$language]}}</span></td>
            </tr>
               
                @endif
        </table>



        @for($i = 0; $i < count($data); $i++ ) <table class="inventory">

            <thead>

                @if(($clientId && $clientId !="all") || ($data[$i]['transactiondt_billOfEntry']))

                @if(($clientId && $clientId !="all") && ($data[$i]['transactiondt_billOfEntry']))
                <tr>
                    <th colspan=5><span>{{$moduleKeys['item2'][$language]}} : {{$data[$i]['item_code']}}</span></th>
                    <th colspan=5><span>{{$moduleKeys['dec3'][$language]}} : {{$data[$i]['transactiondt_billOfEntry']}}</span></th>
                    <th colspan=5><span>{{$moduleKeys['client2'][$language]}} : {{$data[$i]['client_firstname']}}</span></th>
                   
                    @if($customer && $customer !="all")
                    <th colspan=5><span>{{$moduleKeys['customer'][$language]}} : {{$data[$i]['customer_name']}}</span></th>

                    @endif
                    
                </tr>
                @else
                <tr>

                    <th colspan=7><span>{{$moduleKeys['item2'][$language]}} : {{$data[$i]['item_code']}}</span></th>
                    <th colspan=8><span>

                            @if($data[$i]['transactiondt_billOfEntry'] && $itemId =='all')
                            {{$moduleKeys['dec3'][$language]}} : {{$data[$i]['transactiondt_billOfEntry']}}
                            @endIf

                            @if($clientId && $clientId !="all")
                            {{$moduleKeys['clients2'][$language]}} : {{$data[$i]['client_firstname']}}
                            @endIf
                        </span></th>
                </tr>
                @endIf
                @endIf

                <tr>
                    <th colspan=15><span> {{$moduleKeys['previousQty'][$language]}} : {{$data[$i]['prevQty']}}</span></th>
                </tr>

                <tr>

                    <th><span>{{$moduleKeys['date'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['type'][$language]}}</span></th>
                    <th><span> {{$moduleKeys['reference'][$language]}} </span></th>
                    @if(!$clientId && $clientId =="all")<th><span>Client</span></th>@endIf

                    @if($supplier)
                    <th><span>{{$moduleKeys['supplier'][$language]}}</span></th>
                    @endif
                    @if($customer)
                    <th><span>{{$moduleKeys['customer'][$language]}}</span></th>
                    @endif
                    @if($forwarder)
                    <th><span>{{$moduleKeys['forwarder'][$language]}}</span></th>
                    @endif
                    @if($weight)
                    <th><span>{{$moduleKeys['weight'][$language]}}</span></th>
                    @endif
                    @if($totalWeight)
                    <th><span>{{$moduleKeys['totalWeight'][$language]}}</span></th>
                    @endif
                    @if(!$billOfEntry) <th><span>{{$moduleKeys['dec3'][$language]}}</span></th> @endIf
                    <th><span>{{$moduleKeys['coo'][$language]}}</span></th>
                    @if($currency)
                    <th><span>{{$moduleKeys['cost'][$language]}}</span></th>
                    @endif
                    @if($currencyBase)
                    <th><span>{{$moduleKeys['cost'][$language]}}({{$currencyCode}})</span></th>
                    @endif

                    <th><span>{{$moduleKeys['qtyIn'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['qtyOut'][$language]}}</span></th>
                    <th><span>{{$moduleKeys['existingQty'][$language]}}  </span></th>
                </tr>



            </thead>

            @for($j = 0; $j < count($data[$i]['transactions']); $j++ ) <tbody>
                <tr>
                    <td><span>{{$data[$i]['transactions'][$j]->transaction_date}}</span></td>

                    <td><span>{{$data[$i]['transactions'][$j]->transaction_type}}</span></td>
                    <td><span>{{$data[$i]['transactions'][$j]->transaction_reference}}</span></td>
                    @if(!$clientId && $clientId =="all") <td><span>{{$data[$i]['transactions'][$j]->client_firstname}}</span></td>@endIf
                    @if($forwarder)
                    <td><span>{{$data[$i]['transactions'][$j]->suppliers}}</span></td>
                    @endif
                    @if($customer)
                    <td><span>{{$data[$i]['transactions'][$j]->customer}}</span></td>
                    @endif
                    @if($supplier)
                    <td><span>{{$data[$i]['transactions'][$j]->forwarder}}</span></td>
                    @endif
                    @if($weight)
                    <td><span>{{$data[$i]['transactions'][$j]->item_weight}}</span></td>
                    @endif
                    @if($totalWeight)
                    <td><span>{{round($data[$i]['transactions'][$j]->item_weight*$data[$i]['transactions'][$j]->qtyExisting,3)}}</span></td>
                    @endif
                    @if(!$billOfEntry) <td><span>{{$data[$i]['transactions'][$j]->transactiondt_billOfEntry}}</span></td> @endIf
                    <td><span>{{$data[$i]['transactions'][$j]->country_name}}</span></td>
                    @if($currency)
                    <td><span>{{$data[$i]['transactions'][$j]->currencyPrice}}</span></td>
                    @endif
                    @if($currencyBase)
                    <td><span>{{$data[$i]['transactions'][$j]->transactiondt_priceBase}}</span></td>
                    @endif
                    <td><span>{{$data[$i]['transactions'][$j]->qtyIn}}</span></td>
                    <td><span>{{$data[$i]['transactions'][$j]->qtyOut}}</span></td>
                    <td><span>{{$data[$i]['transactions'][$j]->qtyExisting}}</span></td>

                </tr>
                </tbody>



                @endFor
                </table>
                @endFor



                @endIf












                <div>
                    @include('./components/footer',['company' => $company] )
                </div>


</body>

</html>
<style type="text/css">
    /* reset */
    /* @page {
                margin: 100px 25px;
            } */

    .page-break {
        page-break-after: always;
    }


    footer {
        position: fixed;
        bottom: -60px;
        left: 0px;
        right: 0px;
        height: 50px;
        font-size: 20px !important;

        /** Extra personal styles **/
        background-color: #008B8B;
        color: white;
        text-align: center;
        line-height: 35px;
    }










    .frame {
        padding-left: 0%;
        width: 100%;
        max-width: 700px;
        margin: 0;
    }


    * {
        border: 0;
        box-sizing: content-box;
        color: inherit;
        font-family: inherit;
        font-size: inherit;
        font-style: inherit;
        font-weight: inherit;
        line-height: inherit;
        list-style: none;

    }

    /* content editable */

    *[contenteditable] {
        border-radius: 0.25em;
        min-width: 1em;
        outline: 0;
    }

    *[contenteditable] {
        cursor: pointer;
    }

    *[contenteditable]:hover,
    *[contenteditable]:focus,
    td:hover *[contenteditable],
    td:focus *[contenteditable],
    img.hover {
        background: #DEF;
        box-shadow: 0 0 1em 0.5em #DEF;
    }

    span[contenteditable] {
        display: inline-block;
        position: absolute
    }

    /* heading */

    h1 {
        font: bold 100% sans-serif;
        text-align: center;
        text-transform: uppercase;
    }

    hr {
        border: 0;
        clear: both;
        display: block;
        width: 100%;
        background-color: black;
        height: 1px;
        vertical-align: center;
    }

    /* table */

    table {
        font-size: 75%;
        table-layout: fixed;
        width: 100%;
    }

    table {
        border-collapse: separate;
        border-spacing: 2px;
    }

    th,
    td {
        padding: 0.3em;
        position: relative;
        text-align: left;
        position: absolute
    }

    th,
    td {
        border-radius: 0.25em;
        border-style: solid;
        position: absolute
    }

    th {
        background: #E6E6E6;
        border-color: #BBB;
        position: absolute
    }

    td {
        border-color: rgb(170 166 166 / 33%);
        position: absolute
    }

    td.nullclass {
        border-color: #0000
    }





    /* invoice title */

    .txt {
        font-size: 75%;
        table-layout: fixed;
        width: 95%;
        position: absolute
    }










    /* table meta & balance */

    table.meta,
    table.balance {
        float: right;
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.meta:after,
    table.balance:after {
        clear: both;
        content: "";
        display: table;
        text-align: center;
        position: absolute
    }

    /* table meta */

    table.meta th {
        width: 40%;
        text-align: center;
        position: absolute
    }

    table.meta td {
        width: 60%;
        text-align: center;
        position: absolute
    }

    /* table items */

    table.inventory {
        clear: both;
        width: 100%;
        position: absolute font-size:15px;
    }

    table.inventory th {
        font-weight: bold;
        text-align: center;
        position: absolutefont-size:15px;
    }

    table.inventory td {
        text-align: center;
        position: absolutefont-size:10px;
    }

    table.inventory td.bigFontTd {
        text-align: center;
        position: absolutefont-size:13px;
        font-weight: bold;
    }

    table.inventory td.small {
        text-align: center;
        position: absolutefont-size:8px;
    }

    /* table balance */

    table.balance th,
    table.balance td {
        width: 50%;
        text-align: center;
        position: absolute
    }

    table.balance td {
        text-align: center;
        position: absolute
    }

    @page {
        margin-bottom: 50;

        header: page-header;
        footer: page-footer;
    }

    /* aside */
</style>