<?php

namespace App\Http\Controllers\BackOffice\Client;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\client;
use App\Models\clientCustomer;
use App\Models\clientShipment;
use App\Models\companies;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\user;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;

class ClientController extends ApiController
{
    public function fetchClients(Request $request)
    {
        $loggerCompanyId = auth()->user()->company_id;
        $searchValue = $request->searchValue;
        $take = $request->take;
        $skip = $request->skip;
        $onlyDo = $request->onlyDO;
       
        $clients = DB::table('clients')
            ->join('users', 'users.id', '=', 'clients.user_id')
            ->leftjoin('currency','currency.currency_id','clients.client_currency')
            ->select('users.user_name', 'clients.*','currency.currency_code')
            ->where([
                ['client_isActive', true],
                ['users.company_id', $loggerCompanyId]
            ])
           
            ->when($searchValue, function ($query) use ($request, $searchValue) {
                return $query->Where(function ($query) use ($searchValue) {
                    $query->Where([
                        ['user_name', 'like', '%' . $searchValue . '%']
                    ])
                        ->orWhere([
                            ['client_firstname', 'like', '%' . $searchValue . '%']
                        ])
                        ->orWhere([
                            ['client_lastname', 'like', '%' . $searchValue . '%']
                        ])
                        ->orWhere([
                            ['client_email', 'like', '%' . $searchValue . '%']
                        ])
                        ->orWhere([
                            ['client_phone', 'like', '%' . $searchValue . '%']
                        ]);
                });
            })
           ;
           if($onlyDo==true){
                $clients->join('transaction_dts','transaction_dts.client_id','clients.client_id')
                ->join('transactions','transactions.transaction_id','transaction_dts.transaction_id')
                ->where([
                    ['transaction_released',1],
                    ['transaction_arrived',1]
                ])
                ->select('clients.*','transactions.transaction_released','transactions.transaction_arrived')
                ->selectRaw("FROM_UNIXTIME(client_from_contract, '%d-%m-%Y') AS client_from_contract")
                ->groupBy('clients.client_id');
           }
        $clientCount = count($clients
        ->get());
        $clients = $clients->when($take != 'all', function ($query) use ($request, $take, $skip) {
            return $query->take($take)
            ->skip($skip);
            
        })
            ->orderby('client_firstname')
        ->get();
        $obj['count'] = $clientCount;
        $obj['clients'] = $clients;
        $obj['onlyDo'] = $onlyDo;
        return ApiController::successResponse($obj, 200);
    }

    public function insertClient(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'clientFirstName' => 'required',
            // 'clientLastName' => 'required',
            // 'clientCountry' => 'required',
            // 'clientContact' => 'required',
            // 'clientPhone' => 'required',
            // 'clientEmail' => 'required'
        ]);


        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $loggerCompanyId = auth()->user()->company_id;
        $checkErp = companies::first()->company_erpSchema;
        //disable erp
        //   $checkErp = null;
        $checkClientExistance = user::where(
            [
                ['user_name', $request->clientUserName],
                ['company_id', $loggerCompanyId],

            ]
        )
            ->first();

        if ($request->clientEmail == null) {
            $request['clientEmail'] = $request->clientUserName . '@gmail.com';
        }
        $checkEmailExistance = client::where([
            ['client_email', $request->clientEmail],
        ])
            ->first();

        if ($checkClientExistance || $checkEmailExistance) {
            return ApiController::errorResponse('Username/Email already taken!', 409);
        }


        $ledgerNumber = "";
        if ($checkErp) {
            if ($request->ledgerNumber) {
                $ledgerNumber = $request->ledgerNumber;
            } else {
                $userName = auth()->user()->user_name;
                $ledgerName = $request->clientFirstName;
                $responseClient = $this->creatClientLedger($userName, $ledgerName);

                try{
                    if ($responseClient->getData()->code == 409) {
                        return ApiController::errorResponse($responseClient->getData()->data->data, 409);
                    }
                    $ledgerNumber = $responseClient->getData()->data->data;
                }catch(Exception $e){
                    $ledgerNumber=null;
                }
                
            }
        }

        $client = array(
            'client_firstname' => $request->clientFirstName,
            'client_lastname' => $request->clientLastName,
            'client_address' => $request->clientAddress,
            'client_country' => $request->clientCountry,
            'client_phone' => $request->clientPhone,
            'client_email' => $request->clientEmail,
            'client_contact' => $request->clientContact,
            'Ledger_number' => $ledgerNumber,
            'client_phone_code' => '961',
            'client_currency' => $request->clientCurrency,
            'client_cost' => $request->clientCost,
            'client_from_contract' => $request->clientDateContract,


            

        );

        $currentActiveUserCompany = auth()->user()->company_id;
        $user = $this->insertClientAsUser($request->clientUserName, $currentActiveUserCompany);
        $client['user_id'] = $user->id;
        $newClient = client::create($client);
        if ($newClient) {
            $this->clientHistory($newClient->toarray(), 'Insert');

            return ApiController::successResponse($newClient, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }
   

    function creatClientLedger($username, $clientFirstName)
    {
        $config = array(
            "userName" => $username,
            "ledgerName" => $clientFirstName
        );
        $utilitiesController = new UtilitiesController();
        $ledger = $utilitiesController->connectDataToErp("createClientLedegrFromLogistics", $config);
        return $ledger;
    }


    function updateLedgersForClient(Request $request){

        $client=DB::table('clients')
        ->where('Ledger_number',null)
        ->orwhere('Ledger_number','')
        ->get();
      // return $client;
        foreach($client as $splitClient){
            $userName=$splitClient->client_firstname;
            $firstName=$splitClient->client_firstname;
            try{
                $response =$this->creatClientLedger($userName,$firstName);
                Storage::put('updateLedgersForClient - Reponse', $response);
                $ledger= $response->getData()->data->data;
                DB::table('clients')->where('client_id',$splitClient->client_id)
                ->update([
                    'Ledger_number' => $ledger
                ]);
            }
            catch(Exception $e) {
                echo 'Message: ' .$e->getMessage();
            }
            
          //  return $response;
        }
    }


    function insertClientAsUser($username, $currentActiveUserCompany,$userId=null)
    {
        $username = str_replace(' ', '_', $username);
        $newUser = array(
            'user_name' => $username,
            'password' => bcrypt('0000'),
            'company_id' => $currentActiveUserCompany
        );
        $historyController = new HistoryController();
        $user = user::create($newUser);
        $newUser['user_modified'] = isset(auth()->user()->id)?auth()->user()->id:$userId;
        $newUser['id'] = $user->id;
        $historyController->insertHistoryData('users', $newUser, 'Insert');
        return $user;
    }

    public function clientHistory($newClient, $type)
    {
        $historyController = new HistoryController();
        $newClient['user_modified'] = auth()->user()->id;
        unset($newClient['id']);
        $username = client::leftjoin('users', 'users.id', 'clients.user_id')
            ->select('user_name')
            ->where([
                ['user_id', $newClient['user_id']]
            ])
            ->first()
            ->user_name;
        $newClient['client_id'] = $username;
        $historyController->insertHistoryData('clients', $newClient, $type);
    }

    public function updateClient(Request $request)
    {
        $historyController = new HistoryController();
        $validator = Validator::make($request->all(), [
            'clientFirstName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        // $ledgerNumber=$this->updateClientLedger($request);


        $client = array(
            'client_firstname' => $request->clientFirstName,
            'client_lastname' => $request->clientLastName,
            'client_address' => $request->clientAddress,
            'client_country' => $request->clientCountry,
            'client_phone' => $request->clientPhone,
            'client_email' => $request->clientEmail,
            'client_contact' => $request->clientContact,
            'client_phone_code' => '961',
            'client_currency' => $request->clientCurrency,
            'client_cost' => $request->clientCost,
            'client_from_contract' => $request->clientDateContract,
        );
        $historyClient = client::where('client_id', $request->clientId);
        $userId = $historyClient->first()->user_id;
        $updateClient = $historyClient->update($client);

        if ($updateClient) {
            $updatedClient = client::where('client_id', $request->clientId)->first();

            $updatedClient['client_id'] = $request->clientId;
            $updatedClient['user_modified'] = auth()->user()->id;
            $updatedClient['user_id'] = $userId;
            $this->clientHistory($updatedClient->toarray(), 'Update');
            return ApiController::successResponse($updateClient, 200);
        }
        return ApiController::errorResponse($validator->errors(), 200);
    }

    function removeClient(Request $request)
    {
        $checkClientTransactions = transactions::where('transaction_clientId', $request->clientId)->first();
        $checkClientTransactionsTmp = transactiontmp::where('transactiontmp_clientId', $request->clientId)->first();

        if ($checkClientTransactions || $checkClientTransactionsTmp) {

            return ApiController::successResponse('User successfully deleted', 204);
        } else {
            $clientRecord = client::where('client_id', $request->clientId);
            $clientData = $clientRecord->first();
            $userId = $clientData->user_id;
            $clientData['user_modified'] = auth()->user()->id;
            $clientData['client_id'] = $request->clientId;
            $clientData['user_id'] = $userId;
            $this->clientHistory($clientData->toarray(), 'Delete');
            $clientRecord->delete();
            clientCustomer::where('customer_related_clientId', $request->clientId)->delete();
            clientShipment::where('shipment_related_clientId', $request->clientId)->delete();
            user::where('id', $clientData->user_id)->delete();
            return ApiController::successResponse('User successfully deleted', 200);
        }
    }

    function checkClientLedgerName(Request $request)
    {
        $config = array(
            "userName" => auth()->user()->user_name,
            "ledgerName" => $request->clientFirstName
        );
        $utilitiesController = new UtilitiesController();
        $ledger = $utilitiesController->connectDataToErp("checkClientLedegrNameFromLogistics", $config);
        return $ledger;
    }

    function updateClientLedger(Request $request)
    {
        $config = array(
            "userName" => auth()->user()->user_name,
            "ledgerNumber" => $request->ledgerNumber,
            "ledgerName" => $request->clientFirstName

        );
        $utilitiesController = new UtilitiesController();
        $ledger = $utilitiesController->connectDataToErp("updateClientLedgerNameByledgerNumber", $config);
        return $ledger;
    }


    function resetPassword(Request $request)
    {
        $clientId = $request->clientId;
        $userId = client::where('client_id',$clientId)->first()->user_id;
       
        $resetPassword = user::where('id',$userId)->update([
            'password' => bcrypt('0000'),
        ]);
        
        if($resetPassword){
            return ApiController::successResponse('Reset Password Success', 200);
        }
        return ApiController::errorResponse('Reset Password failed', 422);

    }
}
