<?php

namespace App\Http\Controllers\BackOffice\Common;


use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\companies;
use App\Models\country;
use App\Models\items;
use App\Models\location;
use App\Models\sequence;
use App\Models\suppliers;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Carbon\Carbon;
use Exception;
use Facade\FlareClient\Api;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;

class CommonServices extends ApiController
{

    public function convertTodayToTimetsamp($date)
    {
        $date = date_create_from_format('Y-m-d H:i:s', $date);
        if ($date) {
            $date = $date->getTimestamp();
            return $date;
        }
        return 0;
    }

    public function checkLoadedPriceModule()
    {
        $company = companies::first();
        $loadPrice = $company->loadPrice;
        return $loadPrice;
    }

    // get max price from DO related to ref GOODSIN
    public function getMaxPrice($transactiontmpId, $rawInGrid)
    {

        $qty = transactiondttmp::where([
            ['transactiondttmps.transactiontmp_id', $transactiontmpId],
            ['raw_in_grid', $rawInGrid]
        ])
            ->select('id_reference_dt')
            ->get();
        $maxPrice = 0;
        foreach ($qty as $splitData) {

            $ref = $splitData->id_reference_dt;
            $refGoodsIn = transactiondt::where('transactiondt_id', $ref)->first();
            if ($refGoodsIn) {
                $price = $refGoodsIn->transactiondt_price;
                if ($price > $maxPrice) $maxPrice = $price;
            }
        }
        return $maxPrice;
    }



    public function prepareTransaction($params = [])
    {
        $currentDateTime = Carbon::now();
        $formattedTime = $currentDateTime->format('H:i');
        return array(
            'transactiontmp_id' => isset($params['transactiontmp_id']) ? $params['transactiontmp_id'] : null,
            'transaction_time' => isset($params['transaction_time']) ? $params['transaction_time'] : $formattedTime,
            'transactiontmp_reference' => isset($params['transactiontmp_reference']) ? $params['transactiontmp_reference'] : null,
            'transactiontmp_date' => isset($params['transactiontmp_date']) ? $params['transactiontmp_date'] : null,
            'transactiontmp_driverPhone' => isset($params['transactiontmp_driverPhone']) ? $params['transactiontmp_driverPhone'] : null,
            'transactiontmp_billOfEntry' => isset($params['transactiontmp_billOfEntry']) ? $params['transactiontmp_billOfEntry'] : null,
            'transactiontmp_clientId' => isset($params['transactiontmp_clientId']) ? $params['transactiontmp_clientId'] : null,
            'transactiontmp_type' => isset($params['transactiontmp_type']) ? $params['transactiontmp_type'] : null,
            'transactiontmp_remark' => isset($params['transactiontmp_remark']) ? $params['transactiontmp_remark'] : null,
            'transactiontmp_typeOfDeliveryId' => isset($params['transactiontmp_typeOfDeliveryId']) ? $params['transactiontmp_typeOfDeliveryId'] : null,
            'transactiontmp_customerId' => isset($params['transactiontmp_customerId']) ? $params['transactiontmp_customerId'] : null,
            'transactiontmp_shipmentReference' => isset($params['transactiontmp_shipmentReference']) ? $params['transactiontmp_shipmentReference'] : null,
            'transactiontmp_mobileReference' => isset($params['transactiontmp_mobileReference']) ? $params['transactiontmp_mobileReference'] : null,
            'user_id' => isset($params['user_id']) ? $params['user_id'] : null,
            'clientCustomer_id' => isset($params['clientCustomer_id']) ? $params['clientCustomer_id'] : null,
            'forwarder_id' => isset($params['forwarder_id']) ? $params['forwarder_id'] : null,
            'transactiontmp_driverName' => isset($params['transactiontmp_driverName']) ? $params['transactiontmp_driverName'] : null,
            'transactiontmp_vehicleNumber' => isset($params['transactiontmp_vehicleNumber']) ? $params['transactiontmp_vehicleNumber'] : null,
            'transactiontmp_exitPoint' => isset($params['transactiontmp_exitPoint']) ? $params['transactiontmp_exitPoint'] : null,
            'transactiontmp_destinationPoint' => isset($params['transactiontmp_destinationPoint']) ? $params['transactiontmp_destinationPoint'] : null,
            'company_id' => isset($params['company_id']) ? $params['company_id'] : null,
            'transactiontmp_paymentMethodId' => isset($params['transactiontmp_paymentMethodId']) ? $params['transactiontmp_paymentMethodId'] : null,
            'transactiontmp_customBillTypeId' => isset($params['transactiontmp_customBillTypeId']) ? $params['transactiontmp_customBillTypeId'] : null,
            'transactiontmp_currencyId' => isset($params['transactiontmp_currencyId']) ? $params['transactiontmp_currencyId'] : null,
            'transactiontmp_shipmentTypeId' => isset($params['transactiontmp_shipmentTypeId']) ? $params['transactiontmp_shipmentTypeId'] : null,
            'transactiontmp_shipById' => isset($params['transactiontmp_shipById']) ? $params['transactiontmp_shipById'] : null,
            'transactiontmp_shipmentRemark' => isset($params['transactiontmp_shipmentRemark']) ? $params['transactiontmp_shipmentRemark'] : null,
            'transactiontmp_supplierId' => isset($params['transactiontmp_supplierId']) ? $params['transactiontmp_supplierId'] : null,
            'transactiontmp_supplierInvoice' => isset($params['transactiontmp_supplierInvoice']) ? $params['transactiontmp_supplierInvoice'] : null,
            'transactiontmp_enterSerial' => isset($params['transactiontmp_enterSerial']) ? $params['transactiontmp_enterSerial'] : false,
            'transactiontmp_totalQty' => isset($params['transactiontmp_totalQty']) ? $params['transactiontmp_totalQty'] : 0,
            'transactiontmp_totalPallet' => isset($params['transactiontmp_totalPallet']) ? $params['transactiontmp_totalPallet'] : 0,
            'transaction_totalPrice' => isset($params['transaction_totalPrice']) ? $params['transaction_totalPrice'] : 0,
            'transaction_totalItem' => isset($params['transaction_totalItem']) ? $params['transaction_totalItem'] : 0,
            'transactiontmp_BOE' => isset($params['transactiontmp_BOE']) ? $params['transactiontmp_BOE'] : null,
            'salesjv_id' => isset($params['salesjv_id']) ? $params['salesjv_id'] : null,
            'transactiontmp_rate' => isset($params['transactiontmp_rate']) ? $params['transactiontmp_rate'] : null,
            'Invoice_type_id' => isset($params['Invoice_type_id']) ? $params['Invoice_type_id'] : null,
            'payment_term_id' => isset($params['payment_term_id']) ? $params['payment_term_id'] : null,
            'delivery_term_id' => isset($params['delivery_term_id']) ? $params['delivery_term_id'] : null,
            'exemption_type_id' => isset($params['exemption_type_id']) ? $params['exemption_type_id'] : null,
            'internal_transfer' => isset($params['internal_transfer']) ? $params['internal_transfer'] : null,
            'transferTo_clientId' => isset($params['transferTo_clientId']) ? $params['transferTo_clientId'] : null,
            'relatedTransferId' => isset($params['relatedTransferId']) ? $params['relatedTransferId'] : null,
            'transaction_released_DEC' => isset($params['transaction_released_DEC']) ? $params['transaction_released_DEC'] : "",
            'showInDocument' => isset($params['showInDocument']) ? $params['showInDocument'] : null,
            'transaction_arrived' => isset($params['transaction_arrived']) ? $params['transaction_arrived'] : false,
            'payment_methods' => isset($params['payment_methods']) ? $params['payment_methods'] : null,
            'way_bill_no' => isset($params['way_bill_no']) ? $params['way_bill_no'] : null,
            'tir' => isset($params['tir']) ? $params['tir'] : null,
            'job_no' => isset($params['job_no']) ? $params['job_no'] : null,
            'salesjv_discount' => isset($params['salesjv_discount']) ? $params['salesjv_discount'] : null,


        );
    }


    public function getDecimal()
    {

        $decimal = DB::table('set_ups')->where([
            ['setup_type', 'decimal_digits'],
        ])
            ->select('setup_value', 'setup_key')
            ->get();

        $result = collect($decimal)
            ->groupBy('setup_key',)
            ->map(function ($group) {
                $key = $group->pluck('setup_key')->unique()->first();
                $value = $group->pluck('setup_value')->unique()->first();
                return [
                    'key' => $key,
                    'value' => $value,
                ];
            });

        $finalResults = array();
        $finalResults['doPrice'] =  $result['decimal_weight_DO']['value'];
        $finalResults['goodsInPrice'] = $result['decimal_weight_DO']['value'];
        $finalResults['doWeight'] =  $result['decimal_weight_DO']['value'];
        $finalResults['goodsInWeight'] = $result['decimal_weight_DO']['value'];






        return $finalResults;
    }




    function returnHeaderOriginalToTmpService($transactionId)
    {
        $originalTransaction = transactions::where('transaction_id', '=', $transactionId)
            ->join('users', 'users.id', '=', 'transactions.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->orderBy('transaction_date', 'asc')
            ->select('users.*', 'clients.*', 'transactions.*')
            ->first();

        $transactionTmp = array(
            'transactiontmp_id' => $originalTransaction->transaction_id,
            'transaction_time' => $originalTransaction->transaction_time,
            'transactiontmp_date' => $originalTransaction->transaction_date,
            'transactiontmp_billOfEntry' => $originalTransaction->transaction_billOfEntry,
            'transactiontmp_clientId' => $originalTransaction->transaction_clientId,
            'transactiontmp_type' => $originalTransaction->transaction_type,
            'transactiontmp_remark' => $originalTransaction->transaction_remark,
            'transactiontmp_typeOfDeliveryId' => $originalTransaction->transaction_typeOfDeliveryId,
            'clientCustomer_id' => $originalTransaction->clientCustomer_id,
            'transactiontmp_shipmentReference' => $originalTransaction->transaction_shipmentReference,
            'transactiontmp_mobileReference' => $originalTransaction->transaction_mobileReference,
            'user_id' => $originalTransaction->user_id,
            'company_id' => $originalTransaction->company_id,
            'transactiontmp_currencyId' => $originalTransaction->transaction_currencyId,
            'transactiontmp_rate' => $originalTransaction->transaction_rate,
            'transactiontmp_driverName' => $originalTransaction->transaction_driverName,
            'transactiontmp_driverPhone' => $originalTransaction->transaction_driverPhone,
            'transactiontmp_vehicleNumber' => $originalTransaction->transaction_vehicleNumber,
            'transactiontmp_exitPoint' => $originalTransaction->transaction_exitPoint,
            'transactiontmp_destinationPoint' => $originalTransaction->transaction_destinationPoint,
            'transactiontmp_shipmentTypeId' => $originalTransaction->transaction_shipmentTypeId,
            'transactiontmp_paymentMethodId' => $originalTransaction->transaction_paymentMethodId,
            'transactiontmp_customBillTypeId' => $originalTransaction->transaction_customBillTypeId,
            'transactiontmp_shipById' => $originalTransaction->transaction_shipById,
            'transactiontmp_shipmentRemark' => $originalTransaction->transaction_shipmentRemark,
            'forwarder_id' => $originalTransaction->forwarder_id,
            'transactiontmp_supplierId' => $originalTransaction->transaction_supplierId,
            'transactiontmp_supplierInvoice' => $originalTransaction->transaction_supplierInvoice,
            'transactiontmp_reference' => $originalTransaction->transaction_reference,
            'transactiontmp_totalQty' => $originalTransaction->transaction_totalQty,
            'transactiontmp_totalPallet' => $originalTransaction->transaction_totalPallet,
            'transaction_totalPrice' => $originalTransaction->transaction_totalPrice,
            'transaction_totalItem' => $originalTransaction->transaction_totalItem,
            'transactiontmp_BOE' => $originalTransaction->transaction_BOE,
            'Invoice_type_id' => $originalTransaction->Invoice_type_id,
            'payment_term_id' => $originalTransaction->payment_term_id,
            'delivery_term_id' => $originalTransaction->delivery_term_id,
            'exemption_type_id' => $originalTransaction->exemption_type_id,
            'internal_transfer' => $originalTransaction->internal_transfer,
            'transferTo_clientId' => $originalTransaction->transferTo_clientId,
            'showInDocument' => $originalTransaction->showInDocument,
            'transaction_arrived' => $originalTransaction->transaction_arrived,
            'way_bill_no' => $originalTransaction->way_bill_no,
            'tir' => $originalTransaction->tir,
            'job_no' => $originalTransaction->job_no,
            'salesjv_discount' => $originalTransaction->salesjv_discount,
            'relatedTransferId' => $originalTransaction->relatedTransferId,

        );
        $newTransactionTmp = transactiontmp::create($transactionTmp);
        $newTransactionTmp->client_firstname = $originalTransaction->client_firstname;
        $newTransactionTmp->customer_name = $originalTransaction->customer_name;
        $newTransactionTmp->transactiontmp_clientId = $originalTransaction->transactiontmp_clientId;
        return $originalTransaction;
    }





    function dubaiTradeRecordService($header, $detailRecord, $index, $isHeader = false)
    {


        if ($isHeader == true) {
            /* 1*/
            $iden = "IH";
            /* 2*/
            $invoice = $header->transaction_reference; // invoice number or reference  length:20
            /* 3*/
            $date = $header->transaction_formatdate; // invoice date   length:20 format  '%Y-%m-%d'
            /* 4*/
            $pageNumber = "1";  // total number of invoice pages  length:3
            /* 5*/
            $invoiceType = substr($header->Invoice_type_id, 0, 3); // type of invoice  length:3
            /* 6*/
            $sellersName = "seller";  //name of seller  length:3
            if ($header->transaction_type == 'GOODS_IN') {
                $sellersName = $header->supplier_name;
                $invoice = $header->transaction_supplierInvoice;
            }else{
                $companyId = auth()->user()->company_id;
                $comapnyName = companies::where('company_id',$companyId)->first();
                if($comapnyName){
                    $sellersName = $comapnyName->company_name;
                }

            }
            /* 7*/
            $paymentTermId = $header->payment_term_id; // payment term  length:3
            /* 8*/
            $vM = "0"; // valuation methods   length:3;  
            /* 9*/
            $curreny = $header->currency_code; //invoice currency   length:3

            /* 10*/
            //SUM(transactiondt_price*item_quantity) as totalValues
            //total values of goods  length: 16.3
            $totalValues = $header->totalValues;
            /* 11*/
            $delivery_term_id = $header->delivery_term_id; // delivery terms id  length: 3



            /* 12*/
            //freight currency code
            /* 13*/
            //freight charges
            /* 14*/
            //insurance currency
            
            $defaultCurrency = "AED";
            /* 15*/
            //insurance charges





            $headert = '"' . $iden . '",' . '"' . $invoice . '",' . '"' . $date . '",' . '"' . $pageNumber . '",' . '"' . $invoiceType . '",' . '"' . $sellersName . '",' . '"' . $paymentTermId . '",' . '"' . $vM . '",' . '"' . $curreny . '",' . '"' . $totalValues . '",' . '"' . $delivery_term_id . '",' . '"",' . '"",' . '"' . $defaultCurrency . '",' . '""';

            return  $headert;
        }




        /* 1*/
        $iden = "ID";
        /* 2*/
        //index
        /* 3*/
        $hscode = substr($detailRecord->hscode, 0, 12);  // lenght:12
        /* 4*/
        $description = substr($detailRecord->transactiondt_item_description, 0, 255);  // lenght:12
        $description = $this->replaceSpecialCharacters($description);
        /*5 */
        $condition = "N"; // N or U
        /* 6*/
        $itemUnit = substr($detailRecord->item_unit, 0, 5);
        /* 7*/
        $itemQuantity = round($detailRecord->item_quantity, 4);
        /* 8*/
        $netWeightUnit = 'kg';
        /* 9*/
        $grossWeight = round($detailRecord->item_weight * $detailRecord->item_quantity , 4);
        /*10 */
        $supQTYME = ""; //supplementary Qty measurment unit
        /*11 */
        $supQTY = ""; //supplementary Qty
        /* 12*/
        $grossPrice = round($detailRecord->transactiondt_price * $detailRecord->item_quantity, 3);
        /* 13*/
        $COO = $detailRecord->country_code;
        /* 14*/
        $previousDecRef="";
        /* 15*/
        $previousDecINvoice = "";
        /* 16*/
        $previousDecINLine = "";
        /* 17*/
        $exemptionTypeId = substr($header->exemption_type_id, 0, 5);
       // $exemptionTypeId = "";
        /* 18*/
        $exemptionRefNumber = "";

        $trade = '"' . $iden . '"' . ',"' . $index . '","' . '' . $hscode . '"' . "," . '"' . $description . '"' . "," . '"' . $condition . '",' . '"' . $itemUnit . '","' . $itemQuantity . '",' . '"' . $netWeightUnit . '",' . '"' . $grossWeight . '"' . "," . '"' . $supQTYME . '","' . $supQTY . '","' . $grossPrice . '",' . '"' . $COO . '",' . '"'.$previousDecRef.'",' . '"'.$previousDecINvoice.'",' . '"'.$previousDecINLine.'","' . $exemptionTypeId . '",' . '"'.$exemptionRefNumber.'"';

        return $trade;
    }

    private function replaceSpecialCharacters($string)
    {
        // Replace all special characters with spaces
        $cleanedString = preg_replace('/[^A-Za-z0-9]/', ' ', $string);
        
        // Optionally, trim multiple spaces to a single space
        $cleanedString = preg_replace('/\s+/', ' ', $cleanedString);
        
        return $cleanedString;
    }
    function dubaiTradeDAteFormatService()
    {
        return 'Y-m-d';
    }


    function indexOfFieldsDubaiTraderService($key)
    {

        $data = [
            "headerDate" => 2,
            "headerCurrencyCode" => 8,
            "headerSupplier" => 1,
            "itemCodeDetail" => 2,
            "descriptionDetail" => 3,
            "qtyDetail" => 6,
            "grossWeight" => 8,
            "grossPrice" => 11,
            "countryCode" => 12,
        ];

        $index = $data[$key];




        return  $index;
    }


    public function getTransactionFilesExist(array $types , $transactions){
        $fullFilesDirectoriesCount = [];
        foreach ( $types as $type){
           
            $path = public_path('/documents/'.$type);
            $nonEmptyDirectories = glob($path . '/*', GLOB_ONLYDIR);
            $nonEmptyDirectories = array_filter($nonEmptyDirectories, function ($dir) {
                return count(glob($dir . '/*')) > 0;
            });
            $nonEmptyDirectoryNames = array_map(function ($dir) {
                return basename($dir);
            }, $nonEmptyDirectories);
          
            $fullFilesDirectoriesCount = array_merge($fullFilesDirectoriesCount, array_values($nonEmptyDirectoryNames));
            
        }

      //  $transactions = collect($fullFilesDirectoriesCount);
     
        $transactions = $transactions->map(function ($object) use ($fullFilesDirectoriesCount) {
            $object->haveFiles = in_array($object->transaction_id, $fullFilesDirectoriesCount);
            return $object;
        });

        return $transactions;
    }
}
