<?php

namespace App\Http\Controllers\BackOffice\Dashboard;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class DashboardController extends ApiController
{
    public function myDashboard(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;
        //return Response()->json(["data"=>$loggerUserCompany]);
        $utilitiesController = new UtilitiesController();
        $dateFrom = $utilitiesController->convertTodayToTimetsamp($request->transactionFromDate . " 00:00:00");
        $dateTo = $utilitiesController->convertTodayToTimetsamp($request->transactionToDate . " 23:59:59");
        $dashboardDataPending = DB::table('transactiontmps')
            ->where([
                ['transactiontmp_reference', '=', null]
            ]);
        if ($request->transactionClient != 'all') {
            $dashboardDataPending = $dashboardDataPending->select(DB::raw('(select count(*) from transactiontmps where transactiontmp_type like "GOODS_IN"
            and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
            and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_goodsin'));

            if (($request->transactionCustomer && $request->transactionCustomer == 'all') || !isset($request->transactionCustomer)) {
                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO" and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "RMA_OUT" and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout'));


                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO"  and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_mobileReference is not null and user_id is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_mobile'));
            } else if ($request->transactionCustomer && $request->transactionCustomer != 'all') {
                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO"  and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . ' and
                transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "RMA_OUT"  and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . ' and
                transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO"
                and transactiontmp_reference is null and transactiontmp_mobileReference is not null
                and user_id is null and transactiontmp_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . ' and
                transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_mobile'));
            }


            $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps where transactiontmp_type like "RMA_IN"
            and transactiontmp_reference is null and transactiontmp_clientId = ' . $request->transactionClient . '
            and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmain'));
        } else {
            $dashboardDataPending = $dashboardDataPending->select(DB::raw('(select count(*) from transactiontmps where transactiontmp_type like "GOODS_IN"
            and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_goodsin'));

            if (($request->transactionCustomer && $request->transactionCustomer == 'all') || !isset($request->transactionCustomer)) {
                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO"  and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_delivery'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "RMA_OUT"  and transactiontmp_mobileReference is null
                and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_rmaout'));
                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO" and transactiontmp_mobileReference is not null
                and user_id is null and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_delivery_mobile'));
            } else if ($request->transactionCustomer && $request->transactionCustomer != 'all') {
                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO" and transactiontmp_mobileReference is null
                and clientCustomer_id = ' . $request->transactionCustomer . ' and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_delivery'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "RMA_OUT" and transactiontmp_mobileReference is null
                and clientCustomer_id = ' . $request->transactionCustomer . ' and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_rmaout'));

                $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps
                where transactiontmp_type like "DO" and transactiontmp_mobileReference is not null and user_id is null
                and clientCustomer_id = ' . $request->transactionCustomer . ' and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as
                total_delivery_mobile'));
            }

            $dashboardDataPending = $dashboardDataPending->selectRaw(DB::raw('(select count(*) from transactiontmps where transactiontmp_type like "RMA_IN"
            and transactiontmp_reference is null and transactiontmp_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmain'));
        }

        $dashboardDataPending = $dashboardDataPending->first();

        $dashboardDataCompleted = DB::table('transactions');
        if ($request->transactionClient != 'all') {
            $dashboardDataCompleted = $dashboardDataCompleted->select(DB::raw('(select count(*) from transactions where
            transaction_type like "GOODS_IN" and transaction_clientId = ' . $request->transactionClient . '
            and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_goodsin'));

            if (($request->transactionCustomer && $request->transactionCustomer == 'all') || !isset($request->transactionCustomer)) {
                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=true and transaction_clientId = ' . $request->transactionClient . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released=true and transaction_clientId = ' . $request->transactionClient . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=false and transaction_clientId = ' . $request->transactionClient . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released=false and transaction_clientId = ' . $request->transactionClient . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_mobileReference is not null and transaction_clientId = ' . $request->transactionClient . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_mobile'));
            } else if ($request->transactionCustomer && $request->transactionCustomer != 'all') {
                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=true and transaction_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released=true and transaction_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=false and transaction_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released=false and transaction_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and  transaction_mobileReference is not null and transaction_clientId = ' . $request->transactionClient . '
                and clientCustomer_id = ' . $request->transactionCustomer . '
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_mobile'));
            }

            $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
            transaction_type like "RMA_IN" and transaction_clientId = ' . $request->transactionClient . '
            and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmain'));
        } else {
            $dashboardDataCompleted = $dashboardDataCompleted->select(DB::raw('(select count(*) from transactions where
            transaction_type like "GOODS_IN"  and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_goodsin'));

            if (($request->transactionCustomer && $request->transactionCustomer == 'all') || !isset($request->transactionCustomer)) {
                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released= true and
                transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released= true and
                transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released= false and
                transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmaout_not_released'));


                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released= false and
                transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_mobileReference is not null
                and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_delivery_mobile'));
            } else if ($request->transactionCustomer && $request->transactionCustomer != 'all') {
                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=true and
                clientCustomer_id = ' . $request->transactionCustomer . ' and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ')
                as total_delivery'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "RMA_OUT" and transaction_released=true and
                clientCustomer_id = ' . $request->transactionCustomer . ' and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ')
                as total_rmaout'));


                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_released=false and
                clientCustomer_id = ' . $request->transactionCustomer . ' and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ')
                as total_delivery_not_released'));

                $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
                transaction_type like "DO" and transaction_mobileReference is not null  and
                clientCustomer_id = ' . $request->transactionCustomer . ' and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ')
                as total_delivery_mobile'));
            }

            $dashboardDataCompleted = $dashboardDataCompleted->selectRaw(DB::raw('(select count(*) from transactions where
            transaction_type like "RMA_IN"  and transaction_date between ' . $dateFrom . ' and ' . $dateTo . ') as total_rmain'));
        }

        $dashboardDataCompleted = $dashboardDataCompleted->first();

        $forwarders = DB::table('client_forwarders')
            ->selectRaw(DB::raw('(select count(*) from client_forwarders where clientforwarder_approved = false) as total_forwarders_notapproved'))
            ->selectRaw(DB::raw('(select count(*) from client_forwarders where clientforwarder_approved = true) as total_forwarders_approved'))
            ->first();

        $pallets = DB::table('client_storage_pallets')->count();

        $data = array();
        $defaultTotal = array(
            'total_goodsin' => 0,
            'total_delivery' => 0,
            'total_rmain' => 0,
            'total_delivery_mobile' => 0
        );
        $goodsInSerials = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->where([
                ['transactiontmps.transactiontmp_type', 'like', 'GOODS_IN'],
                ['transactiontmp_enterSerial', '=', true]
            ])
            ->whereBetween('transactiontmp_date', [$dateFrom, $dateTo]);
        if ($request->transactionClient != 'all') {
            $goodsInSerials->where([
                ['transactiontmp_clientId', '=', $request->transactionClient]
            ]);
        }
        if ($loggerUserCompany != null) {
            $goodsInSerials->where([
                ['transactiontmps.company_id', '=', $loggerUserCompany]
            ]);
        }
        $goodsInSerials = $goodsInSerials->count();

        $deliveryOrderSerials = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->where([
                ['transactiontmps.transactiontmp_type', 'like', 'DO'],
                ['transactiontmp_enterSerial', '=', true]
            ])
            ->whereBetween('transactiontmp_date', [$dateFrom, $dateTo]);
        if ($request->transactionClient != 'all') {
            $deliveryOrderSerials->where([
                ['transactiontmp_clientId', '=', $request->transactionClient]
            ]);
        }
        if ($loggerUserCompany != null) {
            $deliveryOrderSerials->where([
                ['transactiontmps.company_id', '=', $loggerUserCompany]
            ]);
        }
        $deliveryOrderSerials = $deliveryOrderSerials->count();

        $data['pending'] = $dashboardDataPending ? $dashboardDataPending : $defaultTotal;
        $data['completed'] = $dashboardDataCompleted ? $dashboardDataCompleted : $defaultTotal;
        $data['forwarders'] = $forwarders;
        $data['pallets'] = $pallets;

        $data['goodsInSerials'] = $goodsInSerials;
        $data['deliveryOrderSerials'] = $deliveryOrderSerials;

        return ApiController::successResponse($data, 200);
    }

    public function fetchTransactionsByTypeAndStatus(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'status' => 'required',
            'transactionType' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        if ($request->transactionType == 'GOODS_IN_SERIALS') {
            $request->transactionType = 'GOODS_IN';
        }
        if ($request->transactionType == 'DO_SERIALS') {
            $request->transactionType = 'DO';
        }
        $loggerUserCompany = auth()->user()->company_id;

        $utilitiesController = new UtilitiesController();
        $dateFrom = $utilitiesController->convertTodayToTimetsamp($request->form['transactionFromDate'] . "" . date('H:i:s'));
        $dateTo = $utilitiesController->convertTodayToTimetsamp($request->form['transactionToDate'] . "" . date('H:i:s'));

        if ($request->transactionType != 'MOBILE_DRAFTS') {

            if ($request->status != 'serials') {
                if ($request->status == 'pending') {
                    $transactions = DB::table('transactiontmps')
                        ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
                        ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
                        //->leftjoin('client_items','client_items.item_id','=','transactiontmps.transactiontmp_clientId')
                        ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
                        ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactiontmps.transactiontmp_supplierId')
                        ->whereBetween('transactiontmp_date', [$dateFrom, $dateTo])
                        ->orderBy('transactiontmp_date', 'desc')
                        ->where([
                            ['transactiontmp_reference', '=', null],
                            ['transactiontmp_mobileReference', '=', null],
                            ['transactiontmp_type', '=', $request->transactionType]
                        ]);
                    if ($request->form['transactionClient'] != 'all') {
                        $transactions->where([
                            ['transactiontmp_clientId', '=', $request->form['transactionClient']]
                        ]);
                    }
                    if (isset($request->form['transactionCustomer']) && $request->form['transactionClient'] != 'all') {
                        $transactions->where([
                            ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                        ]);
                    }
                    $transactions = $transactions->orderBy('transactiontmp_date');
                    // $transactions = $transactions->select('*');
                    $transactions = $transactions->get();
                    foreach ($transactions as $transaction) {
                        if ($transaction->transactiontmp_date) {
                            $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transactiontmp_date);
                        }
                    }
                } else if ($request->status == 'completed') {
                    $transactions = DB::table('transactions')
                        ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                        ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
                        ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
                        ->whereBetween('transaction_date', [$dateFrom, $dateTo])
                        ->where([
                            ['transaction_type', '=', $request->transactionType]
                        ])
                        ->orderBy('transaction_date', 'desc');
                    if ($request->form['transactionClient'] != 'all') {
                        $transactions->where([
                            ['transaction_clientId', '=', $request->form['transactionClient']]
                        ]);
                    }
                    if (isset($request->form['transactionCustomer']) && $request->form['transactionCustomer'] != 'all') {
                        $transactions->where([
                            ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                        ]);
                    }
                    $transactions = $transactions->orderBy('transaction_reference');
                    $transactions = $transactions->select('transaction_reference as transactiontmp_reference',
                        'clients.client_firstname', 'clients.client_id', 'transaction_billOfEntry as transactiontmp_billOfEntry', 'clientCustomer_id',
                        'transaction_remark as transactiontmp_remark', 'transaction_date', 'transaction_date as transactiontmp_date', 'transaction_id as transactiontmp_id', 'transaction_id',
                        'client_customers.customer_name', 'client_forwarders.clientforwarder_name',
                        'transaction_currencyId as transactiontmp_currencyId',
                        'transaction_exitPoint as transactiontmp_exitPoint', 'transaction_destinationPoint as transactiontmp_destinationPoint');
                    $transactions = $transactions->get();
                    foreach ($transactions as $transaction) {
                        if ($transaction->transaction_date) {
                            $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transaction_date);
                        }
                    }
                } else if ($request->status == 'Released') {
                    $transactions = DB::table('transactions')
                        ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                        ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
                        ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
                        ->whereBetween('transaction_date', [$dateFrom, $dateTo])
                        ->where([
                            ['transaction_type', '=', $request->transactionType],
                            ['transaction_released', true]
                        ])
                        ->orderBy('transaction_date', 'desc');
                    if ($request->form['transactionClient'] != 'all') {
                        $transactions->where([
                            ['transaction_clientId', '=', $request->form['transactionClient']]
                        ]);
                    }
                    if (isset($request->form['transactionCustomer']) && $request->form['transactionCustomer'] != 'all') {
                        $transactions->where([
                            ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                        ]);
                    }
                    $transactions = $transactions->orderBy('transaction_reference');
                    $transactions = $transactions->select('transaction_reference as transactiontmp_reference',
                        'clients.client_firstname', 'transaction_billOfEntry as transactiontmp_billOfEntry', 'clients.client_id', 'clientCustomer_id',
                        'transaction_remark as transactiontmp_remark', 'transaction_date', 'transaction_id as transactiontmp_id', 'transaction_id',
                        'client_customers.customer_name', 'client_forwarders.clientforwarder_name',
                        'transaction_currencyId as transactiontmp_currencyId',
                        'transaction_exitPoint as transactiontmp_exitPoint', 'transaction_destinationPoint as transactiontmp_destinationPoint');
                    $transactions = $transactions->get();
                    foreach ($transactions as $transaction) {
                        if ($transaction->transaction_date) {
                            $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transaction_date);
                        }
                    }
                } else if ($request->status == 'NotReleased') {
                    $transactions = DB::table('transactions')
                        ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                        ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
                        ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
                        //->leftjoin('client_items','client_items.item_id','=','transactiontmps.transactiontmp_clientId')
                        ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId')
                        ->whereBetween('transaction_date', [$dateFrom, $dateTo])
                        ->where([
                            ['transaction_type', '=', $request->transactionType],
                            ['transaction_released', false]
                        ])
                        ->orderBy('transaction_date', 'desc');
                    if ($request->form['transactionClient'] != 'all') {
                        $transactions->where([
                            ['transaction_clientId', '=', $request->form['transactionClient']]
                        ]);
                    }
                    if (isset($request->form['transactionCustomer']) && $request->form['transactionCustomer'] != 'all') {
                        $transactions->where([
                            ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                        ]);
                    }
                    $transactions = $transactions->orderBy('transaction_reference');
                    $transactions = $transactions->select('transaction_reference as transactiontmp_reference', 'clients.client_id', 'clients.client_id as transactiontmp_clientId',
                        'clients.client_firstname', 'transaction_billOfEntry as transactiontmp_billOfEntry', 'clientCustomer_id',
                        'transaction_remark as transactiontmp_remark', 'transaction_date', 'transaction_date as transactiontmp_date', 'transaction_id as transactiontmp_id', 'transaction_id',
                        'client_customers.customer_name', 'client_forwarders.clientforwarder_name', 'transaction_typeOfDeliveryId as transactiontmp_typeOfDeliveryId',
                        'transaction_shipById as transactiontmp_shipById', 'forwarder_id', 'transaction_driverName as transactiontmp_driverName',
                        'transaction_vehicleNumber as transactiontmp_vehicleNumber', 'transaction_paymentMethodId as transactiontmp_paymentMethodId', 'transaction_customBillTypeId as transactiontmp_customBillTypeId',
                        'transaction_currencyId as transactiontmp_currencyId', 'transaction_supplierId as transactiontmp_supplierId',
                        'transaction_exitPoint as transactiontmp_exitPoint', 'transaction_destinationPoint as transactiontmp_destinationPoint');
                    $transactions = $transactions->get();
                    foreach ($transactions as $transaction) {
                        if ($transaction->transaction_date) {
                            $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transaction_date);
                        }
                    }
                }
            } else if ($request->status == 'serials') {
                $transactions = DB::table('transactiontmps')
                    ->join('users', 'users.id', '=', 'transactiontmps.user_id')
                    ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
                    ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
                    ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
                    ->whereBetween('transactiontmp_date', [$dateFrom, $dateTo])
                    ->where([
                        ['transactiontmp_type', '=', $request->transactionType],
                        ['transactiontmp_enterSerial', '=', true],
                        ['transactiontmps.company_id', '=', $loggerUserCompany],
                    ])
                    ->orderBy('transactiontmp_date', 'desc');
                if ($request->form['transactionClient'] != 'all') {
                    $transactions->where([
                        ['transactiontmp_clientId', '=', $request->form['transactionClient']]
                    ]);
                }
                if (isset($request->form['transactionCustomer']) && $request->form['transactionCustomer'] != 'all') {
                    $transactions->where([
                        ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                    ]);
                }
                $transactions = $transactions->get();
                foreach ($transactions as $transaction) {
                    if ($transaction->transactiontmp_date) {
                        $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transactiontmp_date);
                    }
                }
            }
        } else if ($request->transactionType == 'MOBILE_DRAFTS') {
            if ($request->status == 'pending') {
                $transactions = DB::table('transactiontmps')
                    ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
                    ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
                    //->leftjoin('client_items','client_items.item_id','=','transactiontmps.transactiontmp_clientId')
                    ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
                    ->whereBetween('transactiontmp_date', [$dateFrom, $dateTo])
                    ->where([
                        ['transactiontmp_reference', '=', null],
                        ['transactiontmps.user_id', '=', null],
                        ['transactiontmps.transactiontmp_mobileReference', '!=', null],
                        ['transactiontmp_type', 'like', 'DO']
                    ])
                    ->orderBy('transactiontmp_date', 'desc');
                if ($request->form['transactionClient'] != 'all') {
                    $transactions->where([
                        ['transactiontmp_clientId', '=', $request->form['transactionClient']]
                    ]);
                }
                if (isset($request->form['transactionCustomer']) && $request->form['transactionClient'] != 'all') {
                    $transactions->where([
                        ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                    ]);
                }
                $transactions = $transactions->orderBy('transactiontmp_date');
                // $transactions = $transactions->select('*');
                $transactions = $transactions->get();
                foreach ($transactions as $transaction) {
                    if ($transaction->transactiontmp_date) {
                        $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transactiontmp_date);
                    }
                }
            } else {
                $transactions = DB::table('transactions')
                    ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                    ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
                    ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
                    ->whereBetween('transaction_date', [$dateFrom, $dateTo])
                    ->where([
                        ['transaction_type', 'like', 'DO'],
                        ['transactions.user_id', '!=', null],
                        ['transactions.transaction_mobileReference', '!=', null],
                    ])
                    ->orderBy('transaction_date', 'desc');
                if ($request->form['transactionClient'] != 'all') {
                    $transactions->where([
                        ['transaction_clientId', '=', $request->form['transactionClient']]
                    ]);
                }
                if (isset($request->form['transactionCustomer']) && $request->form['transactionCustomer'] != 'all') {
                    $transactions->where([
                        ['clientCustomer_id', '=', $request->form['transactionCustomer']]
                    ]);
                }
                $transactions = $transactions->orderBy('transaction_reference');
                $transactions = $transactions->select('transaction_reference as transactiontmp_reference', 'clients.client_id',
                    'clients.client_firstname', 'transaction_billOfEntry as transactiontmp_billOfEntry',
                    'transaction_remark as transactiontmp_remark', 'transaction_date', 'transaction_id as transactiontmp_id', 'transaction_id', 'clientCustomer_id',
                    'client_customers.customer_name', 'client_forwarders.clientforwarder_name',
                    'transaction_exitPoint as transactiontmp_exitPoint', 'transaction_destinationPoint as transactiontmp_destinationPoint');
                $transactions = $transactions->get();
                foreach ($transactions as $transaction) {
                    if ($transaction->transaction_date) {
                        $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transaction_date);
                    }
                }
            }
        }


        return ApiController::successResponse($transactions, 200);
    }
}
