<?php

namespace App\Http\Controllers\BackOffice\TO;


use App\enums\NotificationTopics;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\companies;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\Notifications\NotificationsController;
use App\Http\Controllers\BackOffice\TO\TOServices;
use App\Models\items;
use App\Models\country;
use App\Models\Localization;
use App\Models\notifications;
use Illuminate\Support\Facades\Log;

use Carbon\Carbon;
use JWTAuth;
use PDF;

class TOController extends ApiController
{
    // $commonController = new CommonServices();

    public function fetchTransactions(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $commonServices = new CommonServices();
        $dateFrom = $request->dateFrom;
        $dateTo = $request->dateTo;


        $count = 0;
        $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('clients as toClient', 'toClient.client_id', '=', 'transactions.transferTo_clientId')
            ->leftjoin('clients as toClientdt', 'toClientdt.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId');

        $transactions = $transactions
            ->select(
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'client_customers.customer_name',
                'client_forwarders.clientforwarder_name',
                'clients.client_firstname',
                'clients.client_id',
                'toClient.client_firstname as transferToClient',
                'transactions.transaction_id',
                'salesjv_id',
                'transaction_type',
                'transaction_currencyId',
                'currency_code',
                'transactions.transaction_released',
                'transactions.transaction_releasedDate',
                'transactions.transaction_remark',
                'transaction_billOfEntry',
                'transaction_shipmentReference',
                'transaction_exitPoint',
                'transaction_destinationPoint',
                'transaction_shipmentRemark',
                'transactions.transaction_mobileReference',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_released_DEC',
                'internal_transfer',
                'transferTo_clientId',
                'toClientdt.client_firstname as dtName',
                'transaction_arrived',
                'way_bill_no',
                'tir',
                'job_no',
                'transactions.transaction_id'
            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_releasedDate, '%d-%m-%Y %H:%i:%s ') AS transaction_releasedDate"))
            ->selectRaw(DB::raw("(SELECT SUM(transactiondt_priceBase*item_quantity) FROM transaction_dts WHERE transaction_id = transactions.transaction_id) AS total_price"))
            ->where([
                ['transaction_type', transactions::transactionTypes["$request->transactionType"]['type']],
                ['internal_transfer', transactions::transactionTypes["$request->transactionType"]["internalTransfer"]]
            ])
            ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$dateFrom, $dateTo])
            ->orderBy('transaction_reference', 'desc');
        $count = count($transactions->groupby('transaction_id')->get());
        if (isset($request->skip) && isset($request->take)) {
            $transactions->skip($request->skip)
                ->take($request->take);
        }
        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ])
                    ->orWhere([
                        ['transaction_mobileReference', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['transaction_remark', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['clients.client_firstname', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['toClientdt.client_firstname', 'like', '%' . $request->search . '%']
                    ]);
            });
        }
        $transactions = $transactions
            ->groupby('transaction_id')->get();

        foreach ($transactions as $splitTrans) {

            $multiDelivery = transactionDt::where('transaction_id', $splitTrans->transaction_id)
                ->groupby('client_id')
                ->get();

            if (count($multiDelivery) > 1) {
                $splitTrans->client_firstname = '-';
            }
        }




        if ($transactions) {
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }


    public function cancelTransactionTmpTable(Request $request)
    {
        $TransationDtTmp = transactiondttmp::where('transactiontmp_id', '=', $request->transactionTmpId)->get();
        $transactionType = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->first();
        $cancelTransactionTmp = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
        $cancelTransactiontmpPalets = TransactiontmpPalets::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();

        foreach ($TransationDtTmp as $transactionDetailTmp) {
            transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDetailTmp->transactiondttmp_id)->delete();
        }
        $cancelTransationDtTmp = transactiondttmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->delete();
        DB::table('client_storage_pallets_tmp')->where('related_transaction_id', $request->transactionTmpId)->delete();

        $path = public_path() . '/documents/' . $transactionType->transactiontmp_type . '/' . $request->transactionTmpId . '/' . $request->file;

        if (file_exists($path) && $transactionType->transactiontmp_reference == null) {
            $deleteFile = File::deleteDirectory($path);
        }


        $transferTrans = transactiontmp::where('relatedTransferId', $request->transactionTmpId)
            ->first();
        if ($transferTrans) {
            transactiontmp::where('transactiontmp_id', $transferTrans->transactiontmp_id)->delete();
            transactiondttmp::where('transactiondttmp_id', $transferTrans->transactiontmp_id)->delete();
        }

        return ApiController::successResponse($cancelTransactionTmp, 200);
    }



    public function createTransactionTmpTO(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $commonController = new CommonServices();
        $tOServices = new TOServices();

        $validator = Validator::make($request->all(), [
            'transactionDate' => 'required',
            'transactionType' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $user = auth()->user();
        $companyId = companies::get();
        $transactionTmpId = $request->transactionTmpId;

        // in case it is an original transaction copy the transaction to tmp table
        $checkOriginalTransactionExistance = transactions::getTransaction($transactionTmpId);
        $getCurrentTransaction = transactiontmp::getTransaction($transactionTmpId);
        transactiondttmp::updatePriceBase($getCurrentTransaction, $request->transactionTmpId, $request->transactionRate);



        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transactionDate . "" . date('H:i:s')),
            'transactiontmp_type' => transactions::transactionTypes["$request->transactionType"]["type"],
            'transactiontmp_remark' => $request->transactionRemark,
            'transferTo_clientId' => $request->transactionClientTo,
            'internal_transfer' => transactions::transactionTypes["$request->transactionType"]["internalTransfer"],
            'transactiontmp_shipmentReference' => $request->transactionShipmentReference,
            'transactiontmp_billOfEntry' => $request->transactionBillOfEntry,
            'transactiontmp_clientId' => $request->transactionClient,
            'user_id' => $user->id,
            'transactiontmp_reference' => isset($checkOriginalTransactionExistance->transaction_reference) ? $checkOriginalTransactionExistance->transaction_reference : null,
            'transactiontmp_typeOfDeliveryId' => $request->orderDeliveryType,
            'forwarder_id' => $request->orderForwarder,
            'clientCustomer_id' => isset($request->transactionCustomer) ? $request->transactionCustomer : null,
            'transactiontmp_driverName' => $request->orderDriverName,
            'transactiontmp_driverPhone' => $request->orderDriverPhone,
            'transactiontmp_vehicleNumber' => $request->orderVehicleNumber,
            'transactiontmp_exitPoint' => $request->orderExitPoint,
            'transactiontmp_destinationPoint' => $request->orderDestinationPoint,
            'company_id' => $companyId,
            'transactiontmp_paymentMethodId' => $request->orderPaymentMethod,
            'transactiontmp_customBillTypeId' => $request->orderCustomBillType,
            'transactiontmp_currencyId' => $request->transactionCurrency,
            'transactiontmp_rate' => $request->transactionRate,
            'transactiontmp_shipmentTypeId' => $request->transactionShipmentType,
            'transactiontmp_shipById' => $request->shipBy,
            'transactiontmp_shipmentRemark' => $request->transactionShipmentRemark,
            'transactiontmp_supplierId' => $request->transactionSupplier,
            'transactiontmp_supplierInvoice' => $request->transactionSupplierInvoice,
            'way_bill_no' => $request->wayBillNOControl,
            'tir' => $request->tirControl,
            'job_no' => $request->jobNoControl,
            'transactiontmp_driverPhone' => $request->orderDriverPhone,
            'transactiontmp_driverName' => $request->orderDriverName,
        );


        return $tOServices->saveTmpTransaction($transactionTmpId, $transactionTmp);
    }

    public function storeTransactionDtTmp(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $commonController = new CommonServices();
        $tOServices = new TOServices();
        $validator = Validator::make($request->all(), [
            'transactionDetailsTmp' => 'required|array',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $transactionDetailsTmp = $request->transactionDetailsTmp;
        $transactionTmpId = $request->transactionTmpId;
        return $tOServices->storeTransactionDtTmpFunction($transactionDetailsTmp, $transactionTmpId);
    }

    public function insertNewTOTransaction(Request $request)
    {
        $date = date('Y-m-d H:i:s');
        $historyController = new HistoryController();
        $utilitiesController = new UtilitiesController();
        $hitoryArray = array();
        $state = "Insert";
        // retrieve the current transaction tmp
        $checkTransactionTmpExistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->first();

        // retrieve the current transaction dt tmp
        $transactionDtsTmp = transactiondttmp::join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->select('transactiondttmps.*', 'items.item_hasSerial')
            ->where('transactiontmp_id', '=', $request->transactionTmpId)
            ->get();

        $navigationTypeOUT = 'TO';





        // delete previous transactions dts
        $previousDtData = null;
        if ($request->transactionId) {
            transactiondt::where('transaction_id', '=', $request->transactionId)->delete();
        }
        $newTransaction = null;
        $getSequence = null;


        if ($checkTransactionTmpExistance) {

            //return ApiController::errorResponse($transactionDtsTmp,422);
            $getSequence = sequence::where('sequence_transactionType', 'like', $checkTransactionTmpExistance->transactiontmp_type)->first();

            if (!$getSequence) {
                return ApiController::errorResponse($getSequence, 422);
            }

            $sequenceNumber = $getSequence->sequence_transactionRef + 1;
            $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;


            $transaction = array(
                'transaction_reference' => $goodsInSequence,
                'transaction_id' => $checkTransactionTmpExistance->transactiontmp_id,
                'transaction_time' => $checkTransactionTmpExistance->transaction_time,
                'transaction_date' => $checkTransactionTmpExistance->transactiontmp_date,
                'transaction_clientId' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
                'transaction_remark' => $checkTransactionTmpExistance->transactiontmp_remark,
                'transaction_mobileReference' => $checkTransactionTmpExistance->transactiontmp_mobileReference,
                'transaction_shipmentReference' => $checkTransactionTmpExistance->transactiontmp_shipmentReference,
                'transaction_billOfEntry' => $checkTransactionTmpExistance->transactiontmp_billOfEntry,
                'user_id' => $checkTransactionTmpExistance->user_id,
                'transaction_typeOfDeliveryId' => $checkTransactionTmpExistance->transactiontmp_typeOfDeliveryId,
                'forwarder_id' => $checkTransactionTmpExistance->forwarder_id,
                'clientCustomer_id' => $checkTransactionTmpExistance->clientCustomer_id,
                'transaction_driverName' => $checkTransactionTmpExistance->transactiontmp_driverName,
                'transaction_driverPhone' => $checkTransactionTmpExistance->transactiontmp_driverPhone,

                'transaction_vehicleNumber' => $checkTransactionTmpExistance->transactiontmp_vehicleNumber,
                'transaction_exitPoint' => $checkTransactionTmpExistance->transactiontmp_exitPoint,
                'transaction_destinationPoint' => $checkTransactionTmpExistance->transactiontmp_destinationPoint,
                'company_id' => $checkTransactionTmpExistance->company_id,
                'transaction_paymentMethodId' => $checkTransactionTmpExistance->transactiontmp_paymentMethodId,
                'transaction_customBillTypeId' => $checkTransactionTmpExistance->transactiontmp_customBillTypeId,
                'transaction_currencyId' => $checkTransactionTmpExistance->transactiontmp_currencyId,
                'transaction_rate' => $checkTransactionTmpExistance->transactiontmp_rate,
                'transaction_shipmentTypeId' => $checkTransactionTmpExistance->transactiontmp_shipmentTypeId,
                'transaction_shipById' => $checkTransactionTmpExistance->transactiontmp_shipById,
                'transaction_shipmentRemark' => $checkTransactionTmpExistance->transactiontmp_shipmentRemark,
                'transaction_supplierId' => $checkTransactionTmpExistance->transactiontmp_supplierId,
                'transaction_supplierInvoice' => $checkTransactionTmpExistance->transactiontmp_supplierInvoice,
                'transaction_totalQty' => $checkTransactionTmpExistance->transactiontmp_totalQty,
                'transaction_totalPallet' => $checkTransactionTmpExistance->transactiontmp_totalPallet,
                'transaction_totalPrice' => $checkTransactionTmpExistance->transaction_totalPrice,
                'transaction_totalItem' => $checkTransactionTmpExistance->transaction_totalItem,
                'transaction_BOE' => $checkTransactionTmpExistance->transactiontmp_BOE,
                'transaction_released_DEC' => $checkTransactionTmpExistance->transaction_released_DEC,
                'way_bill_no' => $checkTransactionTmpExistance->way_bill_no,
                'tir' => $checkTransactionTmpExistance->tir,
                'job_no' => $checkTransactionTmpExistance->job_no,

            );


            if ($checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference) {

                $newTransaction = transactions::create($transaction);
                $notificationController = new NotificationsController();
                $notificationController->sendNotificationsByTopic(auth()->user()->id,NotificationTopics::TO_CREATED, $newTransaction->transaction_id,$newTransaction->transaction_reference);

            } else {
                transactions::where('transaction_id', '=', $request->transactionId)->update($transaction);
                $newTransaction = transactions::where('transaction_id', '=', $request->transactionId)->first();
            }

            if (!$checkTransactionTmpExistance->transactiontmp_reference) {
                sequence::where('sequence_transactionType', 'like', $checkTransactionTmpExistance->transactiontmp_type)->increment('sequence_transactionRef', 1);
            }

            // after saving and creation of transaction or update get tmp transaction dt into original and remove from tmp
            if ($newTransaction) {
                // start : transfer supplier to client suppliers


                $insertDtFound = array();
                foreach ($transactionDtsTmp as $transactionDtTmp) {
                    if ($transactionDtTmp->state == 'deleted') continue;

                    $newTransactionDt = new transactionDt();
                    $newTransactionDt->transactiondt_id = $transactionDtTmp->transactiondttmp_id;
                    $newTransactionDt->transaction_id = $newTransaction->transaction_id;
                    $newTransactionDt->item_id = $transactionDtTmp->item_id;
                    $newTransactionDt->client_id = $transactionDtTmp->client_id;
                    $newTransactionDt->item_quantity = $transactionDtTmp->item_quantity;
                    $newTransactionDt->supplier_id = $transactionDtTmp->supplier_id;
                    $newTransactionDt->supplier_invoice_number = $transactionDtTmp->supplier_invoice_number;
                    $newTransactionDt->transactiondt_locationid = $transactionDtTmp->transactiondttmp_locationid;
                    $newTransactionDt->transactiondt_countryOfOrigin = $transactionDtTmp->transactiondttmp_countryOfOrigin;
                    $newTransactionDt->transactiondt_price = $transactionDtTmp->transactiondttmp_price;
                    $newTransactionDt->transactiondt_priceBase = $transactionDtTmp->transactiondttmp_priceBase;
                    $newTransactionDt->id_reference_dt = $transactionDtTmp->id_reference_dt;
                    $newTransactionDt->transactiondt_billOfEntry = $transactionDtTmp->transactiontmpdt_billOfEntry;
                    $newTransactionDt->raw_in_grid = $transactionDtTmp->raw_in_grid;
                    $newTransactionDt->item_weight = $transactionDtTmp->item_weight;
                    $newTransactionDt->item_unit = $transactionDtTmp->item_unit;
                    $newTransactionDt->item_qtyPerPack = $transactionDtTmp->item_qtyPerPack;
                    $newTransactionDt->item_pack = $transactionDtTmp->item_pack;
                    $newTransactionDt->group_id = $transactionDtTmp->group_id;
                    $newTransactionDt->palet_no = $transactionDtTmp->palet_no;
                    $newTransactionDt->transactiondt_nbOfCarton = $transactionDtTmp->transactiondttmp_nbOfCarton;
                    $newTransactionDt->transactiondt_cellMerge = $transactionDtTmp->transactiondttmp_cellMerge;
                    $newTransactionDt->transactiondt_BOE = $transactionDtTmp->transactiontmpdt_BOE;
                    $newTransactionDt->transactiondt_fprice = $transactionDtTmp->transactiondttmp_fprice;
                    $newTransactionDt->transactiondt_fpriceBase = $transactionDtTmp->transactiondttmp_fpriceBase;
                    $newTransactionDt->hscode = $transactionDtTmp->hscode;
                    $newTransactionDt->transactiondt_item_description = $transactionDtTmp->transactiondt_item_description;
                    $newTransactionDt->total_price = $transactionDtTmp->total_price;
                    $newTransactionDt->total_weight = $transactionDtTmp->total_weight;
                    $newTransactionDt->gross_weight = $transactionDtTmp->gross_weight;
                    $newTransactionDt->total_gross_weight = $transactionDtTmp->total_gross_weight;

                    $newTransactionDt->save();


                    array_push($insertDtFound, $transactionDtTmp->transactiondttmp_id);
                    // start : transfer items to client items

                    if ($transactionDtTmp->item_id) {
                        //$this->createClientItems($transactionDtTmp, $newTransaction->transaction_clientId);
                    }
                    // end : transfer items to client items


                    //   $newTransactionDt = transactiondt::create($transactionDtArray);

                }

                transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
            }
            //  $historyController->insertHistoryTransactionDtData($previousDtData, $insertDtFound, $date, $transactionIndex, auth()->user()->id);
        }
        return ApiController::errorResponse('some thing error', 200);
    }



    public function importTODetail(Request $request)
    {
        $records = $request->data; 
        $rate = $request->rate;
    
        $utilitiesController = new UtilitiesController();
        $company = companies::first();
    
        $validRecords = [];
        $invalidData = [];
        $transactionTmpId = $request->transactionId;
        $transactionTmp = transactiontmp::where('transactiontmp_id', '=', $transactionTmpId)->first();
    
        $headers = $records[0];
        unset($records[0]); 
            $headerMap = array_flip($headers);
    
        foreach ($records as $index => $record) {
            if (empty(array_filter($record))) {
                continue; 
            }
    
            $invalidRecord = ['Record' => $index + 1, 'message' => ''];
            $itemCode = $record[$headerMap['item_code']] ?? null;
            $itemDescription = $record[$headerMap['item_description']] ?? null;
            $hscode = $record[$headerMap['hscode']] ?? null;
            $countryCode = $record[$headerMap['country Of Origin code']] ?? null;
            $quantity = $record[$headerMap['QTY']] ?? null;
            $price = $record[$headerMap['PRICE']] ?? null;
            $totalWeight = $record[$headerMap['WEIGHT']] ?? null;
            $itemPack = $record[$headerMap['PACK']] ?? '-';
            $qtyPerPack = $record[$headerMap['QTY/PACK']] ?? 1;
            $itemUnit =isset($headerMap['ITEM_UNIT']) ?  $record[$headerMap['ITEM_UNIT']]:'u';
            $totalWeight = $record[$headerMap['WEIGHT']] ?? null;
            $grossWeight = isset($headerMap['Gross_Weight']) && $record[$headerMap['Gross_Weight']] ? $record[$headerMap['Gross_Weight']]:null ;
    
            $item = items::where('item_code', trim($itemCode))->first();
            $country = country::where('country_code', trim($countryCode))
                ->orWhere('country_name', trim($countryCode))
                ->first();
    
            $errorMessages = [];
             $errorMessages[] = $utilitiesController->validateItem($item);
             $errorMessages[] = $utilitiesController->validateQuantity($quantity);
             $errorMessages[] = $utilitiesController->validatePrice($price);
             $errorMessages[] = $utilitiesController->validateWeight($totalWeight);
             $errorMessages[] = $utilitiesController->validateCountry($country);
    
            if ($company->company_grossWeight === 1) {
                $errorMessages[] = $utilitiesController->validateGrossWeight($totalWeight,$grossWeight);
            }else{
                $grossWeight= $totalWeight;
            }
    
            $errorMessages = array_filter($errorMessages);
    
            if (!empty($errorMessages)) {
                $invalidRecord['Item'] = $itemCode;
                $invalidRecord['message'] = implode(', ', $errorMessages);
                $invalidData[] = $invalidRecord;
                continue;
            }
    
            // Prepare transaction details
            $transactionDtArray = [
                'transactiontmp_id' => $transactionTmpId,
                'item_id' => $item->item_id,
                'transactiondt_item_description' => $itemDescription,
                'hscode' => $hscode,
                'item_quantity' => $quantity,
                'transactiondttmp_countryOfOrigin' => $country->country_id ?? null,
                'transactiondttmp_price' => $price / $quantity,
                'transactiondttmp_priceBase' => ($price / $quantity) * $rate,
                'item_weight' => $totalWeight / $quantity,
                'total_weight' => $totalWeight,
                'gross_weight' => $grossWeight / $quantity,
                'total_gross_weight' => $grossWeight,
                'total_price' => $price,
                'client_id' => $transactionTmp->transactiontmp_clientId,
                'transactiontmpdt_BOE' => $transactionTmp->transactiontmp_BOE,
                'transactiontmpdt_billOfEntry' => $transactionTmp->transactiontmp_billOfEntry,
                'item_unit' => $itemUnit,
                'item_pack' => $itemPack,
                'item_qtyPerPack' => $qtyPerPack
            ];
    
            $validRecords[] = $transactionDtArray;
        }
    
        if (empty($invalidData)) {
            transactiondttmp::insert($validRecords);
        }
    
        $result = [
            'data' => 'success',
            'invalidData' => $invalidData,
        ];
    
        return ApiController::successResponse($result, 200);
    }



    function validateItem($item, $record) {
        return $item ? '' : 'Invalid Item';
    }

    function validateQuantity($record) {
        return is_numeric($record[5]) ? '' : 'Invalid QTY';
    }

    function validatePrice($record) {
        return is_numeric($record[6]) ? '' : 'Invalid Price';
    }

    function validateWeight($record) {
        return isset($record[7]) && is_numeric($record[7]) ? '' : 'Invalid Weight';
    }

    function validateCountry($country) {
        return $country ? '' : 'Invalid Country';
    }

    function validateGrossWeight($record) {
        if (!isset($record[8])) {
            return '';
        }

        if (!is_numeric($record[8])) {
            return 'Invalid Gross Weight';
        }

        if (is_numeric($record[7]) && $record[8] < $record[7]) {
            return 'Invalid Gross Weight, Gross Weight must be greater than net weight';
        }

        return '';
    }

    public function importTOFromTxt(Request $request)
    {

        $file = $request->file('file');

        // Process the file (e.g., store it, read its contents, etc.)
        $contents = file_get_contents($file->path());
        $splitFile = explode("\n", $contents);
        $user_id = JWTAuth::user()->id;
        $companyId = auth()->user()->company_id;
        $clientId = $request->clientId;
        $utilitiesController = new UtilitiesController();
        $commonServices = new CommonServices();
        $dateFormat = $commonServices->dubaiTradeDAteFormatService();

        $dateFormat = str_replace('%', '', $dateFormat);

        $i = 0;
        $transactiontmp_id = 0;
        $header_response = null;
        $currencyCode = '';
        $currencyIdValue = 0;
        $currencyRateValue = 1;
        $errorArray = array();
        $errorMessage = '';
        if (count($splitFile) > 0) {

            //  $header=$splitFile[0];
            //   $trade = '"IH",' . '"' . $header->transaction_reference . '",' . '"' . $header->transaction_formatdate . '",' . '"pg",' . '"' . $header->Invoice_type_id . '",' . '"' . $seller . '",' . '"' . $header->payment_term_id . '",' . '"0",' . '"' . $header->currency_code . '",' . '"' . $totalValue->totalValues . '",' . '"' . $header->delivery_term_id . '",' . '"",' . '"",' . '"' . $defaultCurrency->currency_name . '",' . '""';


            foreach ($splitFile as $data) {
                if ($i == 0) {

                    $headerData = explode(",", $data);
                    $headerData = str_replace("\"", '', $headerData);
                    $date = $headerData[$commonServices->indexOfFieldsDubaiTraderService('headerDate')];
                    $currencyCode = $headerData[$commonServices->indexOfFieldsDubaiTraderService('headerCurrencyCode')];
                    $supplierInvoice = $headerData[$commonServices->indexOfFieldsDubaiTraderService('headerSupplier')];
                    $date = str_replace("\"", '', $date);
                    $date = Carbon::createFromFormat($dateFormat, $date);
                    $date = str_replace("\"", '', $date);
                    $dateConvert = $utilitiesController->convertTodayToTimetsamp($date);
                    $date = str_replace("\"", '', $date);
                    $currencyId = DB::table('currency')
                        ->where('currency_code', $currencyCode)
                        ->first();
                    if ($currencyId) {
                        $currencyIdValue = $currencyId->currency_id;
                        $currencyRate = $utilitiesController->getCurrencyRateFunction($currencyId->currency_id, $date);
                        $currencyRateValue = $currencyRate[0]->CurRate;
                    }

                    $currentDateTime = Carbon::now();
                    $formattedTime = $currentDateTime->format('H:i');
                    // transactiondttmpPrice
                    $transactionTmpArray = array(
                        'transactiontmp_date' => $dateConvert,
                        'transaction_time' => $formattedTime,
                        'transactiontmp_type' => 'TO',
                        'transactiontmp_remark' => 'test import',
                        'transactiontmp_billOfEntry' => null,
                        'user_id' => $user_id,
                        'forwarder_id' => $request->orderForwarder,
                        'clientCustomer_id' => $request->transactionCustomer,
                        'company_id' => $companyId,
                        'transactiontmp_currencyId' => $currencyIdValue,
                        'transactiontmp_rate' => $currencyRateValue,
                        'transactiontmp_shipmentRemark' => $request->transactionShipmentRemark,
                        'transactiontmp_supplierId' => $request->transactionSupplier,
                        'transactiontmp_supplierInvoice' => $supplierInvoice,
                        'transactiontmp_BOE' => $request->transactionBOE != '' ? $request->transactionBOE : '-',
                        'transactiontmp_clientId' => $clientId
                    );
                    $header_response = transactiontmp::create($transactionTmpArray);
                    $header_response['client_id'] = (float) $clientId;
                    $header_response['transactiontmp_formatdate'] = date('Y-m-d', $header_response->transactiontmp_date);

                    $transactiontmp_id = $header_response->transactiontmp_id;
                    $i++;
                } else {
                    $details = explode(",", $data);
                    $details = str_replace("\"", '', $details);

                    //      '"ID"' . ',"' . $index . '","' . '' . $splitDetails->hscode . '"' . "," . '"' . $splitDetails->item_description . '"' . "," . '"N",' . '"' . $splitDetails->item_unit . '","'.$splitDetails->item_quantity.'",' . '"kg",' . '"' . $grossWeight . '"' . "," . '"","",' . '"' . $grossPrice . '",' . '"' . $splitDetails->country_code . '",' . '"",' . '"","",' . '"",' . '"' . $header->exemption_type_id . '",' . '""';
                    if (count($details) < 2) continue;

                    $itemCode = $details[$commonServices->indexOfFieldsDubaiTraderService('itemCodeDetail')];
                    $description = $details[$commonServices->indexOfFieldsDubaiTraderService('descriptionDetail')];
                    $qty = $details[$commonServices->indexOfFieldsDubaiTraderService('qtyDetail')];
                    $grossWeight = $details[$commonServices->indexOfFieldsDubaiTraderService('grossWeight')];
                    $grossPrice = $details[$commonServices->indexOfFieldsDubaiTraderService('grossPrice')];
                    $countryCode = $details[$commonServices->indexOfFieldsDubaiTraderService('countryCode')];
                    $price = (float)$grossPrice / (float)$qty;
                    $weight = (float)$grossWeight / (float)$qty;
                    $item = Items::where('item_hscode', $itemCode)
                        ->first();
                    if (!$item) {
                        $errorMessage = $errorMessage . "\n" . 'Item ' . $itemCode . ' not found';
                        array_push($errorArray, $itemCode);
                        continue;
                        return 'Item ' . $itemCode . ' not found';
                    }
                    // return $item;
                    $country = DB::table('countries')->where('country_code', $countryCode)
                        ->first();
                    $itemId = 0;
                    $countryId = 0;
                    if ($item) {
                        $itemId = $item->item_id;
                    } else {
                    }
                    if ($country) {
                        $countryId = $country->country_id;
                    }
                    $transactiondtTmp = array(
                        'transactiontmp_id' => $transactiontmp_id,
                        'transactiontmpdt_BOE' => null,
                        'item_id' => $itemId,
                        'group_id' => null,
                        'transactiondt_item_description' => $description,
                        'item_quantity' => $qty,
                        'transactiontmpdt_billOfEntry' => null,
                        'transactiondttmp_locationid' => null,
                        'transactiondttmp_countryOfOrigin' => $countryId,
                        'transactiondttmp_price' => $price,
                        'transactiondttmpPriceBase' => $price * $currencyRateValue,
                        'id_reference_dt' => null,
                        'raw_in_grid' => null,
                        'palet_no' => null,
                        'item_weight' => $weight,
                        'item_qtyPerPack' => 1,
                        'item_pack' => "-",
                        'transactiondttmp_nbOfCarton' => " ",
                        'transactiondttmp_cellMerge' => " ",
                        'item_unit' => 'u',
                        'client_id' => $clientId,
                        'transactiondttmp_fprice' => 0,
                        'transactiondttmp_fpriceBase' => 0,
                        'hscode' => $itemCode,
                        'supplier_invoice_number' => null,
                        'total_price' => $grossPrice,
                        'total_weight' => $grossWeight,
                        'state' => 'new',
                        'supplier_id' => null,

                    );
                    $detail_response = transactiondttmp::create($transactiondtTmp);
                }
            }
        }
        $obj = array();
        $obj['data'] = $header_response;
        $obj['error'] = $errorArray;
        $obj['errorMessage'] = $errorMessage;


        return ApiController::successResponse($obj, 200);
    }


    public function printManifest(Request $request)
    {

        $UtilitiesController = new UtilitiesController();

        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $requestData = $UtilitiesController->decipherRequest($request->transactionId);
        $requestData = json_decode($requestData);

        $request = $requestData->info->id;
        $language = $requestData->info->language;
        $company = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', 'companies.currency')
            ->first();


        $finalData = DB::table('transactions')
            ->whereIn('transactions.transaction_id', $request)
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')

            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('clients.client_firstName', 'transactions.*', 'transaction_dts.item_id', 'client_customers.customer_name', 'client_forwarders.clientforwarder_name')
            ->get();


        $recordWithSmallestReference = $finalData->sortBy('transaction_reference')->first();
        $recordWithSmallestReference->transaction_date = date('d-m-Y', $recordWithSmallestReference->transaction_date);


        $collectDataClient = collect($finalData)
            ->groupBy('transaction_clientId',)
            ->map(function ($group,) {
                $transaction_clientId = $group->pluck('transaction_clientId')->unique()->first();
                $client_firstName = $group->pluck('client_firstName')->unique()->first();

                return [
                    'transaction_clientId' => $transaction_clientId,
                    'client_firstName' => $client_firstName,
                ];
            })
            ->values();
        $groupedClient = $collectDataClient->pluck('client_firstName')->toArray();

        $collectDataDest = collect($finalData)
            ->groupBy('transaction_destinationPoint',)
            ->map(function ($group,) {
                $transaction_destinationPoint = $group->pluck('transaction_destinationPoint')->unique()->first();

                return [
                    'transaction_destinationPoint' => $transaction_destinationPoint,
                ];
            })
            ->values();



        if (count($groupedClient) > 1) {
            return ApiController::errorResponse('Multible Client Invalid', 422);
        }

        $clientName = implode(' ', $groupedClient);



        $collectData = collect($finalData)
            ->groupBy('transaction_released_DEC',)
            ->map(function ($group,) {
                $transaction_released_DEC = $group->pluck('transaction_released_DEC')->unique()->first();
                return [
                    'transaction_released_DEC' => $transaction_released_DEC,
                ];
            })
            ->values();
        $groupedDEC = $collectData->pluck('transaction_released_DEC')->toArray();

        $collectDataDes = collect($finalData)
            ->groupBy('transaction_destinationPoint',)
            ->map(function ($group,) {
                $transaction_destinationPoint = $group->pluck('transaction_destinationPoint')->unique()->first();
                return [
                    'transaction_destinationPoint' => $transaction_destinationPoint,
                ];
            })
            ->values();
        $groupedDes = $collectDataDes->pluck('transaction_destinationPoint')->toArray();

        $collectDataJob = collect($finalData)
            ->groupBy('transaction_id',)
            ->map(function ($group,) {
                $job_no = $group->pluck('job_no')->unique()->first();
                return [
                    'job_no' => $job_no,
                ];
            })
            ->values();
        $groupedJop = $collectDataJob->pluck('job_no')->toArray();




        $data = DB::table('transactions')
            ->whereIn('transactions.transaction_id', $request)
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('transactions.*', 'transaction_dts.item_id', 'client_customers.customer_name')
            ->first();
        $data->transaction_date = date('d-m-Y', $data->transaction_date);


        $suppliers = DB::table('transaction_dts')
            ->where('transaction_id', $request)
            ->select('supplier_invoice_number')
            ->where('transaction_id', $request)
            ->groupBy('supplier_invoice_number')
            ->get();
        $supplierString = '';
        foreach ($suppliers as $supplier) {
            $supplierString .= $supplier->supplier_invoice_number . '/';
        }
        $supplierString = rtrim($supplierString, '/');

        $data->supplier = $supplierString;

        $dt = DB::table('transaction_dts')
            ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->join('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->select('job_no','transaction_supplierInvoice','transaction_dts.*', 'clients.client_firstName', 'transactions.transaction_reference', 'clientforwarder_name', 'transaction_destinationPoint')
            ->selectRaw('SUM(item_weight*item_quantity) as totalWeight,SUM(transactiondt_priceBase*item_quantity )as totalPrice,SUM(total_gross_weight) as totalGrossWeight',)
            ->whereIn('transaction_dts.transaction_id', $request)
            ->groupBy('client_id', 'transaction_dts.transaction_id')
            ->get();




        $coutries = DB::table('transaction_dts')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->select('countries.*', 'transaction_dts.transactiondt_countryOfOrigin')
            ->where('transaction_id', $request)
            ->groupBy('transactiondt_countryOfOrigin')
            ->get();
        $countryNamesString = 'AS Per BOE';
        if (count($coutries) <= 3) {
            $countryNames = $coutries->pluck('country_name')->toArray();
            $countryNamesString = implode(' ', $countryNames);
        }


        $finaltotalWeight = 0;
        $finaltotalGrossWeight = 0;
        $finaltotalPrice = 0;
        $finaltotalPkg = 0;
        foreach ($dt as $total) {
            $finaltotalWeight = $finaltotalWeight + $total->totalWeight;
            $finaltotalGrossWeight = $finaltotalGrossWeight + $total->totalGrossWeight;

            $finaltotalPrice = $finaltotalPrice + $total->totalPrice;

            $details = DB::table('transaction_dts')
                ->where('transaction_id', $total->transaction_id)
                ->selectRaw('SUM(transactiondt_nbOfCarton) as cartoons, item_pack')
                ->groupBy('item_pack')
                ->get();

            // Map details to format "cartoons item_pack" and convert to array
            $packs = $details->map(function ($detail) {
                return "{$detail->cartoons} {$detail->item_pack}";
            })->toArray();

            $total->packs = implode(' + ', $packs);
        }



        $dtHs = DB::table('transaction_dts')
            ->join('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->select('transaction_dts.*', 'clients.client_firstName')
            ->where('transaction_id', $request)
            ->get();

        $hscodeString = 'AS Per BOE';
        $hscode = collect($dtHs)
            ->groupBy('hscode',)
            ->map(function ($group,) {
                $hscode = $group->pluck('hscode')->unique()->first();
                return [
                    'hscode' => $hscode,
                ];
            })
            ->values();
        $groupedhscode = $hscode->pluck('hscode')->toArray();
        if (count($groupedhscode) <= 3) {
            $hscodeString = implode(' ', $groupedhscode);
        }
        $data->dt = $dt;
        //   return $data;
        $Obj = array();
        $Obj['finaltotalWeight'] = $finaltotalWeight;
        $Obj['finaltotalGrossWeight'] = $finaltotalGrossWeight;


        $Obj['finaltotalPrice'] = $finaltotalPrice;
        $Obj['finaltotalPkg'] = $finaltotalPkg;

        $Obj['company_id'] = $company->company_id;
        $Obj['company_prefix'] = $company->company_prefix;
        $Obj['company_logo'] = $company->company_logo;
        $Obj['currency_code'] = $company->currency_code;

        $Obj['collectDataDestLength'] = count($groupedDes);
        $Obj['data'] = $data;
        $Obj['clientName'] = $clientName;
        $Obj['hscodeString'] = $hscodeString;
        $Obj['recordWithSmallestReference'] = $recordWithSmallestReference;

        // $Obj['forwarderName'] = $forwarderName;
        $Obj['countryNamesString'] = $countryNamesString;
        $Obj['groupedDEC'] = $groupedDEC;
        //   $Obj['groupedDes'] = $groupedDes;
        $Obj['groupedJop'] = $groupedJop;

        $Obj['rowspan'] = count($dt);

        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['language'] = $language;
        $Obj['company'] = DB::table('companies')->first();
        $withStamp = isset($requestData->withStamp) ? $requestData->withStamp : false;
        $Obj['withStamp'] = $withStamp;
        $commonServices = new CommonServices();
        $decimals = $commonServices->getDecimal();
        $Obj['decimals'] = $decimals;
        $pdf = PDF::loadView(
            'manifestReportTo',
            $Obj,
            [],
            [
                'title' => 'Certificate',
                'format' => 'A4',
                'orientation' => 'L'
            ]
        );


        return $pdf->stream('Manifest Report.pdf');
    }
}
