<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->bigIncrements('company_id');
            $table->string('company_logo')->nullable();
            $table->string('company_address', 2056)->nullable();
            $table->string('company_trn')->nullable();
            $table->string('company_importCode')->nullable();
            $table->string('company_exitCode')->nullable();
            $table->string('company_name', 300);
            $table->integer('company_range');
            $table->integer('currency');


        });

        DB::table('companies')->insert(
            [
                [
                    "company_name" => "3DS",
                    "company_range" => 30,
                    "currency" => 1
                ],
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
