<?php

namespace App\Http\Controllers\BackOffice\AccessManager;

use App\Http\Controllers\ApiController;
use App\Models\roles;
use App\Models\user;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class RolesController extends ApiController
{
    public function getUserRoles(): JsonResponse
    {
        $roles = DB::table('roles')
            ->orderBy('role_code')
            ->where('role_code', '!=', 'superAdmin')
            ->get();

        foreach ($roles as $role) {
            $checkUserRoleExistance = user::where('user_role_id', '=', $role->role_id)->first();
            if ($checkUserRoleExistance) {
                $role->delete = false;
            }
        }

        return ApiController::successResponse($roles, 200);

    }

    public function fetchAccessByRole(Request $request): JsonResponse
    {
        $userPermissions = DB::table('roles_access')
            ->where([
                ['roles_access.role_id', '=', $request->role_id]
            ])
            ->get();
        if (count($userPermissions)) {
            return ApiController::successResponse($userPermissions, 200);
        }
        return ApiController::successResponse($userPermissions, 204);
    }


    public function postUserRoles(Request $request): JsonResponse
    {
        $requestContent = array();
        $requestContent = json_decode($request->getContent(), true);
        $screens = $requestContent['screens']; // global screens
        $userPermissions = $requestContent['userPermissions']; // insert update delete view
        $userRole = $requestContent['userRole']; // user role id

        if ($userRole && $screens && $userPermissions) {
            for ($i = 0; $i < count($screens); $i++) {
                $row = $screens[$i]; // screenName // screenCode
                $permission = $userPermissions[$row['screenCode']];
                $checkAccessExistance = DB::table('roles_access')
                    ->where([
                        ['roles_access.role_id', '=', $userRole],
                        ['roles_access.roleaccess_formcode', '=', $row['screenCode']]
                    ])
                    ->first(); // check if role is already created
                if ($checkAccessExistance) // if true update
                {
                    DB::table('roles_access')
                        ->where([
                            ['roles_access.role_id', '=', $userRole],
                            ['roles_access.roleaccess_formcode', '=', $row['screenCode']]
                        ])
                        ->update([
                            'roleaccess_insert' => $permission['insertMode'],
                            'roleaccess_update' => $permission['updateMode'],
                            'roleaccess_delete' => $permission['deleteMode'],
                            'roleaccess_view' => $permission['viewMode'],
                        ]);
                } else { // else insert new role
                    DB::table('roles_access')
                        ->insert([
                            'role_id' => (int)$userRole,
                            'roleaccess_formcode' => $row['screenCode'],
                            'roleaccess_insert' => $permission['insertMode'],
                            'roleaccess_update' => $permission['updateMode'],
                            'roleaccess_delete' => $permission['deleteMode'],
                            'roleaccess_view' => $permission['viewMode'],
                        ]);
                }
            }
            return ApiController::successResponse($userPermissions, 200);
        }
        return ApiController::errorResponse("Invalid request", 422);
    }

    public function insertRoles(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'roleCode' => 'required',
            'roleName' => 'required',
            'roleDefaultPath' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }


        $checkrolesExistance = roles::where(
            [
                ['role_code', '=', $request->setupCode],
                ['role_name', '=', $request->setupTable],
            ])
            ->first();

        if ($checkrolesExistance) {
            return ApiController::errorResponse('Code already taken!', 409);
        }
        $roles = array(
            'role_code' => $request->roleCode,
            'role_name' => $request->roleName,
            'role_defaultPath' => $request->roleDefaultPath
        );
        $newroles = roles::create($roles);
        if ($newroles) {
            return ApiController::successResponse($newroles, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);

    }

    public function removeRoles(Request $request)
    {
        $removeRoleAccess = DB::table('roles_access')
            ->where('role_id', '=', $request->roleId)->delete();
        $removeRole = DB::table('roles')
            ->where('role_id', '=', $request->roleId)->delete();
        return ApiController::successResponse($removeRole, 200);
    }


    public function updateRoles(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'roleCode' => 'required',
            'roleName' => 'required',
            'roleDefaultPath' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $role = array(
            'role_code' => $request->roleCode,
            'role_name' => $request->roleName,
            'role_defaultPath' => $request->roleDefaultPath
        );
        $checkRoleExistance = DB::table('roles')
            ->where(
                [
                    ['role_code', '=', $request->roleCode],
                    ['role_id', '!=', $request->roleId],
                ])
            ->first();

        if ($checkRoleExistance) {
            return ApiController::errorResponse('Code already taken!', 409);
        }


        $updateRole = roles::where('role_id', $request->roleId)->update($role);

        if ($updateRole) {
            return ApiController::successResponse($updateRole, 200);
        }
        return ApiController::errorResponse('no update', 200);


    }


}
