<?php

namespace App\Http\Controllers\BackOffice\Charging;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\chargeTemplate;
use App\Models\transactionDt;
use App\Models\transactions;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\BackOffice\Charging\ChargeTemplateService;



class ChargeTempalteController extends ApiController
{

    public function fetchChargeTemplates(Request $request)
    {
        // $userId = auth()->user()->id;
        // $companyId = auth()->user()->company_id;

        // $getUser = user::where('id','=',$userId)
        // ->join('roles','roles.role_id','=','users.user_role_id')
        // ->select('roles.role_code')
        // ->first();

        $chargeTemplates = chargeTemplate::Select(
            'chargeTemplate_id',
            'Ledger_number',
            'Currency_code',
            'chargeTemplate_service',
            'chargeTemplate_type',
            'Ledger_name',
            'chargeTemplate_amount'
        );

        if ($request->service) {
            $chargeTemplates = $chargeTemplates->Where([
                ['chargeTemplate_service', '=', $request->service]
            ]);
        }

        if ($request->searchValue != null) {
            $chargeTemplates->Where(function ($query) use ($request) {
                $query->Where([
                    ['Ledger_number', 'like', $request->searchValue . '%']
                ])
                    ->orWhere([
                        ['Ledger_name', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['Currency_code', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['chargeTemplate_amount', '=', $request->searchValue]
                    ])
                    ->orWhere([
                        ['chargeTemplate_type', 'like', '%' . $request->searchValue . '%']
                    ]);
            });
        }

        $chargeTemplatesCount = count($chargeTemplates->get());
        if (isset($request->skip) && isset($request->take)) {
            $chargeTemplates = $chargeTemplates
                ->take($request->take)
                ->skip($request->skip);
        }
        $chargeTemplates = $chargeTemplates->select('*');
        $chargeTemplates = $chargeTemplates->selectRaw('FORMAT(chargeTemplate_amount,2) as chargeTemplate_amount');
        $chargeTemplates = $chargeTemplates->get();
        $obj['count'] = $chargeTemplatesCount;
        $obj['chargeTemplates'] = $chargeTemplates;

        $utilitiesController = new UtilitiesController();
        $config = array(
            "userName" => auth()->user()->user_name
        );
        $currency = $utilitiesController->connectDataToErp("getCurrencytLogistics", $config);
        $obj['currency'] = $currency;
        return ApiController::successResponse($obj, 200);
    }


    public function fetchDataChargeTemplate(Request $request)
    {

        $config = array(
            "userName" => auth()->user()->user_name,
            "search" => null
        );
        $utilitiesController = new UtilitiesController();
        $ledger = $utilitiesController->connectDataToErp("getLedgerLogistics", $config)->getData()->data->data;

        //return ApiController::successResponse($ledger, 200);

        $config = array(
            "userName" => auth()->user()->user_name,
            "search" => null
        );
        $currency = $utilitiesController->connectDataToErp("getCurrencytLogistics", $config)->getData()->data->data;
        $data['currency'] = $currency;
        $data['ledger'] = $ledger;
        return ApiController::successResponse($data, 200);
    }


    public function insertChargeTemplate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ledgerNumber' => 'required',
            'ledgerName' => 'required',
            'service' => 'required',
            'currency' => 'required',
            'amount' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $chargeTemplate = array(
            'Ledger_number' => $request->ledgerNumber,
            'Ledger_name' => $request->ledgerName,
            'chargeTemplate_service' => $request->service,
            'Currency_code' => $request->currency,
            'chargeTemplate_type' => $request->type,
            'chargeTemplate_amount' => $request->amount,
        );
        $newChargeTemplate = chargeTemplate::create($chargeTemplate);
        if ($newChargeTemplate) {
            return ApiController::successResponse($newChargeTemplate, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }


    public function updateChargeTemplate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ledgerNumber' => 'required',
            'ledgerName' => 'required',
            'service' => 'required',
            'currency' => 'required',
            'amount' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $chargeTemplate = array(
            'Ledger_number' => $request->ledgerNumber,
            'Ledger_name' => $request->ledgerName,
            'chargeTemplate_service' => $request->service,
            'Currency_code' => $request->currency,
            'chargeTemplate_type' => $request->type,
            'chargeTemplate_amount' => $request->amount,
        );
        $updateChargeTemplate = chargeTemplate::where('chargeTemplate_id', $request->chargeTemplateId)->update($chargeTemplate);
        if ($updateChargeTemplate) {
            return ApiController::successResponse($updateChargeTemplate, 200);
        }
        return ApiController::errorResponse($validator->errors(), 200);
    }


    function removeChargeTemplate(Request $request)
    {
        $removeChargeTemplate = chargeTemplate::where('chargeTemplate_id', $request->chargeTemplateId)->delete();
        return ApiController::successResponse($removeChargeTemplate, 200);
    }

    public function submitInvoices(Request $request)
    {
        $details = json_decode($request->getContent(), true);

        for ($i = 0; $i < count($details); $i++) {
            $element = $details[$i];
            chargeTemplate::where('chargeTemplate_id', $element['chargeTemplateId'])
                ->update([
                    "chargeTemplate_amount" => str_replace(',', '', $element['amount']),
                    "Currency_code" => $element['currency'],
                ]);
        }
        return ApiController::successResponse($details, 200);
    }

    public function fetchChargeTemplateByTransaction(Request $request)
    {
        $transactionId = $request->transactionId;
        $service = $request->service;
        $response = $this->fetchChargeTemplateByTransactionFuntion($transactionId, $service);
        return ApiController::successResponse($response, 200);
    }


    public function fetchChargeTemplateByTransactionFuntion($transactionId, $service)
    {
        $company = DB::table('companies')
            ->first();
        $paymentMethod = null;
        $totalchargeTemplates = 0;
        $totalAmountPaid = 0;
        $isShipment = $company->company_onlyShipment;
        $getClientOnTransaction = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
            ->where([
                ['transaction_id', '=', $transactionId]
            ])
            ->Select('Ledger_number', 'client_firstname', 'currency_code','salesjv_discount')
            ->first();

        $chargeTemplates = chargeTemplate::Where([
            ['chargeTemplate_service', 'like', $service],
            ['Ledger_number', '=', $getClientOnTransaction->Ledger_number]
        ]);

        $chargeTemplates = $chargeTemplates->select('*');
        $chargeTemplates = $chargeTemplates->selectRaw('FORMAT(chargeTemplate_amount,2) as chargeTemplate_amount');
        // $chargeTemplates = $chargeTemplates->selectRaw('true as client');
        $chargeTemplates = $chargeTemplates->get();

        $chargeTemplatesAllByService = chargeTemplate::Where([
            ['chargeTemplate_service', 'like', $service]
        ])
            ->select('*',)
            ->selectRaw('FORMAT(chargeTemplate_amount,2) as chargeTemplate_amount')
            ->get();

        $utilitiesController = new UtilitiesController();
        $config = array(
            "userName" => auth()->user()->user_name
        );
        $clients = $utilitiesController->connectDataToErp("fetchLedgersFromClients", $config)->getData()->data->data;

        $currency = $utilitiesController->connectDataToErp("getCurrencytLogistics", $config)->getData()->data->data;

        if ($isShipment == 1) {

            $charges = array();
            $dt = transactionDt::leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->where('transaction_id', '=', $transactionId)
                ->select('transaction_dts.*', 'items.item_code')
                ->selectRaw('SUM(transaction_dts.item_quantity) as item_quantity')
                ->selectRaw('SUM(transaction_dts.item_quantity_to_delivery) as item_quantity_to_delivery')
                ->selectRaw('SUM(transaction_dts.item_quantity_to_cancel) as item_quantity_to_cancel')

                ->groupBy('item_id', 'transactiondt_id')
                ->get();

            $getOrderPaymentMethod = transactions::where('transaction_id', '=', $transactionId)
                ->select('transactions.transaction_paymentMethodId')
                ->first();

            if ($getOrderPaymentMethod) {
                $paymentMethod = $getOrderPaymentMethod->transaction_paymentMethodId;
            }
            $totalchargeTemplates = 0;
            foreach ($dt as $splitDt) {
                if ((float)($splitDt->item_quantity_to_delivery) == 0) {
                    continue;
                }
                $data = array(
                    "chargeTemplate_id" => $chargeTemplatesAllByService[0]->chargeTemplate_id,
                    "Ledger_number" => $chargeTemplatesAllByService[0]->Ledger_number,
                    "Currency_code" => $getClientOnTransaction->Currency_code,
                    "chargeTemplate_service" => $chargeTemplatesAllByService[0]->chargeTemplate_service,
                    "chargeTemplate_type" => $chargeTemplatesAllByService[0]->chargeTemplate_type,
                    "Ledger_name" => $chargeTemplatesAllByService[0]->Ledger_name,
                    "chargeTemplate_amount" => (float)$splitDt->transactiondt_price,
                    "chargeTemplate_quantity" =>  (float)($splitDt->item_quantity_to_delivery),
                    "chargeTemplate_description" => $splitDt->item_code . ' ' . $splitDt->transactiondt_item_description,


                );
                $totalchargeTemplates = $totalchargeTemplates + (float)$splitDt->transactiondt_price * (float)($splitDt->item_quantity_to_delivery);
                array_push($charges, $data);
            }
            $chargeTemplateService = new ChargeTemplateService();

            $payload = array();
            $payload['transactionId'] = $transactionId;
            $totalAmountPaid = $chargeTemplateService->getTotalPaymentMethodsService($payload);
            $chargeTemplatesAllByService = $charges;
        }
        $jsonObj['currency'] = $currency;
        $jsonObj['chargeTemplates'] = $chargeTemplatesAllByService;
        $jsonObj['totalchargeTemplates'] = $totalchargeTemplates;
        $jsonObj['totalAmountPaid'] = $totalAmountPaid;


        $jsonObj['clients'] = $clients;
        $jsonObj['getClientOnTransaction'] = $getClientOnTransaction;
        $jsonObj['isShipment'] = $isShipment;
        $jsonObj['orderPaymentMethod'] = $paymentMethod;
        $jsonObj['salesjv_discount'] = $getClientOnTransaction->salesjv_discount;


        

        return $jsonObj;
    }

    public function generateInvoicesByTransactionType(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $isShipment = $request->isShipment;
        $salesJvId = $request->salesJvId;
        $transactionId = $request->transactionId;
        $ledgerNumber = $request->ledgerNumber;
        $currency = $request->currency;
        $details = $request->details;
        $discount = $request->discount;
        $discountAmount = $request->discountAmount;

        $ledgerNumber = $request->client['ledgerNumber'];
        $currency = $request->client['currency'];
        $orderPaymentMethod = $request->client['orderPaymentMethod'];

        $response = $this->generateInvoicesByTransactionTypeFunction($isShipment, $salesJvId, $transactionId, $details, $ledgerNumber, $currency, $orderPaymentMethod, $discount, $discountAmount);

        return $response;
    }

    public function generateInvoicesByTransactionTypeFunction($isShipment, $salesJvId, $transactionId, $details, $ledgerNumber, $currency, $orderPaymentMethod, $discount = 0, $discountAmount = 0)
    {
        $utilitiesController = new UtilitiesController();
        $paymentMethodsDecoded = [];
        $getTransactionAndClient = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->join('currency', 'currency.currency_id', '=', 'transaction_currencyId')
            ->where([
                ['transaction_id', '=', $transactionId]
            ])
            ->select(
                'transaction_type',
                'client_firstname',
                'Ledger_number',
                'transaction_date',
                'currency.currency_code',
                'transaction_remark',
                'transaction_date',
                'payment_methods',
                'transaction_reference'
            )
            ->first();

        if ($getTransactionAndClient->salesjv_id != null) {
            return ApiController::errorResponse("Sales JV already created", 422);
        }

        if ($getTransactionAndClient) {
            $getTransactionAndClient->transaction_date = date('Y-m-d', $getTransactionAndClient->transaction_date);
            $paymentMethods = $getTransactionAndClient->payment_methods;

            if ($paymentMethods != null) {

                $paymentMethodsDecoded = json_decode($paymentMethods);
            }
            $credits = $details;
            if ($isShipment == 0) {

                foreach ($credits as $splitCredits) {

                    $totalAmount = $splitCredits['totalAmount'];
                    $splitCredits['amount'] = $totalAmount;
                }
            }


            $debit = $getTransactionAndClient;

            $getLedgerForPaymenetMethod = DB::table('payment_methods')
                ->where('id', $orderPaymentMethod)
                ->first();
            $ledgerNumberPayment = null;
            if ($getLedgerForPaymenetMethod) {
                $ledgerNumberPayment = $getLedgerForPaymenetMethod->ledger_number;
            }
            $payload = array(
                'header' => $getTransactionAndClient,
                'credits' => $credits,
                'debit' => $ledgerNumber,
                'currency' => $currency,
                'type' => $getTransactionAndClient->transaction_type,
                'transactionId' => $transactionId,
                'user' => auth()->user()->user_name,
                'salesJvId' => $salesJvId,
                'isShipment' => $isShipment,
                'ledgerNumberPayment' => $ledgerNumberPayment,
                'paymentMethods' => $paymentMethodsDecoded,
                'logisticomRef' => $getTransactionAndClient->transaction_reference,
                'discount' => $discount,
                'discountAmount' => $discountAmount,
            );


            $response = $utilitiesController->connectDataToErp('createSalesJvLogisticsSide', $payload);
            //
            //return ApiController::errorResponse($payload, 422);
            try {
                if ($response->getData()->data->code == 409) {
                    return ApiController::errorResponse($response->getData(), 422);
                }

                if ($response->getData()->data->code == 200) {
                    //   return ApiController::errorResponse($response->getData()->data->data, 422);

                    transactions::where([
                        ['transaction_id', '=', $transactionId]
                    ])
                        ->update([
                            "salesjv_id" => $response->getData()->data->data->SalesJV_Id,
                            "transaction_paymentMethodId" => $orderPaymentMethod,
                            "salesjv_discount" => $discount
                        ]);
                }
                return ApiController::successResponse($response->getData()->data->data, 200);
            } catch (Exception $e) {
                return $response->getData()->data;
            }
        }
        return ApiController::errorResponse($getTransactionAndClient, 422);
    }




    //add payment methods for transactions
    public function addPaymentMethods(Request $request)
    {

        $chargeTemplateService = new ChargeTemplateService();
        $transactionId = $request->transactionId;
        $paymentMethods = $request->paymentMethods;
        $payload = array();
        $payload["transactionId"] = $transactionId;
        $payload["paymentMethods"] = $paymentMethods;

        $result = $chargeTemplateService->addPaymentMethodsService($payload);

        return $result;
    }

    //get payment methods for transactions
    public function getPaymentMethods(Request $request)
    {

        $chargeTemplateService = new ChargeTemplateService();
        $transactionId = $request->transactionId;
        $payload = array();
        $payload["transactionId"] = $transactionId;

        $result = $chargeTemplateService->getPaymentMethodsService($payload);

        return $result;
    }
}
