<?php

namespace App\Http\Controllers\BackOffice\Charging;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\chargeTemplate;
use App\Models\transactionDt;
use App\Models\transactions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;


class ChargeTemplateService extends ApiController
{


    function addPaymentMethodsService($payload)
    {

        $transactionId = $payload['transactionId'];
        $paymentMethods = $payload['paymentMethods'];

        $encodedPaymentMthods = json_encode($paymentMethods);

        $result = transactions::where('transaction_id', '=', $transactionId)->update([
            'payment_methods' => $encodedPaymentMthods
        ]);
        if ($result) {
            return ApiController::successResponse('success', 200);
        }
        return ApiController::errorResponse('failed', 422);
    }



    function getPaymentMethodsService($payload)
    {
        $transactionId = $payload['transactionId'];

        $transaction = transactions::where('transaction_id', '=', $transactionId)
            ->first();
        $paymentMethods = DB::table('payment_methods')
            ->select('payment_methods.*',)
            ->selectRaw('0 as amount')
            ->get();

        if ($transaction) {
            $payment = $transaction->payment_methods;
            if ($payment) {
                //decode the payment from transaction, and concat to payemtns
                $decodedPayment = json_decode($payment);
                foreach ($paymentMethods as $splitPayment) {
                    $id = $splitPayment->id;
                    foreach ($decodedPayment as $decodedPaymentSplit) {
                        if ($decodedPaymentSplit->id == $id) {
                            $splitPayment->amount = isset($decodedPaymentSplit->amount) ? (float) $decodedPaymentSplit->amount : (float) 0;
                        }
                    }
                }
            }
        }



        return ApiController::successResponse($paymentMethods, 200);
    }


    function getTotalPaymentMethodsService($payload)
    {
        $transactionId = $payload['transactionId'];
        $transaction = transactions::where('transaction_id', '=', $transactionId)
            ->first();
        if ($transaction) {
            $payment = $transaction->payment_methods;
            $decodedPayment = json_decode($payment);
            $totalAmountPaid = 0;
          
            if($decodedPayment){
                foreach ($decodedPayment as $decodedPaymentSplit) {
                    
                    $totalAmountPaid =(float) $totalAmountPaid +( isset($decodedPaymentSplit->amount) ? (float) $decodedPaymentSplit->amount : (float) 0);
                   
                }
            }
            return $totalAmountPaid;
        } else {
            return 0;
        }
    }
}
