<?php

namespace App\Http\Controllers\BackOffice\ClientCustomer;

use App\Http\Controllers\ApiController;
use App\Models\clientCustomer;
use App\Models\transactions;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ClientCustomerController extends ApiController
{
    public function fetchClientCustomers(Request $request)
    {

        $clientCustomers = clientCustomer::leftjoin('countries', 'countries.country_id', '=', 'client_customers.customer_country')
            ->where([
                ['customer_related_clientid', '=', $request->clientId],
                ['isActive', true],
            ]);
        if ($request->searchValue) {
            $clientCustomers->where([
                ['customer_name', 'like', '%' . $request->searchValue . '%']
            ]);
        }
        $clientCustomers = $clientCustomers->get();
        return ApiController::successResponse($clientCustomers, 200);
    }

    public function insertClientCustomer(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'customerName' => 'required',
            'customerAddress' => 'required',
            'customerCountry' => 'required',
            'clientId' => 'required'
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        return $this->insertClientCustomerFunction(
            $request->customerName,
            $request->clientId,
            $request->customerContactPerson,
            $request->customerAddress,
            $request->customerCountry,
            $request->customerPhone,
            $request->customerEmail,
           
        );
    }

    public function insertClientCustomerFunction(
        $name,
        $clientId,
        $customerContactPerson = "",
        $customerAddress = "",
        $customerCountry = "",
        $customerPhone = "",
        $customerEmail = ""
    )
    {
        $clientCustomer = array(
            'customer_name' => $name,
            'customer_contactPerson' => $customerContactPerson,
            'customer_address' => $customerAddress,
            'customer_country' => $customerCountry,
            'customer_phone' => $customerPhone,
            'customer_email' => $customerEmail,
            'customer_related_clientid' => $clientId
        );

        $chckAlreadyExist = clientCustomer::where([
            ['customer_name', $name],
            ['customer_related_clientid', $clientId]
        ])->first();
        if ($chckAlreadyExist) {
            return ApiController::errorResponse($chckAlreadyExist, 422);
        }
        $newClientCustomer = clientCustomer::create($clientCustomer);

        if ($newClientCustomer) {
            return ApiController::successResponse($newClientCustomer, 200);
        }
        return ApiController::errorResponse($newClientCustomer, 422);
    }

    public function updateClientCustomer(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'customerName' => 'required',

            'customerAddress' => 'required',


            'customerCountry' => 'required',
            //'customerPhoneCode' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $clientCustomer = array(
            'customer_name' => $request->customerName,
            'customer_contactPerson' => $request->customerContactPerson,
            'customer_address' => $request->customerAddress,
            'customer_country' => $request->customerCountry,
            'customer_phone' => $request->customerPhone,
            'customer_email' => $request->customerEmail,
            //'customer_phone_code' => $request->customerPhoneCode,
        );

        $updateClientCustomer = clientCustomer::where('customer_id', $request->clientCustomerId)
            ->update($clientCustomer);

        if ($updateClientCustomer) {
            return ApiController::successResponse($updateClientCustomer, 200);
        }
        return ApiController::errorResponse($updateClientCustomer, 200);
    }

    function removeClientCustomer(Request $request)
    {
        $checkClientTransactions = transactions::where('clientCustomer_id', $request->customerId)->first();
        $checkClientTransactionsTmp = transactiontmp::where('clientCustomer_id', $request->customerId)->first();

        if ($checkClientTransactions || $checkClientTransactionsTmp) {
            //  clientCustomer::where('customer_id',$request->customerId)->update([
            //   'isActive' => false,
            //  ]);
            return ApiController::successResponse('unable to delete', 204);
        } else {
            clientCustomer::where('customer_id', $request->customerId)->delete();

            return ApiController::successResponse('User successfully deleted', 200);
        }
    }
}
