<?php

namespace App\Http\Controllers\BackOffice\ClientForwarder;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientForwarder;
use App\Models\transactions;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ClientForwarderController extends ApiController
{
    public function fetchClientForwarders(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;


        $clientForwarders = clientForwarder::select(
            'clientforwarder_id',
            'clientforwarder_name',
            'clientforwarder_contactPerson',
            'clientforwarder_email',
            'clientforwarder_phone',
            'clientforwarder_address',
            'clientforwarder_tradeLicenseNumber',
            'clientforwarder_mercalTo',
            'clientforwarder_importCode',
            'clientforwarder_approved'
        )
            ->selectRaw("(case when ( clientforwarder_approved) = 0 THEN ('No')
        else (' Yes') END ) as aprroved_display");
        if ($request->status == 'notApproved') {
            $clientForwarders->where([
                ['clientforwarder_approved', '=', false]
            ]);
        } else if ($request->status == 'approved') {
            $clientForwarders->where([
                ['clientforwarder_approved', '=', true]
            ]);
        }
        if ($request->searchValue) {
            $clientForwarders->Where(function ($query) use ($request) {
                $query->Where([
                    ['clientforwarder_name', 'like', '%' . $request->searchValue . '%']
                ])
                    ->orWhere([
                        ['clientforwarder_contactPerson', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['clientforwarder_email', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['clientforwarder_phone', 'like', '%' . $request->searchValue . '%']
                    ]);
            });
        }
        $clientForwardersCount = count($clientForwarders->get());
        if (isset($request->skip)) {
            $clientForwarders->skip($request->skip)
                ->take($request->take);
        }

        $clientForwarders = $clientForwarders->get();


        $obj['count'] = $clientForwardersCount;
        $obj['forwarders'] = $clientForwarders;
        return ApiController::successResponse($obj, 200);
    }

    public function insertClientForwarder(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;
        $validator = Validator::make($request->all(), [
            'forwarderName' => 'required',


        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $clientForwarder = array(
            'clientforwarder_name' => $request->forwarderName,
            'clientforwarder_contactPerson' => $request->forwarderContactPerson,
            'clientforwarder_email' => $request->forwarderEmail,
            'clientforwarder_phone' => $request->forwarderPhone,
            'clientforwarder_address' => $request->forwarderAddress,
            'clientforwarder_tradeLicenseNumber' => $request->forwarderTradeLicenseNumber,
            'clientforwarder_mercalTo' => $request->forwarderMercalTo,
            'clientforwarder_importCode' => $request->forwarderImportCode,
            'clientforwarder_approved' => $request->forwarderApproved,
            'company_id' => $loggerUserCompany
        );
        return $this->insertClientForwarderFunction($clientForwarder, $request->forwarderEmail, false);
    }

    public function insertClientForwarderFunction($clientForwarder, $forwarderEmail, $isDataLoad = false)
    {

        $checkClientForwarder = clientForwarder::where([
            ['clientforwarder_email', $forwarderEmail],
            ['clientforwarder_email', '!=', null],

        ])
            ->first();

        $checkClientForwarderName = clientForwarder::where([
            ['clientforwarder_name', trim($clientForwarder['clientforwarder_name'])]
        ])
            ->first();
        if ($checkClientForwarderName && $isDataLoad) {
            return $checkClientForwarderName->clientforwarder_id;
        } else if ($checkClientForwarder && !$isDataLoad) {
            return ApiController::errorResponse('Email already taken', 422);
        } else if ($checkClientForwarderName && !$isDataLoad) {
            return ApiController::errorResponse('Name already taken', 422);
        }


        $newClientForwarder = clientForwarder::create($clientForwarder);

        if ($newClientForwarder && !$isDataLoad) {
            $utilitiesController = new UtilitiesController();

            $admins = DB::table('users')
                ->join('useraccess', 'useraccess.user_id', 'users.id')
                ->where([
                    ["useraccess.useraccess_formcode", 'forwarders'],
                ])
                ->get();

            foreach ($admins as $admindt) {

                if ($admindt->user_pushToken) {
                    $notificationArray = array(
                        'title' => 'Forwarder',
                        'message' => 'New Forwarder Transaction was created',
                        'seen' => 0,
                        'related_userid' => $admindt->id,
                        'trans_id' => null,
                        'key' => null,
                        'code' => "Forwarder_created",
                        'notificationToken' => $admindt->user_pushToken,
                        'transType' => "DO"
                    );
                    $utilitiesController->sendNotification($notificationArray);
                }
            }


            $clientForwarder['clientforwarder_id'] = $newClientForwarder->id;
            $clientForwarder['user_modified'] = auth()->user()->id;
            $clientForwarder['clientforwarder_approved'] = $newClientForwarder->clientforwarder_approved == 1 ? 'True' : 'False';
            $historyController = new HistoryController();
            $historyController->insertHistoryData('client_forwarders', $clientForwarder, 'Insert');
            return ApiController::successResponse($newClientForwarder, 200);
        } else if ($newClientForwarder && $isDataLoad) {
            return $newClientForwarder->clientforwarder_id;
        }
        return ApiController::errorResponse($newClientForwarder, 422);
    }

    public function updateClientForwarder(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'forwarderName' => 'required',
            'forwarderContactPerson' => 'required',
            'forwarderEmail' => 'required',
            'forwarderPhone' => 'required',
            'forwarderTradeLicenseNumber' => 'required',
            'forwarderMercalTo' => 'required',
            'forwarderImportCode' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $clientForwarder = array(
            'clientforwarder_name' => $request->forwarderName,
            'clientforwarder_contactPerson' => $request->forwarderContactPerson,
            'clientforwarder_email' => $request->forwarderEmail,
            'clientforwarder_phone' => $request->forwarderPhone,
            'clientforwarder_address' => $request->forwarderAddress,
            'clientforwarder_tradeLicenseNumber' => $request->forwarderTradeLicenseNumber,
            'clientforwarder_mercalTo' => $request->forwarderMercalTo,
            'clientforwarder_importCode' => $request->forwarderImportCode,
            //'customer_related_clientid' => $request->clientId
            'clientforwarder_approved' => $request->forwarderApproved,

        );

        $updateClientForwarder = clientForwarder::where('clientforwarder_id', '=', $request->clientForwarderId)->update($clientForwarder);

        if ($updateClientForwarder) {
            $clientForwarder['clientforwarder_id'] = $request->clientForwarderId;
            $clientForwarder['user_modified'] = auth()->user()->id;
            $clientForwarder['clientforwarder_approved'] = $clientForwarder['clientforwarder_approved'] == 1 ? 'True' : 'False';

            $historyController = new HistoryController();
            $historyController->insertHistoryData('client_forwarders', $clientForwarder, 'Update');
            return ApiController::successResponse($updateClientForwarder, 200);
        }
        return ApiController::errorResponse($updateClientForwarder, 200);
    }

    public function uploadFile(Request $request)
    {
        //$utilitiesController = new utilitiesController();

        $validator = Validator::make($request->all(), [
            'forwarderId' => 'required',
            'file' => 'required',
            //'type' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        $path = public_path() . '/forwarders/images/' . $request->forwarderId . '/';

        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        // if( $request->type == 'image' )
        // {
        //     $utilitiesController->base64ToJpeg($request->file,$path);
        // }
        // else
        // {
        $file = $request->file;
        $filename = $file->getClientOriginalName();
        $extension = $file->getClientOriginalExtension();
        $document = $filename;
        $insertStatus = $file->move($path, $document);
        //$utilitiesController->base64ToDocument($request->file,public_path(). '/orders/images/'.$request->orderDtSubId.'/');
        // }
        return ApiController::successResponse($insertStatus, 200);
    }

    public function fetchFilesByForwarder(Request $request)
    {
        $files = $this->getFilesByForwarderFunction($request->forwarderId);
        return ApiController::successResponse($files, 200);
    }

    function getFilesByForwarderFunction($forwarder_id)
    {
        $path = public_path('/forwarders/images/' . $forwarder_id);
        // return $path;
        if (file_exists($path)) {
            $files = array_slice(scandir($path), 2);
            $filesArray = array();
            for ($i = 0; $i < count($files); $i++) {
                $fileObject = array();
                $fileObject['file_name'] = $files[$i];
                $pathWithName = $path . '/' . $files[$i];
                $pathWithName = str_replace('/home/dsdatacomlb/', 'https://', $pathWithName);
                $fileObject['path'] = $pathWithName;
                if (
                    str_contains($fileObject['file_name'], '.xlsx') || str_contains($fileObject['file_name'], '.docx')
                    || str_contains($fileObject['file_name'], '.pdf')
                ) {
                    $fakePath = public_path('/forwarders/images');
                    $fakePath = str_replace('/home/dsdatacomlb/', 'https://', $fakePath);
                    if (str_contains($fileObject['file_name'], '.xlsx')) {
                        $imageName = $fakePath . '/excel.png';
                    } else if (str_contains($fileObject['file_name'], '.docx')) {
                        $imageName = $fakePath . '/word.png';
                    } else {
                        $imageName = $fakePath . '/pdf.png';
                    }

                    $fileObject['fake_path'] = $imageName;
                } else {
                    $fileObject['fake_path'] = null;
                }

                array_push($filesArray, $fileObject);
            }
            return $filesArray;
        }
    }

    public function removePublicFile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'file' => 'required',
            'forwarderId' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        // return  file_exists($request->path);
        $path = public_path() . '/forwarders/images/' . $request->forwarderId . '/' . $request->file;

        //return $path;
        //return ApiController::successResponse($path,422);
        if (file_exists($path)) {
            //$path = str_replace('/home/dsdatacomlb/','https://',$path);
            //return $path;
            $deleteFile = File::delete($path);
            return ApiController::successResponse($deleteFile, 200);
        }
        return ApiController::errorResponse($validator->errors(), 422);
    }


    public function removeForwarder(Request $request)
    {
        $checkForwarderTransactions = transactions::where('forwarder_id', $request->forwarderId)->first();
        $checkForwarderTransactionsTmp = transactiontmp::where('forwarder_id', $request->forwarderId)->first();

        if ($checkForwarderTransactionsTmp || $checkForwarderTransactionsTmp) {
            return ApiController::successResponse('unable to delete', 204);
        } else {
            $forwarder = clientForwarder::where('clientforwarder_id', $request->forwarderId);
            $historyController = new HistoryController();
            $deleteForwarder = $forwarder->first()->toArray();
            $deleteForwarder['clientforwarder_id'] = $request->forwarderId;
            $deleteForwarder['user_modified'] = auth()->user()->id;
            $historyController->insertHistoryData('client_forwarders', $deleteForwarder, 'Delete');
            $deleteForwarders = $forwarder->delete();

            if ($deleteForwarders) {
                $utilitiesController = new UtilitiesController();

                $admins = DB::table('users')
                    ->join('useraccess', 'useraccess.user_id', 'users.id')
                    ->where([
                        ["useraccess.useraccess_formcode", 'forwarders'],
                    ])
                    ->get();

                foreach ($admins as $admindt) {

                    if ($admindt->user_pushToken) {
                        $notificationArray = array(
                            'title' => 'Forwarder',
                            'message' => 'Forwarder was removed',
                            'seen' => 0,
                            'related_userid' => $admindt->id,
                            'trans_id' => null,
                            'key' => null,
                            'code' => "Forwarder_deleted",
                            'notificationToken' => $admindt->user_pushToken,
                            'transType' => "DO"
                        );
                        $utilitiesController->sendNotification($notificationArray);
                    }
                }


                return ApiController::successResponse($deleteForwarders, 200);
            }
        }

        return ApiController::errorResponse('no update', 200);
    }
}
