<?php

namespace App\Http\Controllers\BackOffice\ClientItem;

use App\Http\Controllers\ApiController;
use App\Models\clientItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ClientItemController extends ApiController
{
    public function fetchClientItems(Request $request)
    {
        $clientItems = clientItem::where('item_related_client_id', '=', $request->clientId);
        if ($request->searchValue) {
            $clientItems->where([
                ['item_description', 'like', '%' . $request->searchValue . '%']
            ]);
        }
        $clientItems = $clientItems->get();
        return ApiController::successResponse($clientItems, 200);
    }

    public function insertClientItem(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'itemCode' => 'required',
            'itemBarcode' => 'required',
            'itemHsCode' => 'required',
            'clientId' => 'required',
            'itemPack' => 'required',
            'itemQuantityPerPack' => 'required',
            'itemWeight' => 'required',

        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $itemCodeExist = clientItem::where('item_code', $request->itemCode)->get();

        if (count($itemCodeExist) > 0) {
            return ApiController::errorResponse("Code already exist", 409);
        }
        $itemBarcodeExist = clientItem::where('item_barcode', $request->itemBarcode)->get();
        if (count($itemBarcodeExist) > 0) {
            return ApiController::errorResponse("Barcode already exist", 409);
        }

        $clientItem = array(
            'item_code' => $request->itemCode,
            'item_barcode' => $request->itemBarcode,
            'item_hscode' => $request->itemHsCode,
            'item_description' => $request->itemDescription,
            'item_hasSerial' => $request->itemHasSerial,
            'item_related_client_id' => $request->clientId,
            'item_weight' => $request->itemWeight,
            'item_pack' => $request->itemPack,

            'item_qtyPerPack' => $request->itemQuantityPerPack
        );

        $newClientItem = clientItem::create($clientItem);

        if ($newClientItem) {
            return ApiController::successResponse($newClientItem, 200);
        }
        return ApiController::errorResponse($newClientItem, 422);
    }

    public function updateClientItem(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'itemCode' => 'required',
            'itemBarcode' => 'required',
            'itemHsCode' => 'required',
            'itemHasSerial' => 'required',
            'itemPack' => 'required',
            'itemQuantityPerPack' => 'required',
            'itemWeight' => 'required',
        ]);

        $clientItem = array(
            'item_code' => $request->itemCode,
            'item_barcode' => $request->itemBarcode,
            'item_hscode' => $request->itemHsCode,
            'item_description' => $request->itemDescription,
            'item_hasSerial' => $request->itemHasSerial,
            'item_weight' => $request->itemWeight,
            'item_pack' => $request->itemPack,

            'item_qtyPerPack' => $request->itemQuantityPerPack
        );
        $itemCodeExist = clientItem::where([
            ['item_code', $request->itemCode],
            ['item_id', '!=', $request->clientItemId]
        ])->get();

        if (count($itemCodeExist) > 0) {
            return ApiController::errorResponse("Code already exist", 409);
        }
        $itemBarcodeExist = clientItem::where([
            ['item_barcode', $request->itemBarcode],
            ['item_id', '!=', $request->clientItemId]
        ])
            ->get();
        if (count($itemBarcodeExist) > 0) {
            return ApiController::errorResponse("Barcode already exist", 409);
        }

        $updateClientItem = clientItem::where('item_id', $request->clientItemId)->update($clientItem);

        if ($updateClientItem) {
            return ApiController::successResponse($updateClientItem, 200);
        }
        return ApiController::errorResponse($updateClientItem, 200);
    }
}
