<?php

namespace App\Http\Controllers\BackOffice\ClientSupplier;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Models\clientSupplier;
use App\Models\suppliers;
use App\Models\transactions;
use App\Models\transactiontmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ClientSupplierController extends ApiController
{
    // public function fetchClientSuppliers(Request $request)
    // {
    //     $clientSuppliers =
    //     clientSupplier::leftjoin('countries','countries.country_id','=','client_suppliers.supplier_country')
    //     ->where('supplier_related_clientid','=',$request->clientId);

    //     if( $request->searchValue )
    //     {
    //         $clientSuppliers->where([
    //             ['supplier_name','like','%'.$request->searchValue.'%']
    //         ]);

    //     }
    //     $clientSuppliers = $clientSuppliers->get();
    //     return ApiController::successResponse($clientSuppliers,200);
    // }

    // public function insertClientSupplier(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'supplierName' => 'required',
    //         'supplierContactPerson' => 'required',
    //         'supplierAddress' => 'required',
    //         'supplierCountry' => 'required',
    //         'supplierPhone' => 'required',
    //         'supplierEmail' => 'required',
    //         'clientId' => 'required'
    //     ]);

    //     if ( $validator->fails() )
    //     {
    //         return ApiController::errorResponse($validator->errors(),422);
    //     }

    //     $clientSupplier = Array(
    //         'supplier_name' => $request->supplierName,
    //         'supplier_contactPerson' => $request->supplierContactPerson,
    //         'supplier_address' => $request->supplierAddress,
    //         'supplier_country' => $request->supplierCountry,
    //         'supplier_phone' => $request->supplierPhone,
    //         'supplier_email' => $request->supplierEmail,
    //         'supplier_related_clientid' => $request->clientId
    //     );

    //     $newClientSupplier = clientSupplier::create($clientSupplier);

    //     if( $newClientSupplier )
    //     {
    //         return ApiController::successResponse($newClientSupplier,200);
    //     }
    //     return ApiController::errorResponse($newClientSupplier,422);
    // }

    // public function updateClientSupplier(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'supplierName' => 'required',
    //         'supplierContactPerson' => 'required',
    //         'supplierAddress' => 'required',
    //         'supplierCountry' => 'required',
    //         'supplierPhone' => 'required',
    //         'supplierEmail' => 'required'
    //     ]);

    //     if ( $validator->fails() )
    //     {
    //         return ApiController::errorResponse($validator->errors(),422);
    //     }

    //     $clientSupplier = Array(
    //         'supplier_name' => $request->supplierName,
    //         'supplier_contactPerson' => $request->supplierContactPerson,
    //         'supplier_address' => $request->supplierAddress,
    //         'supplier_country' => $request->supplierCountry,
    //         'supplier_phone' => $request->supplierPhone,
    //         'supplier_email' => $request->supplierEmail
    //     );

    //     $updateClientSupplier = clientSupplier::where('supplier_id',$request->clientSupplierId)
    //     ->update($clientSupplier);

    //     if( $updateClientSupplier )
    //     {
    //         return ApiController::successResponse($updateClientSupplier,200);
    //     }
    //     return ApiController::errorResponse($updateClientSupplier,200);
    // }


    public function fetchSuppliers(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;

        $clientSuppliers =
            suppliers::leftjoin('countries', 'countries.country_id', '=', 'suppliers.supplier_country')
                ->where([
                    ['company_id', '=', $company_id],
                    ['isActive', true]
                ]);

        if ($request->searchValue) {
            $clientSuppliers->Where(function ($query) use ($request) {
                $query->Where([
                    ['supplier_name', 'like', '%' . $request->searchValue . '%']
                ])
                    ->orWhere([
                        ['supplier_contactPerson', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['supplier_country', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['supplier_email', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['supplier_phone', 'like', '%' . $request->searchValue . '%']
                    ]);
            });
        }

        $clientSuppliersCount = count($clientSuppliers->get());
        if ($request->take != 'all') {
            $clientSuppliers->skip($request->skip)->take($request->take);
        }
        $clientSuppliers = $clientSuppliers->get();


        $obj['count'] = $clientSuppliersCount;
        $obj['suppliers'] = $clientSuppliers;
        return ApiController::successResponse($obj, 200);
    }


    public function insertSupplier(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;

        $validator = Validator::make($request->all(), [
            'supplierName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        return $this->insertSupplierFunction(
            $request->supplierName,
            $request->supplierContactPerson,
            $request->supplierAddress,
            $request->supplierCountry,
            $request->supplierEmail,
            $request->supplierPhone,
            $company_id,


        );
    }

    public function insertSupplierFunction(
        $supplierName,
        $supplierContactPerson = "",
        $supplierAddress = "",
        $supplierCountry = "",
        $supplierEmail = "",
        $supplierPhone = "",
        $company_id,
        $isDataLoad = false
    )
    {


        $checkSupplier = suppliers::where([
            ['supplier_name', $supplierName]
        ])
            ->first();


        if ($checkSupplier) {
            if ($isDataLoad) return $checkSupplier->supplier_id;
            return ApiController::errorResponse($checkSupplier, 422);
        }

        $clientSupplier = array(
            'supplier_name' => $supplierName,
            'supplier_contactPerson' => $supplierContactPerson,
            'supplier_address' => $supplierAddress,
            'supplier_country' => $supplierCountry,
            'supplier_phone' => $supplierPhone,
            'supplier_email' => $supplierEmail,
            'company_id' => $company_id
        );

        $newSupplier = suppliers::create($clientSupplier);


        if ($newSupplier) {
            if (!$isDataLoad) {
                $clientSupplier['supplier_id'] = $newSupplier->id;
                $clientSupplier['user_modified'] = auth()->user()->id;
                $historyController = new HistoryController();
                $historyController->insertHistoryData('suppliers', $clientSupplier, 'Insert');
                return ApiController::successResponse($newSupplier, 200);

            } else {
                return $newSupplier->id;

            }


        }

        return ApiController::errorResponse($newSupplier, 422);
    }

    public function updateSupplier(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'supplierName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $checkSupplier = suppliers::where([
            ['supplier_name', $request->supplierName],
            ['supplier_id', '!=', $request->clientSupplierId]
        ])
            ->first();

        if ($checkSupplier) {
            return ApiController::errorResponse($checkSupplier, 422);
        }
        $clientSupplier = array(
            'supplier_name' => $request->supplierName,
            'supplier_contactPerson' => $request->supplierContactPerson,
            'supplier_address' => $request->supplierAddress,
            'supplier_country' => $request->supplierCountry,
            'supplier_phone' => $request->supplierPhone,
            'supplier_email' => $request->supplierEmail
        );

        $updateSupplier = suppliers::where('supplier_id', $request->clientSupplierId)
            ->update($clientSupplier);

        $updateClientSupplier = clientSupplier::where('supplier_id', $request->clientSupplierId)
            ->update($clientSupplier);
        if ($updateSupplier) {
            $clientSupplier['supplier_id'] = $request->clientSupplierId;
            $clientSupplier['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('suppliers', $clientSupplier, 'Update');
            return ApiController::successResponse($updateSupplier, 200);
        }
        return ApiController::errorResponse($updateSupplier, 200);
    }

    public function removeSupplier(Request $request)
    {
        $checkSupplierTransactions = transactions::where('transaction_supplierId', $request->supplierId)->first();
        $checkSupplierTransactionsTmp = transactiontmp::where('transactiontmp_supplierId', $request->supplierId)->first();

        if ($checkSupplierTransactionsTmp || $checkSupplierTransactionsTmp) {

            return ApiController::successResponse('Unable to delete', 204);
        } else {
            $deleteSuppliers = suppliers::where('supplier_id', $request->supplierId);

            if ($deleteSuppliers) {
                $historyController = new HistoryController();
                $deleteItem = $deleteSuppliers->first()->toArray();
                $deleteItem['supplier_id'] = $request->supplierId;
                $deleteItem['user_modified'] = auth()->user()->id;
                $historyController->insertHistoryData('suppliers', $deleteItem, 'Delete');
                $deleteSuppliers->delete();
                return ApiController::successResponse($deleteSuppliers, 200);
            }
        }

        return ApiController::errorResponse('no update', 200);
    }
}
