<?php

namespace App\Http\Controllers\BackOffice\Companies;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\companies;
use App\Models\user;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class CompanyController extends ApiController
{
    public function fetchCompanies(Request $request)
    {
        $userId = auth()->user()->id;
        $companyId = auth()->user()->company_id;

        $getUser = user::where('id', '=', $userId)
            ->join('roles', 'roles.role_id', '=', 'users.user_role_id')
            ->select('roles.role_code')
            ->first();

        $companies = companies::leftjoin('currency', 'currency.currency_id', '=', 'companies.currency');
        if ($getUser && $getUser->role_code != 'superAdmin') {
            $companies = $companies->where([
                ['company_id', '=', $companyId]
            ]);
        }
        $companies = $companies->get();

        foreach ($companies as $company) {
            if ($company->company_logo) {

                $company->company_logo = '/companies/images/' . $company->company_id . '/' . $company->company_logo;
            }
        }

        foreach ($companies as $company) {
            if ($company->company_logo) {

                $company->company_stamp = '/companies/images/' . $company->company_id . '/' . $company->company_stamp;

            }
        }

        return ApiController::successResponse($companies, 200);
    }

    public function insertNewCompany(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'companyName' => 'required',
            'companyImportCode' => 'required',
            'companyExitCode' => 'required',
            'companyAddress' => 'required',
            'companyCurrency' => 'required',
            'companyRange' => 'required',
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $utilitiesController = new UtilitiesController();

        $array = array(
            'company_address' => $request->companyAddress,
            'company_trn' => $request->companyTrn,
            'company_importCode' => $request->companyImportCode,
            'company_exitCode' => $request->companyExitCode,
            'company_range' => $request->companyRange,
            'currency' => $request->companyCurrency,
            'company_name' => $request->companyName,
            'company_prefix' => $request->companyPrefix,
            'company_licenseNo' => $request->companyLicenseNo,
            'company_logoLength' => $request->companyLogoLength,
            'company_logoWidth' => $request->companyLogoWidth,
            'company_stampLength' => $request->companyStampLength,
            'company_stampWidth' => $request->companyStampWidth,
            'company_showFinalPrice' => $request->companyShowFinalPrice,
            'company_showBasePrice' => $request->companyShowBasePrice,
            'company_defaultShipTo' => $request->shipTo
        );

        $company = companies::create($array);
        $imageName = $utilitiesController->base64ToJpeg($request->image, public_path() . '/companies/images/' . $company->company_id . '/');

        if ($company) {
            companies::where('company_id', '=', $company->company_id)
                ->update([
                    "company_logo" => $imageName
                ]);
        }
        return ApiController::successResponse($company, 200);
    }

    public function updateCompany(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'companyName' => 'required',
            'companyImportCode' => 'required',
            'companyExitCode' => 'required',
            'companyAddress' => 'required',
            'companyCurrency' => 'required',
            'companyRange' => 'required'
        ]);
        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $utilitiesController = new UtilitiesController();

        if ($request->image) {
            $imageName = $utilitiesController->base64ToJpeg($request->image, public_path() . '/companies/images/' . $request->companyId . '/');
        }
        //return ApiController::errorResponse($request->all(),200);
        if ($request->stamp) {

            $stampName = $utilitiesController->base64ToJpeg($request->stamp, public_path() . '/companies/images/' . $request->companyId . '/');
        }


        $array = array(
            'company_address' => $request->companyAddress,
            'company_trn' => $request->companyTrn,
            'company_importCode' => $request->companyImportCode,
            'company_exitCode' => $request->companyExitCode,
            'company_range' => $request->companyRange,
            'currency' => $request->companyCurrency,
            'company_name' => $request->companyName,
            'company_prefix' => $request->companyPrefix,
            'company_licenseNo' => $request->companyLicenseNo,
            'company_logoLength' => $request->companyLogoLength,
            'company_logoWidth' => $request->companyLogoWidth,
            'company_stampLength' => $request->companyStampLength,
            'company_stampWidth' => $request->companyStampWidth,
            'company_showFinalPrice' => $request->companyShowFinalPrice,
            'company_showBasePrice' => $request->companyShowBasePrice,
            'company_address' => $request->companyAddress,
            'Rental_Space_Unit' => $request->companyStorage,
            'company_defaultShipTo' => $request->shipTo
        );


        $company = companies::where('company_id', '=', $request->companyId)->update($array);

        if ($request->image) {
            companies::where('company_id', '=', $request->companyId)
                ->update([
                    "company_logo" => $imageName
                ]);
        }

        if ($request->stamp) {
            companies::where('company_id', '=', $request->companyId)
                ->update([
                    "company_stamp" => $stampName
                ]);
        }

        if ($request->removeStampImage) {
            companies::where('company_id', '=', $request->companyId)
                ->update([
                    "company_stamp" => null
                ]);
        }


        return ApiController::successResponse($company, 200);
    }

    public function deleteCompany(Request $request)
    {
        $deleteCompany = companies::where('company_id', '=', $request->companyId)->delete();
        return ApiController::successResponse($deleteCompany, 200);
    }
}
