<?php

namespace App\Http\Controllers\BackOffice\Country;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Models\country;
use App\Models\transactionDt;
use App\Models\transactiondttmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class CountryController extends ApiController
{
    public function fetchCountry(Request $request)
    {
        $countries = DB::table('countries')
            ->orderBy('country_code')
            ->get();
        return ApiController::successResponse($countries, 200);
    }

    public function removeCountry(Request $request)
    {
        $checkCountryTransactions = transactionDt::where('transactiondt_countryOfOrigin', $request->countryId)->first();
        $checkCountryTransactionsTmp = transactiondttmp::where('transactiondttmp_countryOfOrigin', $request->countryId)->first();

        if ($checkCountryTransactions || $checkCountryTransactionsTmp) {
            return ApiController::successResponse('Unable to Delete', 204);
        }

        $removeCountry = country::where('country_id', '=', $request->countryId);
        $historyController = new HistoryController();

        $removeCountry = $removeCountry->first();
        unset($removeCountry['GCC']);
        $removeCountry['user_modified'] = auth()->user()->id;
        $historyController->insertHistoryData('countries', $removeCountry->toArray(), 'Delete');
        $removeCountry->delete();
        return ApiController::successResponse($removeCountry, 200);
    }

    public function insertCountry(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'countryCode' => 'required',
            'countryName' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }

        return $this->insertCountryFunction($request->countryCode, $request->countryName, $request->countryAreaCode);


    }

    public function insertCountryFunction($countryCode, $countryName, $countryAreaCode, $isDataLoad = false)
    {
        $checkCountryExistance = country::where(
            [
                ['country_code', '=', $countryCode]
            ])
            ->first();

        if ($checkCountryExistance) {
            return ApiController::errorResponse('Code already taken!', 409);
        }


        $country = array(
            'country_code' => $countryCode,
            'country_name' => $countryName,
            'country_areaCode' => $countryAreaCode,
        );
        $newCountry = country::create($country);
        if ($newCountry) {
            if (!$isDataLoad) {
                $historyController = new HistoryController();

                $country['country_id'] = $newCountry->country_id;
                $country['user_modified'] = auth()->user()->id;
                $historyController->insertHistoryData('countries', $country, 'Insert');

            }
            return ApiController::successResponse($newCountry, 200);
        }
        return ApiController::errorResponse('errors', 422);
    }

    public function updateCountry(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'countryCode' => 'required',
            'countryName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $country = array(
            'country_code' => $request->countryCode,
            'country_name' => $request->countryName,
            'country_areaCode' => $request->countryAreaCode,
        );
        $checkCountryExistance = country::where(
            [
                ['country_id', '!=', $request->countryId],
                ['country_code', '=', $request->countryCode]
            ])
            ->first();


        if ($checkCountryExistance) {
            return ApiController::errorResponse('Code already taken!', 409);
        }


        $updateCountry = country::where('country_id', $request->countryId)->update($country);

        if ($updateCountry) {
            $historyController = new HistoryController();
            $country['country_id'] = $request->countryId;
            $country['user_modified'] = auth()->user()->id;

            $historyController->insertHistoryData('countries', $country, 'Update');
            return ApiController::successResponse($updateCountry, 200);
        }
        return ApiController::errorResponse('no update', 200);


    }
}
