<?php

namespace App\Http\Controllers\BackOffice\DO;

use App\enums\NotificationTopics;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\companies;
use App\Models\items;
use App\Models\location;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\TransactionPalets;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use File;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\Notifications\NotificationsController;
use App\Models\notifications;
use Illuminate\Support\Facades\Log;

class DOController extends ApiController
{
    public function insertNewDOTransaction(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $historyController = new HistoryController();
        $transactionIndex = 0;
        $hitoryArray = array();
        $hitoryDtArray = array();
        $state = "Insert";
        $date = date('Y-m-d H:i:s');

        $navigationEntry = 'GOODS_IN';
        $navigationOut = 'DO';

        if ($request->navigationType == 'RMA_OUT') {
            $navigationEntry = 'RMA_IN';
            $navigationOut = 'RMA_OUT';
        }


        $priceArray = $this->checkPriceBeforeSave($request);

        if (count($priceArray) > 0) {
            // $obj = array();
            // $obj['message'] = 'Price less than GoodsIn Price';
            // $obj['data'] = $priceArray;
            // $obj['type'] = 'price';
            // return ApiController::errorResponse($obj, 422);
        }
        //        $dateValidity = $this->checkValidQtyBeforeSave($request);




        // retrieve the current transaction tmp
        $checkTransactionTmpExistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->leftjoin('clients', 'clients.client_id', 'transactiontmps.transactiontmp_clientId')
            ->select('transactiontmps.*', 'clients.client_firstName')
            ->first();


        // retrieve the current transaction dt tmp
        $transactionDtsTmp = transactiondttmp::join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->select('transactiondttmps.*', 'items.item_hasSerial',)
            ->where('transactiontmp_id', '=', $request->transactionTmpId)
            ->get();



        $checkQtyValidity = $this->checkValidityQty($transactionDtsTmp, $checkTransactionTmpExistance, $request, $navigationEntry, $navigationOut);

        //  return ApiController::errorResponse($checkQtyValidity, 422);


        if (count($checkQtyValidity["invalidTransactions"]) > 0) {
            $obj = array();
            $obj['message'] = 'Invalid Qty Exist';
            $obj['data'] = $checkQtyValidity["invalidTransactions"];
            $obj['type'] = 'qty';
            return ApiController::errorResponse($obj, 422);
        }
        if (count($checkQtyValidity["TransactionsSerialsIndex"]) > 0) {
            $obj = array();
            $obj['message'] = 'Invalid Qty/Serials Exist';
            $obj['data'] = $checkQtyValidity["TransactionsSerialsIndex"];
            $obj['type'] = 'qty';
            return ApiController::errorResponse($obj, 422);
        }
        $newTransaction = null;

        if ($checkTransactionTmpExistance) {
            //return ApiController::errorResponse($transactionDtsTmp,422);
            $sequenceNumber = sequence::getSequences($checkTransactionTmpExistance->transactiontmp_type, $checkTransactionTmpExistance->internal_transfer, $checkTransactionTmpExistance->transactiontmp_reference);

            if (!$sequenceNumber) {
                $obj = array();
                $obj['message'] = 'something error in sequence';
                $obj['data'] = $sequenceNumber;
                return ApiController::errorResponse($obj, 422);
            }


            $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;


            $transaction = array(
                'transaction_reference' => $goodsInSequence,
                'transaction_id' => $checkTransactionTmpExistance->transactiontmp_id,
                'transaction_date' => $checkTransactionTmpExistance->transactiontmp_date,
                'transaction_clientId' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
                'internal_transfer' => $checkTransactionTmpExistance->internal_transfer,
                'transferTo_clientId' => $checkTransactionTmpExistance->transferTo_clientId,
                'transaction_remark' => $checkTransactionTmpExistance->transactiontmp_remark,
                'transaction_mobileReference' => $checkTransactionTmpExistance->transactiontmp_mobileReference,
                'transaction_shipmentReference' => $checkTransactionTmpExistance->transactiontmp_shipmentReference,
                'transaction_billOfEntry' => $checkTransactionTmpExistance->transactiontmp_billOfEntry,
                'user_id' => $checkTransactionTmpExistance->user_id,
                'transaction_typeOfDeliveryId' => $checkTransactionTmpExistance->transactiontmp_typeOfDeliveryId,
                'forwarder_id' => $checkTransactionTmpExistance->forwarder_id,
                'clientCustomer_id' => $checkTransactionTmpExistance->clientCustomer_id,
                'transaction_driverName' => $checkTransactionTmpExistance->transactiontmp_driverName,
                'transaction_driverPhone' => $checkTransactionTmpExistance->transactiontmp_driverPhone,
                'transaction_vehicleNumber' => $checkTransactionTmpExistance->transactiontmp_vehicleNumber,
                'transaction_exitPoint' => $checkTransactionTmpExistance->transactiontmp_exitPoint,
                'transaction_destinationPoint' => $checkTransactionTmpExistance->transactiontmp_destinationPoint,
                'company_id' => $checkTransactionTmpExistance->company_id,
                'transaction_paymentMethodId' => $checkTransactionTmpExistance->transactiontmp_paymentMethodId,
                'transaction_customBillTypeId' => $checkTransactionTmpExistance->transactiontmp_customBillTypeId,
                'transaction_currencyId' => $checkTransactionTmpExistance->transactiontmp_currencyId,
                'transaction_rate' => $checkTransactionTmpExistance->transactiontmp_rate,
                'transaction_shipmentTypeId' => $checkTransactionTmpExistance->transactiontmp_shipmentTypeId,
                'transaction_shipById' => $checkTransactionTmpExistance->transactiontmp_shipById,
                'transaction_shipmentRemark' => $checkTransactionTmpExistance->transactiontmp_shipmentRemark,
                'transaction_supplierId' => $checkTransactionTmpExistance->transactiontmp_supplierId,
                'transaction_supplierInvoice' => $checkTransactionTmpExistance->transactiontmp_supplierInvoice,
                'transaction_totalQty' => $checkTransactionTmpExistance->transactiontmp_totalQty,
                'transaction_totalPallet' => $checkTransactionTmpExistance->transactiontmp_totalPallet,
                'transaction_totalPrice' => $checkTransactionTmpExistance->transaction_totalPrice,
                'transaction_totalItem' => $checkTransactionTmpExistance->transaction_totalItem,
                'Invoice_type_id' => $checkTransactionTmpExistance->Invoice_type_id,
                'payment_term_id' => $checkTransactionTmpExistance->payment_term_id,
                'delivery_term_id' => $checkTransactionTmpExistance->delivery_term_id,
                'exemption_type_id' => $checkTransactionTmpExistance->exemption_type_id,
                'way_bill_no' => $checkTransactionTmpExistance->way_bill_no,
                'tir' => $checkTransactionTmpExistance->tir,
                'job_no' => $checkTransactionTmpExistance->job_no,
                'showInDocument' => $checkTransactionTmpExistance->showInDocument,
                'salesjv_discount' => $checkTransactionTmpExistance->salesjv_discount,
            );
            $clients = array(
                'table' => 'clients',
                'column' => 'client_id',
                'value' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'selectedValue' => 'client_firstname',
                'replaceColumn' => 'transaction_clientId'
            );
            $customers = array(
                'table' => 'client_customers',
                'column' => 'customer_id',
                'value' => $checkTransactionTmpExistance->clientCustomer_id,
                'selectedValue' => 'customer_name',
                'replaceColumn' => 'clientCustomer_id'
            );
            $forwarders = array(
                'table' => 'client_forwarders',
                'column' => 'clientforwarder_id',
                'value' => $checkTransactionTmpExistance->forwarder_id,
                'selectedValue' => 'clientforwarder_name',
                'replaceColumn' => 'forwarder_id'
            );
            array_push($hitoryArray, $clients);
            array_push($hitoryArray, $customers);
            array_push($hitoryArray, $forwarders);

            if ($checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference) {
                $newTransaction = transactions::create($transaction);
                $notificationController = new NotificationsController();
                $notificationController->sendNotificationsByTopic(auth()->user()->id, NotificationTopics::DO_PREPARATION, $newTransaction->transaction_id,$newTransaction->transaction_reference);
                $utilitiesController->createErpProject($newTransaction->transaction_reference,'DO',$checkTransactionTmpExistance->client_firstName,$checkTransactionTmpExistance->transactiontmp_id);

                $this->insertTransactionStatusFunction($checkTransactionTmpExistance->transactiontmp_id, null, 'Shipment preparation', 'shipmentPreparation');



                $notificationToken = DB::table('users')
                    ->join('clients', 'clients.user_id', 'id')
                    ->where([
                        ["clients.client_id", $checkTransactionTmpExistance->transactiontmp_clientId],
                    ])
                    ->first();


                $ref = 0;
                $message = "";
                $type = "";
                $notificationKey = "";
                $notificationKey2 = "warehousekeeper";
                if ($checkTransactionTmpExistance->transactiontmp_type == "DO") {
                    $type = "Delivery Order";
                    $notificationKey = "delivery";
                } else if ($checkTransactionTmpExistance->transactiontmp_type == "RMA_OUT") {
                    $type = "RMAOUT";
                    $notificationKey = "";
                }

                if ($checkTransactionTmpExistance->transactiontmp_mobileReference) {
                    $ref = $checkTransactionTmpExistance->transactiontmp_mobileReference;
                    $message = $type . ' Ref: ' . $ref . ' was approved';
                } else {
                    $ref = $goodsInSequence;
                    $message = $type . ' Ref: ' . $ref . ' was created';
                }


                ///notification to client
                if (isset($notificationToken->user_pushToken)) {

                    $notificationArray = array(
                        'title' => 'Delivery_Created',
                        'message' => 'Delivery_Created',
                        'seen' => 0,
                        'related_userid' => $checkTransactionTmpExistance->transactiontmp_clientId,
                        'trans_id' => $newTransaction->transaction_id,
                        'key' => $newTransaction->transaction_id,
                        'code' => 'Delivery_Created',
                        'notificationToken' => $notificationToken->user_pushToken,
                        'transType' => "DO"
                    );

                    $utilitiesController->sendNotification($notificationArray);
                }
                $admins = DB::table('users')
                    ->join('useraccess', 'useraccess.user_id', 'users.id')
                    ->join('roles', 'roles.role_id', 'users.user_role_id')
                    ->where([
                        ["useraccess.useraccess_formcode", $notificationKey],
                    ])
                    ->orwhere([
                        ['roles.role_code', "WH Operator"]
                    ])
                    ->groupBy('users.user_name')
                    ->get();

                foreach ($admins as $admindt) {

                    if ($admindt->user_pushToken) {
                        $notificationArray = array(
                            'title' => 'Delivery_Created',
                            'message' => 'Delivery_Created',
                            'seen' => 0,
                            'related_userid' => $admindt->id,
                            'trans_id' => $newTransaction->transaction_id,
                            'key' => $newTransaction->transaction_id,
                            'code' => 'Delivery_Created',
                            'notificationToken' =>  $admindt->user_pushToken,
                            'transType' => "DO"
                        );
                        $utilitiesController->sendNotification($notificationArray);
                    }
                }
            } else {
                $state = "Update";
                transactions::where('transaction_id', '=', $request->transactionId)->update($transaction);
                $newTransaction = transactions::where('transaction_id', '=', $request->transactionId)->first();
                // $transaction['transaction_id'] = $request->transactionId;
                // $transaction['user_modified'] = auth()->user()->id;
                // $transaction['date_modified'] = $date;
                // $transaction['modification_type'] = 'Update';
                // $transactionIndex = $historyController->insertTransactionHistoryData('transactions', $transaction, 'Update', $hitoryArray);

            }


            //return ApiController::successResponse($newTransaction,200);


            // after saving and creation of transaction or update get tmp transaction dt into original and remove from tmp
            if ($newTransaction) {
                // start : transfer supplier to client suppliers

                $previousDtData = null;

                // delete previous transactions dts
                if ($request->transactionId) {
                    $previousDtData = transactiondt::where('transaction_id', '=', $request->transactionId)->get();
                    transactiondt::where('transaction_id', '=', $request->transactionId)->delete();
                }
                //return ApiController::errorResponse($transactionDtsTmp,422);
                $insertDtFound = array();

                foreach ($transactionDtsTmp as $transactionDtTmp) {
                    if ($transactionDtTmp->item_quantity == 0) {

                        continue;
                    } else {

                        $BOE = $transactionDtTmp->transactiontmpdt_BOE;
                        if ($BOE == null) {
                            $BOE = transactionDt::where('transactiondt_id', '=', $transactionDtTmp->id_reference_dt)->first()->transactiondt_BOE;
                        }
                        $transactionDtArray = array(
                            'transactiondt_id' => $transactionDtTmp->transactiondttmp_id,
                            'transaction_id' => $newTransaction->transaction_id,
                            'item_id' => $transactionDtTmp->item_id,
                            'client_id' => $transactionDtTmp->client_id,
                            'item_quantity' => $transactionDtTmp->item_quantity,
                            'supplier_id' => $transactionDtTmp->supplier_id,
                            'supplier_invoice_number' => $transactionDtTmp->supplier_invoice_number,
                            'transactiondt_locationid' => $transactionDtTmp->transactiondttmp_locationid,
                            'transactiondt_countryOfOrigin' => $transactionDtTmp->transactiondttmp_countryOfOrigin,
                            'transactiondt_price' => $transactionDtTmp->transactiondttmp_price,
                            'id_reference_dt' => $transactionDtTmp->id_reference_dt,
                            'transactiondt_billOfEntry' => $transactionDtTmp->transactiontmpdt_billOfEntry,
                            'raw_in_grid' => $transactionDtTmp->raw_in_grid,
                            'item_weight' => $transactionDtTmp->item_weight,
                            'item_unit' => $transactionDtTmp->item_unit,
                            'item_qtyPerPack' => $transactionDtTmp->item_qtyPerPack,
                            'item_pack' => $transactionDtTmp->item_pack,
                            'group_id' => $transactionDtTmp->group_id,
                            'palet_no' => $transactionDtTmp->palet_no,
                            'transactiondt_nbOfCarton' => $transactionDtTmp->transactiondttmp_nbOfCarton,
                            'transactiondt_cellMerge' => $transactionDtTmp->transactiondttmp_cellMerge,
                            'transactiondt_BOE' => $BOE,
                            'client_id' => $transactionDtTmp->client_id,
                            'transactiondt_fprice' => $transactionDtTmp->transactiondttmp_fprice,
                            'transactiondt_fpriceBase' => $transactionDtTmp->transactiondttmp_fpriceBase,
                            'transactiondt_priceBase' => $transactionDtTmp->transactiondttmp_priceBase,
                            'hscode' => $transactionDtTmp->hscode,
                            'transactiondt_item_description' => $transactionDtTmp->transactiondt_item_description,
                            'dt_transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
                            'reference_internal_dt' => $checkTransactionTmpExistance->reference_internal_dt,
                            'gross_weight' => $transactionDtTmp->gross_weight,
                            'total_gross_weight' => $transactionDtTmp->total_gross_weight,


                        );
                        array_push($insertDtFound, $transactionDtTmp->transactiondttmp_id);
                    }



                    $newTransactionDt = transactiondt::create($transactionDtArray);
                    $serialsTmp = transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDtTmp->transactiondttmp_id)->get();
                    transactionDtsn::where('transactiondt_id', '=', $newTransactionDt->transactiondt_id)->delete();

                    foreach ($serialsTmp as $serialTmp) {
                        $transactionSerialTmpArray = array(
                            'transactiondt_id' => $newTransactionDt->transactiondt_id,
                            'item_id' => $serialTmp->item_id,
                            'transactiondtsn_id' => $serialTmp->transactiondtsntmp_id,
                            'transaction_item_serial' => $serialTmp->transaction_item_serial
                        );
                        if ($serialTmp->status == 'Delete') {
                            continue;
                        }

                        transactionDtsn::create($transactionSerialTmpArray);
                    }

                    $palets = DB::table('transactiontmp_palets')
                        ->where([
                            ['transactiontmp_id', $checkTransactionTmpExistance->transactiontmp_id]
                        ])
                        ->get();
                    TransactionPalets::where('transaction_id', $checkTransactionTmpExistance->transactiontmp_id)->delete();
                    foreach ($palets as $paletsTmp) {

                        $palets = array(
                            'palet_id' => $paletsTmp->palettmp_id,
                            'palet_no' => $paletsTmp->palet_no,
                            'palet_dimension' => $paletsTmp->palet_dimension,
                            'transaction_id' => $paletsTmp->transactiontmp_id,
                            'palet_weight' => $paletsTmp->palet_weight,
                            'palet_order' => $paletsTmp->palet_order,

                        );
                        TransactionPalets::create($palets);
                    }
                }


                if (config('app.TRANSFERFROMSHIPMENTTOLOGI') == 1 && $state == "Insert") {

                    $utilitiesController->connectShipmentToLogisticom($newTransaction->transaction_id);
                }

                if ($newTransaction) {
                    $transactionIndex = $historyController->insertTransactionHistoryDataByRef(
                        $state,
                        $newTransaction->transaction_reference,
                        auth()->user()->id,
                        $date,
                        $newTransaction->transaction_type
                    );
                    transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                    TransactiontmpPalets::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();

                    // delete transaction details from tmp table
                    foreach ($transactionDtsTmp as $transactionDetailTmp) {
                        transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDetailTmp->transactiondttmp_id)->delete();
                    }
                    transactiondttmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                }
            }

            //   $historyController->insertHistoryTransactionDtData($previousDtData, $insertDtFound, $date, $transactionIndex, auth()->user()->id);
        }
        if ($checkTransactionTmpExistance->internal_transfer == 1) {

            //  $this->addGoodsInInternal();
        }
        return ApiController::errorResponse($checkQtyValidity["TransactionsSerialsIndex"], 200);
    }


    //check valid qty as date

    public function checkPriceBeforeSave(Request $request)
    {
        $priceArray = array();
        $obj = array();
        $checkPrice = transactiondttmp::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transactiondttmps.id_reference_dt')
            ->join('items', 'items.item_id', 'transactiondttmps.item_id')
            ->where([
                ['transactiondttmps.transactiontmp_id', $request->transactionTmpId],
                ['transactiondttmps.item_quantity', '>', 0],
                ['items.item_unDependentPrice', '!=', 1],
            ])
            ->select('transaction_dts.transactiondt_priceBase as goodsIn_price', 'transactiondttmps.transactiondttmp_priceBase as do_price', 'transactiondttmps.raw_in_grid')
            ->get();

        foreach ($checkPrice as $data) {
            if ($data->do_price < $data->goodsIn_price) {
                array_push($priceArray, $data);
            }
        }

        return $priceArray;
    }

    public function checkValidQtyBeforeSave(Request $request)
    {

        $priceArray = array();
        $obj = array();
        $checkDate = transactiondttmp::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transactiondttmps.id_reference_dt')
            ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->join('transactiontmps', 'transactiontmps.transactiontmp_id', 'transactiondttmps.transactiontmp_id')
            ->where([
                ['transactiondttmps.transactiontmp_id', $request->transactionTmpId],
                ['transactiondttmps.item_quantity', '>', 0],
            ])
            ->select('transactions.transaction_date as goodsIn_date', 'transactiontmps.transactiontmp_date as do_date', 'transactiondttmps.raw_in_grid', 'transactiondttmp_id')
            ->get();

        foreach ($checkDate as $data) {
            if ($data->do_date <= $data->goodsIn_date) {
                transactiondttmp::where('transactiondttmp_id', $data->transactiondttmp_id)
                    ->update([
                        'item_quantity' => 0
                    ]);
                // array_push($priceArray, $data);
            }
        }

        return $priceArray;
    }

    public function checkValidityQty($transactionDtsTmp, $checkTransactionTmpExistance, Request $request, $navigationEntry, $navigationOut)
    {
        $invalidTransactionsSerialsIndex = array();
        $invalidTransactionsIndex = array();
        for ($i = 0; $i < count($transactionDtsTmp); $i++) {
            $quantity = $transactionDtsTmp[$i]->item_quantity;
            $dateFrom = $checkTransactionTmpExistance->transactiontmp_date;

            $checkNbrOfSerialsCreatedTmp = transactionDtSnTmp::where([
                ['transactiondttmp_id', '=', $transactionDtsTmp[$i]->transactiondttmp_id],

            ])
                ->where(function ($query) {
                    $query->where('status', '!=', 'Delete')
                        ->orWhereNull('status');
                })
                ->get();


            if (($transactionDtsTmp[$i]->item_hasSerial && $quantity != count($checkNbrOfSerialsCreatedTmp))) {
                array_push($invalidTransactionsSerialsIndex, $transactionDtsTmp[$i]);
            }

            $qtyIn2 = DB::table('transaction_dts')
                ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->leftjoin('clients', 'clients.client_id', 'transaction_dts.client_id')
                ->where([
                    ['transaction_dts.item_id', $transactionDtsTmp[$i]->item_id],
                    //['transaction_dts.transactiondt_billOfEntry', $transactionDtsTmp[$i]->transactiontmpdt_billOfEntry],
                    // ['transaction_dts.transactiondt_countryOfOrigin', $transactionDtsTmp[$i]->transactiondttmp_countryOfOrigin],
                    ['transaction_dts.transactiondt_id', $transactionDtsTmp[$i]->id_reference_dt],
                    //  ['transaction_date', "<=", $dateFrom]
                ])
                ->first();





            $qtyOutBalance = DB::table('transaction_dts')
                ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->where([
                    ['transaction_dts.id_reference_dt', $transactionDtsTmp[$i]->id_reference_dt],
                    ['transactions.transaction_id', '!=', $transactionDtsTmp[$i]->transactiontmp_id]

                ])
                ->sum('item_quantity');
            $qtyIn = $qtyIn2->item_quantity;
            $qtyOut = isset($qtyOutBalance) ? $qtyOutBalance : 0;

            $qtyOutSameTr = DB::table('transaction_dts')
                ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->where([
                    ['transaction_dts.item_id', $transactionDtsTmp[$i]->item_id],
                    ['transactions.transaction_type', $navigationOut],
                    ['transaction_dts.transaction_id', $transactionDtsTmp[$i]->transactiontmp_id],
                    ['transaction_dts.transactiondt_id',  $transactionDtsTmp[$i]->transactiondttmp_id],
                    ['transaction_dts.id_reference_dt', $transactionDtsTmp[$i]->id_reference_dt],
                ])
                ->sum('transaction_dts.item_quantity');


            $qtyExistInDoTmp = transactiondttmp::join(
                'transactiontmps',
                'transactiontmps.transactiontmp_id',
                'transactiondttmps.transactiontmp_id'
            )
                ->where([
                    ['transactiondttmps.item_id', $transactionDtsTmp[$i]->item_id],
                    ['transactiontmps.transactiontmp_type', $navigationOut],
                    ['transactiondttmps.transactiontmp_id', $transactionDtsTmp[$i]->transactiontmp_id],
                    ['transactiondttmp_id', '!=', $transactionDtsTmp[$i]->transactiondttmp_id],
                    ['transactiondttmps.id_reference_dt', $transactionDtsTmp[$i]->id_reference_dt],
                ])
                ->sum('transactiondttmps.item_quantity');


            $qtyOutSameTr = isset($qtyOutSameTr) ? $qtyOutSameTr : 0;
            $qtyExistInDoTmp = isset($qtyExistInDoTmp) ? $qtyExistInDoTmp : 0;
            $qtyExist = $qtyIn - $qtyOut + $qtyOutSameTr - $qtyExistInDoTmp;
            $transactionDtsTmp[$i]->qtyOut = $qtyOut;
            $transactionDtsTmp[$i]->qtyIn = $qtyIn;

            $transactionDtsTmp[$i]->qtyOutSameTr = $qtyOutSameTr;
            $transactionDtsTmp[$i]->qtyExistInDoTmp = $qtyExistInDoTmp;

            $transactionDtsTmp[$i]->qtyExist = $qtyExist;

            if ($quantity > $qtyExist) {
                array_push($invalidTransactionsIndex, $transactionDtsTmp[$i]);
            }
        }
        $obj = array();
        $obj["TransactionsSerialsIndex"] = $invalidTransactionsSerialsIndex;
        $obj["invalidTransactions"] = $invalidTransactionsIndex;
        return $obj;
    }

    public function insertTransactionStatusFunction($transactionId, $transactiondtId, $status, $code, $withNotif = 1)
    {
        $reference = DB::table('transactions')
            ->where('transaction_id', $transactionId)
            ->first()->transaction_reference;


        $utilitiesController = new utilitiesController();
        $date = $utilitiesController->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
        $transaction[] = [
            'transaction_id' => $transactionId,
            'delivery_status' => $status,
            'delivery_created_at' => $date,
        ];
        if ($transactiondtId) {
            $data = DB::table('delivery_status')
                ->where('delivery_status_id', $transactiondtId)
                ->update(
                    ['delivery_status' => $status,]
                );
            $data = $this->fetchTransactionStatusFunction($transactionId);

            if ($withNotif == 1) {
                $this->sendToClientNotifications($transactionId, 'Delivery Items with Reference:' . $reference . $status, $code);
   }
            return ApiController::successResponse($data, 204);
        }
        $data = DB::table('delivery_status')
            ->insert($transaction);
        $data = $this->fetchTransactionStatusFunction($transactionId);
        if ($withNotif == 1) {
            $this->sendToClientNotifications($transactionId, 'Delivery Items with Reference:' . $reference . ' ' . $status, $code);
        }

        return ApiController::successResponse($data, 204);
    }

    public function fetchTransactionStatusFunction($transactionId)
    {
        $data = DB::table('delivery_status')
            ->selectRaw(DB::raw("FROM_UNIXTIME(delivery_created_at, '%d-%m-%Y %H:%i:%s') AS delivery_created_at"))
            ->addselect('delivery_status.delivery_status', 'delivery_status_id')
            ->where(
                'transaction_id',
                $transactionId
            )
            ->orderBy('delivery_created_at', 'desc')
            ->get();
        return $data;
    }

    public function sendToClientNotifications($transactionId, $message, $code)
    {
        $utilitiesController = new utilitiesController();

        $data = DB::table('clients')
            ->leftjoin('transaction_dts', 'transaction_dts.client_id', 'clients.client_id')
            ->where('transaction_id', $transactionId)
            ->select('clients.client_id')
            ->groupBy('client_id')
            ->get();

        foreach ($data as $clients) {
            $notificationToken = DB::table('users')
                ->join('clients', 'clients.user_id', 'id')
                ->where([
                    ["clients.client_id", $clients->client_id],
                ])
                ->first();


            if (isset($notificationToken->user_pushToken)) {
                $notificationArray = array(
                    'title' => 'Delivery Status',
                    'message' => $message,
                    'seen' => 0,
                    'related_userid' => $clients->client_id,
                    'trans_id' => $transactionId,
                    'key' => $transactionId,
                    'code' => $code,
                    'notificationToken' => $notificationToken->user_pushToken,
                    'transType' => "DO"
                );
                $utilitiesController->sendNotification($notificationArray);
            }
        }


        return $data;
    }

    public function updateTransactionDtTmpPriceDO(Request $request)
    {
        $groupId = $request->transactionDetailItemGroup;
        $itemUnit = $request->transactionDetailItemUnit;
        $transactionDtTmpsIdGet = DB::table('transactiondttmps')
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['raw_in_grid', '=', $request->raw_in_grid]
            ]);
        $transactionDtTmpsId = $transactionDtTmpsIdGet->update([
            'transactiondttmp_price' => $request->transactionTmpPrice,

            'item_qtyPerPack' => $request->transactionTmpQtyPerPack,
            'item_pack' => $request->itemPack,
            'item_unit' => $itemUnit,
            'transactiondttmp_nbOfCarton' => $request->noOfCarton,
            'group_id' => $groupId,
            'palet_no' => $request->paletNo,
            'transactiondttmp_nbOfCarton' => $request->noOfCarton,
            'transactiondttmp_cellMerge' => $request->mergeOfCarton,
            'transactiondttmp_priceBase' => $request->transactiondttmpPriceBase,
            'transactiondttmp_fprice' => $request->fPrice,
            'transactiondttmp_fpriceBase' => $request->fPrice,


        ]);
        //if ($request->transactiondttmpDescription) {
        // $transactionDtTmpsId = $transactionDtTmpsIdGet->update([
        //     'transactiondt_item_description' => $request->transactiondttmpDescription
        // ]);
        // }

        //return $request->transactionTmpQtyPerPack;
        //return $request->transactionTmpWeight;
        return ApiController::successResponse($transactionDtTmpsId, 200);
    }



    public function removeTransactionDtTmpDO(Request $request)
    {



        $transactionDtTmpsId = DB::table('transactiondttmps')
            ->select('transactiondttmp_id')
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['raw_in_grid', '=', $request->raw_in_grid]
            ])
            ->get();
        if (count($transactionDtTmpsId) > 0) {
            $transactionDt = transactiondttmp::where('transactiondttmps.transactiondttmp_id', '=', $transactionDtTmpsId[0]->transactiondttmp_id)
                ->first();
        } else {
            return ApiController::successResponse(1, 200);
        }


        foreach ($transactionDtTmpsId as $row) {

            transactionDtSnTmp::where('transactiondttmp_id', '=', $row->transactiondttmp_id)->delete();
            $removeTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', '=', $row->transactiondttmp_id)->delete();
        }

        if ($transactionDt) {
            $transactionDtSumQty = transactiondttmp::where('transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId)
                ->select('transactiondttmps.item_quantity')
                ->selectRaw(' SUM(transactiondttmps.item_quantity) as totalQty')
                ->first();
            transactiontmp::where('transactiontmps.transactiontmp_id', '=', $request->transactionTmpId)
                ->update(["transactiontmp_totalQty" => $transactionDtSumQty->totalQty]);
        }

        $transactionDtTmpsId = DB::table('transactiondttmps')
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['raw_in_grid', '>', $request->raw_in_grid]
            ])
            ->decrement('raw_in_grid');
        //->update(['raw_in_grid' => (raw_in_grid-1)]);


        return ApiController::successResponse(1, 200);
    }

    public function storeTransactionDtTmpDO(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'transactionDetailsTmp' => 'required|array',
            //'transactionTmpId' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $commonServices = new CommonServices();

        $newTransactionDtTmp = null;
        $loadPrice = $commonServices->checkLoadedPriceModule();
       // $headerData = tran::where('transactiontmp_id',$request->transactiontmp_id)->first();

        for ($i = 0; $i < count($request->transactionDetailsTmp); $i++) {
            $element = $request->transactionDetailsTmp[$i];

            if ($element['transactionDetailClientId'] == null || $element['transactionDetailClientId'] == 0 || $element['transactionDetailClientId'] == '0') {
                return ApiController::errorResponse($element['transactionDetailClientId'], 422);
            }

            if ($element['transactionDetailItemCode'] != null && $element['transactionDetailItemQty'] != null) {

                $itemWeight = $element['transactionDetailItemWeight'];
                $itemGrossWeight = $element['transactionDetailItemGrossWeight'];

                $price = isset($element['transactiondttmpPrice']) ? $element['transactiondttmpPrice'] : null;
                $priceBase = isset($element['transactiondttmpPriceBase']) ? $element['transactiondttmpPriceBase'] : 0;
                $fPrice = isset($element['fPrice']) ? $element['fPrice'] : 0;
                $fPriceBase = isset($element['fPriceBase']) ? $element['fPriceBase'] : 0;

                // if module to get default price

                $goodsIn = transactionDt::where([
                    ['transactiondt_id', $element['idReferenceDt']]
                ])->first();
                $goodsInDesc = isset($goodsIn->transactiondt_item_description) ? $goodsIn->transactiondt_item_description : null;
                $goodsInSupplier = isset($goodsIn->supplier_id) ? $goodsIn->supplier_id : null;
                $goodsInSupplierInvoice = isset($goodsIn->supplier_invoice_number) ? $goodsIn->supplier_invoice_number : null;

                if ($goodsIn && $loadPrice == 1) {
                    $price = $goodsIn->transactiondt_priceBase;
                }

                if ($request->transactionType == "INTERNAL_TRANSFER") {

                    $goodsIn = transactionDt::where([
                        ['transactiondt_id', $element['idReferenceDt']]
                    ])->first();

                    if ($goodsIn) {
                        $price = $goodsIn->transactiondt_price;
                        $priceBase = $goodsIn->transactiondt_priceBase;
                        $fPrice = $goodsIn->transactiondt_fprice;
                        $fPriceBase = $goodsIn->transactiondt_fpriceBase;
                    }
                }

                $transactionDtTmp = array(
                    'transactiontmp_id' => $request->transactiontmp_id,
                    'transactiontmpdt_BOE' => $goodsIn->transactiondt_BOE,
                    'item_id' => $element['transactionDetailItemCode'],
                    'group_id' => isset($element['itemGroup']) ? $element['itemGroup'] : null,
                    'client_id' => $element['transactionDetailClientId'],
                    'item_quantity' => $element['transactionDetailItemQty'],
                    'transactiontmpdt_billOfEntry' => $goodsIn->transactiondt_billOfEntry,
                    'supplier_id' => $goodsInSupplier,
                    'supplier_invoice_number' => $goodsInSupplierInvoice,
                    'transactiondttmp_locationid' => $element['transactionDetailLocation'],
                    'transactiondttmp_countryOfOrigin' => $element['transactionDetailCountryOfOrigin'],
                    'transactiondttmp_price' => $price,
                    'id_reference_dt' => isset($element['idReferenceDt']) ? $element['idReferenceDt'] : null,
                    'raw_in_grid' => isset($element['rawInGrid']) ? $element['rawInGrid'] : null,
                    'palet_no' => isset($element['paletNo']) ? $element['paletNo'] : null,
                    'item_weight' => $itemWeight,
                    'item_unit' => isset($element['itemUnit']) ? $element['itemUnit'] : null,
                    'item_qtyPerPack' => isset($element['itemQtyPerPack']) ? $element['itemQtyPerPack'] : 1,
                    'item_pack' => isset($element['itemPack']) ? $element['itemPack'] : " ",
                    'transactiondttmp_nbOfCarton' => isset($element['transactiondttmp_nbOfCarton']) ? $element['transactiondttmp_nbOfCarton'] : " ",
                    'transactiondttmp_cellMerge' => isset($element['transactiondt_cellMerge']) ? $element['transactiondt_cellMerge'] : " ",
                    'transactiondttmp_fprice' => $fPrice,
                    'transactiondttmp_fpriceBase' => $fPriceBase,
                    'hscode' => isset($element['transactionDetailHSCode']) ? $element['transactionDetailHSCode'] : null,
                    'transactiondttmp_priceBase' => $priceBase,
                    'dt_transaction_type' => 'DO',
                    'transactiondt_item_description' => $goodsInDesc,
                    'gross_weight' => $itemGrossWeight,
                    'total_gross_weight' => $itemGrossWeight * $element['transactionDetailItemQty'],
                    'total_price' => $element['transactionDetailItemQty'] * $price,
                    'total_weight' => $element['transactionDetailItemQty'] * $itemWeight,

                );

                $transactionDtTmp['transactiontmp_id'] = $request->transactionTmpId;


                $checkBillForDo = transactiondttmp::where(
                    [
                        ["transactiontmpdt_billOfEntry", $element['transactionDetailBill']],
                        ["transactiondttmp_id", isset($element['transactiondttmp_id']) ? $element['transactiondttmp_id'] : -1],
                        ["transactiondttmp_countryOfOrigin", $element['transactionDetailCountryOfOrigin']]
                    ]
                )->first();

                if (!isset($element['transactiondttmp_id']) || $element['transactiondttmp_id'] == null || $checkBillForDo == null) {
                    $newTransactionDtTmp = transactiondttmp::create($transactionDtTmp);

                    $payload['transactionType'] = $request->transactionType;
                    $payload['transactionTmpId'] = $request->transactionTmpId;
                    $payload['transactionDtTmp'] = $transactionDtTmp;
                    $payload['idReference'] = $newTransactionDtTmp->transactiondttmp_id;
                    transactiondttmp::createTransactionInternaldt($payload);
                } else {

                    $updateTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                        ->update($transactionDtTmp);
                    $newTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                        ->first();
                    transactiondttmp::updateTransactionInternaldt($request, $transactionDtTmp, $element['transactiondttmp_id'], $element['transactionDetailItemQty']);
                }


                $transactionDtSumQty = transactiondttmp::where('transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId)
                    ->select('transactiondttmps.item_quantity')
                    ->selectRaw(' SUM(transactiondttmps.item_quantity) as totalQty')
                    ->first();


                transactiontmp::where('transactiontmps.transactiontmp_id', '=', $request->transactionTmpId)
                    ->update(["transactiontmp_totalQty" => $transactionDtSumQty->totalQty]);

                $transactionDtSumNoCartoon = transactiondttmp::where([
                    ['transactiontmp_id', $request->transactionTmpId],
                    ['raw_in_grid', $element['rawInGrid']]

                ])->sum('item_quantity');

                $newQty = 0;
                if ($element['itemQtyPerPack'] > 0) {
                    $newQty = ceil($transactionDtSumNoCartoon / $element['itemQtyPerPack']);
                }


                $updateTransactionDtSumNoCartoon = transactiondttmp::where([
                    ['transactiontmp_id', $request->transactionTmpId],
                    ['raw_in_grid', $element['rawInGrid']]
                ])
                    ->update(["transactiondttmp_nbOfCarton" => $newQty]);
            }
        }
        if ($newTransactionDtTmp) {
            // fetch transactions dts after insert with their primary id in order to add new transaction serials
            $transactionDetailsTmp = transactiondttmp::join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
                ->leftjoin('client_suppliers', 'client_suppliers.supplier_id', '=', 'transactiondttmps.supplier_id')
                ->select(
                    'client_items.item_barcode',
                    'client_suppliers.supplier_name',
                    'transactiondttmps.item_quantity',
                    'transactiondttmps.supplier_invoice_number',
                    'transactiondttmps.item_id',
                    'transactiondttmps.supplier_id',
                    'transactiontmp_id',
                    'transactiondttmp_id',
                    'client_items.item_code',
                    'client_items.item_description',
                    'transactiondttmps.transactiontmpdt_billOfEntry',
                    'transactiondttmps.transactiondttmp_locationid',
                    'transactiondttmps.transactiondttmp_countryOfOrigin',
                    'client_items.item_hasSerial',
                    'hscode',
                    'transactiondttmps.transactiondttmp_price',
                    'transactiondttmps.id_reference_dt',
                    'transactiondttmps.raw_in_grid',
                )
                ->where([
                    ['transactiontmp_id', '=', $newTransactionDtTmp->transactiontmp_id]
                ])
                ->get();

            $getClientTransaction = transactiontmp::where([
                ['transactiontmps.transactiontmp_id', '=', $newTransactionDtTmp->transactiontmp_id]
            ])
                ->select('transactiontmps.transactiontmp_clientId')
                ->first();

            if ($getClientTransaction && $getClientTransaction->transactiontmp_clientId) {
                $getClientItems = clientItem::where([
                    ['item_related_client_id', '=', $getClientTransaction->transactiontmp_clientId]
                ])
                    ->get();

                $getClientSuppliers = clientSupplier::where([
                    ['client_suppliers.supplier_related_clientid', '=', $getClientTransaction->transactiontmp_clientId]
                ])
                    ->get();
            }

            $data = array();
            $data['transactionDt'] = $newTransactionDtTmp;
            $data['clientItems'] = $getClientTransaction ? $getClientItems : null;
            $data['clientSuppliers'] = $getClientTransaction ? $getClientSuppliers : null;
            $data['locations'] = location::get();
            $data['transactionTmp'] = $newTransactionDtTmp;
            $data['transactionDetailsTmp'] = $transactionDetailsTmp;

            foreach ($data['transactionDetailsTmp'] as $transactionDt) {
                $transactionDt->transactionDtSerials = $this->fetchTransactionDtSerialsTmp($transactionDt->transactiondttmp_id);
            }
            return ApiController::successResponse($data, 200);
        }
        return ApiController::errorResponse($newTransactionDtTmp, 422);
    }

    public function fetchTransactionDtSerialsTmp($transactionDtTmpId)
    {
        $transactionSerials = transactionDtSnTmp::where([
            ['transactiondttmp_id', $transactionDtTmpId],
        ])
            ->where(function ($query) {
                $query->where('status', '!=', 'Delete')
                    ->orWhereNull('status');
            })
            ->get();

        return $transactionSerials;
    }

    public function fetchTransactionDetailsTmpDO(Request $request)
    {
        if ($request->rawInGrid !== null) {
            $transactionDetailsTmp = transactiondttmp::join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
                ->join('items', 'items.item_code', 'client_items.item_code')
                ->join('transactiontmps', 'transactiontmps.transactiontmp_id', 'transactiondttmps.transactiontmp_id')
                ->leftjoin('client_suppliers', 'client_suppliers.supplier_id', '=', 'transactiondttmps.supplier_id')
                ->select(
                    'client_items.item_barcode',
                    'client_suppliers.supplier_name',
                    'transactiondttmps.item_quantity',
                    'transactiondttmps.supplier_invoice_number',
                    'transactiondttmps.item_id',
                    'transactiondttmps.supplier_id',
                    'transactiontmps.transactiontmp_id',
                    'transactiondttmps.group_id',
                    'transactiondttmps.palet_no',
                    'transactiondttmp_id',
                    'client_items.item_code',

                    'transactiondttmps.transactiontmpdt_billOfEntry',
                    'transactiondttmps.transactiondttmp_locationid',
                    'transactiondttmps.transactiondttmp_countryOfOrigin',
                    'transactiondttmps.transactiondttmp_price',
                    'transactiondttmps.id_reference_dt',
                    'transactiondttmps.raw_in_grid',
                    'transactiondttmps.item_weight',
                    'transactiondttmps.transactiondttmp_nbOfCarton',
                    'transactiondttmps.transactiondttmp_cellMerge',
                    'transactiondttmps.item_qtyPerPack',
                    'transactiondttmps.item_pack',
                    'items.item_hasSerial',
                    'isMobile',
                    'transactiondttmps.item_unit',
                    'client_id',
                    'transactiondttmp_fprice',
                    'hscode',
                    'transactiondt_item_description',
                    'item_quantity_to_delivery',
                    'item_quantity_to_cancel'
                )
                ->where([
                    ['transactiontmps.transactiontmp_id', '=', $request->transactionTmpId],
                    ['raw_in_grid', $request->rawInGrid],
                    ['transactiondttmps.client_id', $request->clientId],
                ])
                ->get();

            $data = array();
            $data['transactionDetailsTmp'] = $transactionDetailsTmp;
            return ApiController::successResponse($data, 204);
        } else {
            $transactionDetailsTmp = DB::table('transactiontmps')
                ->join('transactiondttmps', 'transactiondttmps.transactiontmp_id', '=', 'transactiontmps.transactiontmp_id')
                ->join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
                ->leftjoin('clients', 'clients.client_id', '=', 'transactiondttmps.client_id')
                ->select('items.item_hasSerial', 'item_quantity_to_delivery', 'item_quantity_to_cancel', 'clients.client_id', 'clients.client_firstname', 'transactiondttmps.raw_in_grid', 'transactiondttmps.transactiondttmp_price', 'transactiondttmps.group_id', 'transactiondttmps.palet_no', 'transactiondt_item_description as item_description', 'items.item_id', 'items.item_code', 'transactiondttmps.item_weight', 'transactiondttmps.item_qtyPerPack', 'transactiondttmps.item_pack', 'transactiondttmps.transactiondttmp_nbOfCarton', 'transactiondttmps.transactiondttmp_cellMerge', 'isMobile', 'transactiondttmps.item_unit', 'transactiondttmp_fprice', 'transactiondttmps.hscode', 'transactiondttmps.transactiondttmp_priceBase')
                ->selectRaw(' SUM(transactiondttmps.item_quantity) as item_quantity')
                ->selectRaw(' SUM(transactiondttmps.item_weight*transactiondttmps.item_quantity) as item_weight')
                ->groupBy('transactiondttmps.raw_in_grid', 'transactiondttmps.transactiondttmp_price', 'items.item_description', 'items.item_id', 'items.item_code', 'transactiondttmps.item_qtyPerPack', 'transactiondttmps.item_pack', 'isMobile')
                ->where([
                    ['transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId],
                ])
                ->get();
            return ApiController::successResponse($transactionDetailsTmp, 201);
        }
    }

    public function fetchDOItems(Request $request)
    {

        $user_id = JWTAuth::user()->id;


        return $this->fetchInventoryItems($request);
    }

    public function fetchInventoryItems(Request $request)
    {

        $user_id = JWTAuth::user()->id;
        $dateFromTimeStamp = $request->transactionTmpDate;

        $navigationEntry = 'GOODS_IN';
        $navigationOut = 'DO';

        if ($request->navigationType == 'RMA_OUT') {
            $navigationEntry = 'RMA_IN';
            $navigationOut = 'RMA_OUT';
        }


        $items = DB::table('client_items')
            ->join('items', 'items.item_code', 'client_items.item_code')
            ->select(
                'client_items.item_id',
                'items.item_hasSerial',
                'client_items.item_code',
                'client_items.item_description',
                'client_items.item_pack',
                'client_items.item_weight',
                'client_items.item_qtyPerPack',
                'client_items.item_unit',
                'client_items.group_id'
            )
            ->where('item_related_client_id', $request->client_id);

        if ($request->item_id) {
            $items->where('client_items.item_id', $request->item_id);
        }

        if ($request->client_id) {
            $items->where('client_items.item_related_client_id', $request->client_id);
        } else {
            $items->where('client_items.item_related_client_id', $user_id);
        }

        $items = $items->get();

        foreach ($items as $quantity) {
            $quantity->totalQuantity = '0';
            $quantity->totalQuantityUsed = '0';
            $GOODSIN = $this->getData($quantity->item_id, $navigationEntry, $quantity->item_code, $request->client_id, $dateFromTimeStamp);

            $quantity->GOODSIN = $GOODSIN;
            $totalQuantity = 0;
            $usedQuantity = 0;

            $quantity->totalQuantity = 0;
            $quantity->totalQuantityUsed = 0;
            $filterItems = array();
            foreach ($quantity->GOODSIN as $calculateTotal) {
                $totalQuantity = $totalQuantity + $calculateTotal->item_quantity;
                $itemsDetais2 = DB::table('transaction_dts')
                    ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
                    ->where([
                        ['transaction_dts.id_reference_dt', $calculateTotal->transactiondt_id],
                        ['transactions.transaction_date', '<=', $dateFromTimeStamp],
                        ['transaction_dts.dt_transaction_type', '!=', 'DQ'],

                    ]);

                if ($request->reference_id) {
                    $itemsDetais2->where('transactions.transaction_reference', '!=', $request->reference_id);
                }

                $itemsDetais2 = $itemsDetais2->get();
                $totalQuantityPerBill = 0;
                foreach ($itemsDetais2 as $calculateTotal2) {
                    $totalQuantityPerBill = $totalQuantityPerBill + $calculateTotal2->item_quantity;
                }
                $calculateTotal->totalUsedPerBill = $totalQuantityPerBill;
                $calculateTotal->totalAvailablePerBill = $calculateTotal->item_quantity - $totalQuantityPerBill;
                $calculateTotal->totalAvailablePerBill > 0 ? $calculateTotal->totalAvailablePerBill : 0;  // TODO @Ali please check this statement
                $usedQuantity = $usedQuantity + $totalQuantityPerBill;


                $checkTmpsQty = DB::table('transactiondttmps')
                    ->join('transactiontmps', 'transactiontmps.transactiontmp_id', '=', 'transactiondttmps.transactiontmp_id')
                    ->select('transactiondttmps.*', 'transactiontmps.*',)
                    ->selectRaw(' SUM(transactiondttmps.item_quantity) as item_quantity')
                    ->groupBy('transactiondttmps.transactiontmpdt_billOfEntry', 'transactiondttmps.item_id', 'transactiondttmps.transactiondttmp_countryOfOrigin')
                    ->where([
                        ['transactiondttmps.transactiontmpdt_billOfEntry', $calculateTotal->transaction_billOfEntry],
                        ['transactiondttmps.transactiondttmp_countryOfOrigin', $calculateTotal->transactiondt_countryOfOrigin],
                        ['raw_in_grid', $request->raw_in_grid],
                        ['item_id', $request->item_id],
                        ['transactiontmps.transactiontmp_type', $navigationOut],
                        ['transactiontmps.transactiontmp_id', $request->transactiontmpId],
                        ['transactiontmps.transactiontmp_date', '<=', $dateFromTimeStamp]
                    ])
                    ->first();

                $checkTmpsQtyAnotherRaw = DB::table('transactiondttmps')
                    ->join('transactiontmps', 'transactiontmps.transactiontmp_id', '=', 'transactiondttmps.transactiontmp_id')
                    ->select('transactiondttmps.*', 'transactiontmps.*',)
                    ->selectRaw(' SUM(transactiondttmps.item_quantity) as item_quantity')
                    ->groupBy('transactiondttmps.transactiontmpdt_billOfEntry', 'transactiondttmps.item_id', 'transactiondttmps.transactiondttmp_countryOfOrigin')
                    ->where([
                        ['transactiondttmps.transactiontmpdt_billOfEntry', $calculateTotal->transaction_billOfEntry],
                        ['transactiondttmps.transactiondttmp_countryOfOrigin', $calculateTotal->transactiondt_countryOfOrigin],
                        ['raw_in_grid', '!=', $request->raw_in_grid],
                        ['item_id', $request->item_id],
                        ['transactiontmps.transactiontmp_type', $navigationOut],
                        ['transactiontmps.transactiontmp_id', $request->transactiontmpId],
                        ['transactiontmps.transactiontmp_date', '<=', $dateFromTimeStamp]
                    ])
                    ->first();


                $checkQty = DB::table('transaction_dts')
                    ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
                    ->select('transaction_dts.*', 'transactions.*',)
                    ->selectRaw(' SUM(transaction_dts.item_quantity) as item_quantity')
                    ->groupBy('transaction_dts.transactiondt_billOfEntry', 'transaction_dts.item_id', 'transaction_dts.transactiondt_countryOfOrigin')
                    ->where([
                        ['transaction_dts.transactiondt_billOfEntry', $calculateTotal->transaction_billOfEntry],
                        ['transaction_dts.transactiondt_countryOfOrigin', $calculateTotal->transactiondt_countryOfOrigin],
                        ['transactions.transaction_type', $navigationOut],
                        ['item_id', $request->item_id],
                        ['transactions.transaction_id', $request->transactiontmpId],
                        ['transactions.transaction_date', '<=', $dateFromTimeStamp]

                    ])
                    ->first();


                $inRawQty = isset($checkTmpsQty->item_quantity) ? $checkTmpsQty->item_quantity : 0;
                $inAnotherRawQty = isset($checkTmpsQtyAnotherRaw->item_quantity) ? $checkTmpsQtyAnotherRaw->item_quantity : 0;
                $qtyTaken = isset($checkQty->item_quantity) ? $checkQty->item_quantity : 0;

                $calculateTotal->item_quantity_new = $inRawQty;
                $calculateTotal->totalAvailablePerBill = $calculateTotal->totalAvailablePerBill - $inAnotherRawQty + $qtyTaken;

                $calculateTotal->totalAvailablePerBill > 0 ? $calculateTotal->totalAvailablePerBill : 0; // TODO @Ali please check this statement

                if ($calculateTotal->totalAvailablePerBill <= 0) {
                    $calculateTotal->totalAvailablePerBill = 0;
                }

                if ($calculateTotal->totalAvailablePerBill > 0 || (int)$calculateTotal->item_quantity_new > 0) {
                    array_push($filterItems, $calculateTotal);
                }
            }
            $quantity->GOODSIN = $filterItems;
            $quantity->totalQuantity = $totalQuantity;
            $quantity->totalQuantityUsed = $usedQuantity;
            $quantity->totalQuantityAvailable = $totalQuantity + $usedQuantity;
        }
        return ApiController::successResponse($items, 200);
    }

    public function getData($itemId, $type, $code, $clientId, $dateFromTimeStamp)
    {
        $data = DB::table('transaction_dts')
            ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->select('transaction_dts.*', 'transactions.*', 'countries.*')
            ->selectRaw(' SUM(transaction_dts.item_quantity) as item_quantity')
            ->groupBy('transaction_dts.transactiondt_billOfEntry', 'transaction_dts.item_id', 'transaction_dts.transactiondt_countryOfOrigin');

        if ($type == 'GOODS_IN') {

            $data->join('items', 'items.item_id', '=', 'transaction_dts.item_id');
            $data->where([
                ['items.item_id', '=', $itemId],
                ['transactions.transaction_clientId', $clientId],
                ['transactions.transaction_date', '<=', $dateFromTimeStamp]
            ]);
        } else {
            $data->where([
                ['transaction_dts.item_id', $itemId],
                ['transactions.transaction_date', '<=', $dateFromTimeStamp]
            ]);
        }
        $data = $data->where('transactions.transaction_type', $type);
        $data = $data->orderBy('raw_in_grid');
        $data = $data->get();
        return $data;
    }

    //for popup dialog do
    public function insertTransactionDtSerialTmpDO(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;
        $validator = Validator::make($request->all(), [
            'transactionSerial' => 'required|array',
            'transactionDtTmp' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $invalidSerials = array();

        for ($i = 0; $i < count($request->transactionSerial); $i++) {

            $element = $request->transactionSerial[$i];
            $result = '';
            $result = implode(';', $element);

            $arrayOfSerials = explode(';', $result);


            $checkSerialExistanceGoodsIn = null;
            $checkSerialExistanceDo = null;
            $checkSerialExistanceTmpDo = null;
            $navigationEntry = 'GOODS_IN';
            $navigationOut = 'DO';
            if ($request->navigationType == 'RMA_OUT') {
                $navigationEntry = 'RMA_IN';
                $navigationOut = 'RMA_OUT';
            }
            if ($request->transactionDtTmp) {


                $serial = "";
                $getFullSerial = transactionDtSn::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                    ->where([
                        ['transactions.company_id', $loggerUserCompany],
                        ['transactions.transaction_type', $navigationEntry],
                        ['transaction_dtsns.item_id', $request->transactionDtTmp['item_id']],
                        ['transactions.transaction_clientId', $request->client_id],
                        ['transaction_dts.transactiondt_countryOfOrigin', $request->countryOfOrigin],
                        ['transaction_dts.transactiondt_billOfEntry', $request->billOfEntry],
                    ])
                    ->where(function ($query) use ($arrayOfSerials) {
                        foreach ($arrayOfSerials as $serial) {
                            $query->orWhereRaw("FIND_IN_SET('$serial', REPLACE(REPLACE(transaction_item_serial, ' ', ''), ';', ',')) > 0");
                        }
                    })
                    ->get();

                if (count($getFullSerial) == 0 || count($getFullSerial) > 1) {
                    array_push($invalidSerials, $element['SERIALNUMBER']);
                } else {
                    $serial = $getFullSerial[0]['transaction_item_serial'];

                    $transactionSerialArray = array(
                        'item_id' => $request->transactionDtTmp['item_id'],
                        'transaction_item_serial' => $serial,
                        'transactiondttmp_id' => $request->transactionDtTmp['transactiondttmp_id'],
                    );
                }


                $checkSerialExistanceGoodsIn = transactionDtSn::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                    ->where([
                        ['transaction_item_serial', '=', $serial],
                        ['transactions.company_id', $loggerUserCompany],
                        ['transactions.transaction_type', $navigationEntry],
                        ['transaction_dtsns.item_id', $request->transactionDtTmp['item_id']],
                        ['transactions.transaction_clientId', $request->client_id],
                    ])
                    ->get();

                $checkSerialExistanceDo = transactionDtSn::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transaction_dtsns.transactiondt_id')
                    ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                    ->where([
                        ['transaction_item_serial', '=', $serial],
                        ['transactions.company_id', $loggerUserCompany],
                        ['transactions.transaction_type', $navigationOut],
                        ['transaction_dts.transactiondt_id', '!=', $request->transactionDtTmp]
                    ])
                    ->get();

                $checkSerialExistanceTmpDo = transactionDtSnTmp::join('transactiondttmps', 'transactiondttmps.transactiondttmp_id', 'transaction_dt_sn_tmps.transactiondttmp_id')
                    ->join('transactiontmps', 'transactiontmps.transactiontmp_id', 'transactiondttmps.transactiontmp_id')
                    ->where([
                        ['transaction_item_serial', '=', $serial],
                        ['transactiontmps.company_id', $loggerUserCompany],
                        ['transactiontmps.transactiontmp_type', $navigationOut],

                    ])
                    ->where(function ($query) {
                        $query->where('status', '!=', 'Delete')
                            ->orWhereNull('status');
                    })
                    ->first();
            }


            //return $checkSerialExistance;


            $count = count($checkSerialExistanceGoodsIn) - count($checkSerialExistanceDo);

            if ($count > 0 && $checkSerialExistanceTmpDo == null) {

                transactionDtSnTmp::create($transactionSerialArray);
            } else {
                array_push($invalidSerials, $serial);
            }
        }
        $request['transactiondttmpId'] = $request->transactionDtTmp['transactiondttmp_id'];
        $transactionDtSerials = $this->fetchTransactionDtSerialsTmpDO($request)->getData();
        $transactionDtSerials->data->error = $invalidSerials;


        return ApiController::successResponse($transactionDtSerials, 200);
    }

    public function fetchTransactionDtSerialsTmpDO(Request $request)
    {
        $transactionSerials = DB::table('transaction_dt_sn_tmps')
            ->leftjoin('transactiondttmps', 'transactiondttmps.transactiondttmp_id', 'transaction_dt_sn_tmps.transactiondttmp_id')
            ->select(
                'transaction_dt_sn_tmps.transactiondtsntmp_id',
                'transaction_dt_sn_tmps.transaction_item_serial',
                'transaction_dt_sn_tmps.transactiondttmp_id',
                'transactiondttmps.item_id',
                'transactiondttmps.transactiondttmp_id'
            )
            ->where([
                ['transactiondttmps.transactiondttmp_id', $request->transactiondttmpId],
            ])
            ->where(function ($query) {
                $query->where('status', '!=', 'Delete')
                    ->orWhereNull('status');
            })
            ->get();

        $serialsHeadear = Db::table('transactiondttmps')
            ->leftjoin('items', 'items.item_id', 'transactiondttmps.item_id')
            ->leftjoin('serial_types', 'serial_types.serial_id', 'items.serial_type_id')
            ->where([
                ['transactiondttmps.transactiondttmp_id', $request->transactiondttmpId],
            ])
            ->select('serial_types.serial_label')
            ->pluck('serial_types.serial_label');

        foreach ($transactionSerials as $serial) {
            $splitSerials = explode(';', $serial->transaction_item_serial);
            for ($i = 0; $i < count($serialsHeadear); $i++) {
                $header = $serialsHeadear[$i];
                $serial->{$header} = isset($splitSerials[$i]) ? $splitSerials[$i] : "-";
            }
        }

        $data["header"] = $serialsHeadear;
        $data["transactionSerials"] = $transactionSerials;
        return ApiController::successResponse($data, 200);
    }

    public function deleteAllSerialsTmp(Request $request)
    {

        $deleteAllSerials = transactionDtSnTmp::where('transactiondttmp_id', $request->transactiondttmp_id)->update(
            [
                'status' => 'Delete'
            ]
        );

        return ApiController::successResponse($deleteAllSerials, 200);
    }

    public function fetchItemsByClient2(Request $request)
    {

        $UtilitiesController = new UtilitiesController();
        $servicesController = new UtilitiesController();
        $transactiontmp_id = $request->transactiontmp_id;
        $clientId = $request->client_id;
        $navigationType = $request->navigationType;
        $dateFromTimeStamp = $request->transactionFromDate;
        $dateFromTimeStamp = date('Y-m-d', $dateFromTimeStamp);

        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeEOUT = 'DO';
        if ($navigationType == 'RMA_OUT') {
            $navigationTypeEntry = 'RMA_IN';
            $navigationTypeEOUT = 'RMA_OUT';
        }
        $data = DB::table('items')
            ->where([
                ['transaction_dts.client_id', $clientId],
            ])
            ->whereRaw('DATE(FROM_UNIXTIME(transactions.transaction_date)) <= ?', [$dateFromTimeStamp])

            ->leftjoin('transaction_dts', 'transaction_dts.item_id', 'items.item_id')
            ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->select(
                'transaction_dts.client_id as item_related_client_id',
                'item_hasSerial',
                'item_description',
                'items.item_id',
                'transaction_dts.item_hscode',
                'item_code',
                'transaction_dts.item_weight',
                'item_quantity',
                'transaction_dts.transactiondt_price',
                'transaction_dts.transactiondt_billOfEntry',
                'country_name',
                'transactiondt_countryOfOrigin',
                'transaction_dts.transactiondt_id',
                'transaction_dts.id_reference_dt',
                'transaction_dts.hscode',
                'transaction_dts.supplier_id as transaction_supplierInvoice',
                'items.item_unit',
                'dt_transaction_type',
                'transactiondt_item_description'
            )
            ->groupBy('transactiondt_id')
            ->selectRaw("SUM(
                            CASE WHEN (transaction_type = '" . $navigationTypeEntry . "')
                            THEN  (transaction_dts.item_quantity)
                            ELSE (
                                CASE WHEN (transaction_type = '" . $navigationTypeEOUT . "' and transaction_dts.transaction_id != '" . $transactiontmp_id . "')
                                THEN  (-transaction_dts.item_quantity)
                                ELSE (0) END
                                ) END
                            )
                            AS qtyExist
                        ") /// if goods_in return qty if DO return -qty

            ->selectRaw("
                        if( transaction_type = '" . $navigationTypeEntry . "',transactiondt_id,id_reference_dt) as id_group_by
                        ");


        if ($request->billOfEntry) {
            $data->where('transactiondt_billOfEntry', $request->billOfEntry);
        }
        if ($request->transactionSupplier) {
            $data->where('transaction_supplierInvoice', $request->transactionSupplier);
        }
        if ($request->itemSearch) {
            $data->Where(function ($query) use ($request) {
                $query->Where([
                    ['items.item_code', 'like', '%' . $request->itemSearch . '%']
                ])
                    ->orWhere([
                        ['transaction_dts.item_hscode', 'like', '%' . $request->itemSearch . '%']
                    ]);
            });
        }
        $data = $data->get();

        $groupedItems = collect($data)
            ->groupBy('id_group_by',)
            ->map(function ($group) {
                $id_group_by = $group->pluck('id_group_by')->unique()->first();
                $transactiondt_billOfEntry = $group->pluck('transactiondt_billOfEntry')->unique()->first();
                $id_reference_dt = $group->pluck('id_reference_dt')->unique()->first();
                $qtyExist = $group->sum('qtyExist');
                $item_id = $group->pluck('item_id')->unique()->first();
                $item_code = $group->pluck('item_code')->unique()->first();
                $transaction_supplierInvoice = $group->pluck('transaction_supplierInvoice')->unique()->first();
                $transactiondt_countryOfOrigin = $group->pluck('transactiondt_countryOfOrigin')->unique()->first();
                $transactiondt_item_description = $group->pluck('transactiondt_item_description')->unique()->first();
                $hscode = $group->pluck('hscode')->unique()->first();
                $item_related_client_id = $group->pluck('item_related_client_id')->unique()->first();

                return [
                    'transactiondt_id' => $id_group_by,
                    'qtyExist' => $qtyExist,
                    'item_id' => $item_id,
                    'transactiondt_billOfEntry' => $transactiondt_billOfEntry,
                    'item_code' => $item_code,
                    'transaction_supplierInvoice' => $transaction_supplierInvoice,
                    'id_reference_dt' => $id_reference_dt,
                    'transactiondt_countryOfOrigin' => $transactiondt_countryOfOrigin,
                    'item_description' => $transactiondt_item_description,
                    'hscode' => $hscode,
                    'item_related_client_id' => $item_related_client_id


                ];
            })
            ->values();

        foreach ($groupedItems as $checkTmp) {
            $tmpQty = DB::table('transactiondttmps')
                ->where([
                    ['item_id', $checkTmp['item_id']],
                    ['transactiontmpdt_billOfEntry', $checkTmp['transactiondt_billOfEntry']],
                    ['transactiondttmp_countryOfOrigin', $checkTmp['transactiondt_countryOfOrigin']],
                    ['transactiontmp_id', '=', $transactiontmp_id]
                ])
                ->selectRaw('SUM(item_quantity) as qty')
                ->groupBy('item_id', 'transactiontmpdt_billOfEntry', 'transactiondttmp_countryOfOrigin')
                ->first();

            if ($tmpQty) {

                $checkTmp['qtyExist'] = $checkTmp['qtyExist'] - $tmpQty->qty;
            }
        }
        $filterData = array();
        foreach ($groupedItems as $splitdata) {



            if ($splitdata['qtyExist'] > 0) {

                array_push(
                    $filterData,
                    $splitdata
                );
            }
        }


        return ApiController::successResponse($filterData, 200);
    }
    // public function fetchItemsByClient(Request $request)
    // {
    //     $UtilitiesController = new UtilitiesController();
    //     $transactiontmp_id = $request->transactiontmp_id;
    //     $clientId = $request->client_id;
    //     $navigationType = $request->navigationType;
    //     $dateFromTimeStamp = $request->transactionFromDate;

    //     $navigationTypeEntry = 'GOODS_IN';
    //     $navigationTypeEOUT = 'DO';
    //     if ($navigationType == 'RMA_OUT') {
    //         $navigationTypeEntry = 'RMA_IN';
    //         $navigationTypeEOUT = 'RMA_OUT';
    //     }

    //     $map = array();
    //     $subItems = array();


    //     $clients = DB::table('clients')
    //         // ->leftjoin('client_items', 'client_items.item_related_client_id', '=', 'clients.client_id')
    //         ->select(
    //             'client_id',
    //             'client_firstname'
    //         )
    //         ->orderBy('client_id')
    //         ->get();

    //     foreach ($clients as $splitClients) {
    //         $subItems['clientName'] = $splitClients->client_firstname;
    //         $data = DB::table('client_items')
    //             ->where([
    //                 ['client_items.item_related_client_id', $splitClients->client_id],
    //                 //   ['transaction_date', '<=', $dateFromTimeStamp],
    //                 ['transaction_dts.client_id', $splitClients->client_id],
    //             ])
    //             ->leftjoin('transaction_dts', 'transaction_dts.item_id', 'client_items.item_id')
    //             ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
    //             ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
    //             ->orderBy('client_items.item_related_client_id')
    //             ->select(
    //                 'client_items.item_related_client_id',
    //                 'item_hasSerial',
    //                 'client_items.item_unit',
    //                 'item_description',
    //                 'client_items.item_id',
    //                 'transaction_dts.item_hscode',
    //                 'item_code',
    //                 'transaction_dts.item_weight',
    //                 'item_quantity',
    //                 'transaction_dts.transactiondt_price',
    //                 'transaction_dts.transactiondt_billOfEntry',
    //                 'country_name',
    //                 'transactiondt_countryOfOrigin',
    //                 'transaction_dts.transactiondt_id',
    //                 'transaction_dts.hscode',
    //                 'transaction_supplierInvoice',
    //                 'client_items.item_qtyPerPack',
    //                 'client_items.item_pack',
    //                 'client_items.group_id'

    //             )
    //             ->selectRaw("SUM(
    //                         CASE WHEN (transaction_type = '" . $navigationTypeEntry . "')
    //                         THEN  (transaction_dts.item_quantity)
    //                         ELSE (
    //                             CASE WHEN (transaction_type = '" . $navigationTypeEOUT . "' and transaction_dts.transaction_id != '" . $transactiontmp_id . "')
    //                             THEN  (-transaction_dts.item_quantity)
    //                             ELSE (0) END
    //                             ) END
    //                         )
    //                         AS qtyExist
    //                     ")
    //             ->groupBy('client_items.item_related_client_id', 'client_items.item_id',)
    //             ->get();

    //         $existQty = array();
    //         foreach ($data as $splitData) {
    //             if ($splitData->qtyExist > 0) {
    //                 array_push($existQty, $splitData);
    //             } else {
    //             }
    //             $splitClients->items = $existQty;
    //         }
    //         $subItems['items'] = $existQty;
    //         $map[$splitClients->client_id] = $subItems;
    //     }


    //     return ApiController::successResponse($map, 200);
    // }
    public function fetchItemsByClient(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $transactiontmp_id = $request->transactiontmp_id;
        $clientId = $request->client_id;
        $navigationType = $request->navigationType;
        $dateFromTimeStamp = $request->transactionFromDate;

        $navigationTypeEntry = 'GOODS_IN';
        $navigationTypeEOUT = 'DO';
        if ($navigationType == 'RMA_OUT') {
            $navigationTypeEntry = 'RMA_IN';
            $navigationTypeEOUT = 'RMA_OUT';
        }

        $map = array();
        $subItems = array();


        $clients = DB::table('clients')
            // ->leftjoin('client_items', 'client_items.item_related_client_id', '=', 'clients.client_id')
            ->select(
                'client_id',
                'client_firstname'
            )
            ->orderBy('client_id')
            ->get();
        $clients = DB::table('clients')
            // ->leftjoin('client_items', 'client_items.item_related_client_id', '=', 'clients.client_id')
            ->select(
                'client_id',
                'client_firstname'
            )
            ->orderBy('client_id')
            ->get();

        foreach ($clients as $splitClients) {
            $subItems['clientName'] = $splitClients->client_firstname;
            $data = DB::table('client_items')
                ->where([
                    ['client_items.item_related_client_id', $splitClients->client_id],
                    //   ['transaction_date', '<=', $dateFromTimeStamp],
                    ['transaction_dts.client_id', $splitClients->client_id],
                ])
                ->leftjoin('transaction_dts', 'transaction_dts.item_id', 'client_items.item_id')
                ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->orderBy('client_items.item_related_client_id')
                ->select(
                    'client_items.item_related_client_id',
                    'item_hasSerial',
                    'client_items.item_unit',
                    'item_description',
                    'client_items.item_id',
                    'transaction_dts.item_hscode',
                    'item_code',
                    'transaction_dts.item_weight',
                    'item_quantity',
                    'transaction_dts.transactiondt_price',
                    'transaction_dts.transactiondt_billOfEntry',
                    'country_name',
                    'transactiondt_countryOfOrigin',
                    'transaction_dts.transactiondt_id',
                    'transaction_dts.hscode',
                    'transaction_supplierInvoice',
                    'client_items.item_qtyPerPack',
                    'client_items.item_pack',
                    'client_items.group_id'

                )
                ->selectRaw("SUM(
                            CASE WHEN (transaction_type = '" . $navigationTypeEntry . "')
                            THEN  (transaction_dts.item_quantity)
                            ELSE (
                                CASE WHEN (transaction_type = '" . $navigationTypeEOUT . "' and transaction_dts.transaction_id != '" . $transactiontmp_id . "')
                                THEN  (-transaction_dts.item_quantity)
                                ELSE (0) END
                                ) END
                            )
                            AS qtyExist
                        ")
                ->groupBy('client_items.item_related_client_id', 'client_items.item_id',)
                ->get();

            $existQty = array();
            foreach ($data as $splitData) {
                if ($splitData->qtyExist > 0) {
                    array_push($existQty, $splitData);
                } else {
                }
                $splitClients->items = $existQty;
            }
            $subItems['items'] = $existQty;
            $map[$splitClients->client_id] = $subItems;
        }


        return ApiController::successResponse($map, 200);
    }
    public function arrivedDO(Request $request)
    {
        $checked = 0;
        $message = "";
        $released = $request->released;
        if ($released == 0) {
            return ApiController::successResponse("releaseTransactionBefore", 200);
        }
        if ($request->checked) {
            $checked = 1;
            $message = "ArrivedSuccess";
        } else {
            $message = "ArrivedFailed";
        }
        $transaction = array(
            'transaction_arrived' => $checked,
        );
        $updateTransaction = transactions::where('transaction_id', '=', $request->transactionId)
            ->update($transaction);
        $notificationController = new NotificationsController();
        $reference=transactions::where('transaction_id' , $request->transactionId)->first()->transaction_reference;

        $notificationController->sendNotificationsByTopic(auth()->user()->id, NotificationTopics::DO_ARRIVED, $request->transactionId,$reference);

        return ApiController::successResponse($message, 200);
    }

    public function releaseDO(Request $request)
    {
        $status = 'Released';
        $transactions = transactiontmp::where([
            ['transactiontmp_id', $request->transactionId]
        ])
            ->first();


        if ($transactions) {
            return ApiController::successResponse("existInDrafts", 200);
        }


        if ($request->DECCode) {
            $transaction = array(
                'transaction_released_DEC' => $request->DECCode,
            );
            $updateTransaction = transactions::where('transaction_id', '=', $request->transactionId)
                ->update($transaction);
            $data = $this->insertTransactionStatusFunction($request->transactionId, null, 'Delivery Transaction Released', 'deliveryStatusReleased', 0);




            return ApiController::successResponse("releasedSuccessfully", 200);
        }


        if ($request->checked) {
            $userId = auth()->user()->id;

            $utilitiesController = new utilitiesController();
            $date = $utilitiesController->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
            $transaction = array(
                'transaction_released' => 1,
                'transaction_releasedUser' => $userId,
                'transaction_releasedDate' => $date
            );

            $updateTransaction = transactions::where('transaction_id', '=', $request->transactionId)
                ->update($transaction);
            $data = $this->insertTransactionStatusFunction($request->transactionId, null, 'Delivery Transaction Released', 'deliveryStatusReleased', 0);


            $UtilitiesController = new UtilitiesController();

            $checkNotif = DB::table('notifications')
                ->where([
                    ['notification_code', 'DO_RELEASED'],
                    ['trans_id', $request->transactionId]
                ])->first();

            if (!$checkNotif) {
                $notificationController = new NotificationsController();
                $reference=transactions::where('transaction_id' , $request->transactionId)->first()->transaction_reference;
                $notificationController->sendNotificationsByTopic(auth()->user()->id, NotificationTopics::DO_RELEASED, $request->transactionId,$reference);



                $clients = transactions::leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
                    ->leftjoin('clients', 'clients.client_id', 'transaction_dts.client_id')
                    ->leftjoin('users', 'users.id', 'clients.user_id')
                    ->where('transaction_dts.transaction_id', '=', $request->transactionId)
                    ->select('transaction_dts.client_id', 'user_pushToken')
                    ->get();
                foreach ($clients as $splitClients) {
                    $clientId = $splitClients->client_id;
                    $notificationToken =  $splitClients->client_id;

                    $notificationArray = array(
                        'title' => 'DO_RELEASED',
                        'message' => 'DO_RELEASED',
                        'seen' => 0,
                        'related_userid' => $clientId,
                        'trans_id' => $request->transactionId,
                        'key' => $request->transactionId,
                        'code' => 'DO_RELEASED',
                        'notificationToken' => $notificationToken,
                        'transType' => "Released DO"
                    );
                    $UtilitiesController->sendNotification($notificationArray);
                }
            }

            return ApiController::successResponse("releasedSuccessfully", 200);
        }

        if (!$request->checked) {
            $transaction = array(
                'transaction_released' => 0,
                'transaction_releasedUser' => null,
                'transaction_releasedDate' => null,
                'transaction_arrived' => 0,

            );
            $updateTransaction = transactions::where('transaction_id', '=', $request->transactionId)
                ->update($transaction);
            $data = $this->insertTransactionStatusFunction($request->transactionId, null, 'Delivery Transaction UnRelease', 'Delivery_Status_UnReleased', 1);

            return ApiController::successResponse("unreleaseSuccessfully", 200);
        }


        return ApiController::successResponse("releasedSuccessfully", 200);
    }

    public function getDateValidity(Request $request)
    {
        $transactiontmpId = $request->transactiontmpId;
        $checkInvalidData = DB::table('transactiondttmps')
            ->leftjoin('transaction_dts as transactiondtsDo', 'transactiondtsDo.transactiondt_id', 'transactiondttmps.id_reference_dt')
            ->join('transactions', 'transactions.transaction_id', 'transactiondtsDo.transaction_id')
            ->where([
                ['transactiondtsDo.id_reference_dt', '=', null],
                ['transactiondttmps.dt_transaction_type', 'DO'],
                ['transactiondttmps.transactiontmp_id', $transactiontmpId],
            ])
            ->whereRaw('DATE(FROM_UNIXTIME(transactions.transaction_date)) > ?', [$request->transactionDate])

            ->get();

        if (count($checkInvalidData) > 0) {
            $checkInvalidMessage = 'Transactions with bill of Entry(';
            $bills = '';
            foreach ($checkInvalidData as $splitResponse) {
                $bills = $bills . ' *' . $splitResponse->transactiontmpdt_billOfEntry . '* ';
            }
            $checkInvalidMessage = $checkInvalidMessage . $bills . ') exceed Qty, Are you sure you want to continue';

            return ApiController::successResponse($checkInvalidMessage, 200);
        }
        return ApiController::successResponse([], 200);
    }

    public function dtItemDetails(Request $request)
    {


        $rawInGrid = $request->rawInGrid;
        $transactiontmpId = $request->transactiontmpId;
        $price = $request->price;
        $qtyPerPack = $request->qtyPerPack;

        $Obj = array();

        $qtyIn = transactiondttmp::join(
            'transactiontmps',
            'transactiontmps.transactiontmp_id',
            'transactiondttmps.transactiontmp_id'
        )
            ->where([
                ['transactiontmps.transactiontmp_id', $transactiontmpId],
                ['raw_in_grid', $rawInGrid]
            ])
            ->selectRaw(' SUM(item_quantity)  as item_quantity')
            ->selectRaw(' MAX(transactiondttmp_price)  as maxPrice')
            // ->groupBy('transactiondt_countryOfOrigin','transactiondt_billOfEntry','item_id')
            ->first();


        $desc = transactiondttmp::join(
            'transactiontmps',
            'transactiontmps.transactiontmp_id',
            'transactiondttmps.transactiontmp_id'
        )
            ->where([
                ['transactiontmps.transactiontmp_id', $transactiontmpId],
                ['raw_in_grid', $rawInGrid],
                ['transactiondt_item_description', '!=', null],
                ['item_quantity', '!=', 0]

            ])
            ->select('transactiondt_item_description')
            ->groupBy('transactiondt_item_description')
            ->first();


        $weight = transactiondttmp::select('item_id', 'group_id', 'transactiondt_item_description')
            ->selectRaw(' SUM(transactiondttmps.item_weight*transactiondttmps.item_quantity) as totalWeight')
            ->where([
                ['transactiondttmps.transactiontmp_id', $transactiontmpId],
                ['raw_in_grid', $rawInGrid]

            ])
            // ->groupBy('transactiondt_countryOfOrigin','transactiondt_billOfEntry','item_id')
            ->first();

        $Obj['qty'] = isset($qtyIn->item_quantity) ? $qtyIn->item_quantity : 0;
        $Obj['totalPrice'] = $Obj['qty'] * $price;
        $nbC = 0;
        if ($qtyPerPack > 0) {
            $nbC = ($Obj['qty'] / $qtyPerPack);
        }
        $commonServices = new CommonServices();
        $loadPrice = $commonServices->checkLoadedPriceModule();
        $maxPrice = 0;
        if ($loadPrice == 1) {
            $maxPrice = $commonServices->getMaxPrice($transactiontmpId, $rawInGrid);
        }



        $Obj['cartoons'] = ceil($nbC);
        $Obj['maxPrice'] = $maxPrice;
        $Obj['weight'] = $weight->totalWeight;
        $Obj['item_code'] = $weight->item_id;
        $Obj['item_description'] = isset($desc->transactiondt_item_description) ? $desc->transactiondt_item_description : null;

        $itemDetails = items::where([
            ['item_id', '=', $weight->item_id]
        ])->first();

        $Obj['group_id'] = isset($itemDetails->group_id) ? $itemDetails->group_id : 0;
        $Obj['item_unit'] = isset($itemDetails->item_unit) ? $itemDetails->item_unit : 0;


        return ApiController::successResponse($Obj, 200);
    }

    public function checkMaxDoPrice(Request $request)
    {

        $price = $request->priceBase;
        $rate = $request->rate;
        $item = $request->item_id;
        $maxPrice = transactiondttmp::join('transaction_dts', 'transaction_dts.transactiondt_id', 'transactiondttmps.id_reference_dt')
            ->join('items', 'items.item_id', 'transactiondttmps.item_id')
            ->where([
                ['transactiondttmps.raw_in_grid', $request->rawInGrid],
                ['transactiondttmps.transactiontmp_id', $request->transactiontmpId],
                ['items.item_unDependentPrice', '!=', 1],

                ['transactiondttmps.item_quantity', '>', 0],
            ])
            ->max('transaction_dts.transactiondt_priceBase');

        if ($price >= $maxPrice) {
            return ApiController::successResponse($maxPrice, 200);
        }
        return ApiController::errorResponse('Delivery Price less than GoodsIn Price', 422);
    }

    public function saveMultiItemsDO(Request $request)
    {
        $data = $request->selectedData;
        $transaction = $request->transactiontmp;
        $transactiontmp_id = $transaction['transactiontmp_id'];
        $rawInGrid = $request->rawInGrid;
        $itemsArray = $request->itemsArray;
        // transactiondttmp::where('transactiontmp_id', $transactiontmp_id)->delete();
        foreach ($itemsArray as $splitItems) {
            foreach ($data as $splitData) {
                if ($splitData['item_id'] != $splitItems) continue;

                $item = items::where('item_id', $splitData['item_id'])->first();
                $referenceId = isset($splitData['transactiondt_id']) ? $splitData['transactiondt_id'] : null;

                $goodsInRef = transactiondt::where([
                    ['transactiondt_id', $referenceId]
                ])->first();



                $referenceDesc = isset($goodsInRef->transactiondt_item_description) ? $goodsInRef->transactiondt_item_description : null;
                $referencePrice = isset($goodsInRef->transactiondt_price) ? $goodsInRef->transactiondt_price : null;
                $referencePriceBase = isset($goodsInRef->transactiondt_priceBase) ? $goodsInRef->transactiondt_priceBase : null;
                $referenceSupplierId = isset($goodsInRef->supplier_id) ? $goodsInRef->supplier_id : null;
                $referenceSupplierInvoice = isset($goodsInRef->supplier_invoice_number) ? $goodsInRef->supplier_invoice_number : null;
                $referencePriceBase = isset($goodsInRef->transactiondt_priceBase) ? $goodsInRef->transactiondt_priceBase : null;
                $referenceFPrice = isset($goodsInRef->transactiondttmp_fprice) ? $goodsInRef->transactiondttmp_fprice : null;
                $referenceFPriceBase = isset($goodsInRef->transactiondttmp_fpriceBase) ? $goodsInRef->transactiondttmp_fpriceBase : null;
                $referenceBillOfEntry = isset($goodsInRef->transactiondt_billOfEntry) ? $goodsInRef->transactiondt_billOfEntry : null;
                $referenceCOO = isset($goodsInRef->transactiondt_countryOfOrigin) ? $goodsInRef->transactiondt_countryOfOrigin : null;
                $referenceWeight = isset($goodsInRef->item_weight) ? $goodsInRef->item_weight : null;


                $transactionDtTmp = array(
                    'transactiontmp_id' => $transactiontmp_id,
                    'item_id' => $splitData['item_id'],
                    'group_id' => $item->group_id,
                    'client_id' => $splitData['item_related_client_id'],
                    'item_quantity' => $splitData['qtyExist'],
                    'transactiontmpdt_billOfEntry' => $referenceBillOfEntry,
                    'transactiondt_item_description' => $referenceDesc,
                    'supplier_id' => $referenceSupplierId,
                    'supplier_invoice_number' => $referenceSupplierInvoice,
                    'transactiondttmp_countryOfOrigin' => $referenceCOO,
                    'transactiondttmp_price' => $referencePrice,
                    'id_reference_dt' => $referenceId,
                    'raw_in_grid' => $rawInGrid,
                    'item_weight' => $referenceWeight,
                    'item_unit' => $item->item_unit,
                    'item_qtyPerPack' => $item->item_qtyPerPack,
                    'item_pack' => $item->item_pack,
                    'transactiondttmp_nbOfCarton' => $item->item_qtyPerPack > 0 ? $splitData['qtyExist'] / $item->item_qtyPerPack : 0,
                    'transactiondttmp_cellMerge' => $rawInGrid + 1,
                    'transactiondttmp_fprice' => $referenceFPrice,
                    'transactiondttmp_priceBase' => $referencePriceBase,
                    'transactiondttmp_fpriceBase' => $referenceFPriceBase,
                    'hscode' => $splitData['hscode'],
                    'dt_transaction_type' => 'DO'
                );
                $newTransactionDtTmp = transactiondttmp::create($transactionDtTmp);
                $payload['transactionType'] = $request->transactionType;
                $payload['transactionTmpId'] = $transactiontmp_id;
                $payload['transactionDtTmp'] = $transactionDtTmp;
                $payload['idReference'] = $newTransactionDtTmp->transactiondttmp_id;

                transactiondttmp::createTransactionInternaldt($payload);


                $serial = TransactionDtsn::where('transaction_dtsns.transactiondt_id', $splitData['transactiondt_id'])
                    ->leftjoin("transaction_dtsns as testSerials", "testSerials.transaction_item_serial", "transaction_dtsns.transaction_item_serial")
                    ->select('testSerials.transaction_item_serial')
                    ->selectRaw("COUNT('testSerials.transaction_item_serial') AS SERIAL_COUNT")
                    ->groupBy('testSerials.transaction_item_serial')
                    ->havingRaw('COUNT(testSerials.transaction_item_serial) = 1')
                    ->get();
                foreach ($serial as $serialData) {
                    $transactionSerialTmpArray = array(
                        'transactiondttmp_id' => $newTransactionDtTmp->transactiondttmp_id,
                        'transactiondtsntmp_id' => $serialData->transactiondtsn_id,
                        'item_id' => $splitData['item_id'],
                        'transaction_item_serial' => $serialData->transaction_item_serial
                    );
                    $newTransactionDtsn = transactionDtSnTmp::create($transactionSerialTmpArray);
                }
            }
            $rawInGrid = $rawInGrid + 1;
        }


        return ApiController::successResponse('success', 200);
    }

    public function fetchDOItemsQty(Request $request)
    {

        $transactionId = $request->transactiontmpId;
        $rawGrid = $request->raw_in_grid;
        $date = date("Y-m-d", $request->transactionTmpDate);
        $navigationEntry = 'GOODS_IN';
        $navigationOut = 'DO';

        if ($request->navigationType == 'RMA_OUT') {
            $navigationEntry = 'RMA_IN';
            $navigationOut = 'RMA_OUT';
        }


        $transactions = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('currency', 'currency.currency_id', 'transactions.transaction_currencyId')
            ->select(
                'transaction_dts.item_weight',
                'transactiondt_billOfEntry',
                'total_gross_weight',
                'transactiondt_countryOfOrigin',
                'item_id',
                'countries.country_name',
                'id_reference_dt',
                'transactiondt_id',
                'transactions.transaction_id',
                'transactions.internal_transfer',

                'transactiondt_BOE',
                'transaction_dts.hscode',
                'currency_code',
                'transaction_dts.transactiondt_price',
                'transaction_dts.transactiondt_priceBase',
                'transactions.transaction_supplierInvoice',
                'transaction_dts.transactiondt_item_description',
                'transaction_dts.transactiondt_id',
                'transaction_dts.item_quantity',
                'transaction_dts.supplier_id',
                'transaction_date',
                'transaction_reference',
                'transaction_dts.total_gross_weight',
                'transaction_dts.gross_weight',

            )
            ->where([
                ['transaction_dts.client_id', $request->client_id],
                ['item_id', $request->item_id],
                ['transaction_type', $navigationEntry],
            ])
            ->whereRaw('DATE(FROM_UNIXTIME(transactions.transaction_date)) <= ?', [$date])

            ->get();



        $availableItems = array();
        foreach ($transactions as $splitTrtansaction) {
            $weight = DB::table('transactiondttmps')
                ->where([
                    ['item_id', $splitTrtansaction->item_id],
                    ['id_reference_dt', $splitTrtansaction->transactiondt_id],
                    ['transactiontmp_id', $transactionId],
                    ['raw_in_grid', $rawGrid],
                ])->first();


            $qtyIn = DB::table('transactions')
                ->join('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
                ->selectRaw('(select SUM(item_quantity) from transaction_dts,transactions
                                where item_id= "' . $splitTrtansaction->item_id . '"  and  transactions.transaction_id = transaction_dts.transaction_id and
                                 transaction_type = "' . $navigationOut . '" and DATE(FROM_UNIXTIME(transaction_date)) <=  "' . $date . '" and
                                 transactions.transaction_id !="' . $transactionId . '"
                                 and id_reference_dt ="' . $splitTrtansaction->transactiondt_id . '"

                                  ) as item_quantity_Total_DO')
                ->selectRaw('(select SUM(item_quantity) from transaction_dts,transactions
                                   where item_id= "' . $splitTrtansaction->item_id . '"  and  transactions.transaction_id = transaction_dts.transaction_id and
                                    transaction_type = "' . $navigationOut . '" and DATE(FROM_UNIXTIME(transaction_date)) <=  "' . $date . '" and
                                     transactions.transaction_id ="' . $transactionId . '" and
                                    raw_in_grid="' . $rawGrid . '"
                                   and id_reference_dt ="' . $splitTrtansaction->transactiondt_id . '"
                                      group by item_id) as item_quantity_Total_DO_selected')
                ->first();



            $qtyInTmp = DB::table('transactiontmps')
                ->join('transactiondttmps', 'transactiondttmps.transactiontmp_id', 'transactiontmps.transactiontmp_id')
                ->select('transactiondttmp_id')
                ->selectRaw('(select SUM(item_quantity) from transactiondttmps,transactiontmps
                                   where item_id= "' . $splitTrtansaction->item_id . '"  and  transactiontmps.transactiontmp_id = transactiondttmps.transactiontmp_id and
                                    transactiontmp_type = "' . $navigationOut . '" and DATE(FROM_UNIXTIME(transactiontmp_date)) <=  "' . $date . '" and  transactiontmps.transactiontmp_id ="' . $transactionId . '" and
                                    raw_in_grid="' . $rawGrid . '"
                                    and id_reference_dt ="' . $splitTrtansaction->transactiondt_id . '"

                                      group by item_id) as item_quantity_Total_tmpDO_selectedInRaw')
                ->where([
                    ['item_id', $splitTrtansaction->item_id],
                    ['transactiontmp_type', $navigationOut],
                   // ['transactiontmp_date', '<=', $dateFromTimeStamp],
        
                    ['transactiontmps.transactiontmp_id', $transactionId],
                    ['raw_in_grid', $rawGrid],
                    ['id_reference_dt', $splitTrtansaction->transactiondt_id],
                    ['dt_transaction_type', '!=', 'DQ'],

                ])
                ->whereRaw('date(FROM_UNIXTIME(transactiontmp_date))<= ?', [ $date])

                ->first();

            $qtyInOtherRawTmp = DB::table('transactiontmps')
                ->join('transactiondttmps', 'transactiondttmps.transactiontmp_id', 'transactiontmps.transactiontmp_id')
                ->select('transactiondttmp_id')
                ->selectRaw('(select SUM(item_quantity) from transactiondttmps,transactiontmps
                                      where item_id= "' . $splitTrtansaction->item_id . '"  and  transactiontmps.transactiontmp_id = transactiondttmps.transactiontmp_id and
                                       transactiontmp_type = "' . $navigationOut . '" and DATE(FROM_UNIXTIME(transactiontmp_date)) <=  "' . $date . '" and
                                      transactiontmps.transactiontmp_id ="' . $transactionId . '" and
                                       raw_in_grid !="' . $rawGrid . '"
                                       and id_reference_dt ="' . $splitTrtansaction->transactiondt_id . '"
                                         group by item_id) as item_quantity_Total_tmpDO_selectedDiffRaw')
                ->where([
                    ['item_id', $splitTrtansaction->item_id],
                    ['transactiontmp_type', $navigationOut],
                  ///  ['transactiontmp_date', '<=', $dateFromTimeStamp],
                    // ['transactiontmpdt_billOfEntry', $splitTrtansaction->transactiondt_billOfEntry],
                    ['transactiontmps.transactiontmp_id', $transactionId],
                    ['raw_in_grid', '!=', $rawGrid],
                    // ['transactiondttmp_countryOfOrigin', $splitTrtansaction->transactiondt_countryOfOrigin]
                ])
                ->whereRaw('date(FROM_UNIXTIME(transactiontmp_date))<= ?', [ $date])

                ->first();


            $splitTrtansaction->totalUsedTmpRaw = isset($qtyInTmp->item_quantity_Total_tmpDO_selectedInRaw) ? $qtyInTmp->item_quantity_Total_tmpDO_selectedInRaw : 0;
            $splitTrtansaction->item_quantity_Total_tmpDO_selectedDiffRaw = isset($qtyInOtherRawTmp->item_quantity_Total_tmpDO_selectedDiffRaw) ? $qtyInOtherRawTmp->item_quantity_Total_tmpDO_selectedDiffRaw : 0;
            $splitTrtansaction->transactiondttmp_id = isset($qtyInTmp->transactiondttmp_id) ? $qtyInTmp->transactiondttmp_id : -1;
            $splitTrtansaction->qtyIn = isset($splitTrtansaction->item_quantity) ? $splitTrtansaction->item_quantity : 0;
            $splitTrtansaction->totalUsed = isset($qtyIn->item_quantity_Total_DO) ? $qtyIn->item_quantity_Total_DO : 0;
            $splitTrtansaction->totalUsedInThisTransaction = isset($qtyIn->item_quantity_Total_DO_selected) ? $qtyIn->item_quantity_Total_DO_selected : 0;
            $splitTrtansaction->totalAvailablePerBill = ($splitTrtansaction->qtyIn - $splitTrtansaction->totalUsed) - $splitTrtansaction->item_quantity_Total_tmpDO_selectedDiffRaw;
            $splitTrtansaction->totalAvailablePerBill = $splitTrtansaction->totalAvailablePerBill > 0 ? $splitTrtansaction->totalAvailablePerBill : 0;

            if ($splitTrtansaction->internal_transfer) {
                $splitTrtansaction->transaction_reference = 'Internal Transfer';
            }
            if ($splitTrtansaction->totalAvailablePerBill > 0 || (float)$splitTrtansaction->totalUsedTmpRaw > 0) {
                array_push($availableItems, $splitTrtansaction);
            }

            if (isset($weight->item_weight)) {
                $splitTrtansaction->item_weight = $weight->item_weight;
            }
            if (isset($weight->total_gross_weight)) {
                $splitTrtansaction->gross_weight = $weight->gross_weight;
            }
        }


        return $availableItems;
    }

    public function addGoodsInInternal(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $transactionId = $request->transactionId;
        $loggerUserCompany = auth()->user()->company_id;
        $exitPoint = companies::where('company_id', $loggerUserCompany)
            ->first();
        $Transaction = transactions::where(
            [
                ['transaction_id', $transactionId],

            ]
        )
            ->first();


        $date = $utilitiesController->convertTodayToTimetsamp(date('Y-m-d 00:00:00'));


        $transactionTmp = array(
            'transactiontmp_date' => $date,
            'transactiontmp_billOfEntry' => $Transaction->transaction_billOfEntry,

            'transactiontmp_clientId' => $Transaction->transaction_clientId,
            'transactiontmp_type' => $Transaction->transaction_type == 'GOODS_IN' ? 'DO' : 'RMA_OUT',
            'transactiontmp_remark' => 'Automatic creation from GoodsIn',
            'user_id' => $Transaction->user_id,
            'company_id' => $Transaction->company_id,
            'transactiontmp_currencyId' => $Transaction->transaction_currencyId,
            'transactiontmp_rate' => $Transaction->transaction_rate,
            'transactiontmp_exitPoint' => $exitPoint->company_exitCode,
        );
        $newTransactionTmp = transactiontmp::create($transactionTmp);


        $transactionsDtsOrignal = transactionDt::where(
            [
                ['transaction_id', $transactionId]
            ]
        )->get();

        $k = 0;
        $transactionSerialArray = [];
        foreach ($transactionsDtsOrignal as $Transactiondt) {
            if (!empty($Transactiondt)) {
                $itemDetails = items::where(
                    [
                        ['item_id', $Transactiondt->item_id]
                    ]
                )->first();

                // Formulate record that will be saved
                $transactionDtsTmp = [];
                $transactionDtsTmp = array(
                    'transactiontmp_id' => $newTransactionTmp->transactiontmp_id,
                    'item_id' => $Transactiondt->item_id,
                    'item_quantity' => $Transactiondt->item_quantity,
                    'item_price' => $Transactiondt->item_price,
                    'group_id' => $itemDetails->group_id,
                    'item_weight' => $Transactiondt->item_weight,
                    'item_pack' => $itemDetails->item_pack,
                    'item_unit' => $itemDetails->item_unit,
                    'item_qtyPerPack' => $itemDetails->item_qtyPerPack,
                    'id_reference_dt' => $Transactiondt->transactiondt_id,
                    'raw_in_grid' => $k,
                    'transactiondttmp_cellMerge' => $k + 1,
                    'transactiondttmp_nbOfCarton' => (isset($itemDetails->item_qtyPerPack) && $itemDetails->item_qtyPerPack > 0) ? ceil($Transactiondt->item_quantity / $itemDetails->item_qtyPerPack) : 0,
                    'supplier_id' => $Transactiondt->supplier_id,
                    'supplier_invoice_number' => $Transactiondt->supplier_invoice_number,
                    'transactiondttmp_locationid' => $Transactiondt->transactiondt_locationid,
                    'transactiondttmp_countryOfOrigin' => $Transactiondt->transactiondt_countryOfOrigin,
                    'transactiontmpdt_billOfEntry' => $Transactiondt->transactiondt_billOfEntry,
                    'transactiondttmp_price' => $Transactiondt->transactiondt_price,
                    'client_id' => $Transactiondt->client_id,
                    'hscode' => $Transactiondt->hscode,
                    'transactiondt_item_description' => $Transactiondt->transactiondt_item_description,
                    'transactiondttmp_fpriceBase' => $Transactiondt->transactiondt_fpriceBase,
                    'transactiondttmp_fprice' => $Transactiondt->transactiondt_fprice,
                    'transactiondttmp_priceBase' => $Transactiondt->transactiondt_priceBase,
                    'transactiontmpdt_BOE' => $Transactiondt->transactiondt_BOE,
                );
            }
            $k = $k + 1;
            $newTransactionDtsTmp = transactiondttmp::create($transactionDtsTmp);

            $serials = transactionDtSn::where([
                ['transactiondt_id', $Transactiondt->transactiondt_id]
            ])->get();
            foreach ($serials as $splitSerials) {
                $transactionSerialArray[] = [
                    'item_id' => $splitSerials->item_id,
                    'transaction_item_serial' => $splitSerials->transaction_item_serial,
                    'transactiondttmp_id' => $newTransactionDtsTmp->transactiondttmp_id,
                ];
            }
        }

        $newTransactionSerialsTmp = transactionDtSnTmp::insert($transactionSerialArray);

        $type = $Transaction->transaction_type == 'GOODS_IN' ? 'DO' : 'RMA OUT';
        $message = ' Automatic ' . $type . ' was created';

        return ApiController::successResponse($message, 200);
    }

    public function fetchDOTransactions(Request $request)
    {
        $utilitiesController = new UtilitiesController();


        $count = 0;
            $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                ->leftjoin('clients as toClient', 'toClient.client_id', '=', 'transactions.transferTo_clientId')
                ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
                ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
                ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId');
            if ($request->filterReleased == "released") {

                $transactions->where([
                    ['transaction_released', 1],
                ]);
            }
            if ($request->filterReleased == "notReleased") {

                $transactions->where([
                    ['transaction_released', 0],

                ]);
            }
            $transactions = $transactions
                ->select(
                    'transactions.transaction_reference',
                    'transactions.transaction_date',
                    'client_customers.customer_name',
                    'client_forwarders.clientforwarder_name',
                    'clients.client_firstname',
                    'toClient.client_firstname as transferToClient',
                    'transactions.transaction_id',
                    'salesjv_id',
                    'transaction_type',
                    'transaction_currencyId',
                    'currency_code',
                    'transactions.transaction_released',
                    'transactions.transaction_releasedDate',
                    'transactions.transaction_remark',
                    'transaction_billOfEntry',
                    'transaction_shipmentReference',
                    'transaction_exitPoint',
                    'transaction_destinationPoint',
                    'transaction_shipmentRemark',
                    'transactions.transaction_mobileReference',
                    'Invoice_type_id',
                    'payment_term_id',
                    'delivery_term_id',
                    'exemption_type_id',
                    'transaction_released_DEC',
                    'internal_transfer',
                    'transferTo_clientId'
                )
                ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
                ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_releasedDate, '%d-%m-%Y %H:%i:%s ') AS transaction_releasedDate"))
                ->where([
                    ['transaction_type', transactions::transactionTypes["$request->transactionType"]['type']],
                    ['internal_transfer', transactions::transactionTypes["$request->transactionType"]["internalTransfer"]]
                ])
                ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$request->dateFrom, $request->dateTo])

                ->orderBy('transaction_date', 'desc')
                ->orderBy('transaction_reference', 'desc');
            $count = count($transactions->get());
            if (isset($request->skip) && isset($request->take)) {
                $transactions->skip($request->skip)
                    ->take($request->take);
            }
            if ($request->search) {
                $transactions->Where(function ($query) use ($request) {
                    $query->Where([
                        ['transaction_reference', 'like', '%' . $request->search . '%']
                    ])
                        ->orWhere([
                            ['transaction_mobileReference', 'like', '%' . $request->search . '%']
                        ]);
                });
            }
            $transactions = $transactions->get();
        

        if ($transactions) {
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }

    public function resolveDublicate(Request $request)
    {


        $records = DB::table('transactions')
            ->select('transaction_reference', DB::raw('COUNT(*) as count'))
            ->groupBy('transaction_reference')
            ->having('count', '>', 1)
            ->get();
        //    return $records;
        foreach ($records as $splitDub) {
            $data = DB::table('transactions')
                ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
                ->where([
                    ['transaction_reference', $splitDub->transaction_reference]
                ])
                ->select('transaction_reference', 'transaction_dts.transaction_id', 'transaction_dts.transactiondt_id')
                ->orderby('transaction_dts.transaction_id')
                ->get();
            foreach ($data as $splitData) {
                $correctTrans = $data[0]->transaction_id;
                $update = DB::table('transaction_dts')
                    ->where([
                        ['transactiondt_id', $splitData->transactiondt_id]
                    ])
                    ->update([
                        'transaction_id' => $correctTrans
                    ]);
            }
        }

        $data = DB::table('transactions')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->where([
                ['transactiondt_id', '=', null],
            ])
            ->select('transaction_reference', 'transaction_dts.transaction_id', 'transaction_dts.transactiondt_id')
            ->orderby('transaction_dts.transaction_id')
            ->delete();

        return $records;
    }

    public function fetchDeliveredTransactions(Request $request)
    {

        $transactionId = $request->transactionId;
        $date = date('Y-m-d');
        $data = DB::table('transaction_dts')
            ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('transaction_delivered', 'transaction_delivered.transactiondt_id', 'transaction_dts.transactiondt_id')
            ->where('transaction_dts.transaction_id', $transactionId)
            ->select('transaction_dts.*', 'items.item_code')
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_date"))
            ->get();

        return ApiController::successResponse($data, 200);
    }

    public function insertDeliveredTransactions(Request $request)
    {
        $data = $request->data;
        $utilitiesController = new UtilitiesController();
        $user = auth()->user();


        foreach ($data as $splitData) {
            $transactionDtId = $splitData['transactiondt_id'];
            $transactionId = $splitData['transactiondt_id'];
            $itemId = $splitData['item_id'];
            $prevQty = $splitData['item_quantity'] - $splitData['deliveredQty'];
            $date = $utilitiesController->convertTodayToTimetsamp($splitData['transaction_date'] . "" . date('H:i:s'));

            $qty = $splitData['newQty'];
            if ($qty == null || $qty == 0) {
                continue;
            }

            $transaction[] = [
                'item_id' => $itemId,
                'transactiondt_id' => $transactionDtId,
                'transaction_id' => $transactionId,
                'delivered_deliveredQty' => $qty,
                'delivered_date' => $date,
                'delivered_userId' => $user->id,
                'delivered_previousQty' => $prevQty,
            ];
        }


        $data = DB::table('transaction_delivered')
            ->insert($transaction);
        return ApiController::successResponse($data, 204);
    }

    public function fetchTransactionStatus(Request $request)
    {
        $transactionId = $request->transactionId;
        $data = $this->fetchTransactionStatusFunction($transactionId);
        return ApiController::successResponse($data, 204);
    }

    public function insertTransactionStatus(Request $request)
    {

        $transactionId = $request->transactionId;
        $transactiondtId = $request->transactiondtId;
        $status = $request->status;

        $data = $this->insertTransactionStatusFunction($transactionId, $transactiondtId, $status, 'Insert_Custom_Status');


        return $data;
    }

    public function deleteStatus(Request $request)
    {
        $transactionId = $request->transaction_id;
        $id = $request->id;


        $reference = DB::table('transactions')
            ->where('transaction_id', $transactionId)
            ->first()
            ->transaction_reference;
        $data = DB::table('delivery_status')
            ->where(
                'transaction_id',
                $transactionId
            )
            ->when($id, function ($query) use ($id) {
                return $query->where('delivery_status_id', $id);
            })
            ->delete();
        $data = $this->fetchTransactionStatusFunction($transactionId);

        $this->sendToClientNotifications($transactionId, 'Delivery Status with reference ' . $reference . 'was Deleted', 'Delivery_Status_Deleted');

        return ApiController::successResponse($data, 204);
    }

    public function fetchTransactionStatusTrack(Request $request)
    {
        $reference = $request->reference;
        $data = DB::table('delivery_status')
            ->leftjoin('transactions', 'transactions.transaction_id', 'delivery_status.transaction_id')
            ->selectRaw(DB::raw("FROM_UNIXTIME(delivery_created_at, '%d-%m-%Y %H:%i:%s') AS datetime"))
            ->addselect('delivery_status.delivery_status as status', 'transaction_reference')
            ->where(
                [
                    ['transaction_reference', $reference],
                    ['transaction_type', 'DO']
                ]
            )
            ->orderBy('delivery_created_at', 'desc')
            ->get();
        return $data;
    }

    public function fetchAutoCompleteData(Request $request)
    {

        $apiType = $request->apiType;
        $search = $request->searingData;
        $client = $request->client;
        $transactiontmp_id =  $request->transactiontmp_id;

        if ($apiType == 'groups') {
            $data = DB::table('item_groups')
                ->where('group_code', 'like', $search . '%')
                ->get();
        } else if ($apiType == 'itemUnits') {
            $data = DB::table('set_ups')
                ->where([
                    ['setup_type', 'like', 'item_unit'],
                    ['setup_key', 'like', $search . '%']
                ])
                ->orderBy('setup_value')->get();
        } else if ($apiType == 'clients') {
            $data = DB::table('clients')
                ->where([
                    ['client_firstName', 'like', $search . '%']
                ])
                ->get();
        } else if ($apiType == 'items') {
            $client_id = DB::table('clients')
                ->where('client_firstName', $client)
                ->first()->client_id;

            $data = DB::table('transaction_dts')
                ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
                ->where([
                    ['transaction_dts.client_id', $client_id],
                    ['id_reference_dt', null]
                ])
                ->leftjoin('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
                ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
                ->select(
                    'transaction_dts.client_id',
                    'items.item_hasSerial',
                    'items.item_unit',
                    'items.item_description',
                    'items.item_id',
                    'transaction_dts.item_hscode',
                    'items.item_code',
                    'transaction_dts.item_weight',
                    'item_quantity',
                    'transaction_dts.transactiondt_price',
                    'transaction_dts.transactiondt_billOfEntry',
                    'country_name',
                    'transactiondt_countryOfOrigin',
                    'transaction_dts.transactiondt_id',
                    'transaction_dts.hscode',
                    'transaction_supplierInvoice',
                    'items.item_qtyPerPack',
                    'items.item_pack',
                    'items.group_id',
                    'items.item_hasSerial'

                )
                ->selectRaw("SUM(
                        CASE WHEN (transaction_type = 'GOODS_In')
                        THEN  (transaction_dts.item_quantity)
                        ELSE (
                            CASE WHEN (transaction_type = 'DO' and transaction_dts.transaction_id != '" . $transactiontmp_id . "')
                            THEN  (-transaction_dts.item_quantity)
                            ELSE (0) END
                            ) END
                        )
                        AS qtyExist
                    ")
                ->groupBy('transaction_dts.item_id',)
                ->having(
                    'qtyExist',
                    '>',
                    0
                )
                ->get();
        }
        return ApiController::successResponse($data, 204);
    }


    public function removeOriginalTransactionDO(Request $request)
    {
        $user = auth()->user();
        $date = date('Y-m-d H:i:s');
        $utilitiesController = new UtilitiesController();

        $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionId)
            ->join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->first();

        if ($checkExsistance) {

            if ($checkExsistance->transactiontmp_type == "DO") {
                $type = "Delivery Order";
            }

            return ApiController::errorResponse($type . '  exists in drafts !(By : ' . $checkExsistance->user_name . ')', 422);
        }


        $checkValidity = transactionDt::join('transaction_dts as dt', 'dt.reference_from_do', 'transaction_dts.transactiondt_id')
            ->where([
                ['transaction_dts.transaction_id', '=', $request->transactionId],
            ])->get();


        if (count($checkValidity) == 0) {
            $getDtData = transactionDt::where([
                ['transaction_dts.transaction_id', '=', $request->transactionId],
            ])->get();
            $historyController = new HistoryController();

            $transactions = transactions::where('transaction_id', '=', $request->transactionId);
            $removeTransactions = $transactions->first()->toarray();
            $removeTransactions['user_modified'] = $user->id;
            $removeTransactions['date_modified'] = $date;


            $path = public_path() . '/documents/' . $removeTransactions['transaction_type'] . '/' . $request->transactionId . '/' . $request->file;

            if (file_exists($path)) {
                $deleteFile = File::deleteDirectory($path);
            }
            $deletedd = $transactions->first();

            if (isset($deletedd->salesjv_id)) {
                $config = array(
                    "salesjvId" => $deletedd->salesjv_id,
                );
                $utilitiesController->connectDataToErp("deleteInvoiceFromLogisticom", $config);
            }
            $historyController->insertTransactionHistoryDataByRef(
                'deleted',
                $deletedd->transaction_reference,
                auth()->user()->id,
                $date,
                $deletedd->transaction_type
            );
            $transactions = $transactions->delete();
            $transactionDtArray = null;


            $transferTrans = transactions::where('relatedTransferId', $request->transactionId)
                ->first();
            if ($transferTrans) {

                transactionDt::where('transaction_id', $transferTrans->transaction_id)->delete();
                transactions::where('transaction_id', $transferTrans->transaction_id)->delete();
            }


            return ApiController::successResponse($transactions, 200);
        } else {
            return ApiController::errorResponse('Unable to delete Delivery with DQ', 422);
        }

        return ApiController::successResponse('unable to delete', 204);
    }

    public function createTransactionTmpDO(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'transactionDate' => 'required',
            'transactionType' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $utilitiesController = new UtilitiesController();
        $commonService = new CommonServices();

        $user = auth()->user();
        $companyId = companies::get();


        // in case it is an original transaction copy the transaction to tmp table
        $checkOriginalTransactionExistance = transactions::getTransaction($request->transactionTmpId);
        $getCurrentTransaction = transactiontmp::getTransaction($request->transactionTmpId);
        transactiondttmp::updatePriceBase($getCurrentTransaction, $request->transactionTmpId, $request->transactionRate);


        $transactionTmp = $commonService->prepareTransaction([
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transactionDate . "" . date('H:i:s')),
            'transactiontmp_type' => transactions::transactionTypes["$request->transactionType"]["type"],
            'transactiontmp_remark' => $request->transactionRemark != null ? $request->transactionRemark : "",
            'transferTo_clientId' => $request->transactionClientTo,
            'internal_transfer' => transactions::transactionTypes["$request->transactionType"]["internalTransfer"],
            'transactiontmp_shipmentReference' => $request->transactionShipmentReference,
            'transactiontmp_billOfEntry' => $request->transactionBillOfEntry,
            'transactiontmp_clientId' => $request->transactionClient,
            'user_id' => $user->id,
            'transactiontmp_reference' => isset($checkOriginalTransactionExistance->transaction_reference) ? $checkOriginalTransactionExistance->transaction_reference : null,
            'transactiontmp_typeOfDeliveryId' => $request->orderDeliveryType,
            'forwarder_id' => $request->orderForwarder,
            'clientCustomer_id' => isset($request->transactionCustomer) ? $request->transactionCustomer : null,
            'transactiontmp_driverName' => $request->orderDriverName,
            'transactiontmp_driverPhone' => $request->orderDriverPhone,
            'transactiontmp_vehicleNumber' => $request->orderVehicleNumber,
            'transactiontmp_exitPoint' => $request->orderExitPoint,
            'transactiontmp_destinationPoint' => $request->orderDestinationPoint,
            'company_id' => $companyId,
            'transactiontmp_paymentMethodId' => $request->orderPaymentMethod,
            'transactiontmp_customBillTypeId' => $request->orderCustomBillType,
            'transactiontmp_currencyId' => $request->transactionCurrency,
            'transactiontmp_rate' => $request->transactionRate,
            'transactiontmp_shipmentTypeId' => $request->transactionShipmentType,
            'transactiontmp_shipById' => $request->shipBy,
            'transactiontmp_shipmentRemark' => $request->transactionShipmentRemark,
            'transactiontmp_supplierId' => $request->transactionSupplier,
            'transactiontmp_supplierInvoice' => $request->transactionSupplierInvoice,
            'transactiontmp_id' => $request->transactionTmpId
        ]);

        if ($request->transactionTmpId) {
            $transactionTmpAfterUpdate = transactiontmp::updateTransaction($request->transactionTmpId, $transactionTmp);
            transactiontmp::updateInternalTransaction($request, $companyId, $user->id);
            if ($transactionTmpAfterUpdate) {
                return ApiController::successResponse($transactionTmpAfterUpdate, 200);
            }
            return ApiController::errorResponse($transactionTmpAfterUpdate, 422);
        } else {
            $newTransactionTmp = transactiontmp::create($transactionTmp);

            $payload = array();
            $payload['transactionType'] = $request->transactionType;
            $payload['transactionClient'] = $request->transactionClient;
            $payload['transactionDate'] = $request->transactionDate;
            $payload['transactionClientTo'] = $request->transactionClientTo;
            $payload['userId'] = $user->id;
            $payload['transactiontmp_id'] = $newTransactionTmp->transactiontmp_id;
            $payload['companyId'] = $companyId;

            transactiontmp::createInternalTransaction($payload);
            if ($newTransactionTmp) {
                return ApiController::successResponse($newTransactionTmp, 200);
            }
            return ApiController::errorResponse($newTransactionTmp, 422);
        }
    }

    public function fetchTransactions(Request $request)
    {
    
        $count = 0;
        $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('transaction_dts', 'transaction_dts.transaction_id', 'transactions.transaction_id')
            ->leftjoin('clients as toClient', 'toClient.client_id', '=', 'transactions.transferTo_clientId')
            ->leftjoin('clients as toClientdt', 'toClientdt.client_id', '=', 'transaction_dts.client_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactions.forwarder_id')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId');
        if ($request->filterReleased == "released") {

            $transactions->where([
                ['transaction_released', 1],
            ]);
        }
        if ($request->filterReleased == "notReleased") {

            $transactions->where([
                ['transaction_released', 0],

            ]);
        }
        if ($request->filterReleased == "arrived") {

            $transactions->where([
                ['transaction_arrived', 1],
            ]);
        }
        $transactions = $transactions
            ->select(
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'client_customers.customer_name',
                'client_forwarders.clientforwarder_name',
                'clients.client_firstname',
                'toClient.client_firstname as transferToClient',
                'transactions.transaction_id',
                'salesjv_id',
                'transaction_type',
                'transaction_currencyId',
                'currency_code',
                'transactions.transaction_released',
                'transactions.transaction_releasedDate',
                'transactions.transaction_remark',
                'transaction_billOfEntry',
                'transaction_shipmentReference',
                'transaction_exitPoint',
                'transaction_destinationPoint',
                'transaction_shipmentRemark',
                'transactions.transaction_mobileReference',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_released_DEC',
                'internal_transfer',
                'transferTo_clientId',
                'toClientdt.client_firstname as dtName',
                'transaction_arrived'
            )
            // ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            //->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_releasedDate, '%d-%m-%Y %H:%i:%s ') AS transaction_releasedDate"))
            ->selectRaw(DB::raw("(SELECT SUM(transactiondt_priceBase*item_quantity) FROM transaction_dts WHERE transaction_id = transactions.transaction_id) AS total_price"))
            ->where([
                ['transaction_type', transactions::transactionTypes["$request->transactionType"]['type']],
                ['internal_transfer', transactions::transactionTypes["$request->transactionType"]["internalTransfer"]]
            ])
            ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$request->dateFrom, $request->dateTo])
            ->orderBy('transaction_reference', 'desc');
        $count = count($transactions->groupby('transaction_id')->get());
        if (isset($request->skip) && isset($request->take)) {
            $transactions->skip($request->skip)
                ->take($request->take);
        }
        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ])
                    ->orWhere([
                        ['transaction_mobileReference', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['transaction_remark', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['clients.client_firstname', 'like', '%' . $request->search . '%']
                    ])
                    ->orWhere([
                        ['toClientdt.client_firstname', 'like', '%' . $request->search . '%']
                    ]);
            });
        }
        $transactions = $transactions
            ->groupby('transaction_id')->get();

        foreach ($transactions as $splitTrans) {
            $splitTrans->transaction_formatdate = date('d-m-Y', $splitTrans->transaction_date);
            $splitTrans->transaction_releasedDate = date('d-m-Y', $splitTrans->transaction_releasedDate);

            $multiDelivery = transactionDt::where('transaction_id', $splitTrans->transaction_id)
                ->groupby('client_id')
                ->get();

            if (count($multiDelivery) > 1) {
                $splitTrans->client_firstname = '-';
            }
        }


        if ($transactions) {
            $commonServices = new CommonServices;
            $transactions = $commonServices->getTransactionFilesExist(['DO'], $transactions);
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }

    public function SyncTransactionDO(Request $request)
    {

        $transactionId = $request->transaction_id;
        $utilitiesController = new UtilitiesController();
        $result =  $utilitiesController->connectShipmentToLogisticom($transactionId);
        if ($result->code == 200)  return ApiController::successResponse('success', 200);
        return ApiController::errorResponse($result->error, 422);
    }



    public function fetchRemainingGoodsIn(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $fromClient = $request->fromClient;

        $transactions = transactions::join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->select(
                'customer_name',
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'transactions.transaction_id',
                'transactions.transaction_mobileReference',
                'salesjv_id',
                'transactions.transaction_remark',
                'transactions.transaction_billOfEntry',
                'transactions.transaction_shipmentReference',
                'transactions.transaction_typeOfDeliveryId',
                'suppliers.supplier_name',
                'transactions.transaction_supplierInvoice',
                'transactions.transaction_type',
                'transaction_BOE',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_dts.*',
                'item_code',
                'country_name',
                'internal_transfer',
                'item_quantity'
            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transactions.transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->where([
                ['transactions.transaction_type', 'GOODS_IN'],
            ])
            ->groupby('transactions.transaction_id')
            ->orderBy('transactions.transaction_date', 'desc')
            ->orderBy('transactions.transaction_reference', 'desc');

        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ]);
            });
        }
        $transactions = $transactions->get();



        $data = array();
        foreach ($transactions as $splitTrans) {
            $checkDt = DB::table('transaction_dts')
                ->where([
                    ['id_reference_dt', $splitTrans->transactiondt_id],
                    ['dt_transaction_type', '!=', 'DQ'],
                ])
                ->SUM('item_quantity');


            $splitTrans->item_quantity = $splitTrans->item_quantity - $checkDt;

            if ($splitTrans->transaction_type == 'GOODS_IN' && $splitTrans->internal_transfer == 1) {
                $splitTrans->transactionType = 'Internal';
            } else {
                $splitTrans->transactionType = '';
            }
            if ($splitTrans->item_quantity > 0) {
                array_push($data, $splitTrans);
            }
        }


        return ApiController::successResponse($data, 200);
    }
}
