<?php

namespace App\Http\Controllers\BackOffice\DO;


use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientSupplier;
use App\Models\sequence;
use App\Models\suppliers;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\TransactionPalets;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;

class DoSerialsController extends ApiController
{
    public function fetchDoItemsHavingSerials(Request $request)
    {

        $goodsinSerials = transactiontmp::join('transactiondttmps', 'transactiondttmps.transactiontmp_id', '=', 'transactiontmps.transactiontmp_id')
            ->join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
            ->join('items', 'items.item_code', '=', 'client_items.item_code')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('item_groups', 'item_groups.group_id', '=', 'transactiondttmps.group_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transactiondttmps.transactiondttmp_countryOfOrigin')
            ->orderBy('client_firstname')
            ->select('transactiontmps.transactiontmp_id', 'items.item_code', 'transactiondttmps.item_quantity', 'clients.client_firstname',
                'transactiontmpdt_billOfEntry', 'transactiontmp_type', 'items.item_description',
                'transactiondttmps.transactiondttmp_id', 'items.item_id', 'countries.country_name', 'transactiondttmps.transactiondttmp_countryOfOrigin')
            ->where([
                ['transactiontmps.transactiontmp_id', $request->transactionTmpId],
                ['items.item_hasSerial', '=', true],

            ])
            ->get();

        return ApiController::successResponse($goodsinSerials, 200);
    }

    public function setNewOriginalTransactionDo(Request $request)
    {
        $user = auth()->user();
        $utilitiesController = new UtilitiesController();


        // retrieve the current transaction tmp
        $checkTransactionTmpExistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->first();


        $navigationEntry = 'GOODS_IN';
        $navigationOut = 'DO';
        $type = "DO";
        if ($checkTransactionTmpExistance->transactiontmp_type == 'RMA_OUT') {
            $navigationEntry = 'RMA_IN';
            $navigationOut = 'RMA_OUT';
            $type = "RMA Out";
        }
        //return Response()->json(["data"=>$checkTransactionTmpExistance],422);

        // retrieve the current transaction dt tmp
        $transactionDtsTmp = transactiondttmp::join('client_items', 'client_items.item_id', '=', 'transactiondttmps.item_id')
            ->select('transactiondttmps.*', 'client_items.item_hasSerial')
            ->where('transactiontmp_id', '=', $request->transactionTmpId)
            ->get();

        //return ApiController::errorResponse($transactionDtsTmp,422);

        // verify nbr of transaction serials dt is equal to the origin quantity
        $invalidTransactionsIndex = array();
        $invalidTransactionsWithOutSnIndex = array();
        $invalidDataObj = array();
        for ($i = 0; $i < count($transactionDtsTmp); $i++) {
            $quantity = $transactionDtsTmp[$i]->item_quantity;

            $checkNbrOfSerialsCreatedTmp = transactionDtSnTmp::where([
                ['transactiondttmp_id', '=', $transactionDtsTmp[$i]->transactiondttmp_id],
            ])
                ->get();

            //return ApiController::errorResponse($quantity,422);

            $qtyIn = transactiondt::join(
                'transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id'
            )
                ->where([
                    ['item_id', $transactionDtsTmp[$i]->item_id],
                    ['transactiondt_id', '!=', $transactionDtsTmp[$i]->transactiondttmp_id],
                    ['transactions.transaction_type', $navigationEntry],
                    ['transactiondt_billOfEntry', $transactionDtsTmp[$i]->transactiontmpdt_billOfEntry],
                    ['transactiondt_countryOfOrigin', $transactionDtsTmp[$i]->transactiondttmp_countryOfOrigin],
                ])
                ->selectRaw(' SUM(item_quantity)  as item_quantity')
                ->groupBy('transactiondt_countryOfOrigin', 'transactiondt_billOfEntry', 'item_id')
                ->first();
            $qtyIn = isset($qtyIn) ? $qtyIn->item_quantity : 0;

            $qtyOut = transactiondt::join(
                'transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id'
            )
                ->where([
                    ['item_id', $transactionDtsTmp[$i]->item_id],
                    ['transactions.transaction_type', $navigationOut],
                    ['transactiondt_id', '!=', $transactionDtsTmp[$i]->transactiondttmp_id],

                    ['transactiondt_billOfEntry', $transactionDtsTmp[$i]->transactiontmpdt_billOfEntry],
                    ['transactiondt_countryOfOrigin', $transactionDtsTmp[$i]->transactiondttmp_countryOfOrigin],
                ])
                ->selectRaw(' SUM(item_quantity)  as item_quantity')
                ->groupBy('transactiondt_countryOfOrigin', 'transactiondt_billOfEntry', 'item_id')
                ->first();
            $qtyOut = isset($qtyOut) ? $qtyOut->item_quantity : 0;
            $qtyExist = $qtyIn - $qtyOut;


            if ($quantity > $qtyExist) {
                array_push($invalidTransactionsWithOutSnIndex, $transactionDtsTmp[$i]);

            }
            if ($transactionDtsTmp[$i]->item_hasSerial && $quantity != count($checkNbrOfSerialsCreatedTmp)) {
                // $transactionDtsTmp[$i]->errorIndex = $i;
                array_push($invalidTransactionsIndex, $transactionDtsTmp[$i]);
            }
        }


        if (count($invalidTransactionsIndex) > 0) {
            $invalidDataObj['data'] = $invalidTransactionsIndex;
            $invalidDataObj['message'] = 'saveWithOutSerialsMessage';
            return ApiController::errorResponse($invalidDataObj, 422);
        } else if (count($invalidTransactionsWithOutSnIndex) > 0) {
            $invalidDataObj['data'] = $invalidTransactionsWithOutSnIndex;
            $invalidDataObj['message'] = 'saveWithOutSerialsMessage2';
            return ApiController::errorResponse($invalidDataObj, 422);

        }

        // delete previous transactions dts
        if ($request->transactionId) {
            transactiondt::where('transaction_id', '=', $request->transactionId)->delete();
        }
        $newTransaction = null;
        $getSequence = null;

        //return ApiController::errorResponse($checkTransactionTmpExistance,422);

        if ($checkTransactionTmpExistance) {
            //return ApiController::errorResponse($transactionDtsTmp,422);
            $getSequence = sequence::where('sequence_transactionType', 'like', $checkTransactionTmpExistance->transactiontmp_type)->first();
            if (!$getSequence) {
                return ApiController::errorResponse($getSequence, 422);
            }

            $sequenceNumber = $getSequence->sequence_transactionRef + 1;
            $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;


            $transaction = array(

                'transaction_reference' => $goodsInSequence,
                'transaction_id' => $checkTransactionTmpExistance->transactiontmp_id,
                'transaction_date' => $checkTransactionTmpExistance->transactiontmp_date,
                'transaction_clientId' => $checkTransactionTmpExistance->transactiontmp_clientId,
                'transaction_type' => $checkTransactionTmpExistance->transactiontmp_type,
                'transaction_remark' => $checkTransactionTmpExistance->transactiontmp_remark,
                'transaction_mobileReference' => $checkTransactionTmpExistance->transactiontmp_mobileReference,
                'transaction_shipmentReference' => $checkTransactionTmpExistance->transactiontmp_shipmentReference,
                'transaction_billOfEntry' => $checkTransactionTmpExistance->transactiontmp_billOfEntry,
                'user_id' => $checkTransactionTmpExistance->user_id,


                'transaction_typeOfDeliveryId' => $checkTransactionTmpExistance->transactiontmp_typeOfDeliveryId,
                'forwarder_id' => $checkTransactionTmpExistance->forwarder_id,
                'clientCustomer_id' => $checkTransactionTmpExistance->clientCustomer_id,
                'transaction_driverName' => $checkTransactionTmpExistance->transactiontmp_driverName,
                'transaction_vehicleNumber' => $checkTransactionTmpExistance->transactiontmp_vehicleNumber,
                'transaction_exitPoint' => $checkTransactionTmpExistance->transactiontmp_exitPoint,
                'transaction_destinationPoint' => $checkTransactionTmpExistance->transactiontmp_destinationPoint,
                'company_id' => $checkTransactionTmpExistance->company_id,
                'transaction_paymentMethodId' => $checkTransactionTmpExistance->transactiontmp_paymentMethodId,
                'transaction_customBillTypeId' => $checkTransactionTmpExistance->transactiontmp_customBillTypeId,
                'transaction_currencyId' => $checkTransactionTmpExistance->transactiontmp_currencyId,
                'transaction_shipmentTypeId' => $checkTransactionTmpExistance->transactiontmp_shipmentTypeId,
                'transaction_shipById' => $checkTransactionTmpExistance->transactiontmp_shipById,
                'transaction_shipmentRemark' => $checkTransactionTmpExistance->transactiontmp_shipmentRemark,
                'transaction_supplierId' => $checkTransactionTmpExistance->transactiontmp_supplierId,
                'transaction_supplierInvoice' => $checkTransactionTmpExistance->transactiontmp_supplierInvoice,
            );
            if ($checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference) {
                $newTransaction = transactions::create($transaction);

                $notificationToken = DB::table('users')
                    ->join('clients', 'clients.user_id', 'id')
                    ->where([
                        ["clients.client_id", $checkTransactionTmpExistance->transactiontmp_clientId],
                    ])
                    ->first();

                $ref = 0;
                $message = "";


                if ($checkTransactionTmpExistance->transactiontmp_mobileReference) {
                    $ref = $checkTransactionTmpExistance->transactiontmp_mobileReference;
                    $message = $type . ' Ref: ' . $ref . ' was approved';

                } else {
                    $ref = $goodsInSequence;
                    $message = $type . ' Ref: ' . $ref . ' was created';
                }

                if (isset($notificationToken->user_pushToken)) {
                    $utilitiesController->sendNotification('Transaction', $message, $notificationToken->user_pushToken, $checkTransactionTmpExistance->transactiontmp_clientId, '');

                }
            } else {
                transactions::where('transaction_id', '=', $request->transactionId)->update($transaction);
                $newTransaction = transactions::where('transaction_id', '=', $request->transactionId)->first();
            }

            if (!$checkTransactionTmpExistance->transactiontmp_reference) {
                sequence::where('sequence_transactionType', 'like', $checkTransactionTmpExistance->transactiontmp_type)->increment('sequence_transactionRef', 1);
            }


            // after saving and creation of transaction or update get tmp transaction dt into original and remove from tmp
            if ($newTransaction) {
                // start : transfer supplier to client suppliers
                if ($checkTransactionTmpExistance && $checkTransactionTmpExistance->transactiontmp_type == 'GOODS_IN') {
                    if ($newTransaction->transaction_supplierId) {
                        $getSupplierDetails = suppliers::where('supplier_id', '=', $newTransaction->transaction_supplierId)->first();

                        $checkIfSupplierExist = clientSupplier::where([
                            ['supplier_email', '=', $getSupplierDetails->supplier_email],
                            ['supplier_related_clientid', '=', $newTransaction->transaction_clientId]
                        ])
                            ->first();

                        if (!$checkIfSupplierExist && $getSupplierDetails) {
                            $supplierArray = array(
                                'supplier_name' => $getSupplierDetails->supplier_name,
                                'supplier_contactPerson' => $getSupplierDetails->supplier_contactPerson,
                                'supplier_address' => $getSupplierDetails->supplier_address,
                                'supplier_country' => $getSupplierDetails->supplier_country,
                                'supplier_phone' => $getSupplierDetails->supplier_phone,
                                'supplier_email' => $getSupplierDetails->supplier_email,
                                'supplier_related_clientid' => $newTransaction->transaction_clientId
                            );
                            clientSupplier::create($supplierArray);
                        }
                    }
                }
                //return ApiController::errorResponse($transactionDtsTmp,422);
                foreach ($transactionDtsTmp as $transactionDtTmp) {
                    $transactionDtArray = array(
                        'transactiondt_id' => $transactionDtTmp->transactiondttmp_id,
                        'transaction_id' => $newTransaction->transaction_id,
                        'item_id' => $transactionDtTmp->item_id,
                        'client_id' => $transactionDtTmp->client_id,

                        'item_quantity' => $transactionDtTmp->item_quantity,
                        'supplier_id' => $transactionDtTmp->supplier_id,
                        'supplier_invoice_number' => $transactionDtTmp->supplier_invoice_number,
                        'transactiondt_locationid' => $transactionDtTmp->transactiondttmp_locationid,
                        'transactiondt_countryOfOrigin' => $transactionDtTmp->transactiondttmp_countryOfOrigin,
                        'transactiondt_price' => $transactionDtTmp->transactiondttmp_price,
                        'id_reference_dt' => $transactionDtTmp->id_reference_dt,
                        'transactiondt_billOfEntry' => $transactionDtTmp->transactiontmpdt_billOfEntry,
                        'raw_in_grid' => $transactionDtTmp->raw_in_grid,
                        'item_weight' => $transactionDtTmp->item_weight,
                        'item_unit' => $transactionDtTmp->item_unit,
                        'item_qtyPerPack' => $transactionDtTmp->item_qtyPerPack,
                        'item_pack' => $transactionDtTmp->item_pack,
                        'group_id' => $transactionDtTmp->group_id,
                        'palet_no' => $transactionDtTmp->palet_no,
                        'transactiondt_nbOfCarton' => $transactionDtTmp->transactiondttmp_nbOfCarton,
                        'transactiondt_cellMerge' => $transactionDtTmp->transactiondttmp_cellMerge,


                    );


                    $newTransactionDt = transactiondt::create($transactionDtArray);
                    $serialsTmp = transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDtTmp->transactiondttmp_id)->get();
                    transactionDtsn::where('transactiondt_id', '=', $newTransactionDt->transactiondt_id)->delete();

                    foreach ($serialsTmp as $serialTmp) {
                        $transactionSerialTmpArray = array(
                            'transactiondt_id' => $newTransactionDt->transactiondt_id,
                            'item_id' => $serialTmp->item_id,
                            'transaction_item_serial' => $serialTmp->transaction_item_serial
                        );
                        transactionDtsn::create($transactionSerialTmpArray);
                    }
                    $palets = DB::table('transactiontmp_palets')
                        ->where([
                            ['transactiontmp_id', $checkTransactionTmpExistance->transactiontmp_id]
                        ])
                        ->get();
                    TransactionPalets::where('transaction_id', $checkTransactionTmpExistance->transactiontmp_id)->delete();
                    foreach ($palets as $paletsTmp) {

                        $palets = array(
                            'palet_id' => $paletsTmp->palettmp_id,
                            'palet_no' => $paletsTmp->palet_no,
                            'palet_dimension' => $paletsTmp->palet_dimension,
                            'transaction_id' => $paletsTmp->transactiontmp_id,
                            'palet_weight' => $paletsTmp->palet_weight,
                            'palet_order' => $paletsTmp->palet_order,

                        );
                        TransactionPalets::create($palets);


                    }
                }

                if ($newTransaction) {
                    transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                    TransactiontmpPalets::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();

                    // delete transaction details from tmp table
                    foreach ($transactionDtsTmp as $transactionDetailTmp) {
                        transactionDtSnTmp::where('transactiondttmp_id', '=', $transactionDetailTmp->transactiondttmp_id)->delete();
                    }
                    transactiondttmp::where('transactiontmp_id', '=', $request->transactionTmpId)->delete();
                }
            }

            if ($newTransaction) {
                // $id=  $checkTransactionTmpExistance->id;
                // $token=  $checkTransactionTmpExistance->user_pushToken;
                // $utilitiesController->sendNotification('Delivery Order serails','Delivery Order Transaction with ref:'.$ref.' was saved with serials',$token,$id,'SaveGoodsInSerials');

                //  return ApiController::successResponse($newTransaction,200);
            }
        }
        return ApiController::errorResponse($invalidTransactionsIndex, 200);
    }

    public function retrievePendingDo(Request $request)
    {
        $loggerUserCompany = auth()->user()->company_id;

        $transactions = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            //->join('transactiondttmps','transactiondttmps.transactiontmp_id','transactiontmps.transactiontmp_id')

            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->where([
                ['transactiontmps.transactiontmp_type', 'like', $request->transactionType],

                ['transactiontmps.company_id', '=', $loggerUserCompany],
                ['transactiontmp_enterSerial', '=', true]
            ])
            ->get();

        foreach ($transactions as $transaction) {
            if ($transaction->transactiontmp_date) {
                $transaction->transactiontmp_formatdate = date('Y-m-d', $transaction->transactiontmp_date);
            }
        }
        return ApiController::successResponse($transactions, 200);
    }

    public function saveDOWithoutSerials(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $invalidTransactionsIndex = array();
        $type = '';
        $notificationType = '';

        $checkItemsHaveSerials = transactiontmp::join('transactiondttmps', 'transactiondttmps.transactiontmp_id', 'transactiontmps.transactiontmp_id')
            ->join('items', 'items.item_id', 'transactiondttmps.item_id')
            ->where([
                ['transactiontmps.transactiontmp_id', '=', $request->transactionTmpId],
            ])
            ->get();
        $type = 'GOODS_IN';
        $notificationType = 'd';
        $canSaveWithoutSerial = false;
        $InvalidSerials = false;
        for ($i = 0; $i < count($checkItemsHaveSerials); $i++) {
            $element = $checkItemsHaveSerials[$i];
            if ($element->item_hasSerial) {
                $canSaveWithoutSerial = true;

                $quantity = $element->item_quantity;
                $checkNbrOfSerialsCreatedTmp = transactionDtSnTmp::where([
                    ['transactiondttmp_id', '=', $element->transactiondttmp_id],
                ])
                    ->get();

                $type = $element->transactiontmp_type == 'DO' ? 'do-serials' : 'rmaOut-serials';
                $notificationType = $element->transactiontmp_type == 'DO' ? 'Delivery  Order W/S' : 'RMA Out';
                if ($element->item_hasSerial && $quantity != count($checkNbrOfSerialsCreatedTmp)) {
                    $InvalidSerials = true;
                }


                // break;
            }
        }


        if ($canSaveWithoutSerial && $InvalidSerials) {
            $updateTransaction = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
                ->update([
                    'transactiontmp_enterSerial' => true,
                ]);

            $admins = DB::table('users')
                ->join('useraccess', 'useraccess.user_id', 'users.id')
                ->where([
                    ["useraccess.useraccess_formcode", $type],
                    ["useraccess.useraccess_insert", true],
                ])
                ->get();

            foreach ($admins as $admindt) {

                if ($admindt->user_pushToken) {

                    $utilitiesController->sendNotification($notificationType . ' serail', 'New ' . $notificationType . ' Transaction was created', $admindt->user_pushToken, $admindt->id, $type);
                }
            }
            return ApiController::successResponse($updateTransaction, 200);
        } else if (!$canSaveWithoutSerial) {
            return ApiController::errorResponse(' All items do not have serials', 422);
        } else {
            return ApiController::errorResponse('save transaction instead of save without serials', 422);

        }

    }
}
