<?php

namespace App\Http\Controllers\BackOffice\DataEntry;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\ClientCustomer\ClientCustomerController;
use App\Http\Controllers\BackOffice\ClientForwarder\ClientForwarderController;
use App\Http\Controllers\BackOffice\ClientSupplier\ClientSupplierController;
use App\Http\Controllers\BackOffice\Country\CountryController;
use App\Http\Controllers\BackOffice\GoodsIn\GoodsInController;
use App\Http\Controllers\BackOffice\Items\ItemsController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\companies;
use App\Models\items;
use App\Models\sequence;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Illuminate\Support\Facades\Log;


class DataEntryController extends ApiController
{


    public function import(Request $request)
    {
        // Get the uploaded Excel file
        $file = $request->file('excel_file');

        // Load the file using PhpSpreadsheet
        $spreadsheet = IOFactory::load($file);

        // Get the first worksheet
        $worksheet = $spreadsheet->getActiveSheet();

        // Get the header row
        $headerRow = $worksheet->getRowIterator(1, 1)->current();

        // Extract header titles
        $headerTitles = [];
        foreach ($headerRow->getCellIterator() as $cell) {
            $headerTitles[] = $cell->getValue();
        }

        // Get the data rows
        $dataRows = [];
        $rowDataIterator = $worksheet->getRowIterator(2);
        foreach ($rowDataIterator as $row) {
            $rowData = [];
            foreach ($row->getCellIterator() as $cell) {
                $rowData[] = $cell->getValue();
            }
            $dataRows[] = $rowData;
        }

        // Create an associative array with header titles as keys
        $data = [];
        foreach ($dataRows as $row) {
            $rowData = [];
            foreach ($headerTitles as $index => $title) {
                $rowData[$title] = $row[$index] ?? null;
            }
            $data[] = $rowData;
        }

        // Convert the array to JSON
        $json = json_encode($data);
        $request['dataEntry'] = json_decode($json);
        return $this->excelCBMDataEntry($request);
    }


    public function excelCBMDataEntry(Request $request){
        $data = json_decode(json_encode($request->dataEntry), true);
        foreach ($data as $splitData) {
            $itemCode = trim($splitData['Item Code']);
             $Length = trim($splitData['Length']);
            $Width = trim($splitData['Width']);
            $Height = trim($splitData['Height']);

       
            items::where('item_code' ,$itemCode )
            ->update([
                'item_length' => $Length,
                'item_width' => $Width,
                'item_height' => $Height,
                'item_cbm' => round(($Length * $Width * $Height)/1000000,3)

            ]);
            clientItem::where('item_code' ,$itemCode )
            ->update([
                'item_length' => $Length,
                'item_width' => $Width,
                'item_height' => $Height,
                'item_cbm' => round(($Length * $Width * $Height)/1000000,3)

            ]);

        }
        return $data;
    }


    public function excelDataEntry(Request $request)
    {

        $data = json_decode(json_encode($request->dataEntry), true);

        $clientId = $request->clientId;
        $customerId = $request->customerId;
        $userId = $request->userId;
        $supplier = "";
        $supplierId = "";
        $supplierController = new ClientSupplierController();
        $goodsInController = new GoodsInController();
        $forwarderController = new ClientForwarderController();
        $countryController = new CountryController();
        $customerController = new ClientCustomerController();

        $transactionTmpId = "";
        $transactionTmpIdDO = "";
        $itemHSCode = "";
        $goodsInTransactions = array();
        $doInTransactions = array();
        $curRate = DB::table('curdt')
            ->leftjoin('currency', 'currency.currency_code', 'curdt.Currency_code')
            ->where('currency.currency_code', 'AED')
            ->orderBy('curdt.Curdt_date', 'DESC')
            ->first();


        $rawInGrid = 0;
        $itemId = "";
        $goodsDt = null;
        $forwarderId = "";
        $customerId = "";
        $countryId = "";
        $transactionBOE = "";
        $transactionBillOfEntry = "";
        foreach ($data as $splitData) {
            // supplier part

            if ($splitData['COO']) {
                $COOG = DB::table('countries')
                    ->where('country_code', $splitData['COO'])
                    ->first();
                if ($COOG) {
                    $countryId = $COOG->country_id;
                } else {
                    $result = $countryController->insertCountryFunction($splitData['COO'], $splitData['COO'], "", true);
                    $countryId = $result->getData()->data->country_id;
                }
            }
            if ($splitData['FORWARDER/Customer']) {
                $customers = $customerController->insertClientCustomerFunction($splitData['FORWARDER/Customer'],$clientId, null, null, $countryId, null, null);
                if ($customers->getData()->code == 200) {
                    $customerId = $customers->getData()->data->id;
                } else {
                    $customerId = $customers->getData()->error->customer_id;
                }
                $email = strtolower($splitData['FORWARDER/Customer']) . '@dataEntry.com';
                $clientForwarder = array(
                    'clientforwarder_name' => $splitData['FORWARDER/Customer'],
                    'clientforwarder_email' => $email,
                    'clientforwarder_approved' => 1,
                );
                $forwarderId = $forwarderController->insertClientForwarderFunction($clientForwarder, $email, true);
            }

            if ($splitData['SUPPLIERS'] != "") {
                $rawInGrid = 0;
                if ($splitData['BOE']) {
                    $transactionBOE = $splitData['BOE'];
                }
                if ($splitData['DEC']) {
                    $transactionBillOfEntry = $splitData['DEC'];
                }

                $supplier = $splitData['SUPPLIERS'];
                if (!$supplier) {
                    $supplier = 'unknow';
                }
                $suppliers = $supplierController->insertSupplierFunction($supplier, null, null, null, null, null, $clientId, true);
                $supplierId = $suppliers;
                /*if ($suppliers->getData()->code == 200) {
                    $supplierId = $suppliers->getData()->data->id;
                } else {
                    $supplierId = $suppliers->getData()->error->supplier_id;
                }*/


                $createTransactionHeader = $this->createGoodsInHeaderFunction(
                    'GOODS_IN',
                    $supplierId,
                    $splitData,
                    $curRate->Curdt_rate,
                    $curRate->currency_id,
                    $clientId,
                    $customerId,
                    $userId,
                    $forwarderId,
                    $transactionBOE,
                    $transactionBillOfEntry
                );
                $createTransactionHeaderGoodsIn = $createTransactionHeader['GoodsIn'];

                if ($createTransactionHeaderGoodsIn->getData()->code == 200) {
                    $transactionTmpId = $createTransactionHeaderGoodsIn->getData()->data->transactiontmp_id;
                    array_push($goodsInTransactions, $transactionTmpId);
                    // if ($createTransactionHeader['DO'] != null) {
                    //     $transactionTmpIdDO = $createTransactionHeader['DO'];
                    //     array_push($goodsInTransactions, $transactionTmpIdDO);
                    // }
                }
            }
            if ($transactionTmpId && $splitData["HS CODE"]) {

                $itemId = $this->createItem($splitData);
                $itemHSCode = $splitData["HS CODE"];
                $goodsDt = $this->createGoodsIndt(
                    $transactionTmpId,
                    $splitData,
                    $itemId,
                    $itemHSCode,
                    $transactionTmpIdDO,
                    $rawInGrid,
                    $curRate->Curdt_rate,
                    $goodsDt,
                    $countryId,
                    $transactionBOE
                );

                // continue;
            }
            if (!$splitData["INVOICE NUMBER"]) continue;
            $doInTransactions = $this->createDO(
                'DO',
                $supplierId,
                $splitData,
                $curRate->Curdt_rate,
                $curRate->currency_id,
                $clientId,
                $customerId,
                $userId,
                $forwarderId,
                $rawInGrid,
                $itemId,
                $itemHSCode,
                $goodsDt,
                $doInTransactions,
                $countryId,
            );
            $rawInGrid = $rawInGrid + 1;
        }
        if (count($goodsInTransactions) > 0) {
            $this->saveGoodIN($goodsInTransactions);
            $goodsInTransactions = [];
        }
        $this->saveGoodIN($doInTransactions);
        return 'success';
    }

    public function createGoodsInHeaderFunction(
        $transactionType,
        $supplierId,
        $parameters,
        $curRate,
        $currency_id,
        $clientId,
        $customerId,
        $userId,
        $forwarderId,
        $transactionBOE,
        $transactionBillOfEntry
    ) {
        $goodsInController = new GoodsInController();
        $utilitiesController = new UtilitiesController();
        $countryController = new CountryController();
        $customerController = new ClientCustomerController();


        $companyId = companies::first()->company_id;

        if ($parameters['COO']) {
            $COOG = DB::table('countries')
                ->where('country_code', $parameters['COO'])
                ->first();
            if ($COOG) {
                $countryId = $COOG->country_id;
            } else {
                $result = $countryController->insertCountryFunction($parameters['COO'], $parameters['COO'], "", true);
                $countryId = $result->getData()->data->country_id;
            }
        }


        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($parameters['DATE'] . "" . date('H:i:s')),
            'transactiontmp_type' => $transactionType,
            'transactiontmp_remark' => 'DATA ENTRY',
            'transactiontmp_billOfEntry' => $transactionBillOfEntry,
            'user_id' => $userId,
            'clientCustomer_id' => $customerId,
            'transactiontmp_customerId' => $customerId,
            'transactiontmp_clientId' => $clientId,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $currency_id,
            'transactiontmp_rate' => $curRate,
            'transactiontmp_supplierId' => $supplierId,
            'transactiontmp_supplierInvoice' => 'replace by your value',
            'transactiontmp_BOE' => $transactionBOE != '' ? str_replace('-', '', $transactionBOE) : '0',
        );
        $goodsIn = $goodsInController->createTransactionTmp($transactionTmp, null);

        $response = array();
        $response['GoodsIn'] = $goodsIn;
        //  $response['DO'] = isset($DO->transactiontmp_id) ? $DO->transactiontmp_id : null;
        return $response;
    }

    public function createItem($splitData)
    {
        $itemsController = new ItemsController();
        $companyId = companies::first()->company_id;

        $itemCode = $splitData['HS CODE'];
        $clientItem = array(
            'item_code' => $itemCode,
            'item_hscode' => $itemCode,
            'item_unit' => 'u',
            'item_description' => $splitData['PARTICULARS'],
            'company_id' => $companyId,
            'item_qtyPerPack' => $splitData['PKG_TYPE'],
            'item_pack' => 'package',

        );
        $item = $itemsController->insertItemFunction($clientItem, $itemCode, null, true);

        if ($item->getData()->code == 200) {
            return $item->getData()->data->id;
        } else {
            return items::where([
                ['item_code', $itemCode],
            ])->first()->item_id;
        }
    }

    public function createGoodsIndt(
        $transactionTmpId,
        $splitData,
        $itemId,
        $itemHSCode,
        $transactionTmpIdDO,
        $rawInGrid,
        $rate,
        $goodsDt,
        $countryId,
        $BOE
    ) {
        $goodsInController = new GoodsInController();
        $itemsController = new ItemsController();
        $countryController = new CountryController();
        $companyId = companies::first()->company_id;


        $transactionDetailsTmp = array();
        $object = array();
        $object['transactionDetailItemCode'] = $itemId;
        $object['BOE'] = $BOE;
        $object['transactionDetailItemQty'] = $splitData['QTY'];
        $object['transactionDetailCountryOfOrigin'] = $countryId;
        $object['transactiondttmpPrice'] = (float)$splitData['UNIT PRICE'];
        $object['transactiondttmpPriceBase'] = (float)$splitData['UNIT PRICE'];

        $object['transactiondttmpItemWeight'] = (float)$splitData['WT'] / (float)$splitData['QTY'];
        $object['transactionDetailItemDesc'] = $splitData['PARTICULARS'];
        $object['transactionDetailItemHsCode'] = $itemHSCode;


        $object['transactionDetailItemTotalPrice'] = (float)$splitData['QTY'] * (float)$splitData['UNIT PRICE'];
        $object['transactionDetailItemTotalWeight'] = $splitData['WT'];


        array_push($transactionDetailsTmp, $object);

        return $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmp, $transactionTmpId);
        if ($splitData['SUPPLIERS']) {
            //  return  $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmp, $transactionTmpId);
        } else {
            // $object['idReferenceDt'] = $goodsDt->getData()->data->transactionDt->transactiondttmp_id;
            // $object['transactionDetailCountryOfOrigin'] = $goodsDt->getData()->data->transactionDt->transactiondttmp_countryOfOrigin;
            // $object['DEC'] = $goodsDt->getData()->data->transactionDt->transactiontmpdt_billOfEntry;
            // $object['rawInGrid'] = $rawInGrid;
            // $object['itemQtyPerPack'] = $splitData['PKG_TYPE'];
            // $object['itemUnit'] = 'u';
            // $object['transactiondttmp_nbOfCarton'] = ceil($splitData['QTY'] / $object['itemQtyPerPack']);


            // $transactionDetailsTmpDO = array();
            // array_push($transactionDetailsTmpDO, $object);
            // if ($transactionTmpIdDO != null) {
            //     $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmpDO, $transactionTmpIdDO);
            // }
        }
    }

    public function createDO(
        $transactionType,
        $supplierId,
        $parameters,
        $curRate,
        $currency_id,
        $clientId,
        $customerId,
        $userId,
        $forwarderId,
        $rawInGrid,
        $itemId,
        $itemHSCode,
        $goodsDt,
        $doInTransactions,
        $countryId
    ) {


        $goodsInController = new GoodsInController();
        $utilitiesController = new UtilitiesController();


        $companyId = companies::first()->company_id;
        $transactionBOE = $parameters['BOE'];
        $transactionBillOfEntry = $parameters['DEC'];
        $reference = $parameters['INVOICE NUMBER'];
        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($parameters['DATE'] . "" . date('H:i:s')),
            'transactiontmp_type' => $transactionType,
            'transactiontmp_remark' => 'DATA ENTRY',
            'transactiontmp_billOfEntry' => $transactionBillOfEntry,
            'user_id' => $userId,
            'clientCustomer_id' => $customerId,
            'transactiontmp_customerId' => $customerId,
            'transactiontmp_clientId' => $clientId,
            'transactiontmp_reference' => $reference,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $currency_id,
            'transactiontmp_rate' => $curRate,
            'transactiontmp_supplierId' => $supplierId,
            'transactiontmp_supplierInvoice' => isset($parameters['INVOICE NUMBER']) ? $parameters['INVOICE NUMBER'] : null,
            'transactiontmp_BOE' => $transactionBOE != '' ? str_replace('-', '', $transactionBOE) : '0',
        );

        $transactionTmp['transactiontmp_type'] = "DO";
        $transactionTmp['transactiontmp_billOfEntry'] = null;
        $transactionTmp['transactiontmp_BOE'] = null;
        $transactionTmp['transactiontmp_paymentMethodId'] = 10;
        $transactionTmp['transactiontmp_customBillTypeId'] = 18;
        $transactionTmp['transactiontmp_destinationPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_exitPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_typeOfDeliveryId'] = 2;
        $transactionTmp['transaction_released_DEC'] = $parameters['OUTBOUND DEC'] != null ? $parameters['OUTBOUND DEC'] : " ";

        $DO = null;
        if ($parameters['OUT DATE'] != "" || $parameters['OUT DATE'] != null) {
            $transactionTmp['transactiontmp_date'] = $utilitiesController->convertTodayToTimetsamp($parameters['OUT DATE'] . "" . date('H:i:s'));
            $transactionTmp['forwarder_id'] = $forwarderId;


            $DO = transactiontmp::where([
                ['transactiontmp_supplierInvoice', $parameters['INVOICE NUMBER']]
            ])->first();
            if (!$DO) {
                $newAutoIncrementValue = $parameters['INVOICE NUMBER'];
                $DO = transactiontmp::create($transactionTmp);
                array_push($doInTransactions, $DO->transactiontmp_id);
                $maxSeq = sequence::where('sequence_transactionType', 'DO')
                    ->max('sequence_transactionRef');
                if ($maxSeq <= $newAutoIncrementValue) {
                    sequence::where('sequence_transactionType', 'DO')->update([
                        'sequence_transactionRef' => $newAutoIncrementValue
                    ]);
                }
            } else {
                $DO = transactiontmp::where([
                    ['transactiontmp_supplierInvoice', $parameters['INVOICE NUMBER']]
                ])->first();
            }
        }


        $response = array();
        $response['DO'] = $DO;
        //  $response['DO'] = isset($DO->transactiontmp_id) ? $DO->transactiontmp_id : null;
        //   return  $response;


        $customerController = new ClientCustomerController();

        $goodsInController = new GoodsInController();
        $itemsController = new ItemsController();
        $countryController = new CountryController();
        $companyId = companies::first()->company_id;


        // if($parameters['SUPPLIERS'] !=null){
        //     $customers = $customerController->insertClientCustomerFunction($parameters['SUPPLIERS'], null, null, $countryId, null, null, $clientId);
        //     if ($customers->getData()->code == 200) {
        //         $customerId = $customers->getData()->data->id;
        //     } else {
        //         $customerId = $customers->getData()->error->customer_id;
        //     }
        // }

        $transactionDetailsTmp = array();
        $object = array();
        $valueOut = trim($parameters['VALUE OUT']) ? trim($parameters['VALUE OUT']) : trim($parameters['VALUE - AED']);
        $object['transactionDetailItemCode'] = $itemId;
        $object['transactionDetailItemQty'] = $parameters['QTY'];
        $object['transactionDetailCountryOfOrigin'] = $countryId;
        $object['transactiondttmpPrice'] = (float)$valueOut / $parameters['QTY'];
        $object['transactiondttmpPriceBase'] = (float)$valueOut / $parameters['QTY'];

        $object['transactiondttmpItemWeight'] = (float)$parameters['WT'] / (float)$parameters['QTY'];
        $object['transactionDetailItemDesc'] = $parameters['PARTICULARS'];
        $object['transactionDetailItemHsCode'] = $itemHSCode;


        $object['transactionDetailItemTotalPrice'] = (float)$parameters['QTY'] * (float)$parameters['UNIT PRICE'];
        $object['transactionDetailItemTotalWeight'] = $parameters['WT'];

        $object['idReferenceDt'] = $goodsDt->getData()->data->transactionDt->transactiondttmp_id;
        $object['transactionDetailCountryOfOrigin'] = $goodsDt->getData()->data->transactionDt->transactiondttmp_countryOfOrigin;
        $object['DEC'] = $goodsDt->getData()->data->transactionDt->transactiontmpdt_billOfEntry;
        $object['BOE'] = $goodsDt->getData()->data->transactionDt->transactiontmpdt_BOE;

        $object['rawInGrid'] = $rawInGrid;
        $object['itemQtyPerPack'] = $parameters['PKG_TYPE'];
        $qtyPacks = $object['itemQtyPerPack'];
        $object['itemUnit'] = 'u';
        if ($object['itemQtyPerPack'] == 0 || $object['itemQtyPerPack'] == '0' || $object['itemQtyPerPack'] == null) {
            $qtyPacks = 1;
        }

        try {
            $object['transactiondttmp_nbOfCarton'] = ceil($parameters['QTY'] / ($qtyPacks == 0 ? 1 : $qtyPacks));
        } catch (Exception $e) {
            $object['transactiondttmp_nbOfCarton'] = ceil($parameters['QTY']);
        }


        $lastRawInGrid = 0;
        $checkGridIndex = transactiondttmp::where('transactiontmp_id', $DO->transactiontmp_id)
            ->orderBy('raw_in_grid', 'DESC')
            ->first();

        if ($checkGridIndex != null) {
            $lastRawInGrid = $checkGridIndex->raw_in_grid + 1;
        }

        $object['rawInGrid'] = $lastRawInGrid;
        $object['type'] = 'DO';
        $transactionDetailsTmpDO = array();
        array_push($transactionDetailsTmpDO, $object);
        //   if ($transactionTmpIdDO != null) {
        $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmpDO, $DO->transactiontmp_id);
        //   }


        return $doInTransactions;
    }

    public function saveGoodIN($goodsInTransactions)
    {
        $goodsInController = new GoodsInController();

        foreach ($goodsInTransactions as $details) {
            if ($details != null && $details != "") {
                $request = Request();
                $request['transactionId'] = $details;
                $request['transactionTmpId'] = $details;
                $goodsInController->insertNewTransactionSave2($request);
            }
        }
    }

    public function createGoodsInHeader(
        $transactionType,
        $supplierId,
        $parameters,
        $curRate,
        $currency_id,
        $clientId,
        $customerId,
        $userId,
        $forwarderId
    ) {
        $goodsInController = new GoodsInController();
        $utilitiesController = new UtilitiesController();


        $companyId = companies::first()->company_id;
        $transactionBOE = $parameters['BOE'];
        $transactionBillOfEntry = $parameters['DEC'];
        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($parameters['DATE'] . "" . date('H:i:s')),
            'transactiontmp_type' => $transactionType,
            'transactiontmp_remark' => 'DATA ENTRY',
            'transactiontmp_billOfEntry' => $transactionBillOfEntry,
            'user_id' => $userId,
            'clientCustomer_id' => $customerId,
            'transactiontmp_customerId' => $customerId,
            'transactiontmp_clientId' => $clientId,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $currency_id,
            'transactiontmp_rate' => $curRate,
            'transactiontmp_supplierId' => $supplierId,
            'transactiontmp_supplierInvoice' => 'replace by your value',
            'transactiontmp_BOE' => $transactionBOE != '' ? str_replace('-', '', $transactionBOE) : '0',
        );
        $goodsIn = $goodsInController->createTransactionTmp($transactionTmp, null);


        $transactionTmp['transactiontmp_type'] = "DO";
        $transactionTmp['transactiontmp_billOfEntry'] = null;
        $transactionTmp['transactiontmp_BOE'] = null;
        $transactionTmp['transactiontmp_paymentMethodId'] = 10;
        $transactionTmp['transactiontmp_customBillTypeId'] = 18;
        $transactionTmp['transactiontmp_destinationPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_exitPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_typeOfDeliveryId'] = 2;
        $transactionTmp['transaction_released_DEC'] = $parameters['OUTBOUND DEC'] != null ? $parameters['OUTBOUND DEC'] : " ";

        $DO = null;
        if ($parameters['OUT DATE'] != "" || $parameters['OUT DATE'] != null) {
            $transactionTmp['transactiontmp_date'] = $utilitiesController->convertTodayToTimetsamp($parameters['OUT DATE'] . "" . date('H:i:s'));
            $transactionTmp['forwarder_id'] = $forwarderId;


            $DO = transactions::where([
                ['transaction_supplierInvoice', $parameters['INVOICE NUMBER']]
            ])->first();
            if (!$DO) {
                $DO = transactiontmp::create($transactionTmp);
            } else {
                $request = Request();
                $request['transactionId'] = $DO->transaction_id;
                $goodsInController->returnToTmpTransaction($request);
            }
        }


        $response = array();
        $response['GoodsIn'] = $goodsIn;
        $response['DO'] = isset($DO->transactiontmp_id) ? $DO->transactiontmp_id : null;
        return $response;
    }



    // for alt
    public function importAlt(Request $request)
    {
        // Get the uploaded Excel file
        $file = $request->file('excel_file');

        // Load the file using PhpSpreadsheet
        $spreadsheet = IOFactory::load($file);

        // Get the first worksheet
        $worksheet = $spreadsheet->getActiveSheet();

        // Get the header row
        $headerRow = $worksheet->getRowIterator(1, 1)->current();

        // Extract header titles
        $headerTitles = [];
        foreach ($headerRow->getCellIterator() as $cell) {
            $headerTitles[] = $cell->getValue();
        }

        // Get the data rows
        $dataRows = [];
        $rowDataIterator = $worksheet->getRowIterator(2);
        foreach ($rowDataIterator as $row) {
            $rowData = [];
            foreach ($row->getCellIterator() as $cell) {
                $rowData[] = $cell->getValue();
            }
            $dataRows[] = $rowData;
        }

        // Create an associative array with header titles as keys
        $data = [];
        foreach ($dataRows as $row) {
            $rowData = [];
            foreach ($headerTitles as $index => $title) {
                $rowData[$title] = $row[$index] ?? null;
            }
            $data[] = $rowData;
        }

        // Convert the array to JSON
        $json = json_encode($data);
        $request['dataEntry'] = json_decode($json);
        return $this->excelAltDataEntry($request);
    }

    public function excelAltDataEntry(Request $request)
    {

        $data = json_decode(json_encode($request->dataEntry), true);


        $clientId = $request->clientId;
        $customerId = $request->customerId;
        $userId = $request->userId;
        $supplier = "";
        $supplierId = "10";
        $supplierController = new ClientSupplierController();
        $goodsInController = new GoodsInController();
        $forwarderController = new ClientForwarderController();
        $countryController = new CountryController();
        $customerController = new ClientCustomerController();

        $transactionTmpId = "";
        $transactionTmpIdDO = "";
        $itemHSCode = "";
        $goodsInTransactions = array();
        $doInTransactions = array();
        $curRate = DB::table('curdt')
            ->leftjoin('currency', 'currency.currency_code', 'curdt.Currency_code')
            ->where('currency.currency_code', 'AED')
            ->orderBy('curdt.Curdt_date', 'DESC')
            ->first();



        $rawInGrid = 0;
        $itemId = "";
        $goodsDt = null;
        $forwarderId = "50";
        $customerId = "16";
        $countryId = "";
        $transactionBOE = "";
        $transactionBillOfEntry = "";

        $i=2;
        foreach ($data as $splitData) {
            // supplier part

            if ( $splitData['HS CODE'] == ""  ) {


                $i=$i+1;
                continue;
            }
            if ( $splitData["ORIGIN"] == ""  ) {


                $i=$i+1;
                continue;
            }
            if (trim($splitData["OUT BOE NO."]) == "IN" ) {


                $i=$i+1;
                continue;
            }
            if ( trim($splitData['HS CODE']) == "" || trim($splitData["ORIGIN"]) == "" || trim($splitData["OUT BOE NO."]) == "IN" ) {


                $i=$i+1;
                continue;
            }
            $qty=(float) $splitData['QTY PCS'];
            if($splitData['QTY PCS']=="" || (float) $splitData['QTY PCS'] == 0 ){
                $qty =(float) $splitData['QTY PLT'];
                if($qty==0 || $qty==""){
                    $qty =(float) $splitData['QTY'];
                }
            }

            if($qty ==0){

                $i=$i+1;
                continue;
            }
            (float) $splitData['QTY']=$qty;
            $i=$i+1;
            if (trim($splitData["ORIGIN"])) {
                $COOG = DB::table('countries')
                    ->where('country_code', trim($splitData["ORIGIN"]))
                    ->first();
                if ($COOG) {
                    $countryId = $COOG->country_id;
                } else {
                    $result = $countryController->insertCountryFunction(trim($splitData["ORIGIN"]), trim($splitData["ORIGIN"]), "", true);
                    $countryId = $result->getData()->data->country_id;
                }

            }

            if(!$countryId) continue;
            //  return $splitData['ORIGIN'];
            // if ($splitData['FORWARDER/Customer']) {
            //     $customers = $customerController->insertClientCustomerFunction($splitData['FORWARDER/Customer'], null, null, $countryId, null, null, $clientId);
            //     if ($customers->getData()->code == 200) {
            //         $customerId = $customers->getData()->data->id;
            //     } else {
            //         $customerId = $customers->getData()->error->customer_id;
            //     }
            //     $email = strtolower($splitData['FORWARDER/Customer']) . '@dataEntry.com';
            //     $clientForwarder = array(
            //         'clientforwarder_name' => $splitData['FORWARDER/Customer'],
            //         'clientforwarder_email' => $email,
            //         'clientforwarder_approved' => 1,
            //     );
            //     $forwarderId = $forwarderController->insertClientForwarderFunction($clientForwarder, $email, true);
            // }

            //  if ($splitData['SUPPLIERS'] != "") {
            //   $rawInGrid = 0;
            if ($splitData['BOE REF']) {
                $transactionBOE = $splitData['BOE REF'];
            }
            if ($splitData['BOE REF']) {
                $transactionBillOfEntry = $splitData['BOE REF'];
                $modifiedDEC = substr_replace($transactionBillOfEntry, '-', 3, 0);
                $modifiedDEC = substr_replace($modifiedDEC, '-', 12, 0);
                $transactionBillOfEntry = $modifiedDEC;
            }

            // $supplier = $splitData['SUPPLIERS'];
            // if (!$supplier) {
            //     $supplier = 'unknow';
            // }
            // $suppliers = $supplierController->insertSupplierFunction($supplier, null, null, null, null, null, $clientId, true);
            // $supplierId = $suppliers;
            /*if ($suppliers->getData()->code == 200) {
                    $supplierId = $suppliers->getData()->data->id;
                } else {
                    $supplierId = $suppliers->getData()->error->supplier_id;
                }*/

            $goodsInTransactions = $this->createGoodsInHeaderFunctionAlt(
                'GOODS_IN',
                $supplierId,
                $splitData,
                $curRate->Curdt_rate,
                $curRate->currency_id,
                $clientId,
                $customerId,
                $userId,
                $forwarderId,
                $transactionBOE,
                $transactionBillOfEntry,
                $goodsInTransactions
            );
        }


        if (count($goodsInTransactions) > 0) {
            $this->saveGoodIN($goodsInTransactions);
            $goodsInTransactions = [];
        }
        // for do

        $DOArray = transactiontmp::pluck('transactiontmp_id');
        $this->saveGoodIN($DOArray);
        return 'success';
    }

    public function createGoodsInHeaderFunctionAlt(
        $transactionType,
        $supplierId,
        $parameters,
        $curRate,
        $currency_id,
        $clientId,
        $customerId,
        $userId,
        $forwarderId,
        $transactionBOE,
        $transactionBillOfEntry,
        $goodsInTransactions
    ) {
        $goodsInController = new GoodsInController();
        $utilitiesController = new UtilitiesController();
        $countryController = new CountryController();
        $customerController = new ClientCustomerController();


        $companyId = companies::first()->company_id;

        if ($parameters['ORIGIN']) {
            $COOG = DB::table('countries')
                ->where('country_code', $parameters['ORIGIN'])
                ->first();
            if ($COOG) {
                $countryId = $COOG->country_id;
            } else {
                $result = $countryController->insertCountryFunction($parameters['ORIGIN'], $parameters['ORIGIN'], "", true);

                $countryId = $result->getData()->data->country_id;
            }
        }


        $date = $parameters['DATE'];

        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($date . "" . date('H:i:s')),
            'transactiontmp_type' => $transactionType,
            'transactiontmp_remark' => 'DATA ENTRY',
            'transactiontmp_billOfEntry' => $transactionBillOfEntry,
            'user_id' => $userId,
            'clientCustomer_id' => $customerId,
            'transactiontmp_customerId' => $customerId,
            'transactiontmp_clientId' => $clientId,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $currency_id,
            'transactiontmp_rate' => $curRate,
            'transactiontmp_supplierId' => $supplierId,
            'transactiontmp_supplierInvoice' => 'replace by your value',
            'transactiontmp_BOE' => $transactionBOE != '' ? str_replace('-', '', $transactionBOE) : '0',
        );

        $checkIfDBExist = transactiontmp::where('transactiontmp_billOfEntry', $transactionBillOfEntry)
            ->first();
        $response = array();

        if (!$checkIfDBExist) {
            $goodsIn = $goodsInController->createTransactionTmp($transactionTmp, null);

            $response['GoodsIn'] = $goodsIn;

            $checkIfDBExist = $goodsIn->getData()->data;
            array_push($goodsInTransactions, $checkIfDBExist->transactiontmp_id);
        }


        $transactiontmp_id = $checkIfDBExist->transactiontmp_id;

        $itemHSCode = $parameters["HS CODE"];
        $itemId = $this->createItemAlt($parameters);

        $goodsDt = $this->createGoodsIndtAlt(
            $transactiontmp_id,
            $parameters,
            $itemId,
            $itemHSCode,
            $curRate,
            $countryId,
            $transactionBOE
        );
        $doInTransactions = $this->createDOAlt(
            'DO',
            $supplierId,
            $parameters,
            $curRate,
            $currency_id,
            $clientId,
            $customerId,
            $userId,
            $forwarderId,
            1,
            $itemId,
            $itemHSCode,
            $goodsDt,
            [],
            $countryId,
            $transactionBOE,
            $transactionBillOfEntry,
            $countryId,
            $goodsDt->getData()->data->transactionDt->transactiondttmp_id,
            $transactionBOE,
            $transactionBillOfEntry,
        );
        //   $rawInGrid = $rawInGrid + 1;

        //  $response['DO'] = isset($DO->transactiontmp_id) ? $DO->transactiontmp_id : null;
        return $goodsInTransactions;
    }

    public function createGoodsIndtAlt(
        $transactionTmpId,
        $splitData,
        $itemId,
        $itemHSCode,
        $curRate,
        $countryId,
        $BOE,


    ) {
        $goodsInController = new GoodsInController();
        $itemsController = new ItemsController();
        $countryController = new CountryController();
        $companyId = companies::first()->company_id;


        $transactionDetailsTmp = array();
        $object = array();
        $object['transactionDetailItemCode'] = $itemId;
        $object['BOE'] = $BOE;
        $object['transactionDetailItemQty'] = $splitData['QTY'];
        $object['transactionDetailCountryOfOrigin'] = $countryId;
        $object['transactiondttmpPrice'] = (float)$splitData['PRICE/UNIT'];
        $object['transactiondttmpPriceBase'] = (float)$splitData['PRICE/UNIT'];

        $object['transactiondttmpItemWeight'] = (float)$splitData['N WEIGHT'] / (float)$splitData['QTY'];
        $object['transactionDetailItemDesc'] = $splitData['HS CODE'];
        $object['transactionDetailItemHsCode'] = $itemHSCode;


        $object['transactionDetailItemTotalPrice'] = (float)$splitData['QTY'] * (float)$splitData['PRICE/UNIT'];
        $object['transactionDetailItemTotalWeight'] = $splitData['N WEIGHT'];


        array_push($transactionDetailsTmp, $object);

        return $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmp, $transactionTmpId);
    }

    public function createItemAlt($splitData)
    {
        $itemsController = new ItemsController();
        $companyId = companies::first()->company_id;

        $itemCode = $splitData['HS CODE'];
        $clientItem = array(
            'item_code' => $itemCode,
            'item_hscode' => $itemCode,
            'item_unit' => 'u',
            'item_description' => $splitData['HS CODE'],
            'company_id' => $companyId,
            'item_qtyPerPack' => 'custom',
            'item_pack' => 'package',

        );
        $item = $itemsController->insertItemFunction($clientItem, $itemCode, null, true);

        if ($item->getData()->code == 200) {
            return $item->getData()->data->id;
        } else {
            return items::where([
                ['item_code', $itemCode],
            ])->first()->item_id;
        }
    }


    public function createDOAlt(
        $transactionType,
        $supplierId,
        $parameters,
        $curRate,
        $currency_id,
        $clientId,
        $customerId,
        $userId,
        $forwarderId,
        $rawInGrid,
        $itemId,
        $itemHSCode,
        $goodsDt,
        $doInTransactions,
        $countryId,
        $transactionBOE,
        $transactionBillOfEntry,
        $transactiondttmp_countryOfOrigin,
        $transactiondttmp_id,
        $transactiontmpdt_billOfEntry,
        $transactiontmpdt_BOE
    ) {


        $goodsInController = new GoodsInController();
        $utilitiesController = new UtilitiesController();


        $companyId = companies::first()->company_id;

        $reference = $parameters['OUT BOE NO.'];

        $transactionTmp = array(
            'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($parameters['DATE'] . "" . date('H:i:s')),
            'transactiontmp_type' => $transactionType,
            'transactiontmp_remark' => 'DATA ENTRY',
            'transactiontmp_billOfEntry' => $transactionBillOfEntry,
            'user_id' => $userId,
            'clientCustomer_id' => 55,
            'transactiontmp_customerId' => 55,
            'transactiontmp_clientId' => $clientId,
            'transactiontmp_reference' => $reference,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $currency_id,
            'transactiontmp_rate' => $curRate,
            'transactiontmp_supplierId' => $supplierId,
            'transactiontmp_supplierInvoice' => isset($reference) ? $reference : null,
            'transactiontmp_BOE' => $transactionBOE != '' ? str_replace('-', '', $transactionBOE) : '0',
            'forwarder_id' => 187,
            'transaction_type' => "00:01:01"
        );

        $transactionTmp['transactiontmp_type'] = "DO";
        $transactionTmp['transactiontmp_billOfEntry'] = null;
        $transactionTmp['transactiontmp_BOE'] = null;
        $transactionTmp['transactiontmp_paymentMethodId'] = 10;
        $transactionTmp['transactiontmp_customBillTypeId'] = 18;
        $transactionTmp['transactiontmp_destinationPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_exitPoint'] = "JEBEL ALI";
        $transactionTmp['transactiontmp_typeOfDeliveryId'] = 2;
        $transactionTmp['transaction_released_DEC'] = $reference != null ? $reference : " ";

        $DO = null;
        $checkDO = transactiontmp::where([
            ['transactiontmp_supplierInvoice', $reference]
        ])->first();
        if (!$checkDO) {
            $newAutoIncrementValue = $reference;
            $DO = transactiontmp::create($transactionTmp);

            array_push($doInTransactions, $DO->transactiontmp_id);
            $maxSeq = sequence::where('sequence_transactionType', 'DO')
                ->max('sequence_transactionRef');
            if ($maxSeq <= $newAutoIncrementValue) {
                sequence::where('sequence_transactionType', 'DO')->update([
                    'sequence_transactionRef' => $newAutoIncrementValue
                ]);
            }
        } else {
            $DO = transactiontmp::where([
                ['transactiontmp_supplierInvoice', $reference]
            ])->first();
        }





        $response = array();
        $response['DO'] = $DO;


        $customerController = new ClientCustomerController();

        $goodsInController = new GoodsInController();
        $itemsController = new ItemsController();
        $countryController = new CountryController();
        $companyId = companies::first()->company_id;


        $transactionDetailsTmp = array();
        $object = array();
        $valueOut = trim($parameters['QTY']);
        $object['transactionDetailItemCode'] = $itemId;
        $object['transactionDetailItemQty'] = $parameters['QTY'];
        $object['transactionDetailCountryOfOrigin'] = $countryId;
        $object['transactiondttmpPrice'] = (float)$parameters['PRICE/UNIT'];
        $object['transactiondttmpPriceBase'] =  (float)$parameters['PRICE/UNIT'];

        $object['transactiondttmpItemWeight'] = (float)$parameters['N WEIGHT'] / (float)$parameters['QTY'];
        $object['transactionDetailItemDesc'] = $parameters['HS CODE'];
        $object['transactionDetailItemHsCode'] = $itemHSCode;


        $object['transactionDetailItemTotalPrice'] =  (float)$parameters['QTY'] * (float)$parameters['PRICE/UNIT'];
        $object['transactionDetailItemTotalWeight'] = $parameters['N WEIGHT'];

        $object['idReferenceDt'] = $transactiondttmp_id;
        $object['transactionDetailCountryOfOrigin'] = $transactiondttmp_countryOfOrigin;
        $object['DEC'] = $transactionBillOfEntry;
        $object['BOE'] = $transactiontmpdt_BOE;

        $object['rawInGrid'] = $rawInGrid;
        $object['itemQtyPerPack'] = 'box';
        $qtyPacks = $object['itemQtyPerPack'];
        $object['itemUnit'] = 'u';
        $qtyPacks = 1;

        try {
            $object['transactiondttmp_nbOfCarton'] = ceil($parameters['QTY'] / ($qtyPacks == 0 ? 1 : $qtyPacks));
        } catch (Exception $e) {
            $object['transactiondttmp_nbOfCarton'] = ceil($parameters['QTY']);
        }


        $lastRawInGrid = 0;
        $checkGridIndex = transactiondttmp::where('transactiontmp_id', $DO->transactiontmp_id)
            ->orderBy('raw_in_grid', 'DESC')
            ->first();

        if ($checkGridIndex != null) {
            $lastRawInGrid = $checkGridIndex->raw_in_grid + 1;
        }

        $object['rawInGrid'] = $lastRawInGrid;
        $object['type'] = 'DO';
        $object['itemGroup'] = '1498';
        $object['itemPack'] = 'box';
        $object['itemQtyPerPack'] = '1';



        $transactionDetailsTmpDO = array();
        array_push($transactionDetailsTmpDO, $object);
        //   if ($transactionTmpIdDO != null) {
        $goodsInController->storeTransactionDtTmpFunction($transactionDetailsTmpDO, $DO->transactiontmp_id);
        //   }


        return $doInTransactions;
    }
}
