<?php

namespace App\Http\Controllers\BackOffice\Internal;


use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\companies;
use App\Models\items;
use App\Models\location;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use App\Models\clientItem;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;
use File;
use Exception;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Dtos\InternalTransfer\inputInternalDtTmpDto;
use App\Http\Dtos\InternalTransfer\inputInternalTmpDto;
use  App\Http\Mappers\InternalTransfer\InputTmpMapper;
use  App\Http\Mappers\InternalTransfer\InputDtTmpMapper;
use  App\Http\Mappers\InternalTransfer\InputTmpOrigMapper;
use  App\Http\Mappers\GeneralMappers\OriginalToTmpDtMapper;
use  App\Http\Mappers\GeneralMappers\TmpToOriginalDtMapper;
use  App\Http\Mappers\GeneralMappers\TmpToOriginalMapper;

use App\Interfaces\InternalTransfer\InternalTransferInterface;


class InternalController extends ApiController
{
    protected $inputTmpMapper;
    protected $inputDtTmpMapper;
    protected $inputTmpOrigMapper;
    protected $originalToTmpDtMapper;
    protected $tmpToOriginalDtMapper;
    protected $tmpToOriginalMapper;
    protected  $internalTransferService;



    public function __construct(
        InternalTransferInterface $internalTransferService,
        InputTmpMapper $inputTmpMapper,
        InputDtTmpMapper $inputDtTmpMapper,
        InputTmpOrigMapper $inputTmpOrigMapper,
        OriginalToTmpDtMapper $originalToTmpDtMapper,
        TmpToOriginalDtMapper $tmpToOriginalDtMapper,
        TmpToOriginalMapper $tmpToOriginalMapper,
        //   InternalTransferInterface $internalTransferService,

    ) {
        $this->inputTmpMapper = $inputTmpMapper;
        $this->inputDtTmpMapper = $inputDtTmpMapper;
        $this->inputTmpOrigMapper = $inputTmpOrigMapper;
        $this->originalToTmpDtMapper = $originalToTmpDtMapper;
        $this->tmpToOriginalDtMapper = $tmpToOriginalDtMapper;
        $this->tmpToOriginalMapper = $tmpToOriginalMapper;
        $this->internalTransferService = $internalTransferService;
    }

    public function fetchRemainingGoodsInTransactions(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $fromClient = $request->fromClient;
        $transactionId = $request->transactionId;

        $transactions = transactions::join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactions.transaction_supplierId')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin')
            ->leftjoin('items', 'items.item_id', '=', 'transaction_dts.item_id')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactions.clientCustomer_id')
            ->select(
                'customer_name',
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'clients.client_firstname',
                'transactions.transaction_id',
                'transactions.transaction_mobileReference',
                'salesjv_id',
                'transactions.transaction_remark',
                'transactions.transaction_billOfEntry',
                'transactions.transaction_shipmentReference',
                'transactions.transaction_typeOfDeliveryId',
                'suppliers.supplier_name',
                'transactions.transaction_supplierInvoice',
                'transactions.transaction_type',
                'transaction_BOE',
                'Invoice_type_id',
                'payment_term_id',
                'delivery_term_id',
                'exemption_type_id',
                'transaction_dts.*',
                'item_code',
                'country_name',
                'internal_transfer',
                'item_quantity'
            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transactions.transaction_date, '%d-%m-%Y') AS transaction_formatdate"))
            ->where([
                ['transactions.transaction_type', 'GOODS_IN'],

            ])
            ->when($fromClient, function ($query) use ($fromClient) {
                return $query->where('transaction_clientId', $fromClient);
            })

            ->groupby('transactions.transaction_id')
            ->orderBy('transactions.transaction_date', 'desc')
            ->orderBy('transactions.transaction_reference', 'desc');

        if ($request->search) {
            $transactions->Where(function ($query) use ($request) {
                $query->Where([
                    ['transaction_reference', 'like', '%' . $request->search . '%']
                ]);
            });
        }
        $transactions = $transactions->get();



        $data = array();
        foreach ($transactions as $splitTrans) {
            $checkDt = DB::table('transaction_dts')
                ->where([
                    ['id_reference_dt', $splitTrans->transactiondt_id],
                    ['dt_transaction_type', '!=', 'DQ'],
                    ['transaction_id', '!=', $transactionId]

                ])
                ->SUM('item_quantity');
            $checkDtTmp = DB::table('transactiondttmps')
                ->where([
                    ['id_reference_dt', $splitTrans->transactiondt_id],
                    ['transactiontmp_id', $transactionId]

                ])
                ->SUM('item_quantity');

            $splitTrans->item_quantity = $splitTrans->item_quantity - $checkDt - $checkDtTmp;

            if ($splitTrans->transaction_type == 'GOODS_IN' && $splitTrans->internal_transfer == 1) {
                $splitTrans->transactionType = 'Internal';
            } else {
                $splitTrans->transactionType = '';
            }
            if ($splitTrans->item_quantity > 0) {
                array_push($data, $splitTrans);
            }
        }


        return ApiController::successResponse($data, 200);
    }




    public function addDOFromMultipleGoodsIn(Request $request)
    {
        $transactions = $request->transactions;
        $transactionTmpId = $request->transactionTmpId;
        $k = 0;
        $maxIndex = transactiondttmp::where(
            [
                ['transactiontmp_id', $transactionTmpId]
            ]
        )
            ->max('raw_in_grid');
            if ($maxIndex !== null) {
                $k = $maxIndex + 1;
            }
        foreach ($transactions as $transElement) {
            $transactionId = $transElement['transaction_id'];

            $Transaction = transactions::where(
                [
                    ['transaction_id', $transactionId],

                ]
            )
                ->first();




            $transactionsDtsOrignal = transactionDt::where(
                [
                    ['transaction_id', $transactionId]
                ]
            )
                ->get();



            foreach ($transactionsDtsOrignal as $Transactiondt) {
                if (!empty($Transactiondt)) {
                    $itemDetails = items::where(
                        [
                            ['item_id', $Transactiondt->item_id]
                        ]
                    )->first();

                    $totalEntry = transactionDt::where(
                        [
                            ['transactiondt_id', $Transactiondt->transactiondt_id]
                        ]
                    )
                        ->sum('item_quantity');

                    $totalExit = transactionDt::where(
                        [
                            ['id_reference_dt', $Transactiondt->transactiondt_id]
                        ]
                    )->sum('item_quantity');

                    $totalExitTmp = transactiondttmp::where(
                        [
                            ['id_reference_dt', $Transactiondt->transactiondt_id],
                            ['transactiontmp_id', $transactionTmpId]
                        ]
                    )->sum('item_quantity');

                    $totalEntry = isset($totalEntry) ? $totalEntry : 0;
                    $totalExit = isset($totalExit) ? $totalExit : 0;
                    $totalExitTmp = isset($totalExitTmp) ? $totalExitTmp : 0;
                    $total = $totalEntry - $totalExit - $totalExitTmp;
                    if ($total <= 0) continue;


                    $data = [
                        'transactionDetailItemCode' => $Transactiondt->item_id,
                        'transactionDetailItemWeight' => $Transactiondt->item_weight,
                        'itemGroup' => $itemDetails->group_id,
                        'itemPack' => $itemDetails->item_pack,
                        'itemQtyPerPack' => $itemDetails->item_qtyPerPack,
                        'transactionDetailHSCode' => $Transactiondt->hscode,
                        'transactionDetailItemDesc' =>  $Transactiondt->transactiondt_item_description,
                        'itemUnit' => $itemDetails->item_unit,
                        'transactionDetailItemQty' => $total,
                        'transactionDetailClientId' => $Transactiondt->client_id,
                        'transactionTmpId' => $transactionTmpId,
                        'idReferenceDt' =>  $Transactiondt->transactiondt_id,
                        'rawInGrid' => $k,
                        'transactiondttmp_id' => null,
                        'noOfCarton' => (isset($itemDetails->item_qtyPerPack) && $itemDetails->item_qtyPerPack > 0) ? ceil($total / $itemDetails->item_qtyPerPack) : 3,

                    ];
                    $request = new inputInternalDtTmpDto($data);
                    $this->internalTransferService->storeTransactionDtTmp($request);
                }
                $k = $k + 1;
            }
        }

        $transactions = transactiontmp::join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'desc')
            ->where([
                ['transactiontmp_id', $transactionTmpId],
            ])
            ->first();

        $transactions->transactiontmp_formatdate = date('Y-m-d', $transactions->transactiontmp_date);

        return ApiController::successResponse($transactions, 200);
    }

    public function fetchTransactions(Request $request)
    {
        $utilitiesController = new UtilitiesController();
        $internalService = new InternalServices();

        $payload = array();
        $payload['transactionType'] = $request->transactionType;
        $payload['dateFrom'] = $request->dateFrom;
        $payload['dateTo'] = $request->dateTo;
        $payload['skip'] = $request->skip;
        $payload['take'] = $request->take;
        $payload['searchKey'] = $request->search;

        return $internalService->fetchTransactionsService($payload);
    }



    public function removeOriginalTransaction(Request $request)
    {
        $user = auth()->user();
        $date = date('Y-m-d H:i:s');
        $utilitiesController = new UtilitiesController();
        $transactionId = $request->transactionId;
        $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionId)
            ->join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->first();

        if ($checkExsistance) {
            $type = "Internal Transfer";
            return ApiController::errorResponse($type . '  exists in drafts !(By : ' . $checkExsistance->user_name . ')', 422);
        }



        $relatedId = transactions::where('relatedTransferId', $transactionId)->first();


        $transactionDetailsTmp = DB::table('transactions')
            ->join('transaction_dts', 'transaction_dts.transaction_id', '=', 'transactions.transaction_id')
            ->select('transaction_dts.transactiondt_id')
            ->where([
                ['transaction_dts.transaction_id', '=', $transactionId],
            ])
            ->get();
        $transactionDttmpIds = $transactionDetailsTmp->pluck('transactiondt_id')->toArray();


        $checkValidity =  transactionDt::wherein('transaction_dts.reference_internal_dt', $transactionDttmpIds)
            ->join('transaction_dts as do', 'do.id_reference_dt', 'transaction_dts.transactiondt_id')
            ->select('transaction_dts.reference_internal_dt')
            ->get();



        if (count($checkValidity) == 0) {
            $getDtData = transactionDt::where([
                ['transaction_dts.transaction_id', '=', $request->transactionId],
            ])->get();

            $transactions = transactions::where('transaction_id', '=', $request->transactionId);
            $removeTransactions = $transactions->first()->toarray();
            $removeTransactions['user_modified'] = $user->id;
            $removeTransactions['date_modified'] = $date;


            $path = public_path() . '/documents/' . $removeTransactions['transaction_type'] . '/' . $request->transactionId . '/' . $request->file;

            if (file_exists($path)) {
                $deleteFile = File::deleteDirectory($path);
            }
            $deletedd = $transactions->first();


            $transactions = $transactions->delete();
            $transactionDtArray = null;


            $transferTrans = transactions::where('relatedTransferId', $request->transactionId)
                ->first();
            if ($transferTrans) {

                transactionDt::where('transaction_id', $transferTrans->transaction_id)->delete();
                transactions::where('transaction_id', $transferTrans->transaction_id)->delete();
            }


            return ApiController::successResponse($transactions, 200);
        }

        return ApiController::successResponse('unable to delete', 204);
    }


    public function returnFromOriginalToTmp(Request $request)
    {

        $loggerUser = auth()->user()->id;

        $realesed = transactions::where('transaction_id', '=', $request->transactionId)
            ->first();

        if ($realesed->transaction_released) {

            return ApiController::errorResponse("Already Released", 422);
        }


        $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionId)
            ->join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->first();


        if ($checkExsistance) {
            $type = "Goods In";
            if ($checkExsistance->transactiontmp_type == "DO") {
                $type = "Delivery Order";
            }

            return ApiController::errorResponse($type . ' already exists in drafts !(By : ' . $checkExsistance->user_name . ')', 422);
        }


        if (!$checkExsistance) {
            $originalTransaction = transactions::where('transaction_id', '=', $request->transactionId)
                ->join('users', 'users.id', '=', 'transactions.user_id')
                ->join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
                // ->leftjoin('client_customers','client_customers.customer_id','=','transactions.clientCustomer_id')
                // ->leftjoin('client_forwarders','client_forwarders.clientforwarder_id','=','transactions.forwarder_id')
                ->orderBy('transaction_date', 'asc')
                ->select('users.*', 'clients.*', 'transactions.*')
                ->first();
            //return Response()->json(["data"=>$originalTransaction],422);

            $transactionTmp = array(
                'transactiontmp_id' => $originalTransaction->transaction_id,
                'transaction_time' => $originalTransaction->transaction_time,
                'transactiontmp_date' => $originalTransaction->transaction_date,
                'transactiontmp_billOfEntry' => $originalTransaction->transaction_billOfEntry,
                'transactiontmp_clientId' => $originalTransaction->transaction_clientId,
                'transactiontmp_type' => $originalTransaction->transaction_type,
                'transactiontmp_remark' => $originalTransaction->transaction_remark,
                'transactiontmp_typeOfDeliveryId' => $originalTransaction->transaction_typeOfDeliveryId,
                'clientCustomer_id' => $originalTransaction->clientCustomer_id,
                'transactiontmp_shipmentReference' => $originalTransaction->transaction_shipmentReference,
                'transactiontmp_mobileReference' => $originalTransaction->transaction_mobileReference,
                'user_id' => $originalTransaction->user_id,
                //'forwarder_id'=> $originalTransaction->orderForwarder,

                'company_id' => $originalTransaction->company_id,
                'transactiontmp_currencyId' => $originalTransaction->transaction_currencyId,
                'transactiontmp_rate' => $originalTransaction->transaction_rate,
                'transactiontmp_driverName' => $originalTransaction->transaction_driverName,
                'transactiontmp_driverPhone' => $originalTransaction->transaction_driverPhone,
                'transactiontmp_vehicleNumber' => $originalTransaction->transaction_vehicleNumber,
                'transactiontmp_exitPoint' => $originalTransaction->transaction_exitPoint,
                'transactiontmp_destinationPoint' => $originalTransaction->transaction_destinationPoint,
                'transactiontmp_shipmentTypeId' => $originalTransaction->transaction_shipmentTypeId,
                'transactiontmp_paymentMethodId' => $originalTransaction->transaction_paymentMethodId,
                'transactiontmp_customBillTypeId' => $originalTransaction->transaction_customBillTypeId,
                'transactiontmp_shipById' => $originalTransaction->transaction_shipById,
                'transactiontmp_shipmentRemark' => $originalTransaction->transaction_shipmentRemark,
                'forwarder_id' => $originalTransaction->forwarder_id,
                'transactiontmp_supplierId' => $originalTransaction->transaction_supplierId,
                'transactiontmp_supplierInvoice' => $originalTransaction->transaction_supplierInvoice,
                'transactiontmp_reference' => $originalTransaction->transaction_reference,
                'transactiontmp_totalQty' => $originalTransaction->transaction_totalQty,
                'transactiontmp_totalPallet' => $originalTransaction->transaction_totalPallet,
                'transaction_totalPrice' => $originalTransaction->transaction_totalPrice,
                'transaction_totalItem' => $originalTransaction->transaction_totalItem,
                'transactiontmp_BOE' => $originalTransaction->transaction_BOE,
                'Invoice_type_id' => $originalTransaction->Invoice_type_id,
                'payment_term_id' => $originalTransaction->payment_term_id,
                'delivery_term_id' => $originalTransaction->delivery_term_id,
                'exemption_type_id' => $originalTransaction->exemption_type_id,
                'internal_transfer' => $originalTransaction->internal_transfer,
                'transferTo_clientId' => $originalTransaction->transferTo_clientId,
                'showInDocument' => $originalTransaction->showInDocument,
                'transaction_arrived' => $originalTransaction->transaction_arrived,
                'way_bill_no' => $originalTransaction->way_bill_no,
                'tir' => $originalTransaction->tir,
                'job_no' => $originalTransaction->job_no,
                'salesjv_discount' => $originalTransaction->salesjv_discount,



            );
            $newTransactionTmp = transactiontmp::create($transactionTmp);
            $newTransactionTmp->client_firstname = $originalTransaction->client_firstname;
            $newTransactionTmp->customer_name = $originalTransaction->customer_name;
            $newTransactionTmp->transactiontmp_clientId = $originalTransaction->transactiontmp_clientId;


            $originalTransactiondt = transactiondt::where('transaction_id', '=', $request->transactionId)->get();

            //$newTransactiondtTmp = transactiondttmp::create($originalTransactiondt);

            foreach ($originalTransactiondt as $data) {
                if ($originalTransaction->transaction_id && $data->transactiondt_id) {
                    $transactiondtTmp = array(
                        'transactiontmp_id' => $originalTransaction->transaction_id,
                        // 'transactiondttmp_price' => $originalTransaction->transactiondt_price,

                        'item_id' => $data->item_id,
                        'client_id' => $data->client_id,
                        'item_quantity' => $data->item_quantity,
                        'item_price' => $data->item_price,
                        'transactiondttmp_id' => $data->transactiondt_id,
                        'transactiontmpdt_billOfEntry' => $data->transactiondt_billOfEntry,
                        'transactiondttmp_countryOfOrigin' => $data->transactiondt_countryOfOrigin,
                        'transactiondttmp_price' => $data->transactiondt_price,
                        'transactiondttmp_priceBase' => $data->transactiondt_priceBase,
                        'id_reference_dt' => $data->id_reference_dt,
                        'raw_in_grid' => $data->raw_in_grid,

                        'supplier_id' => $data->supplier_id,
                        'supplier_invoice_number' => $data->supplier_invoice_number,
                        'transactiondttmp_locationid' => $data->transactiondt_locationid,
                        'item_weight' => $data->item_weight,
                        'item_unit' => $data->item_unit,

                        'item_qtyPerPack' => $data->item_qtyPerPack,
                        'item_pack' => $data->item_pack,
                        'group_id' => $data->group_id,
                        'palet_no' => $data->palet_no,
                        'transactiondttmp_nbOfCarton' => $data->transactiondt_nbOfCarton,
                        'transactiondttmp_cellMerge' => $data->transactiondt_cellMerge,
                        'transactiontmpdt_BOE' => $data->transactiondt_BOE,

                        'transactiondttmp_fprice' => $data->transactiondt_fprice,
                        'transactiondttmp_fpriceBase' => $data->transactiondt_fpriceBase,
                        'hscode' => $data->hscode,
                        'transactiondt_item_description' => $data->transactiondt_item_description,
                        'total_weight' => $data->total_weight,
                        'total_price' => $data->total_price,
                        'item_quantity_to_delivery' => $data->item_quantity_to_delivery,
                        'item_quantity_to_cancel' => $data->item_quantity_to_cancel,
                        'dt_transaction_type' => $data->dt_transaction_type,
                        'reference_from_do' => $data->reference_from_do,
                        'reference_internal_dt' => $data->reference_internal_dt,





                    );
                    $newTransactiondtTmp = transactiondttmp::create($transactiondtTmp);


                    $serials = transactionDtsn::where('transactiondt_id', '=', $newTransactiondtTmp->transactiondttmp_id)->get();

                    foreach ($serials as $data) {
                        $transactiondtSnTmp = array(
                            'transactiondttmp_id' => $data->transactiondt_id,
                            'transactiondtsntmp_id' => $data->transactiondtsn_id,
                            'item_id' => $data->item_id,
                            'transaction_item_serial' => $data->transaction_item_serial,

                        );
                        $newTransactionSnTmp = transactionDtSnTmp::create($transactiondtSnTmp);
                    }
                }
            }
            $palets = DB::table('transaction_palets')
                ->where([
                    ['transaction_id', $originalTransaction->transaction_id]
                ])
                ->get();
            foreach ($palets as $paletsTmp) {

                $palets = array(
                    'palet_no' => $paletsTmp->palet_no,
                    'palet_dimension' => $paletsTmp->palet_dimension,
                    'transactiontmp_id' => $paletsTmp->transaction_id,
                    'palet_weight' => $paletsTmp->palet_weight,
                    'palet_order' => $paletsTmp->palet_order,

                );
                TransactiontmpPalets::create($palets);
            }
            if ($newTransactionTmp->transactiontmp_date) {
                $newTransactionTmp->transactiontmp_formatdate = date('Y-m-d', $newTransactionTmp->transactiontmp_date);
            }

            $storageData = DB::table('client_storage_pallets')
                ->where('related_transaction_id', $request->transactionId)
                ->get();
            foreach ($storageData as $item) {
                $data = array(
                    'length' => $item->length,
                    'width' => $item->width,
                    'height' => $item->height,
                    'related_transaction_id' => $item->related_transaction_id,
                    'pallet_no' => $item->pallet_no,
                    'pallet_seq' => $item->pallet_seq,
                    'related_plan' => $item->related_plan,
                    'id' => $item->id,

                );
                DB::table('client_storage_pallets_tmp')
                    ->insert($data);
            }

            $updateTransactionTmp = transactiontmp::where('transactiontmp_id', $request->transactionId)
                ->update(['user_id' => $loggerUser]);


            ///tmp to resolve
            $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionId)
                ->join('users', 'users.id', '=', 'transactiontmps.user_id')
                ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
                ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
                ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
                ->orderBy('transactiontmp_date', 'asc')
                ->first();

            if ($checkExsistance->transactiontmp_date) {
                $checkExsistance->transactiontmp_formatdate = date('Y-m-d', $checkExsistance->transactiontmp_date);
            }

            $updateTransactionTmp = transactiontmp::where('transactiontmp_id', $request->transactionId)
                ->update(['user_id' => $loggerUser]);
            return ApiController::successResponse($checkExsistance, 200);
        }


        if ($checkExsistance->transactiontmp_date) {
            $checkExsistance->transactiontmp_formatdate = date('Y-m-d', $checkExsistance->transactiontmp_date);
        }


        $updateTransactionTmp = transactiontmp::where('transactiontmp_id', $request->transactionId)
            ->update(['user_id' => $loggerUser]);

        return ApiController::successResponse($checkExsistance, 200);
    }





    public function solveInternal(Request $request)
    {


        $transactionRef = $request->transactionRef;

        $transaction_id = transactions::where([
            ['transaction_reference', $transactionRef],
            ['internal_transfer', 1],
            ['transaction_type', 'GOODS_IN']
        ])->first();

        $relatedTransfer =  $transaction_id->relatedTransferId;


        $dts = transactionDt::where('transaction_id', $relatedTransfer)->get();


        foreach ($dts as $splitDts) {

            $splitDts->transaction_id = $transaction_id->transaction_id;
            $dtId = transactionDt::max('transactiondt_id') + 1;
            $splitDts->transactiondt_id = $dtId;
            DB::statement("ALTER TABLE transactiondttmps  AUTO_INCREMENT = $dtId");
            transactiondt::insert($splitDts->toArray());
        }
        return $dts;
    }








    public function returnToTmpTransaction(int $transactionId)
    {

        $loggerUser = auth()->user()->id;
        $commonServices = new CommonServices();
        $type = "Internal Transfer";

        $goodsInternal = transactions::where('relatedTransferId', '=', $transactionId)
            ->first();

        $entryTransactionId = $goodsInternal->transaction_id;
        if (!$entryTransactionId)
            return ApiController::errorResponse($type . 'Missing Data', 422);



        $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $transactionId)
            ->join('users', 'users.id', '=', 'transactiontmps.user_id')
            ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
            ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
            ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
            ->orderBy('transactiontmp_date', 'asc')
            ->first();


        if ($checkExsistance) {


            return ApiController::errorResponse($type . ' already exists in drafts !(By : ' . $checkExsistance->user_name . ')', 422);
        }

        if (!$goodsInternal) {
            return ApiController::errorResponse($type . 'Missing Data', 422);
        }
        if (!$checkExsistance) {

            $originalTransaction = $commonServices->returnHeaderOriginalToTmpService($transactionId);
            $originalTransactionGoodsIn = $commonServices->returnHeaderOriginalToTmpService($entryTransactionId);


            $originalTransactiondt = transactiondt::where('transaction_id', '=', $transactionId)
                ->orwhere('transaction_id', $entryTransactionId)
                ->get();
            //  $originalTransactiondtEntry = transactiondt::where('transaction_id', '=', $entryTransactionId->transaction_id)->get();


            //DO
            foreach ($originalTransactiondt as $data) {
                $input = $this->originalToTmpDtMapper->toArray($data);
                $newTransactiondtTmpGoodsIn = transactiondttmp::create($input);
            }





            ///tmp to resolve
            $checkExsistance = transactiontmp::where('transactiontmp_id', '=', $transactionId)
                ->join('users', 'users.id', '=', 'transactiontmps.user_id')
                ->join('clients', 'clients.client_id', '=', 'transactiontmps.transactiontmp_clientId')
                ->leftjoin('client_customers', 'client_customers.customer_id', '=', 'transactiontmps.clientCustomer_id')
                ->leftjoin('client_forwarders', 'client_forwarders.clientforwarder_id', '=', 'transactiontmps.forwarder_id')
                ->orderBy('transactiontmp_date', 'asc')
                ->first();

            if ($checkExsistance->transactiontmp_date) {
                $checkExsistance->transactiontmp_formatdate = date('Y-m-d', $checkExsistance->transactiontmp_date);
            }

            $updateTransactionTmp = transactiontmp::where('transactiontmp_id', $transactionId)
                ->orwhere('transactiontmp_id', $entryTransactionId)
                ->update(['user_id' => $loggerUser]);
            return ApiController::successResponse($checkExsistance, 200);
        }

        return ApiController::successResponse($checkExsistance, 200);
    }

    public function fetchInternalTransactionDetailsTmp(Request $request)
    {
        $transactionDetailsTmp = transactiondttmp::join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->leftjoin('suppliers', 'suppliers.supplier_id', '=', 'transactiondttmps.supplier_id')
            ->leftjoin('locations', 'locations.location_id', '=', 'transactiondttmps.transactiondttmp_locationid')
            ->leftjoin('countries', 'countries.country_id', '=', 'transactiondttmps.transactiondttmp_countryOfOrigin')
            ->select(
                'items.item_barcode',
                'suppliers.supplier_name',
                'transactiondttmps.item_quantity',
                'transactiondttmps.supplier_invoice_number',
                'transactiondttmps.group_id',
                'transactiondttmps.palet_no',
                'transactiondttmps.item_id',
                'transactiondttmps.supplier_id',
                'transactiondttmps.item_pack',
                'transactiondttmps.item_qtyPerPack',
                'transactiondttmps.transactiondttmp_nbOfCarton',

                'transactiontmp_id',
                'transactiondttmp_id',
                'items.item_code',
                'items.item_description',
                'transactiondttmps.transactiontmpdt_billOfEntry',
                'transactiondttmps.transactiondttmp_locationid',
                'transactiondttmps.transactiondttmp_countryOfOrigin',
                'items.item_hasSerial',
                'country_name',
                'transactiondttmps.item_weight',
                'transactiondttmps.transactiondttmp_price',
                'transactiondttmps.transactiondttmp_priceBase',
                'transactiondttmps.id_reference_dt',
                'transactiondttmps.raw_in_grid',
                'locations.location_id',
                'locations.location_name',
                'transactiondttmp_fprice',
                'hscode',
                'transactiondt_item_description',
                'transactiondttmps.total_price',
                'transactiondttmps.total_weight'
            )
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['state', '!=', 'deleted']
            ])
            ->get();


        $loggerUserCompany = auth()->user()->company_id;

        if ($loggerUserCompany) {
            $getClientItems = items::where([
                ['company_id', '=', $loggerUserCompany]
            ])
                ->get();
        }

        $data = array();
        $data['clientItems'] = $loggerUserCompany ? $getClientItems : null;
        $data['locations'] = location::get();

        $data['transactionDetailsTmp'] = $transactionDetailsTmp;


        return ApiController::successResponse($data, 200);
    }
    public function checkTransactionUpdateValidity(Request $request)
    {

        $transactionId = $request->transactionId;

        $goodsInTransaction = transactions::where('relatedTransferId', $transactionId)->first();


        $checkDO = transactionDt::where([
            //['transactiondt_billOfEntry', $billOfEntry],
            ['transaction_id', '=', $goodsInTransaction->transaction_id]
        ])
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->select('transaction_dts.*', 'items.item_code')
            ->get();


        if (count($checkDO) > 0) {
            return ApiController::errorResponse($checkDO, 422);
        }
        return ApiController::successResponse(true, 200);
    }


    public function fetchTransactionDetailsTmp(Request $request)
    {


        $transactionTmpId = $request->transactionTmpId;
        $relatedId = transactions::where('relatedTransferId', $transactionTmpId)->first();


        $transactionDetailsTmp = DB::table('transactiontmps')
            ->join('transactiondttmps', 'transactiondttmps.transactiontmp_id', '=', 'transactiontmps.transactiontmp_id')
            ->join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
            ->leftjoin('clients', 'clients.client_id', '=', 'transactiondttmps.client_id')
            ->select('transactiondttmp_id', 'item_quantity_to_delivery', 'item_quantity_to_cancel', 'clients.client_id', 'clients.client_firstname', 'transactiondttmps.raw_in_grid', 'transactiondttmps.transactiondttmp_price', 'transactiondttmps.group_id', 'transactiondttmps.palet_no', 'transactiondt_item_description as item_description', 'items.item_id', 'items.item_code', 'transactiondttmps.item_weight', 'transactiondttmps.item_qtyPerPack', 'transactiondttmps.item_pack', 'transactiondttmps.transactiondttmp_nbOfCarton', 'transactiondttmps.transactiondttmp_cellMerge', 'isMobile', 'transactiondttmps.item_unit', 'transactiondttmp_fprice', 'transactiondttmps.hscode', 'transactiondttmps.transactiondttmp_priceBase')
            ->selectRaw(' SUM(transactiondttmps.item_quantity) as item_quantity')
            ->selectRaw(' SUM(transactiondttmps.item_weight*transactiondttmps.item_quantity) as item_weight')
            ->groupBy('transactiondttmps.raw_in_grid', 'items.item_id')
            ->where([
                ['transactiondttmps.transactiontmp_id', '=', $transactionTmpId],
            ])
            ->get();
        $transactionDttmpIds = $transactionDetailsTmp->pluck('transactiondttmp_id')->toArray();

        //  foreach($transactionDetailsTmp as $split){

        $checkEntry =  transactionDt::wherein('transaction_dts.reference_internal_dt', $transactionDttmpIds)
            ->join('transaction_dts as do', 'do.id_reference_dt', 'transaction_dts.transactiondt_id')
            ->select('transaction_dts.reference_internal_dt')
            ->get();



        return ApiController::successResponse([
            'data' => $transactionDetailsTmp,
            'invalid' => $checkEntry
        ], 201);
    }







    public function createTransactionTmp(inputInternalTmpDto $request)
    {

        $utilitiesController = new UtilitiesController();
        $user = auth()->user();
        $company = companies::first();
        $currency = $company->currency;
        $companyId = $company->company_id;
        $input = $this->inputTmpMapper->toArray($request);
        $input['transactiontmp_date'] = $utilitiesController->convertTodayToTimetsamp($input['transactiontmp_date'] . "" . date('H:i:s'));
        $input['user_id'] =  $user->id;
        $input['transactiontmp_type'] = 'DO';
        $input['company_id'] = $companyId;
        $input['transactiontmp_currencyId'] = $currency;
        $input['transactiontmp_rate'] = 1;
        $input['internal_transfer'] = 1;

        if ($input['transactiontmp_id']) {

            try {
                DB::beginTransaction();
                $transactionTmpAfterUpdate = transactiontmp::where('transactiontmp_id', $input['transactiontmp_id'])
                    ->update([
                        'transactiontmp_remark' => $input['transactiontmp_remark'],
                        'transactiontmp_date' => $input['transactiontmp_date'],
                    ]);
                $transactionTmpAfterUpdateEntry = transactiontmp::where('relatedTransferId', $input['transactiontmp_id'])
                    ->update([
                        'transactiontmp_remark' => $input['transactiontmp_remark'],
                        'transactiontmp_date' => $input['transactiontmp_date'],
                    ]);
                DB::commit();
                if ($transactionTmpAfterUpdate && $transactionTmpAfterUpdateEntry) {
                    $response =  transactiontmp::where('transactiontmp_id', $input['transactiontmp_id'])->first();
                    return ApiController::successResponse($response, 200);
                }
                DB::rollBack();
                return ApiController::errorResponse($transactionTmpAfterUpdate, 422);
            } catch (Exception $e) {
                DB::rollBack();
                throw $e;
            }
        } else {
            try {
                DB::beginTransaction();
                $newTransactionTmp = transactiontmp::create($input);
                $input['relatedTransferId'] = $newTransactionTmp->transactiontmp_id;
                $input['transactiontmp_clientId'] = $newTransactionTmp->transferTo_clientId;
                $input['transferTo_clientId'] = null;
                $input['transactiontmp_type'] = 'GOODS_IN';
                transactiontmp::create($input);
                DB::commit();
                if ($newTransactionTmp) {
                    return ApiController::successResponse($newTransactionTmp, 200);
                }
                return ApiController::errorResponse($newTransactionTmp, 422);
            } catch (Exception $e) {
                DB::rollBack();
                throw $e;
            }
        }
    }


    public function storeTransactionDtTmp(inputInternalDtTmpDto $request)
    {

        $response = $this->internalTransferService->storeTransactionDtTmp($request);

        return ApiController::successResponse($response, 200);
    }

    public function updateTransactionDtTmp(Request $request)
    {
        $groupId = $request->transactionDetailItemGroup;
        $itemUnit = $request->transactionDetailItemUnit;

        //reference_internal_dt
        $transactionDtTmpsIdGet = DB::table('transactiondttmps')
            ->leftjoin('transactiondttmps as entry', 'entry.reference_internal_dt', 'transactiondttmps.transactiondttmp_id')
            ->where([
                ['transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId],
                ['transactiondttmps.raw_in_grid', '=', $request->raw_in_grid]
            ]);
        $transactionDtTmpsId = $transactionDtTmpsIdGet->update([
            'transactiondttmps.item_qtyPerPack' => $request->transactionTmpQtyPerPack,
            'entry.item_qtyPerPack' => $request->transactionTmpQtyPerPack,
            'transactiondttmps.item_pack' => $request->itemPack,
            'entry.item_pack' => $request->itemPack,
            'transactiondttmps.item_unit' => $itemUnit,
            'entry.item_unit' => $itemUnit,
            'transactiondttmps.transactiondttmp_nbOfCarton' => $request->noOfCarton,
            'entry.transactiondttmp_nbOfCarton' => $request->noOfCarton,
            'transactiondttmps.group_id' => $groupId,
            'entry.group_id' => $groupId,
            'transactiondttmps.palet_no' => $request->paletNo,
            'entry.palet_no' => $request->paletNo,
            'transactiondttmps.transactiondttmp_cellMerge' => $request->mergeOfCarton,
            'entry.transactiondttmp_cellMerge' => $request->mergeOfCarton,

        ]);

        return ApiController::successResponse($transactionDtTmpsId, 200);
    }

    public function insertNewTransaction(Request $request)
    {


        try {
            DB::beginTransaction();
            // retrieve the current transaction tmp
            $checkTransactionTmpExistance = transactiontmp::where('transactiontmp_id', '=', $request->transactionTmpId)
            ->leftjoin('clients','clients.client_id','transactiontmps.transactiontmp_clientId')
            ->select('transactiontmps.*','clients.client_firstName')
                ->first();

            $newTransaction = null;


            if ($checkTransactionTmpExistance) {
                //return ApiController::errorResponse($transactionDtsTmp,422);
                $sequenceNumber = sequence::getSequences($checkTransactionTmpExistance->transactiontmp_type, $checkTransactionTmpExistance->internal_transfer, $checkTransactionTmpExistance->transactiontmp_reference);

                if (!$sequenceNumber) {
                    $obj = array();
                    $obj['message'] = 'something error in sequence';
                    $obj['data'] = $sequenceNumber;
                    return ApiController::errorResponse($obj, 422);
                }
                $goodsInSequence = $checkTransactionTmpExistance->transactiontmp_reference ? $checkTransactionTmpExistance->transactiontmp_reference : $sequenceNumber;

                if ($checkTransactionTmpExistance && !$checkTransactionTmpExistance->transactiontmp_reference) {
                    DB::beginTransaction();
                    $input = $this->tmpToOriginalMapper->toArray($checkTransactionTmpExistance);
                    $input['transaction_reference'] = $goodsInSequence;
                    $newTransaction = transactions::create($input);
                    $utilitiesController = new UtilitiesController();
                    $utilitiesController->createErpProject($newTransaction->transaction_reference,'INTERNAL_TRANSFER',$checkTransactionTmpExistance->client_firstName,$checkTransactionTmpExistance->transactiontmp_id);

                    $transferTrans = transactiontmp::where('relatedTransferId', $newTransaction->transaction_id)
                        ->first();
                    $input = $this->tmpToOriginalMapper->toArray($transferTrans);
                    $input['transaction_reference'] = $goodsInSequence;
                    $newTransactionEntry = transactions::create($input);
                    DB::commit();
                } else {
                    DB::beginTransaction();
                    $input = $this->tmpToOriginalMapper->toArray($checkTransactionTmpExistance);
                    transactions::where('transaction_id', '=', $request->transactionId)->update($input);
                    $transferTrans = transactiontmp::where('relatedTransferId', $request->transactionId)
                        ->first();
                    $input = $this->tmpToOriginalMapper->toArray($transferTrans);
                    transactions::where('transaction_id', '=', $transferTrans->transactionId)->update($input);
                    $newTransaction = transactions::where('transaction_id', '=',  $request->transactionId)->first();

                    DB::commit();
                }




                // after saving and creation of transaction or update get tmp transaction dt into original and remove from tmp
                if ($newTransaction) {

                    // delete previous transactions dts
                    if ($request->transactionTmpId) {
                        $relatedId = transactions::where('relatedTransferId',  $request->transactionTmpId)->first();
                        transactiondt::where('transaction_id', '=', $request->transactionTmpId)->delete();
                        transactiondt::where('transaction_id', '=', $relatedId->transaction_id)->delete();
                    }
                    // retrieve the current transaction dt tmp
                    $transactionDtsTmp = transactiondttmp::join('items', 'items.item_id', '=', 'transactiondttmps.item_id')
                        ->select('transactiondttmps.*', 'items.item_hasSerial',)
                        ->where([
                            ['transactiontmp_id', '=', $request->transactionTmpId],
                            ['state', '!=', 'deleted']
                        ])
                        ->get();
                    if (count($transactionDtsTmp) == 0) {
                        DB::rollBack();
                        $invalid = array();
                        $invalid['message'] = 'Empty Details Found';
                        $invalid['data'] = [];
                        return ApiController::errorResponse($invalid, 422);
                    }
                    foreach ($transactionDtsTmp as $transactionDtTmp) {
                        DB::beginTransaction();
                        // if ($transactionDtTmp->item_quantity == 0) {
                        //     continue;
                        // }
                        $input = $this->tmpToOriginalDtMapper->toArray($transactionDtTmp);
                        $newTransactionDt = transactiondt::create($input);
                        $entryDt = transactiondttmp::where('reference_internal_dt', $transactionDtTmp->transactiondttmp_id)->first();
                        $input = $this->tmpToOriginalDtMapper->toArray($entryDt);
                        $newTransactionDtEntry = transactiondt::create($input);
                        $this->createClientItems($newTransactionDtEntry, $transactionDtTmp->client_id);
                        DB::commit();
                    }



                    if ($newTransaction) {

                        DB::beginTransaction();
                        transactiontmp::where('transactiontmp_id', $request->transactionTmpId)
                            ->orwhere('relatedTransferId', $request->transactionTmpId)
                            ->delete();
                        DB::commit();
                    }
                }
            }
            DB::commit();
            return ApiController::successResponse('success', 200);
        } catch (Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    public function createClientItems($transactionDtTmp, $clientId)
    {

        $getItemDetails = items::where('item_id', '=', $transactionDtTmp->item_id)->first();

        $checkIfItemExist = clientItem::where([
            ['item_id', '=', $getItemDetails->item_id],
            ['item_related_client_id', '=', $clientId]
        ])
            ->first();

        if (!$checkIfItemExist && $getItemDetails) {
            $itemArray = array(
                'item_id' => $getItemDetails->item_id,
                'item_code' => $getItemDetails->item_code,
                'item_description' => $getItemDetails->item_description,
                'item_barcode' => $getItemDetails->item_barcode,
                'item_related_client_id' => $clientId,
                'item_hasSerial' => $getItemDetails->item_hasSerial,
                'item_hscode' => $getItemDetails->item_hscode,
                'item_weight' => $getItemDetails->item_weight,
                'item_unit' => $getItemDetails->item_unit,
                'item_qtyPerPack' => $getItemDetails->item_qtyPerPack,
                'item_pack' => $getItemDetails->item_pack,
                'group_id' => $getItemDetails->group_id,
            );
            clientItem::create($itemArray);
        }
    }
    public function removeTransactionDtTmp(Request $request)
    {

        $transactionTmpId = $request->transactionTmpId;
        $relatedGoodsIn = transactiontmp::where('relatedTransferId', $transactionTmpId)->first();
        if (!$relatedGoodsIn) {
        }

        $goodsInId = $relatedGoodsIn->transaction_id;

        $transactionDtTmpsId = DB::table('transactiondttmps')
            ->select('transactiondttmp_id')
            ->where([
                ['transactiontmp_id', '=', $request->transactionTmpId],
                ['raw_in_grid', '=', $request->raw_in_grid]
            ])
            ->get();
        if (count($transactionDtTmpsId) > 0) {
            $transactionDt = transactiondttmp::where('transactiondttmps.transactiondttmp_id', '=', $transactionDtTmpsId[0]->transactiondttmp_id)
                ->first();
        } else {
            return ApiController::successResponse(1, 200);
        }



        foreach ($transactionDtTmpsId as $row) {

            transactiondttmp::where('transactiondttmp_id', '=', $row->transactiondttmp_id)->delete();
            transactiondttmp::where('reference_internal_dt', '=', $row->transactiondttmp_id)->delete();
        }

        if ($transactionDt) {
            $transactionDtSumQty = transactiondttmp::Where(function ($query) use ($request, $goodsInId) {
                $query->Where([
                    ['transactiondttmps.transactiontmp_id', '=', $request->transactionTmpId]

                ]);
            })

                ->select('transactiondttmps.item_quantity')
                ->selectRaw(' SUM(transactiondttmps.item_quantity) as totalQty')
                ->first();

            transactiontmp::Where(function ($query) use ($request, $goodsInId) {
                $query->Where([
                    ['transactiontmp_id', '=', $request->transactionTmpId]

                ])->orwhere(
                    [
                        ['transactiontmp_id', '=', $goodsInId],
                    ]
                );
            })
                ->update(["transactiontmp_totalQty" => $transactionDtSumQty->totalQty]);
        }

        $transactionDtTmpsId = DB::table('transactiondttmps')
            ->Where(function ($query) use ($request, $goodsInId) {
                $query->Where([
                    ['transactiontmp_id', '=', $request->transactionTmpId],
                    ['raw_in_grid', '>', $request->raw_in_grid]
                ])
                    ->orwhere(
                        [
                            ['transactiontmp_id', '=', $goodsInId],
                            ['raw_in_grid', '>', $request->raw_in_grid]
                        ]
                    );
            })->decrement('raw_in_grid');

        return ApiController::successResponse(1, 200);
    }


    public function solveInternalData()
    {
        $doTrans = transactions::leftjoin('transactions as g', 'g.relatedTransferId', 'transactions.transaction_id')
            ->where([
                ['transactions.transaction_type', 'DO'],
                ['transactions.internal_transfer', 1],

            ])
            ->select('transactions.transaction_reference', 'transactions.transaction_id', 'g.transaction_id as gTransaction')
            ->get();

        foreach ($doTrans as $split) {
            $doTrans =  $split->transaction_id;
            $gTrans =  $split->gTransaction;
            $doTransDt = transactionDt::where('transaction_id', $doTrans)->get();

            foreach ($doTransDt as $splitDt) {
                $gDt = transactionDt::where([
                    ['transaction_id', $gTrans],
                    ['item_quantity', $splitDt->item_quantity],
                    // ['supplier_id',$splitDt->supplier_id],
                    ['supplier_invoice_number', $splitDt->supplier_invoice_number],
                    ['group_id', $splitDt->group_id],
                    ['transactiondt_countryOfOrigin', $splitDt->transactiondt_countryOfOrigin],
                    //  ['transactiondt_billOfEntry',$splitDt->transactiondt_billOfEntry],
                    ['item_weight', $splitDt->item_weight],
                    ['reference_internal_dt', '=', null],
                ])->first();
                if (!$gDt) continue;
                // return $gDt ;

                transactionDt::where([
                    ['transactiondt_id', $gDt->transactiondt_id],

                ])->update([
                    'reference_internal_dt' => $splitDt->transactiondt_id,
                    'dt_transaction_type' => 'GOODS_IN'
                ]);
                //  return $gDt;
            }

            // return transactionDt::where('transaction_dts.transaction_id',$doTrans)
            // ->leftjoin('transaction_dts as g','g.reference_internal_dt','transaction_dts.transactiondt_id')
            // ->select('transaction_dts.transactiondt_id' ,'g.transactiondt_id as referecneGoodsIn',
            // 'transaction_dts.dt_transaction_type as dotype','g.dt_transaction_type as goodsType')
            // ->get();
            // return $doTransDt;
        }


        return $doTrans;
    }
}
