<?php

namespace App\Http\Controllers\BackOffice\Items;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Models\ItemGroup;
use App\Models\transactionDt;
use App\Models\transactiondttmp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class ItemGroupController extends ApiController
{
    public function insertNewGroup(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'groupCode' => 'required',
            'groupName' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }

        $company_id = JWTAuth::user()->company_id;
        $groupCodeExist = ItemGroup::where([
            ['group_code', $request->groupCode],

        ])
            ->first();

        if ($groupCodeExist) {
            return ApiController::errorResponse("Group Code already exists !", 409);
        }

        $itemsGroup = array(
            'group_code' => $request->groupCode,
            'group_name' => $request->groupName,
            'company_id' => $company_id,
            'group_itempack' => $request->groupItempack,
            'group_hscode' => $request->groupHsCode,
            'group_itemunit' => $request->groupItemunit,

        );

        $newItemGroup = ItemGroup::create($itemsGroup);

        if ($newItemGroup) {
            $itemsGroup['group_id'] = $newItemGroup->group_id;
            $itemsGroup['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('item_groups', $itemsGroup, 'Insert');
            return ApiController::successResponse($newItemGroup, 200);
        }
        return ApiController::errorResponse($newItemGroup, 422);
    }

    public function fetchGroups(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $groups = DB::table('item_groups')
            ->where([
                ['company_id', $company_id],
                ['isActive', true]
            ]);
        if ($request->searchValue) {

            $groups->Where(function ($query) use ($request) {
                $query->Where([
                    ['group_code', 'like', '%' . $request->searchValue . '%']
                ])
                    ->orWhere([
                        ['group_name', 'like', '%' . $request->searchValue . '%']
                    ])
                    ->orWhere([
                        ['group_hscode', 'like', '%' . $request->searchValue . '%']
                    ]);
            });
        }
        $groupsCount = count($groups->get());
        $groups = $groups->take($request->take)
            ->skip($request->skip)->get();

        $obj['count'] = $groupsCount;
        $obj['groups'] = $groups;
        return ApiController::successResponse($obj, 200);
    }

    public function updateGroup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'groupCode' => 'required',
            'groupName' => 'required',


        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $groups = array(
            'group_code' => $request->groupCode,
            'group_name' => $request->groupName,
            'group_itempack' => $request->groupItempack,
            'group_itemunit' => $request->groupItemunit,
            'group_hscode' => $request->groupHsCode,
        );

        $groupCodeExist = ItemGroup::where([
            ['group_code', $request->groupCode],
            ['group_id', '!=', $request->groupId]
        ])->get();

        if (count($groupCodeExist) > 0) {
            return ApiController::errorResponse("Code already exist", 409);
        }

        $updateGroups = ItemGroup::where('group_id', $request->groupId)->update($groups);

        if ($updateGroups) {
            $groups['group_id'] = $request->groupId;
            $groups['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('item_groups', $groups, 'Update');
            return ApiController::successResponse($updateGroups, 200);
        }
        return ApiController::errorResponse('no update', 200);
    }


    public function removeGroup(Request $request)
    {
        $checkGroupTransactions = transactiondt::where('group_id', $request->groupId)->first();
        $checkGroupTransactionsTmp = transactiondttmp::where('group_id', $request->groupId)->first();

        if ($checkGroupTransactions || $checkGroupTransactionsTmp) {


            return ApiController::successResponse('unable to delete', 204);
        } else {
            $groups = ItemGroup::where('group_id', $request->groupId);
            $historyController = new HistoryController();
            $deletegroups = $groups->first()->toArray();
            $deletegroups['group_id'] = $request->groupId;
            $deletegroups['user_modified'] = auth()->user()->id;
            $historyController->insertHistoryData('item_groups', $deletegroups, 'Delete');
            $deleteGroups = $groups->delete();

            if ($deleteGroups) {
                return ApiController::successResponse($deleteGroups, 200);
            }
        }

        return ApiController::errorResponse('no update', 200);
    }
}
