<?php

namespace App\Http\Controllers\BackOffice\Items;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Models\clientItem;
use App\Models\items;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;


class ItemsController extends ApiController
{


    public function fetchPalets(Request $request)
    {
        $Obj = array();
        $company_id = JWTAuth::user()->company_id;

        $palets = DB::table('transactiontmp_palets')
            ->where([
                ['transactiontmp_id', $request->transactionid]
            ])
            ->get();

        $transactionTmp = DB::table('transactiontmps')
            ->where([
                ['transactiontmp_id', $request->transactionid]
            ])
            ->first();


        $obj['palets'] = $palets;

        $obj['totalPallet'] = $transactionTmp->transactiontmp_totalPallet;
        $obj['showInDocument'] = $transactionTmp->showInDocument;

        return ApiController::successResponse($obj, 200);
    }

    public function insertNewPalet(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'palet_no' => 'required',
            'palet_dimension' => 'required',
            'transactiontmp_id' => 'required',
            'palet_weight' => 'required'


        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }


        $palets = array(
            'palet_no' => $request->palet_no,
            'palet_dimension' => $request->palet_dimension,
            'transactiontmp_id' => $request->transactiontmp_id,
            'palet_weight' => $request->palet_weight,
            'palet_order' => $request->palet_order,
        );

        $newPalets = null;
        if ($request->palettmp_id) {

            $checkPalet = TransactiontmpPalets::where([
                ['palet_no', $request->palet_no],
                ['transactiontmp_id', $request->transactiontmp_id],
                ['palettmp_id', '!=', $request->palettmp_id]

            ])
                ->first();

            if ($checkPalet) {
                return ApiController::errorResponse('pallet already exist', 422);
            }
            $newPalets = TransactiontmpPalets::where('palettmp_id', $request->palettmp_id)->update($palets);
        } else {
            $checkPalet = TransactiontmpPalets::where([
                ['palet_no', $request->palet_no],
                ['transactiontmp_id', $request->transactiontmp_id],

            ])
                ->first();

            if ($checkPalet) {
                return ApiController::errorResponse('pallet already exist', 422);
            }
            $newPalets = TransactiontmpPalets::create($palets);
        }


        $palets = DB::table('transactiontmp_palets')
            ->where([
                ['transactiontmp_id', $request->transactiontmp_id]
            ])
            ->get();


        $transactionTmp = DB::table('transactiontmps')
            ->where([
                ['transactiontmp_id', $request->transactiontmp_id]
            ])
            ->first();


        $obj['palets'] = $palets;
        $obj['totalPallet'] = $transactionTmp->transactiontmp_totalPallet;
        return ApiController::successResponse($obj, 200);
    }

    public function removePalet(Request $request)
    {

        $deletePalets = TransactiontmpPalets::where('palettmp_id', $request->paletId)->delete();

        if ($deletePalets) {
            return ApiController::successResponse($deletePalets, 200);
        }
        return ApiController::errorResponse('no items deleted', 200);
    }


    public function fetchItems(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $Obj = array();


        $clientItems = items::where([
            ['item_isActive', '=', true]
        ])
            ->leftjoin('item_groups', 'item_groups.group_id', 'items.group_id');
        if ($request->searchValue) {
            $clientItems->Where(function ($query) use ($request) {
                $query->Where([
                    ['item_code', 'like', '%' . $request->searchValue . '%']
                ])
                    ->orWhere([
                        ['item_hscode', 'like', '%' . $request->searchValue . '%']
                    ]);
            });
        }
        $clientItemsCount = count($clientItems->get());
        if (isset($request->take) && isset($request->skip)) {
            $clientItems = $clientItems
                ->take($request->take)
                ->skip($request->skip);
        }
        $clientItems = $clientItems
            ->get();
        $obj['count'] = $clientItemsCount;
        $obj['clientItems'] = $clientItems;
        return ApiController::successResponse($obj, 200);
    }

    public function insertItem(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $validator = Validator::make($request->all(), [
            'itemCode' => 'required',
            'itemHsCode' => 'required',
        ]);

        if ($validator->fails()) {
            return ApiController::errorResponse($validator->errors(), 422);
        }
        $clientItem = array(
            'item_code' => $request->itemCode,
            'item_barcode' => $request->itemBarcode,
            'item_hscode' => $request->itemHsCode,
            'item_description' => $request->itemDescription,
            'item_hasSerial' => $request->itemHasSerial,
            'item_weight' => $request->itemWeight,
            'item_unit' => $request->itemUnit,
            'item_pack' => $request->itemPack == null || $request->itemPack == ''  ? "-" : $request->itemPack,
            'company_id' => $company_id,
            'item_qtyPerPack' => $request->itemQuantityPerPack,
            'group_id' => $request->groupId,
            'item_unDependentPrice' => $request->itemOpenPrice,
            'serial_type_id' => $request->serialTypes,
            'item_width' => $request->itemWidth,
            'item_height' => $request->itemHeight,
            'item_length' => $request->itemLength,
            'item_cbm' => $request->itemCBM,
        );
        return $this->insertItemFunction($clientItem, $request->itemCode, $request->itemBarcode);
    }

    public function insertItemFunction($clientItem, $itemCode, $itemBarcode, $isLoader = false)
    {
        $itemCodeExist = items::where([
            ['item_code', $itemCode],
        ])->get();
        if (count($itemCodeExist) > 0) {
            return ApiController::errorResponse("Code already exist", 409);
        }
        $itemBarcodeExist = items::where([
            ['item_barcode', $itemBarcode],
            ['item_barcode', '!=', null],
        ])->get();
        if (count($itemBarcodeExist) > 0) {
            return ApiController::errorResponse("Barcode already exist", 409);
        }


        $newClientItem = items::create($clientItem);

        if ($newClientItem && !$isLoader) {
            $clientItem['item_id'] = $newClientItem->id;
            $clientItem['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('items', $clientItem, 'Insert');
            return ApiController::successResponse($newClientItem, 200);
        }
        return ApiController::successResponse($newClientItem, 200);
    }

    public function updateClientItem(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'itemCode' => 'required',
            'itemBarcode' => 'required',
            'itemHsCode' => 'required',
            'itemHasSerial' => 'required',
            'itemPack' => 'required',
            'itemQuantityPerPack' => 'required',
            'itemWeight' => 'required',
        ]);

        $clientItem = array(
            'item_code' => $request->itemCode,
            'item_barcode' => $request->itemBarcode,
            'item_hscode' => $request->itemHsCode,
            'item_description' => $request->itemDescription,
            'item_hasSerial' => $request->itemHasSerial,
            'item_weight' => $request->itemWeight,
            'item_pack' => $request->itemPack,
            'item_unit' => $request->itemUnit,

            'item_qtyPerPack' => $request->itemQuantityPerPack,
            'group_id' => $request->groupId,
            'item_unDependentPrice' => $request->itemOpenPrice,
            'serial_type_id' => $request->serialTypes,
            'item_width' => $request->itemWidth,
            'item_height' => $request->itemHeight,
            'item_length' => $request->itemLength,
            'item_cbm' => $request->itemCBM,

        );
        $itemCodeExist = items::where([
            ['item_code', $request->itemCode],
            ['item_id', '!=', $request->clientItemId]
        ])->get();

        if (count($itemCodeExist) > 0) {
            return ApiController::errorResponse("Code already exist", 409);
        }
        $itemBarcodeExist = items::where([
            ['item_barcode', $request->itemBarcode],
            ['item_id', '!=', $request->clientItemId],
            ['item_barcode', '!=', null],
        ])
            ->get();
        if (count($itemBarcodeExist) > 0) {
            return ApiController::errorResponse("Barcode already exist", 409);
        }


        $updateItem = items::where('item_id', $request->clientItemId)->update($clientItem);

        $updateClientItem = clientItem::where('item_id', $request->clientItemId)->update($clientItem);

        if ($updateItem) {
            $clientItem['item_id'] = $request->clientItemId;
            $clientItem['user_modified'] = auth()->user()->id;
            $historyController = new HistoryController();
            $historyController->insertHistoryData('items', $clientItem, 'Update');
            return ApiController::successResponse($updateClientItem, 200);
        }

        return ApiController::errorResponse($updateItem, 204);
    }

    function removeItem(Request $request)
    {

        $itemCode = items::where('item_id', $request->itemId)
            ->first();
        if ($itemCode->item_unit == null) {
            $itemCode->item_unit = 'u';
        }

        if ($itemCode) {
            $checkItemTransactions = items::join('transaction_dts', 'transaction_dts.item_id', 'items.item_id')
                ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id',)
                ->where([
                    ['transaction_type', 'GOODS_IN'],
                    ['transaction_dts.item_id', $request->itemId]
                ])
                ->first();
            $checkItemTransactionstmp = items::join('transactiondttmps', 'transactiondttmps.item_id', 'items.item_id')
                ->join('transactiontmps', 'transactiontmps.transactiontmp_id', 'transactiondttmps.transactiontmp_id',)
                ->where([
                    ['transactiontmp_type', 'GOODS_IN'],
                    ['transactiondttmps.item_id', $request->itemId]

                ])
                ->first();
            if ($checkItemTransactions || $checkItemTransactionstmp) {
                return ApiController::successResponse('unable to delete', 204);
            } else {

                $historyController = new HistoryController();
                $deleteItem = $itemCode->toArray();
                $deleteItem['item_id'] = $request->itemId;
                $deleteItem['user_modified'] = auth()->user()->id;
                $historyController->insertHistoryData('items', $deleteItem, 'Delete');
                items::where('item_id', $request->itemId)->delete();
                clientItem::where([
                    ['item_code', $itemCode->item_code],
                ])->delete();
                return ApiController::successResponse('Item successfully deleted', 200);
            }
        }
    }


    function updateTotalPallet(Request $request)
    {
        $transactionTmp = DB::table('transactiontmps')
            ->where([
                ['transactiontmp_id', $request->transactiontmpId]
            ])
            ->update([
                "transactiontmp_totalPallet" => $request->totalPallet,
                "showInDocument" => $request->showInDocument
            ]);


        return ApiController::successResponse($transactionTmp, 200);
    }

    function importItems(Request $request)
    {
        $records = $request->data;
        $invalidItems = array();


        for ($i = 1; $i < count($records); $i++) {

            $record = $records[$i];
            if (count($record) == 0) continue;

            $itemCode = trim($record[0]);
            $itemDescription = trim($record[1]);
            $itemHsCode = trim($record[2]);
            $unit = trim($record[4]) ?? 'u';
            $weight = isset($record[8]) ? trim($record[8]) : 0;
            $itemBarcode = isset($record[8]) ? trim($record[8]) : null;
            $item_hasSerial = trim($record[3]);
            $qtyPerPack = is_numeric(trim($record[5])) ? trim($record[5]) : 1;
            $pack = trim($record[6]);
            $groupCode = trim($record[7]);

            $group = DB::table('item_groups')
                ->where([
                    ['group_code', $groupCode]
                ])
                ->orwhere([
                    ['group_hscode', $groupCode]
                ])
                ->first();





            $record = array();
            if (!$group && !$itemHsCode) {
                $record['item'] = $itemCode;
                $record['group'] = $groupCode;
                $record['hscode'] = $itemHsCode;
                $record['message'] = 'Invalid Group and Hscode';
                array_push($invalidItems, $record);
                continue;
            } else if (!$group) {
                $record['item'] = $itemCode;
                $record['group'] = $groupCode;
                $record['hscode'] = $itemHsCode;
                $record['message'] = 'Invalid Group';

                array_push($invalidItems, $record);
                continue;
            } else if (!$itemHsCode) {
                $record['item'] = $itemCode;
                $record['group'] = $groupCode;
                $record['hscode'] = $itemHsCode;
                $record['message'] = 'Invalid Hscode';
                array_push($invalidItems, $record);
                continue;
            }
            $groupId = $group->group_id;



            $clientItem = array(
                'item_code' => $itemCode,
                'item_barcode' => $itemBarcode,
                'item_hscode' => $itemHsCode,
                'item_description' => $itemDescription,
                'item_hasSerial' => $item_hasSerial,
                'item_weight' => $weight,
                'item_unit' => $unit,
                'item_pack' => $pack,
                'company_id' => 1,
                'item_qtyPerPack' => $qtyPerPack,
                'group_id' => $groupId,
                'item_unDependentPrice' => 0,
                'serial_type_id' => 1
            );

            $this->insertItemFunction($clientItem, $itemCode, $itemBarcode, true);
        }

        $obj = array();
        $obj['invalidData'] = $invalidItems;
        return ApiController::successResponse($obj, 200);
    }
}
