<?php

namespace App\Http\Controllers\BackOffice\Notifications;

use App\enums\NotificationTopics;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\notifications;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use JWTAuth;
use Illuminate\Support\Str;

class NotificationsController extends ApiController
{
    public function fetchNotificationsCount(Request $request)
    {
        $userId = auth()->user()->id;
        $count = DB::table('notifications')
            ->where([
                ['notification_seen', '=', 0],
                ['notifications.notification_related_userid', '=', $userId],
            ])
            ->groupBy('trans_id','notification_related_userid','notification_description')
            ->get();
        return ApiController::successResponse(count($count), 200);
    }



    public function fetchNotifications(Request $request)
    {
        $userId = auth()->user()->id;
        $notifications = DB::table('notifications')
            ->select(
                'notifications.notification_title',
                'notifications.notification_id',
                'notifications.notification_description',
                'notifications.notification_seen',
                'trans_id',
                'notification_code','notification_related_userid'
            )
            ->where([
                ['notifications.notification_related_userid', '=', $userId],
                //['notification_seen','=',$request->status]
            ]);
        if ($request->status) {
            $notifications->where([
                ['notification_seen', '=', $request->status]
            ]);
        }
        $notifications = $notifications->orderBy('notification_date', 'desc')
        ->groupBy('trans_id','notification_related_userid','notification_description');
        $notifications = $notifications->selectRaw("DATE_FORMAT(notification_date, '%d-%M-%Y %H:%m') as notification_date_view");
        $notifications = $notifications->get();

        $allNotifications = DB::table('notifications')
            ->where([
                ['notifications.notification_related_userid', '=', $userId],
                //['notification_seen','=',$request->status]
            ]);
        if ($request->status) {
            $allNotifications->where([
                ['notification_seen', '=', $request->status]
            ]);
        }
        $allNotifications = $allNotifications->count();

        $data = array();
        $data['notifications'] = $notifications;
        $data['allNotifications'] = $allNotifications;

        return ApiController::successResponse($data, 200);
    }

    public function updateNotificationsAsRead(Request $request)
    {
        $userId = auth()->user()->id;

        $notificationId = $request->notificationId;
        $updateNotification = notifications::when($notificationId, function ($query) use ($notificationId) {
                return $query->where('notification_id',  $notificationId);
            })
            ->where([
                ['notifications.notification_related_userid', '=', $userId],

            ])
            ->update([
                "notification_seen" => true
            ]);
        return ApiController::successResponse($updateNotification, 200);
    }

    




    public function fetchCustomUserNotificationRoles(Request $request)
    {
        $userPermissions = DB::table('users')
            ->where([
                ['id', '=', $request->userId],
                ['notification_topics', '!=', 'null']
            ])
            ->first();
        if ($userPermissions) {
            $topics = json_decode($userPermissions->notification_topics);
            return ApiController::successResponse($topics, 200);
        }
        return ApiController::successResponse([], 200);
    }


    public function insertCustomNotificationByUser(Request $request)
    {

        $requestContent = array();
        $requestContent = json_decode($request->getContent(), true);
        $userPermissions = $requestContent['userPermissions']; // insert update delete view
        $user = $requestContent['user']; // user id
        if ($userPermissions) {
            DB::table('users')
                ->where([
                    ['id', '=', $user]
                ])
                ->update([
                    'notification_topics' => json_encode($userPermissions),
                ]);
            return ApiController::successResponse($userPermissions, 200);
        }
        return ApiController::errorResponse("Invalid request", 422);
    }


    public function sendNotificationsByTopic($userId, $notificationTopic, $transactionId, $reference = '')
    {
        $utilitiesController = new UtilitiesController();
        $userPermissions = DB::table('users')
            ->where([
                  ['id','!=',$userId],
                  ['user_pushToken','!=','']
            ])
            ->whereNotNull('user_pushToken')
            ->whereRaw("JSON_CONTAINS(notification_topics, '\"$notificationTopic\"')")
            ->get();

        foreach ($userPermissions as $user) {
            $utilitiesController->sendCustomNotification($user, $notificationTopic, $transactionId, $reference);
        }
    }

    public function updateNotificationToken(Request $request){
        $userId = auth()->user()->id;
        $notificationToken = $request->notificationToken;
        $updateNotification =DB::table('users')
        ->where([
            ['id', '=', $userId]
        ])
        ->update([
            'user_pushToken' =>$notificationToken,
        ]);
        return ApiController::successResponse($updateNotification, 200);

    }
}
