<?php

namespace App\Http\Controllers\BackOffice\Reports;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\Localization;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use JWTAuth;
use PDF;

class InventoryController extends ApiController
{

    public function printInventoryReport(Request $request)
    {

        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '500');
        ini_set("pcre.backtrack_limit", "5000000");

        $reportData=$this->inventoryReportData1($request);
        $dataTransaction = $reportData->getData();

        if ($dataTransaction->code == 204) {
            return '';
        }
        if ($reportData->status() == 422) {
            return ApiController::successResponse("No data", 200);
        }


        if ($dataTransaction->data->clientGroup == 'byGroup') {
            $collection = collect($dataTransaction->data->data);

            $grouped = $collection->groupBy('transaction_clientId')->map(function ($transactions, $clientId) {
                $clientName = $transactions->pluck('client_firstName')->unique()->implode(', ');
                return [
                    'clientId' => $clientId,
                    'clientName' => $clientName,
                    'items' => $transactions,
                ];
            })->values();

            $dataTransaction->data->data = $grouped;
        }

        $reportPath = "Inventory_report";
        if ($dataTransaction->data->isShipment == 1) {
            $reportPath = "/shipment/Inventory_report";
        }
        $pdf = PDF::loadView($reportPath, (array)$dataTransaction->data);

        return $pdf->stream('Inventory_report.pdf');
    }


    public function fetchInventoryReport(Request $request)
    {
        $UtilitiesController = new UtilitiesController();
        $params = array();
        $params['dateFromTimeStamp'] = $UtilitiesController->convertTodayToTimetsamp($request->transactionFromDate . "00:00:00");
        $params['dateToTimeStamp'] = $UtilitiesController->convertTodayToTimetsamp($request->transactionToDate . "23:59:59");
        $params['DEC'] = $request->decNo;
        $params['BOE'] = $request->boeNo;
        $params['GroupByClient'] = $request->clientGroup;
        $params['clientId'] = $request->clientId;
        $params['transactionBillOfEntry'] = $request->transactionBillOfEntry;
        $params['navigationTypeEntry'] = 'GOODS_IN';
        $params['navigationTypeOUT'] = 'DO';
        $params['transactionBOE'] = $request->transactionBOE;
        $params['withZero'] = $request->withZero;
        $params['supplierId'] = $request->supplierId;
        if ($request->navigationType == 'rma') {
            $params['navigationTypeEntry'] = 'RMA_IN';
            $params['navigationTypeOUT'] = 'RMA_OUT';
        }

        $items = $this->getInventoryData($params);
        return ApiController::successResponse($items, 200);
    }
    public function inventoryReportData1(Request $request)
    {

        $Obj = array();
        $UtilitiesController = new UtilitiesController();
        $requestData = $UtilitiesController->decipherRequest($request->transactionDataId);

        if (!$requestData) {
            return ApiController::errorResponse('unreachable pdf detected', 204);
        }
        $requestData = json_decode($requestData);
        $params = array();
        $requestData = $requestData->info;
        $params['dateFromTimeStamp'] = $UtilitiesController->convertTodayToTimetsamp($requestData->transactionFromDate . "00:00:00");
        $params['dateToTimeStamp'] = $UtilitiesController->convertTodayToTimetsamp($requestData->transactionToDate . "23:59:59");
        $params['DEC'] = $requestData->decNo;
        $params['currency'] = $requestData->currency;
        $params['supplierId'] = $requestData->supplierId;
        $params['BOE'] = $requestData->boeNo;
        $params['GroupByClient'] = $requestData->clientGroup;
        $params['clientId'] = $requestData->clientId;
        $params['transactionBillOfEntry'] = isset($requestData->transactionBillOfEntry) ? $requestData->transactionBillOfEntry : null;
        $params['company'] = DB::table('companies')
            ->first();
        $moduleKeys = Localization::moduleKeys; // Assuming this is an array of keys

        $params['navigationTypeEntry'] = 'GOODS_IN';
        $params['navigationTypeOUT'] = 'DO';
        $params['withCurrency'] = $requestData->withCurrencyBase;
        $params['transactionBOE'] = isset($requestData->transactionBOE) ? $requestData->transactionBOE : null;
        $params['withZero'] = $requestData->withZero;
        if ($requestData->navigationType == 'rma') {
            $params['navigationTypeEntry'] = 'RMA_IN';
            $params['navigationTypeOUT'] = 'RMA_OUT';
        }

        $inventoryData = $this->getInventoryData($params);

        //  return ApiController::successResponse($params, 200);


        $withZero = $requestData->withZero;
        $clientGroup = $requestData->clientGroup;
        $decNo = $requestData->decNo;
        $boeNo = $requestData->boeNo;
        $clientId = $requestData->clientId;
        $transactionFromDate = $requestData->transactionFromDate;
        $transactionToDate = $requestData->transactionToDate;
        $withCurrencyBase = $requestData->withCurrencyBase;
        $Obj['supplierId'] = $requestData->supplierId;
        $Obj['clientGroup'] = 'groupByClient';
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['decNo'] = $decNo;
        $Obj['currency'] = $requestData->currency;
        $Obj['language'] = $requestData->language;
        $Obj['withZero'] = $withZero;
        $Obj['data'] = $inventoryData;
        $Obj['from'] = $transactionFromDate;
        $Obj['to'] = $transactionToDate;
        $Obj['withCurrencyBase'] = $withCurrencyBase;
        $Obj['boeNo'] = $boeNo;
        $Obj['company'] = DB::table('companies')->first();
        $Obj['isShipment'] = $Obj['company']->company_onlyShipment;

        if ($clientGroup == 'groupByClient' && $decNo === true) {
            $Obj['clientGroup'] = 'byGroup';
        } else if ($clientGroup == 'withoutGroupByClient' && $decNo === false) {
            $Obj['clientGroup'] = 'withoutGroup';
        }
      

        if ($clientId == 'all' || $clientId == '') {
            $Obj['client'] = 'All';
        } else {
            $clientName = DB::table('clients')
                ->select('client_firstname')
                ->where('client_id', $clientId)->first();
            $Obj['client'] = $clientName->client_firstname;
        }
        if ($clientGroup == 'withoutGroupByClient') {
            $Obj['clientGroup'] = 'withoutGroup';
        } else {
            $Obj['clientGroup'] = 'byGroup';
        }


        return ApiController::successResponse($Obj, 200);
    }
    public function getInventoryData($params)
    {


        $dateFromTimeStamp = $params['dateFromTimeStamp'];
        $dateToTimeStamp = $params['dateToTimeStamp'];
        $DEC = $params['DEC'];
        $BOE = $params['BOE'];
        $withZero = $params['withZero'];
        $GroupByClient = $params['GroupByClient'];
        $clientId = $params['clientId'];
        $navigationTypeEntry = $params['navigationTypeEntry'];
        $navigationTypeOUT = $params['navigationTypeOUT'];
        $transactionBillOfEntry = $params['transactionBillOfEntry'];
        $transactionBOE = $params['transactionBOE'];
        $supplier = $params['supplierId'];

        Log::info('DEC', [
            'DEC' => $DEC
        ]);
        $items = DB::table('transaction_dts')
            ->join('transactions', 'transactions.transaction_id', 'transaction_dts.transaction_id')
            ->join('items', 'items.item_id', 'transaction_dts.item_id')
            ->join('clients', 'clients.client_id', 'transaction_dts.client_id')
            ->leftjoin('transaction_dts as forRef', 'forRef.transactiondt_id', 'transaction_dts.id_reference_dt')
            ->leftjoin('suppliers', 'suppliers.supplier_id', 'transaction_dts.supplier_id')
            ->where(function ($query) use ($navigationTypeEntry, $navigationTypeOUT) {
                $query->Where([
                    ['transaction_type', $navigationTypeEntry]
                ])
                    ->orwhere(
                        [
                            ['transaction_type', $navigationTypeOUT]
                        ]
                    );
            })
            ->when($DEC === true, function ($query) use ($transactionBillOfEntry) {
                return $query->groupBy('transaction_dts.item_id', 'transaction_dts.transactiondt_billOfEntry')
                    ->when($transactionBillOfEntry, function ($query) use ($transactionBillOfEntry) {
                        return $query->where('transaction_dts.transactiondt_billOfEntry', $transactionBillOfEntry);
                    });
            })
            ->when($BOE == true, function ($query) use ($transactionBOE) {
                return $query->groupBy('transaction_dts.transactiondt_BOE')
                    ->when($transactionBOE != '', function ($query) use ($transactionBOE) {
                        return $query->where('transaction_dts.transactiondt_BOE', $transactionBOE);
                    });
            })
            ->when($GroupByClient == 'groupByClient', function ($query) {
                return $query->groupBy('transaction_dts.item_id', 'transaction_dts.client_id',);
            })
            ->when($GroupByClient != 'groupByClient', function ($query) {
                return $query->groupBy('transaction_dts.item_id', 'transaction_dts.client_id',);
                //  return $query->where('intrenal_transfer', 0);
            })
            ->when($clientId != 'all', function ($query) use ($clientId) {
                return $query->where('transaction_dts.client_id', $clientId);
            })
            ->when($supplier != 'all' && $supplier != '', function ($query) use ($supplier) {
                return $query->where('transaction_dts.supplier_id', $supplier);
            })
            ->select(
                'items.item_id',
                'items.item_description as itemDescription',
                'transaction_dts.transactiondt_BOE',
                'transaction_dts.transactiondt_id',
                'transaction_dts.transactiondt_billOfEntry',
                'transaction_clientId',
                'client_firstName',
                'transaction_dts.item_quantity',
                'item_code',
                'items.item_hscode',
                'transaction_date',
                'transaction_dts.supplier_id',
                'transaction_supplierId',
                'supplier_name',
                'transaction_dts.transactiondt_item_description as goodsDescription'

            )
            ->groupBy('transaction_dts.item_id')
            ->selectRaw("SUM(CASE WHEN (transaction_type = '" . $navigationTypeEntry . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (transaction_dts.item_quantity) END ) as qtyIn,SUM(CASE WHEN (transaction_type = '" . $navigationTypeEntry . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (transaction_dts.transactiondt_priceBase* transaction_dts.item_quantity) END ) as transactiondt_priceBase,SUM(CASE WHEN (transaction_type = '" . $navigationTypeEntry . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (transaction_dts.item_weight* transaction_dts.item_quantity) END ) as transactiondt_weight,
            SUM(CASE WHEN (transaction_type = '" . $navigationTypeOUT . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (transaction_dts.item_quantity) END ) as qtyOut,SUM(CASE WHEN (transaction_type = '" . $navigationTypeOUT . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (forRef.transactiondt_priceBase* transaction_dts.item_quantity) END ) as transactiondt_priceBaseOut,
            SUM(CASE WHEN (transaction_type = '" . $navigationTypeOUT . "' and transaction_date BETWEEN  '" . $dateFromTimeStamp . "' and '" . $dateToTimeStamp . "')
            THEN  (transaction_dts.item_weight* transaction_dts.item_quantity) END ) as transactiondt_WeightOut
        ")
            ->selectRaw("SUM(
            CASE WHEN (transaction_type = '" . $navigationTypeEntry . "' and transaction_date <=  '" . $dateFromTimeStamp . "' )
            THEN  (transaction_dts.item_quantity)
            ELSE (
                CASE WHEN (transaction_type = '" . $navigationTypeOUT . "'and transaction_date <=  '" . $dateFromTimeStamp . "' )
                THEN  (-transaction_dts.item_quantity)
                ELSE (0) END
                ) END
            )
            AS prevQty
        ")

            ->get();

        $filterItems = array();
        foreach ($items as $checkData) {

            if ($checkData->qtyIn == null) {
                $checkData->qtyIn = 0;
            }
            if ($checkData->qtyOut == null) {
                $checkData->qtyOut = 0;
            }
            $checkData->totalQuantityAvailable = ($checkData->prevQty) + $checkData->qtyIn - $checkData->qtyOut;

            $checkData->QInCostUnit = 0;
            $checkData->totalCost = 0;
            $checkData->finalTotalCost = 0;
            $checkData->Totalweight = 0;
            if ($checkData->totalQuantityAvailable != 0) {

                if ($checkData->qtyIn != 0) {
                    $checkData->QInCostUnit = $checkData->transactiondt_priceBase / $checkData->qtyIn;
                }

                // unit cost
                $unitCost = ($checkData->transactiondt_priceBase - $checkData->transactiondt_priceBaseOut) / ($checkData->totalQuantityAvailable);
                $checkData->totalCost = round($unitCost, 5);
                $checkData->finalTotalCost = $checkData->totalQuantityAvailable * $unitCost;


                $checkData->finalTotalCost = number_format($checkData->finalTotalCost, 2);
                $checkData->totalCost = number_format($checkData->totalCost, 2);

                $checkData->goodsInweight = isset($checkData->transactiondt_weight) ? $checkData->transactiondt_weight : 0;
                $checkData->doweight = isset($checkData->transactiondt_WeightOut) ? $checkData->transactiondt_WeightOut : 0;
                $checkData->Totalweight = round(($checkData->goodsInweight - $checkData->doweight), 3);
                $checkData->weight = round(($checkData->goodsInweight - $checkData->doweight) / $checkData->totalQuantityAvailable, 3);

                array_push($filterItems, $checkData);
            }
        }
        if ($withZero != true) {
            return $filterItems;
        }
        return $items;
    }
}
