<?php

namespace App\Http\Controllers\BackOffice\SerialTypes;

use App\Http\Controllers\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;

class SerialTypesController extends ApiController
{
    public function fetchSerialTypes(Request $request)
    {
        $items = DB::table('serial_types')
            ->orderBy('serial_id')
            ->groupBy('serial_id')
            ->get();

        return ApiController::successResponse($items, 200);
    }

    public function fetchTypesBySerialId(Request $request)
    {
        $serialId = $request->serial_id;
        $items = DB::table('serial_types')
            ->orderBy('serial_id')
            ->where([
                ['serial_id', $serialId]
            ])
            ->get();

        return ApiController::successResponse($items, 200);
    }

    public function insertSerialType(Request $request)
    {

        // $validator = Validator::make($request->all(), [
        //     'setupType'     => 'required',
        //     'labelValue'    => 'required'
        // ]);
        // if ($validator->fails()) {
        //     return response()->json($validator->errors(), 422);
        // }

        if ($request->newType) {
            $setupCheck = DB::table('serial_types')->where([
                ['serial_code', $request->setupType]
            ])
                ->first();
            if ($setupCheck) {
                return ApiController::errorResponse($setupCheck, 422);
            }

            $newSerial = DB::table('serial_types')->max('serial_id');
            $newTypeArray = array(
                'serial_code' => $request->setupType,
                'serial_label' => $request->labelValue,
                'serial_order' => 1,
                'serial_id' => $newSerial + 1

            );
            $newType = DB::table('serial_types')->insert($newTypeArray);
            if ($newType) {
                return ApiController::successResponse($newType, 200);
            }
        }

        $serials = DB::table('serial_types')->where([
            ['serial_id', $request->setupType]
        ])
            ->orderBy('serial_order', 'desc')->first();
        $newSerialTypeArray = array(
            'serial_label' => $request->labelValue,
            'serial_id' => $request->setupType,
            'serial_order' => $serials->serial_order + 1,
            'serial_code' => $serials->serial_code,
        );
        $newType = DB::table('serial_types')->insert($newSerialTypeArray);

        if ($newSerialTypeArray) {
            return ApiController::successResponse($newSerialTypeArray, 200);
        }
        return ApiController::errorResponse($newSerialTypeArray, 422);
    }

    public function deleteSerialType(Request $request)
    {
        $serialId = $request->serialId;
        $serialLabel = $request->serialLabel;

        DB::table('serial_types')->where([
            [
                'serial_id', $serialId
            ]
        ])
            ->when($serialLabel, function ($query) use ($serialLabel) {
                return $query->where('serial_label', 'like', $serialLabel);
            })
            ->delete();

    }


}
