<?php

namespace App\Http\Controllers\BackOffice\Setup;

use App\Http\Controllers\ApiController;
use App\Models\SetUp;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\DB;

class SetupController extends ApiController
{
    public function insertSetup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'setupType' => 'required',
            'setupKey' => 'required',
            'setupValue' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $setupCheck = SetUp::where([
            ['setup_key', 'like', $request->setupKey]
        ])
            ->first();

        if ($setupCheck) {
            return ApiController::errorResponse($setupCheck, 422);
        }
        $setupArray = array(
            'setup_key' => $request->setupKey,
            'setup_value' => $request->setupValue,
            'setup_type' => $request->setupType
        );
        $newSetup = SetUp::create($setupArray);

        if ($newSetup) {
            return ApiController::successResponse($newSetup, 200);
        }
        return ApiController::errorResponse($newSetup, 422);
    }
    public function insertPaymentSetup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'setupType' => 'required',
            'setupKey' => 'required',
            'setupValue' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $setupCheck = DB::table('payment_methods')->where([
            ['code', 'like', $request->setupKey]
        ])
            ->first();

        if ($setupCheck) {
            return ApiController::errorResponse($setupCheck, 422);
        }
        $setupArray = array(
            'code' => $request->setupKey,
            'name' => $request->setupValue,
            'ledger_number' => $request->ledgerValue
        );
        $newSetup =  DB::table('payment_methods')->insert($setupArray);

        if ($newSetup) {
            return ApiController::successResponse($newSetup, 200);
        }
        return ApiController::errorResponse($newSetup, 422);
    }

    public function updateSetup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'setupType' => 'required',
            //'setupKey'      => 'required',
            'setupValue' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $setupArray = array(
            //'setup_key' => $request->setupKey,
            'setup_value' => $request->setupValue,
            'setup_type' => $request->setupType
        );
        $updateSetup = SetUp::where([
            ['setup_id', '=', $request->setupId]
        ])
            ->update($setupArray);

        return ApiController::successResponse($updateSetup, 200);
    }

    public function updatePaymentSetup(Request $request)
    {
        $validator = Validator::make($request->all(), [
            //'setupKey'      => 'required',
            'setupValue' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json($validator->errors(), 422);
        }
        $setupArray = array(
            //'setup_key' => $request->setupKey,
            'name' => $request->setupValue,
            'ledger_number' => $request->ledgerValue
        );
        $updateSetup = DB::table('payment_methods')->where([
            ['id', '=', $request->setupId]
        ])
            ->update($setupArray);

        return ApiController::successResponse($updateSetup, 200);
    }
    public function deleteSetup(Request $request)
    {
        $deleteSetup = SetUp::where([
            ['setup_id', '=', $request->setupId]
        ])
            ->delete();

        return ApiController::successResponse($deleteSetup, 200);
    }
    public function deletePaymentSetup(Request $request)
    {
        $deleteSetup = DB::table('payment_methods')->where([
            ['id', '=', $request->setupId]
        ])
            ->delete();

        return ApiController::successResponse($deleteSetup, 200);
    }
    public function createCellMerge(Request $request)
    {
        for ($i = 1; $i < 100; $i++) {
            $setupArray = array(
                'setup_key' => "cell" . $i,
                'setup_value' => "CELL" . $i,
                'setup_type' => "CellMerge",
            );
            $newSetup = SetUp::create($setupArray);
        }
    }

    public function fetchSetupsByType(Request $request)
    {
        if($request->setupType=='payment_method'){
            $setups = DB::table('payment_methods')
            ->select('id as setup_id','name as setup_value','code as setup_key','ledger_number')
            ->get();
            foreach ($setups as $setup) {
                $setup->setup_type = 'payment_method';
            }
        }else{
            $setups = SetUp::where([
                ['setup_type', 'like', $request->setupType]
            ])
                ->get();
        }
       

        return ApiController::successResponse($setups, 200);
    }

}
