<?php

namespace App\Http\Controllers\BackOffice\TO;



use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\companies;
use App\Models\country;
use App\Models\items;
use App\Models\location;
use App\Models\sequence;
use App\Models\suppliers;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Carbon\Carbon;
use Exception;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\GoodsIn\GoodsInFunctions;


class TOServices extends ApiController
{
    
    function saveTmpTransaction($transactionTmpId,$transactionTmp){
        if ($transactionTmpId) {
            $transactionTmpAfterUpdate = transactiontmp::updateTransaction($transactionTmpId, $transactionTmp);
            if ($transactionTmpAfterUpdate) {
                return ApiController::successResponse($transactionTmpAfterUpdate, 200);
            }
            return ApiController::errorResponse($transactionTmpAfterUpdate, 422);
        } else {
            $newTransactionTmp = transactiontmp::create($transactionTmp);
            if ($newTransactionTmp) {
                return ApiController::successResponse($newTransactionTmp, 200);
            }
            return ApiController::errorResponse($newTransactionTmp, 422);
        }
    }

    public function storeTransactionDtTmpFunction($transactionDetailsTmp, $transactionTmpId)
    {

        $newTransactionDtTmp = null;
        $goodsInBillOfEntry = null;
        $goodsInFunctions = new GoodsInFunctions();

        foreach ($transactionDetailsTmp as $element) {

            if ($element['transactionDetailItemCode'] != null && $element['transactionDetailItemQty'] != null) {
                $getBillOfEntryInCaseOfGoodsIn = transactiontmp::where('transactiontmp_id', '=', $transactionTmpId)->first();

                if ($getBillOfEntryInCaseOfGoodsIn) {
                    $goodsInBillOfEntry = $getBillOfEntryInCaseOfGoodsIn->transactiontmp_billOfEntry;
                }

                $transactionDtTmp = $goodsInFunctions->prepareTransactionDtTmp($getBillOfEntryInCaseOfGoodsIn, $element, $goodsInBillOfEntry, $transactionTmpId,$element['transactionDetailItemCode']);

                if (!isset($element['transactiondttmp_id']) || $element['transactiondttmp_id'] == null) {
                    $newTransactionDtTmp = transactiondttmp::create($transactionDtTmp);
                } else {
                    $updateTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                        ->update($transactionDtTmp);

                    transactionDtSnTmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                        ->update([
                            'item_id' => $element['transactionDetailItemCode']
                        ]);


                    $newTransactionDtTmp = transactiondttmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                        ->leftjoin('items', 'items.item_id', 'transactiondttmps.item_id')
                        ->select('transactiondttmps.*', 'items.item_hasSerial')
                        ->first();
                    if (!$newTransactionDtTmp->item_hasSerial) {
                        transactionDtSnTmp::where('transactiondttmp_id', '=', $element['transactiondttmp_id'])
                            ->update([
                                'status' => 'Delete'
                            ]);
                    }
                }

                $transactionDtSumQty = transactiondttmp::where('transactiondttmps.transactiontmp_id', '=', $transactionTmpId)
                    ->select('transactiondttmps.item_quantity')
                    ->selectRaw('SUM(transactiondttmps.item_quantity) as totalQty')
                    ->first();

                transactiontmp::where('transactiontmps.transactiontmp_id', '=', $transactionTmpId)
                    ->update(["transactiontmp_totalQty" => $transactionDtSumQty->totalQty]);
            }
        }

        if ($newTransactionDtTmp) {

            $data = array();
            $data['transactionDt'] = $newTransactionDtTmp;
            $data['transactionTmp'] = $newTransactionDtTmp;

            return ApiController::successResponse($data, 200);
        }

        return ApiController::errorResponse($newTransactionDtTmp, 422);
    }

  
}
