<?php

namespace App\Http\Controllers\BackOffice\Transactions;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\clientItem;
use App\Models\clientSupplier;
use App\Models\companies;
use App\Models\items;
use App\Models\Localization;
use App\Models\location;
use App\Models\sequence;
use App\Models\transactionDt;
use App\Models\transactionDtsn;
use App\Models\transactionDtSnTmp;
use App\Models\transactiondttmp;
use App\Models\TransactionPalets;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\TransactiontmpPalets;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use JWTAuth;
use File;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\Transactions\input\TransactionSearchRequest;
use PDF;

class TransactionService extends ApiController
{
    function fetchTransactions(TransactionSearchRequest $request)
    {

        $commonServices = new CommonServices;

        $transactions = transactions::join('clients', 'clients.client_id', '=', 'transactions.transaction_clientId')
            ->leftjoin('currency', 'currency.currency_id', '=', 'transactions.transaction_currencyId')
            ->select(
                'transactions.transaction_reference',
                'transactions.transaction_date',
                'clients.client_firstname',
                'transactions.transaction_id',
                'transactions.transaction_type',
                'transactions.transaction_billOfEntry',
                'transaction_type',
                'transaction_currencyId',
                'currency_code',
                'transactions.transaction_remark',
                'internal_transfer',
                'transaction_clientId',
                DB::raw("CASE WHEN transactions.internal_transfer = 1 THEN 'Internal' ELSE transactions.transaction_type END AS transaction_type")

            )
            ->selectRaw(DB::raw(" FROM_UNIXTIME(transaction_date, '%d-%m-%Y') AS transaction_formatdate"));

        $selectRawQuery = "";
        if (in_array('DO', $request->type)) {
            $selectRawQuery = "(transaction_type='DO' and internal_transfer=0)";
        }
        if (in_array('GOODS_IN', $request->type)) {
            $selectRawQuery = $selectRawQuery === "" ? "" : $selectRawQuery . " or ";
            $selectRawQuery = $selectRawQuery . "(transaction_type='GOODS_IN' and internal_transfer=0) ";
        }
        if (in_array('INTERNAL_TRANSFER', $request->type)) {
            $selectRawQuery = $selectRawQuery === "" ? "" : $selectRawQuery . " or ";
            $selectRawQuery = $selectRawQuery . "(transaction_type='DO' and internal_transfer=1) ";
        }
        $selectRawQuery = "transaction_clientId =" . $request->clientId . " and (" . $selectRawQuery . ")";

        $transactions
            ->whereRaw(DB::raw($selectRawQuery))->where([
                ['transaction_clientId', $request->clientId],
            ])

            ->whereRaw('date(FROM_UNIXTIME(transaction_date)) BETWEEN ? AND ?', [$request->fromDate, $request->toDate])
            ->orderBy('transaction_date', 'desc');
        $count = count($transactions->groupby('transaction_id')->get());
        if (isset($skip) && isset($take)) {
            $transactions->skip($skip)
                ->take($take);
        }
        $transactions = $transactions
            ->groupby('transaction_id')
            ->orderby('transaction_date', 'desc')
            ->get();

        if ($request->hasFiles) {
            $transactions = $commonServices->getTransactionFilesExist($request->type, $transactions);
        }
        if ($transactions) {
            return ApiController::successResponse($transactions, 200, $count);
        }
        return ApiController::successResponse('No result', 204);
    }


    public function transactionsPdf(TransactionSearchRequest $transactionSearchRequest)
    {
        $clientId = $transactionSearchRequest->clientId;
        $company = DB::table('companies')->first();
        $result = $this->fetchTransactions($transactionSearchRequest)->getData();
        $moduleKeys = Localization::moduleKeys;
        $language = $transactionSearchRequest->language;
        $client = DB::table('clients')->where('client_id', $clientId)->first()->client_firstname;

        $Obj['result'] = $result;
        $Obj['moduleKeys'] = $moduleKeys;
        $Obj['company'] = $company;
        $Obj['language'] = $language;
        $Obj['client'] = $client;
        $Obj['transactionSearchRequest'] = $transactionSearchRequest;

        ini_set('max_execution_time', '50000');
        ini_set("pcre.backtrack_limit", "5000000000");
        ini_set('memory_limit', '200048M');

        $pdf = PDF::loadView('clientMovementReport', $Obj);


        return $pdf->stream('clientMovement.pdf');
    }
}
