<?php

namespace App\Http\Controllers\BackOffice\User;

use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use App\Models\user;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use JWTAuth;

class UserServices extends ApiController
{
    function changePasswordService ($payload) {

        $currentPassword= $payload['currentPassword'];
        $newPassword= $payload['newPassword'];


        if (Hash::check($currentPassword, auth()->user()->password)) {
            $resetPassword = $this->updatePasswordFunction($newPassword);
            return ApiController::successResponse($resetPassword, 200);
        }

        return ApiController::errorResponse("unableToChangePassword", 409);
    }

    function updatePasswordFunction ($newPassword) {
        return  DB::table('users')
        ->where([
            ['id', '=', auth()->user()->id]
        ])
        ->update([
            'password' => bcrypt($newPassword),
        ]);
    }
}
