<?php

namespace App\Http\Controllers\BackOffice\Utilities;

use App\enums\NotificationTopics;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\BackOffice\GoodsIn\GoodsInFunctions;
use App\Models\client;
use App\Models\clientForwarder;
use App\Models\companies;
use App\Models\country;
use App\Models\items;
use App\Models\notifications;
use App\Models\SetUp;
use App\Models\suppliers;
use App\Models\transactionDt;
use App\Models\transactiondttmp;
use App\Models\transactions;
use App\Models\transactiontmp;
use App\Models\user;

use App\Traits\Firebase;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use JWTAuth;
use App\Models\Localization;
use App\Http\Controllers\BackOffice\Common\CommonServices;
use App\Http\Controllers\BackOffice\Client\ClientController;
use App\Http\Controllers\BackOffice\Items\ItemsController;
use App\Http\Controllers\BackOffice\Country\CountryController;
use Exception;
use App\Models\ItemGroup;
use DateTime;
use DateTimeZone;
use Illuminate\Support\Facades\Log;

class UtilitiesController extends ApiController
{
    use Firebase;

    public function getUtilities(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;

        $utilities = array();

        $utilities['countries'] = DB::table('countries')
            ->orderBy('country_name')->get();



        $utilities['roles'] = DB::table('roles')->get();

        $utilities['shipmentTypes'] = DB::table('set_ups')->where('setup_type',  'shipment_type')
            ->orderBy('setup_value')->get();

        $utilities['deliveryTypes'] = DB::table('set_ups')->where('setup_type',  'delivery_type')
            ->orderBy('setup_value')->get();

        $utilities['defaultDeliveryType'] = DB::table('set_ups')->where([
            ['setup_type', 'delivery_type'],
            ['setup_key', 'Shipment']
        ])
            ->orderBy('setup_value')->first()->setup_id;

        $utilities['shipmentTransfers'] = DB::table('set_ups')->where('setup_type', 'like', 'shipment_transfer')
            ->orderBy('setup_value')->get();

        $utilities['shipmentStatus'] = DB::table('set_ups')->where('setup_type', 'like', 'shipment_status')
            ->orderBy('setup_value')->get();

        $utilities['shipBy'] = DB::table('set_ups')->where('setup_type', 'like', 'Shipby')
            ->orderBy('setup_value')->get();

        $utilities['paymentMethods'] = DB::table('payment_methods')->get();

        $utilities['customBillTypes'] = DB::table('set_ups')->where('setup_type', 'like', 'custom_billtypes')
            ->orderBy('setup_value')->get();
        $utilities['clients'] = client::join('users', 'users.id', '=', 'clients.user_id')
            ->leftjoin('companies', 'companies.company_id', '=', 'users.company_id')
            ->leftjoin('currency', 'currency.currency_id', '=', 'clients.client_currency')
            ->where('companies.company_id', $company_id)
            ->orderby('client_firstname', 'asc')
            ->get();

        $utilities['suppliers'] = suppliers::where('company_id', '=', $company_id)
            ->orderBy('supplier_name')->get();


        $utilities['setups'] = SetUp::distinct('setup_type')->select('setup_type')->get();


        $utilities['forwarders'] = clientForwarder::where('clientforwarder_approved', '=', true)
            ->orderBy('clientforwarder_name')
            ->get();
        $utilities['currency'] = DB::table('currency')
            ->orderby('currency_code')
            ->get();

        $utilities['users'] = user::where('user_role_id', '!=', 0)->get();

        $utilities['company'] = DB::table('companies')
            ->leftjoin('currency', 'currency.currency_id', '=', 'companies.currency')
            ->where('company_id', $company_id)
            ->first();

        $utilities['company']->company_logo = '/companies/images/' . $utilities['company']->company_id . '/' . $utilities['company']->company_logo;

        $utilities['groups'] = DB::table('item_groups')
            ->where('company_id', $company_id)
            ->orderby('group_code')
            ->get();

        $utilities['defaultCurrency'] = DB::table('currency')
            ->where('currency_id', $utilities['company']->currency)
            ->first();

        $utilities['dates'] = array(
            'date' => date('Y-m-d')
        );
        $utilities['maxTransDate'] = DB::table('transactions')
            ->selectRaw("FROM_UNIXTIME(MAX(transactions.transaction_date), '%d-%m-%Y') AS transaction_formatdate")
            ->first();
        if ($utilities['maxTransDate']) {
            $utilities['maxTransDate'] = $utilities['maxTransDate']->transaction_formatdate;
        }

        $utilities['clientStorageTypes'] = DB::table('set_ups')
            ->where([
                ['setup_type', 'storage_rental_type'],
            ])
            ->get();
        $utilities['clientStorageUnits'] = DB::table('set_ups')
            ->where([
                ['setup_type', 'storage_rental_unit'],
            ])
            ->get();
        $range = null;
        $range = $utilities['company'];
        $today = date('Y-m-d');
        if ($range) {
            $dateToTimestamp = $this->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
            $rangeTimestamp = $range->company_range * 24 * 60 * 60;
            $finalTimestamp = $dateToTimestamp - $rangeTimestamp;
        } else {
            $finalTimestamp = $this->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
        }
        $dateRange = null;
        if ($finalTimestamp) {
            $dateRange = date('Y-m-d', $finalTimestamp);
        }
        $utilities['dateRange'] = $dateRange;

        $utilities['paymentTerms'] = DB::table('set_ups')->where('setup_type', 'like', 'payment_term')->orderBy('setup_value')->get();
        $utilities['invoiceTypes'] = DB::table('set_ups')->where('setup_type', 'like', 'invoice_type')->orderBy('setup_value')->get();

        $utilities['deliveryTerms'] = DB::table('set_ups')->where('setup_type', 'like', 'term_of_delivery')->orderBy('setup_value')->get();
        $utilities['itemUnits'] = DB::table('set_ups')->where('setup_type', 'like', 'item_unit')->orderBy('setup_value')->get();
        $utilities['exemption'] = DB::table('set_ups')->where('setup_type', 'like', 'Exemption')->orderBy('setup_value')->get();
        $utilities['serialTypes'] = DB::table('serial_types')->orderBy('serial_id')->groupBy('serial_id')->get();


        $utilities['notificationTopics'] = NotificationTopics::all();


        return ApiController::successResponse($utilities, 200);
    }

    public function convertTodayToTimetsamp($date)
    {
        $date = date_create_from_format('Y-m-d H:i:s', $date);
        if ($date) {
            $date = $date->getTimestamp();
            return $date;
        }
        return 0;
    }

    public function convertDateTimestamp(Request $request)
    {
        return $this->convertTodayToTimetsamp('2022-02-23 00:00:00');
    }

    public function fetchInventoryItems(Request $request)
    {


        $user_id = JWTAuth::user()->id;
        $company_id = JWTAuth::user()->company_id;


        $items = DB::table('client_items');
        //->orderBy('raw_in_grid');

        if ($request->item_id) {
            $items->where('client_items.item_id', $request->item_id);
        }

        if ($request->client_id) {
            $items->where('client_items.item_related_client_id', $request->client_id);
        } else {
            $items->where('client_items.item_related_client_id', $user_id);
        }

        $items = $items->get();

        // $items = DB::table('items')
        // ->where('company_id' ,$company_id);
        //  if($request ->item_id){
        //     $items ->where('items.item_id' ,$request->item_id);
        // }
        // $items =  $items  ->get();

        foreach ($items as $quantity) {
            $quantity->totalQuantity = '0';
            $quantity->totalQuantityUsed = '0';
            $DO = UtilitiesController::getData($quantity->item_id, 'DO', $quantity->item_code,);
            $GOODSIN = UtilitiesController::getData($quantity->item_id, 'GOODS_IN', $quantity->item_code);


            $quantity->DO = $DO;
            $quantity->GOODSIN = $GOODSIN;
            $totalQuantity = 0;
            $usedQuantity = 0;

            $quantity->totalQuantity = 0;
            $quantity->totalQuantityUsed = 0;
            foreach ($quantity->GOODSIN as $calculateTotal) {

                // if( $calculateTotal->transaction_type =='GOODS_IN'){
                $totalQuantity = $totalQuantity + $calculateTotal->item_quantity;
                $itemsDetais2 = DB::table('transaction_dts')
                    ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
                    ->where('transaction_dts.id_reference_dt', $calculateTotal->transactiondt_id);

                if ($request->reference_id) {
                    $itemsDetais2->where('transactions.transaction_reference', '!=', $request->reference_id);
                }


                //->select('transactions.transaction_type','transaction_dts.item_quantity')
                $itemsDetais2 = $itemsDetais2->get();

                $totalQuantityPerBill = 0;
                foreach ($itemsDetais2 as $calculateTotal2) {

                    $totalQuantityPerBill = $totalQuantityPerBill + $calculateTotal2->item_quantity;
                }
                $calculateTotal->totalUsedPerBill = $totalQuantityPerBill;
                $calculateTotal->totalAvailablePerBill = $calculateTotal->item_quantity - $totalQuantityPerBill;
                $usedQuantity = $usedQuantity + $totalQuantityPerBill;
            }
            $quantity->totalQuantity = $totalQuantity;
            $quantity->totalQuantityUsed = $usedQuantity;
            $quantity->totalQuantityAvailable = $totalQuantity - $usedQuantity;
        }

        return ApiController::successResponse($items, 200);
    }

    public function getData($itemId, $type, $code)
    {
        $data = DB::table('transaction_dts')
            ->join('transactions', 'transactions.transaction_id', '=', 'transaction_dts.transaction_id')
            ->leftjoin('countries', 'countries.country_id', '=', 'transaction_dts.transactiondt_countryOfOrigin');
        if ($type == 'GOODS_IN') {
            $items = DB::table('items')
                ->where('item_code', $code);
            $items = $items->first();

            $itemId2 = $items->item_id;


            $data->join('items', 'items.item_id', '=', 'transaction_dts.item_id');
            $data->where([
                ['items.item_id', '=', $itemId2]
            ]);
        } else {
            $data->where([
                ['transaction_dts.item_id', $itemId]
            ]);
        }
        $data = $data->where('transactions.transaction_type', $type);
        $data = $data->orderBy('raw_in_grid');
        //->select('transactions.transaction_type','transaction_dts.item_quantity')
        $data = $data->get();
        return $data;
    }

    public function fetchSetUps(Request $request)
    {
        $items = DB::table('set_ups')
            ->orderBy('setup_type')
            ->groupBy('setup_type')
            ->get();

        return ApiController::successResponse($items, 200);
    }

    public function getCompanyRange(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $range = null;
        $range = DB::table('companies')
            ->select('company_range')
            ->where('company_id', $company_id)->first();
        $today = date('Y-m-d');
        if ($range) {
            $dateToTimestamp = $this->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
            $rangeTimestamp = $range->company_range * 24 * 60 * 60;
            $finalTimestamp = $dateToTimestamp - $rangeTimestamp;
        } else {
            $finalTimestamp = $this->convertTodayToTimetsamp(date('Y-m-d H:i:s'));
        }
        $dateRange = null;
        if ($finalTimestamp) {
            $dateRange = date('Y-m-d', $finalTimestamp);
        }
        return ApiController::successResponse($dateRange, 200);
    }

    public function sendNotification($notificationArray)
    {
        $userId = $notificationArray['related_userid'];

        $getlLanguage = DB::table('users')
            ->where('id', $userId)
            ->first();
        $language = isset($getlLanguage->language) ? $getlLanguage->language : 'en';

        if ($language == "") $language = 'en';
        $token = $notificationArray['notificationToken'];
        //$title=$notificationArray['title'];

        $key = $notificationArray['key'];
        $transId = $notificationArray['trans_id'];

        $transType = $notificationArray['transType'];

        $notificationCodeValue = isset($notificationArray['code']) ? $notificationArray['code'] : "CUSTOM";
        $notificationCode = Localization::notificationKeys[$notificationCodeValue]['code'];
        $title = Localization::notificationKeys[$notificationCodeValue]['title_' . $language];
        $message = Localization::getMessageWithReference($notificationCodeValue, $language, $transId, $notificationArray['message']);

        //'Delivery Items with Reference:' . $reference.' '. $status,
        $notification = [
            'title' => $title,
            'body' => $message,
            'key' => $key,
            'icon' => 'myIcon',
            'sound' => 'mySound'
        ];
        $extraNotificationData = ["message" => $notification, "moredata" => $key, "transType" => $transType];

        $fcmNotification = [
            //'registration_ids' => $tokenList, //multple token array
            'to' => $token, //single token
            'notification' => $notification,
            'data' => $extraNotificationData
        ];
        $notification = array(
            'notification_title' => $title,
            'notification_description' => $message,
            'notification_seen' => 0,
            'notification_related_userid' => $userId,
            'trans_id' => $key,
            'notification_code' => $notificationCode
        );

        $newNotification = notifications::create($notification);
        return $this->firebaseNotification($fcmNotification);
    }

    function base64ToJpeg($base64String, $outputFile)
    {
        $imgName = "IMG_" . time() . ".png";
        $outputFile .= $imgName;
        $base64String = str_replace('data:image/png;base64,', '', $base64String);
        $base64String = str_replace('data:image/jpeg;base64,', '', $base64String);
        $base64String = str_replace(' ', '+', $base64String);

        $dirname = dirname($outputFile);
        if (!is_dir($dirname)) {
            mkdir($dirname, 0755, true);
        }

        $imagef = fopen("base64Text.txt", 'wb');
        fwrite($imagef, $base64String);
        fclose($imagef);

        $ifp = fopen($outputFile, 'wb');
        $decoded = base64_decode($base64String);
        fwrite($ifp, $decoded);

        fclose($ifp);
        //  $image = base64_encode(file_get_contents($request->file('image')->pat‌​h()));

        return $imgName;
    }

    public function sendMail($message, $subject, $email, $file = null)
    {
        //    try {
        Mail::send([], [], function ($sendMail) use ($message, $email, $subject, $file) {
            //$sendMail->from('RLP-Team', 'name');
            $sendMail->to($email)
                ->subject($subject)
                ->setBody($message);
            if ($file) {
                $sendMail->attach($file);
            }
        });
        //    } catch (\Throwable $th) {
        //         return ApiController::errorResponse($th,422);
        //    }

    }


    public function cipherRequest(Request $request)
    {


        $encrypt_method = "AES-256-CBC";
        $secret_key = 'FB396BDB821DA7A746EAEC5D2ADE1B11612E3D98341943E25C2B545A285D2ADE1';
        $secret_iv = '7aE3OKIZxusugQdpk3gwNi9x63MRAFLgkMJ4nyil88ZYMyjqTSE3FIo8L5KJghfi';
        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);


        $info = $request->info;
        $info['language'] = $request->header('language') ?? 'en';
        $data = array();
        $data['info'] = $info;
        $string = json_encode($data);
        // encrypt token;
        $encryptToken = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
        $encryptToken = base64_encode($encryptToken);
        return ApiController::successResponse($encryptToken, 200);
    }

    public function decipherRequest($cipherText)
    {

        $encrypt_method = "AES-256-CBC";
        $secret_key = 'FB396BDB821DA7A746EAEC5D2ADE1B11612E3D98341943E25C2B545A285D2ADE1';
        $secret_iv = '7aE3OKIZxusugQdpk3gwNi9x63MRAFLgkMJ4nyil88ZYMyjqTSE3FIo8L5KJghfi';
        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);

        $text = $cipherText;
        $decryptToken = openssl_decrypt(base64_decode($text), $encrypt_method, $key, 0, $iv);
        return $decryptToken;
    }


    public function connectDataToErp($api, $payload)
    {
        $company = companies::first();
        if (!$company->company_erpSchema) {
            return [];
        }
        $payload['schema'] = $company->company_erpSchema;
        $payload['companyName'] = $company->company_erpName;
        $url = $company->company_erpURL . $api;

        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            if (curl_errno($ch)) {
                throw new \Exception(curl_error($ch));
            }

            curl_close($ch);

            if ($httpCode !== 200) {
                Log::channel('accountingCurls')->error('ERP request failed', [
                    'url' => $url,
                    'httpCode' => $httpCode,
                    'response' => $result,
                    'requestBody' => $payload
                ]);
                return ApiController::errorResponse('ERP request failed', 409);
            }

            if ($result) {
                $decodedResult = json_decode($result);
                if ($decodedResult) {
                    return ApiController::successResponse($decodedResult, 200);
                } else {
                    Log::channel('accountingCurls')->error('Invalid JSON response from ERP', [
                        'url' => $url,
                        'response' => $result,
                        'requestBody' => $payload
                    ]);
                    return ApiController::errorResponse('Invalid response from ERP', 409);
                }
            } else {
                Log::channel('accountingCurls')->error('Empty response from ERP', [
                    'url' => $url,
                    'requestBody' => $payload
                ]);
                return ApiController::errorResponse('No result found', 409);
            }
        } catch (\Exception $e) {
            Log::channel('accountingCurls')->error('Exception in ERP connection', [
                'url' => $url,
                'error' => $e->getMessage(),
                'requestBody' => $payload
            ]);
            return ApiController::errorResponse('Error connecting to ERP: ' . $e->getMessage(), 409);
        }
    }


    public function getCurrencyRate(Request $request)
    {
        $result = $this->getCurrencyRateFunction($request->currencyId, $request->date);
        return ApiController::successResponse($result, 200);
    }


    public function getCurrencyRateFunction($currencyId, $date)
    {
        $currency = DB::table('currency')
            ->where('currency_id', $currencyId)
            ->first();
        $result = DB::select(' SELECT CurRate("' . $currency->currency_code . '", "' . $date . ' 00:00:00") AS CurRate');
        return $result;
    }


    public function dubaiTrader(Request $request)
    {
        $company_id = JWTAuth::user()->company_id;
        $commonServices = new CommonServices();
        $dateFormat = $commonServices->dubaiTradeDAteFormatService();
        $transactionId = $request->transactionId;
        $invoiceId = $request->invoiceId;
        $paymentTermId = $request->paymentTermId;
        $deliveryTermId = $request->deliveryTermId;
        $exemptionId = $request->exemptionId;
        $trade = "";
        transactions::where([
            ['transaction_id', $transactionId]
        ])
            ->update([
                'Invoice_type_id' => $invoiceId,
                'payment_term_id' => $paymentTermId,
                'delivery_term_id' => $deliveryTermId,
                'exemption_type_id' => $exemptionId
            ]);
        $header = transactions::where([
            ['transaction_id', $transactionId]
        ])
            ->leftjoin('currency', 'currency_id', 'transactions.transaction_currencyId')
            ->leftjoin('client_suppliers', 'client_suppliers.supplier_id', 'transactions.transaction_supplierId')
            ->select('*')
            ->first();

        $header->transaction_formatdate = date($dateFormat, $header->transaction_date);




        $details = transactionDt::where([
            ['transaction_id', $transactionId]
        ])
            // ->leftjoin('transactions','transactions.transaction_id','transaction_dts.transaction_id')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin')
            ->select('transaction_dts.*', 'items.item_id', 'items.item_description', 'countries.country_code')
            ->get();


        $header->totalValues = transactionDt::where([
            ['transaction_id', $transactionId]
        ])
            ->selectRaw('SUM(transactiondt_price*item_quantity) as totalValues')
            ->first()->totalValues;
        $trade = $commonServices->dubaiTradeRecordService($header, null, null,  true);
        $index = 1;
        foreach ($details as $splitDetails) {
            if (!$splitDetails->item_unit) {
                $itemId = $splitDetails->item_id;
                $items = items::where('item_id', $itemId)->first();
                if ($items) $splitDetails->item_unit = $items->item_unit;
            }
            $trade = $trade . "\n" . $commonServices->dubaiTradeRecordService($header, $splitDetails, $index,  false);
            $index = $index + 1;
        }


        return ApiController::successResponse($trade, 200);
    }
    private function replaceSpecialCharacters($string)
    {
        // Replace all special characters with spaces
        $cleanedString = preg_replace('/[^A-Za-z0-9]/', ' ', $string);

        // Optionally, trim multiple spaces to a single space
        $cleanedString = preg_replace('/\s+/', ' ', $cleanedString);

        return $cleanedString;
    }
    public function checkActivePlan($clientId)
    {
        $activePlans = DB::table('client_storage_rent')
            ->where([
                ['active', true],
                ['related_client_id', $clientId]
            ])
            ->get();
        if (count($activePlans) > 0) return true;
        return false;
    }

    public function getChargesStorage($clientId, $clients)
    {

        $charges = DB::table('client_storage_pallets')
            ->leftjoin('client_storage_rent', 'client_storage_rent.id', 'client_storage_pallets.related_plan')
            ->select('length', 'width', 'height', 'cost', 'pallet_no')
            ->where([
                // ['related_plan',$clientId],
                ['client_storage_rent.active', true],
                ['client_storage_pallets.related_plan', $clients->id]
            ])
            ->get();
        $totalSpace = 0;
        foreach ($charges as $splitData) {

            if ($clients->storage_type == 'Daily') {
                $totalSpace = $totalSpace + $splitData->length * $splitData->width * $splitData->height * $splitData->cost * $splitData->pallet_no;
            } else {
                $totalSpace = $splitData->cost;
            }
        }


        return $totalSpace;
    }

    public function checkGoodsInHeaderModules($request)
    {

        $date = date('Y-m-d');
        // return time();
        $timeStamp = time();

        $company = DB::table('companies')
            ->first();
        if ($company->company_onlyShipment == 0) return $request;
        //format dec
        $paddedDEC = str_pad($timeStamp, 13, '0', STR_PAD_LEFT);
        $part1 = substr($paddedDEC, 0, 3);
        $part2 = substr($paddedDEC, 3, 8);
        $part3 = substr($paddedDEC, -2);
        $formattedDEC = "$part1-$part2-$part3";
        //end dec

        //boe
        $timeStampBOE = time();
        $paddedBOE = str_pad($timeStampBOE, 12, '0', STR_PAD_RIGHT);
        $part1 = substr($paddedBOE, 0, 12);
        $formattedBOE = "$part1";
        // end boe

        //supplier

        $supplierId = 0;
        $checkSupplier = DB::table('suppliers')
            ->where('supplier_name', 'DEFAULT')
            ->first();
        if ($checkSupplier) {
            $supplierId = $checkSupplier->supplier_id;
        } else {
            $clientSupplier = array(
                'supplier_name' => 'DEFAULT',
                'supplier_contactPerson' => '',
                'supplier_address' => 'DEF',
                'supplier_country' => 'DEF',
                'supplier_phone' => '00',
                'supplier_email' => '00',
                'company_id' => '1'
            );
            $newSupplier = suppliers::create($clientSupplier);
            $supplierId = $newSupplier->id;
        }


        //end supplier


        $request['transactionBillOfEntry'] = $formattedDEC;
        $request['transactionBOE'] = $formattedBOE;
        $request['transactionSupplier'] = $supplierId;
        $request['transactionSupplierInvoice'] = 'DEFAULT';
        return $request;
    }

    public function checkGoodsInDetailsModules($request)
    {

        $date = date('Y-m-d');
        // return time();
        $timeStamp = time();

        $company = DB::table('companies')
            ->first();
        if ($company->company_onlyShipment == 0) return $request;

        //supplier

        $countryId = 0;
        $checkCountries = DB::table('countries')
            ->where('country_code', 'DF')
            ->first();
        if ($checkCountries) {
            $countryId = $checkCountries->country_id;
        } else {
            $country = array(
                'country_code' => 'DF',
                'country_name' => 'DF',
                'country_areaCode' => '',
            );
            $newCountry = country::create($country);
            $countryId = $newCountry->country_id;
        }


        //end supplier
        $request['transactionDetailCountryOfOrigin'] = $countryId;
        return $request;
    }


    public function connectShipmentToLogisticomApi(Request $request)
    {
        $transactionId = $request->transactionId;
        return $this->connectShipmentToLogisticom($transactionId);
    }


    public function connectShipmentToLogisticom($transactionId)
    {

        $data = array();
        $header = DB::table('transactions')
            ->leftjoin('clients', 'clients.client_id', 'transactions.transaction_clientId')
            ->leftjoin('users', 'users.id', 'clients.user_id')
            ->where('transaction_id', $transactionId)
            ->select('transaction_date', 'transaction_remark', 'transactions.user_id', 'transaction_clientId', 'users.user_name', 'transaction_rate', 'transaction_currencyId')
            ->first();

        $client = client::where('client_id', $header->transaction_clientId)->first();

        $details = DB::table('transaction_dts')
            ->leftjoin('items', 'items.item_id', 'transaction_dts.item_id')
            ->leftjoin('item_groups', 'item_groups.group_id', 'items.group_id')
            ->leftjoin('countries', 'countries.country_id', 'transaction_dts.transactiondt_countryOfOrigin',)
            ->where('transaction_id', $transactionId)
            ->select(
                'item_code',
                'items.*',
                'countries.*',
                'item_quantity',
                'transaction_dts.group_id as dtGroupId',
                'country_code',
                'transactiondt_item_description as dtDecription',
                'transactiondt_price',
                'transactiondt_priceBase',
                'transaction_dts.item_weight as dtWeight',
                'transaction_dts.hscode as  dtHscode',
                'item_groups.*'
            )
            ->get();
        $data['header'] = $header;
        $data['details'] = $details;
        $data['client'] = $client;
        $url = config('app.LOGISTICOM_URL') . 'receivetransactionFromShipment';

        // return $data;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        $result = curl_exec($ch);


        curl_close($ch);
        if ($result)
            if (Json_decode($result))
                return Json_decode($result);
            else return [];
        else
            return [];
    }



    public function receivetransactionFromShipment(Request $request)
    {
        $header = $request->header;
        $details = $request->details;
        $client = $request->client;
        $currentDateTime = Carbon::now();
        $formattedTime = $currentDateTime->format('H:i');
        $companyId = companies::first()->company_id;
        $goodsInFunctions = new GoodsInFunctions();

        $checkUserExist = DB::table('users')
            ->where('id', $header['user_id'])
            ->first();

        if (!$checkUserExist) {
            return ApiController::errorResponse('User not found', 422);
        }


        $clientId = 0;
        $checkClient = DB::table('users')
            ->leftjoin('clients', 'clients.user_id', 'users.id')
            ->where('user_name', $header['user_name'])
            ->first();
        if ($checkClient) {
            $clientId = $checkClient->client_id;
        } else {

            $clientController = new ClientController();
            $user = $clientController->insertClientAsUser(
                $header['user_name'],
                1,
                $header['user_id']
            );
            $client['user_id'] = $user->id;
            $newClient = client::create($client);
            if (!$newClient) {
                return ApiController::errorResponse('Client not found', 422);
            }
            $clientId = $newClient->id;
        }
        $modulesShipment = $this->checkGoodsInHeaderModules($request);

        $transactionTmpArray = array(
            'transactiontmp_date' => $header['transaction_date'],
            'transaction_time' => $formattedTime,
            'transactiontmp_type' => 'GOODS_IN',
            'transactiontmp_remark' => $header['transaction_remark'],
            'transactiontmp_billOfEntry' => $modulesShipment['transactionBillOfEntry'],
            'user_id' => $header['user_id'],
            'forwarder_id' => $request->orderForwarder,
            'clientCustomer_id' => $request->transactionCustomer,
            'company_id' => $companyId,
            'transactiontmp_currencyId' => $header['transaction_currencyId'],
            'transactiontmp_rate' => $header['transaction_rate'],
            'transactiontmp_shipmentRemark' => $request->transactionShipmentRemark,
            'transactiontmp_supplierId' => $modulesShipment['transactionSupplier'],
            'transactiontmp_supplierInvoice' => $modulesShipment['transactionSupplierInvoice'],
            'transactiontmp_BOE' => $modulesShipment['transactionBOE'],
            'transactiontmp_clientId' => $clientId
        );
        $header_response = transactiontmp::create($transactionTmpArray);
        if (!$header_response) {
            return ApiController::errorResponse('Unable to Sync Delivery', 422);
        }
        try {
            foreach ($details as $dtData) {
                $groupId = $dtData['group_id'];
                $item = Items::where('item_code', $dtData['item_code'])
                    ->first();
                $country = DB::table('countries')->where('country_code', $dtData['country_code'])
                    ->first();
                $itemId = 0;
                $countryId = 0;
                if ($item) {
                    $itemId = $item->item_id;
                } else {


                    $checkGroup = DB::table('item_groups')
                        ->where('group_id', $dtData['group_id'])->first();
                    if (!$checkGroup) {
                        $itemsGroup = array(
                            'group_code' => $dtData['group_code'],
                            'group_name' => $dtData['group_name'],
                            'company_id' => 1,
                            'group_itempack' => $dtData['group_itempack'],
                            'group_hscode' => $dtData['group_hscode'],
                            'group_itemunit' => $dtData['group_itemunit'],

                        );

                        $newItemGroup = ItemGroup::create($itemsGroup);
                        $groupId = $newItemGroup->group_id;
                    }












                    $itemsController = new ItemsController();
                    $clientItem = array(
                        'item_code' => $dtData['item_code'],
                        'item_barcode' => $dtData['item_barcode'],
                        'item_hscode' => $dtData['item_hscode'],
                        'item_description' => $dtData['item_description'],
                        'item_hasSerial' => $dtData['item_hasSerial'],
                        'item_weight' => $dtData['item_weight'],
                        'item_unit' => $dtData['item_unit'] ?? 'u',
                        'item_pack' => $dtData['item_pack'] ?? '-',
                        'company_id' => 1,
                        'item_qtyPerPack' => $dtData['item_qtyPerPack'],
                        'group_id' => $groupId,
                        'item_unDependentPrice' => $dtData['item_unDependentPrice'],
                        'serial_type_id' => $dtData['serial_type_id']
                    );
                    $newItem = $itemsController->insertItemFunction($clientItem, null, null, true);
                    $itemId =  $newItem->getData()->data->id;
                }
                if ($country) {
                    $countryId = $country->country_id;
                } else {
                    $countryController = new CountryController();
                    if (isset($dtData['country_code'])) {
                        $result = $countryController->insertCountryFunction($dtData['country_code'], $dtData['country_name'], "", true);

                        $countryId =  $result->getData()->data->country_id;
                    }
                }
                $transactiondtTmp = array(
                    'transactiontmp_id' => $header_response->transactiontmp_id,
                    'transactiontmpdt_BOE' => $modulesShipment['transactionBOE'],
                    'item_id' => $itemId,
                    'group_id' => $groupId,
                    'transactiondt_item_description' => $dtData['dtDecription'],
                    'item_quantity' => $dtData['item_quantity'],
                    'transactiontmpdt_billOfEntry' =>  $modulesShipment['transactionBillOfEntry'],
                    'transactiondttmp_locationid' => null,
                    'transactiondttmp_countryOfOrigin' => $countryId,
                    'transactiondttmp_price' => $dtData['transactiondt_price'],
                    'transactiondttmp_priceBase' => $dtData['transactiondt_priceBase'],
                    'id_reference_dt' => null,
                    'raw_in_grid' => null,
                    'palet_no' => null,
                    'item_weight' => $dtData['dtWeight'],
                    'item_qtyPerPack' => null,
                    'item_pack' => " ",
                    'transactiondttmp_nbOfCarton' => " ",
                    'transactiondttmp_cellMerge' => " ",
                    'item_unit' => null,
                    'client_id' => $clientId,
                    'transactiondttmp_fprice' => 0,
                    'transactiondttmp_fpriceBase' => 0,
                    'hscode' => $dtData['dtHscode'],
                    'supplier_invoice_number' => null,
                    'total_price' => 0,
                    'total_weight' => 0,
                    'state' => 'new',
                    'supplier_id' => $modulesShipment['transactionSupplier'],

                );
                $detail_response = transactiondttmp::create($transactiondtTmp);

                if (!$detail_response) {
                    transactiontmp::where('transactiontmp_id', $header_response->transactiontmp_id)->delete();
                    return ApiController::errorResponse('Unable to Sync Delivery', 422);
                }
            }
        } catch (Exception $e) {
            transactiontmp::where('transactiontmp_id', $header_response->transactiontmp_id)->delete();
            return ApiController::errorResponse('Unable to Sync Delivery', 422);
        }

        return ApiController::successResponse('success', 200);
    }


    public function updateLanguageUrl(Request $request)
    {
        $language = $request->header('language');
        $user_id = JWTAuth::user()->id;

        DB::table('users')
            ->where('id', $user_id)
            ->update([
                'language' => $language
            ]);

        return ApiController::successResponse('', 200);
    }





    function validateItem($item)
    {
        return $item ? '' : 'Invalid Item';
    }

    function validateQuantity($record)
    {
        return is_numeric($record) ? '' : 'Invalid QTY';
    }

    function validatePrice($record)
    {
        return is_numeric($record) ? '' : 'Invalid Price';
    }

    function validateWeight($record)
    {
        return isset($record) && is_numeric($record) ? '' : 'Invalid Weight';
    }

    function validateCountry($country)
    {
        return $country ? '' : 'Invalid Country';
    }

    function validateGrossWeight($totalWeight,$grossWeight)
    {
        if (!isset($grossWeight)) {
            return '';
        }

        if (!is_numeric($grossWeight)) {
            return 'Invalid Gross Weight';
        }

        if (is_numeric($totalWeight) && $grossWeight < $totalWeight) {
            return 'Invalid Gross Weight, Gross Weight must be greater than net weight';
        }

        return '';
    }

    public function grossWeightModule()
    {

        return companies::first()->company_grossWeight;
    }

    public function createErpProject($reference, $type, $name, $transId)
    {

        $typeProject = '';
        $code = '';

        if ($type == 'GOODS_IN') {
            $typeProject = 'GRN';
            $code = $reference;
            $name = $name . '(' . $reference . '/' . $typeProject . ')';
        };
        if ($type == 'DO') {
            $typeProject = 'DO';
            $code = $reference . '-' . $typeProject;
        }
        if ($type == 'INTERNAL_TRANSFER') {
            $typeProject = 'INT';
            $code = $reference . '-' . $typeProject;
        }

        $payload = array(
            'code' => $code,
            'name' => $name,
            'typeProject' => $typeProject,
            'transId' => $transId,
        );


        $response = $this->connectDataToErp('insertProjectFromLogisticom', $payload);
    }
    //TODO the below function should be refactored and moved to NotificationController
    public function sendCustomNotification($user, $code, $transactionId, $reference, $status = null)
    {
        $language = $user->language ?? 'en';
        $token = $user->user_pushToken;

        $title = notifications::notificationTopics[$code]['title_' . $language];
        $message = notifications::notificationTopics[$code]['message_' . $language];
        $message = str_replace('{{_reference}}', $reference, $message);

        $payload = [
            "message" => [
                "token" => $token,
                "notification" => [
                    "title" => $title,
                    "body"  => $message,
                ],
                "data" => [
                    'key' => $code,
                    'transId' => $transactionId != null ? (string) $transactionId : '',
                ], // Optional additional data

            ]
        ];
        $notification = array(
            'notification_title' => $title,
            'notification_description' => $message,
            'notification_seen' => 0,
            'notification_related_userid' => $user->id,
            'trans_id' => $transactionId,
            'notification_code' => $code
        );

        notifications::create($notification);

        return $this->firebaseNotificationUsers($payload);
    }
    public function getTimeZone()
    {
        $timezone = new DateTimeZone(config("app.timezone"));
        $datetime = new DateTime('now', $timezone);
        $offset = $timezone->getOffset($datetime);
        return $offset;
    }
}
