<?php

namespace App\Http\Controllers\mobile\Notifications;

use App\Http\Controllers\ApiController;
use App\Traits\Firebase;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use JWTAuth;

use App\Models\Localization;
use App\Models\notifications;
use App\Models\user;
use Illuminate\Support\Facades\Log;

class NotificationsController extends ApiController
{
    use Firebase;



    public function getNotifications(Request $request)
    {

        $user_id = JWTAuth::user()->id;

        $language = DB::table('users')->where('id', $user_id)->first()->language;
        $page = $request->page;
        $limit = $request->limit;
        $clientId = $request->clientId;
        $notifications = DB::table('notifications')
            ->join('clients', 'clients.client_id', 'notifications.notification_related_userid')
            ->join('users', 'users.id', 'clients.user_id')
            ->where([
                ['users.id', $user_id],
            ])
            ->when($clientId, function ($query) use ($clientId) {
                return $query->where([
                    ['notification_related_userId', $clientId],
                ]);
            })
            ->select('notifications.notification_code', 'trans_id', 'notifications.notification_title', 'notifications.notification_id', 'notifications.notification_description', 'notifications.notification_seen')
            ->orderBy('notification_date', 'desc')
            ->selectraw("DATE_FORMAT(notification_date, '%d-%M-%Y %H:%m') as notification_date_view")
            ->skip($page * $limit)
            ->limit($limit)
            ->get();


        foreach ($notifications as $splitNotification) {
            $splitNotification->notification_title = Localization::notificationKeys[$splitNotification->notification_code]['title_' . $language];
        }
        $allNotifications = DB::table('notifications')
            ->join('clients', 'clients.client_id', 'notifications.notification_related_userid')
            ->join('users', 'users.id', 'clients.user_id')
            ->where([
                ['users.id', $user_id],
            ])
            ->when($clientId, function ($query) use ($clientId) {
                return $query->where([
                    ['notification_related_userId', $clientId],
                ]);
            })
            ->get()
            ->count();

        if ($allNotifications) {
            $concatElements = array();
            $concatElements['data'] = $notifications;
            $concatElements['count'] = $allNotifications;
            return ApiController::successResponse($concatElements, 200);
        }
        return ApiController::successResponse($notifications, 204);
    }




}
