<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Log;

class RequestLoggerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */

    public $startTime;

    public function handle($request, Closure $next)
    {
        // Process the request
        $response = $next($request);

        // Log the request and response
        $logData = [
            'method' => $request->method(),
            'url' => $request->fullUrl(),
            'status' => $response->getStatusCode(),
            'request' => $request->all(),
        ];

        // Add the response content only for POST requests
        if ($request->isMethod('post')) {
            $logData['response'] = $response->getContent();
        }

        Log::channel('daily_log_requests')->debug('Endpoint accessed:',
            $logData);

        return $response;
    }

    public function terminate($request, $response)
    {

    }
}
