<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Localization extends Model
{
    use HasFactory;


    const moduleKeys = array(
        'direction' =>
        array(
            'en' => 'LTR',
            'ar' => 'RTL',
        ),
        'deliveryPicking' =>
        array(
            'en' => 'Picking-list',
            'ar' => 'Picking-list',
        ),
        'client' =>
        array(
            'en' => 'Client',
            'ar' => 'العميل',
        ),
        'ctn' =>
        array(
            'en' => 'CTN',
            'ar' => 'CTN',
        ),
        'deliveredItems' =>
        array(
            'en' => 'Delivered Items',
            'ar' => 'الأصناف المسلمة',
        ),
        'user' =>
        array(
            'en' => 'User',
            'ar' => 'المستخدم',
        ),
        'previousQty' =>
        array(
            'en' => 'Previous QTY',
            'ar' => 'الكمية السابقة',
        ),
        'deliveredQty' =>
        array(
            'en' => 'Delivered QTY',
            'ar' => 'الكمية المسلمة',
        ),
        'date' =>
        array(
            'en' => 'Date',
            'ar' => 'التاريخ',
        ),
        'item' =>
        array(
            'en' => 'Item',
            'ar' => 'الصنف',
        ),
        'item2' =>
        array(
            'en' => 'Item.',
            'ar' => 'الصنف.',
        ),
        'dec3' =>
        array(
            'en' => ' DEC No.',
            'ar' => 'رقم الـ DEC.',
        ),
        'type' =>
        array(
            'en' => 'Type',
            'ar' => 'النوع',
        ),
        'client2' =>
        array(
            'en' => 'Clients.',
            'ar' => 'العملاء.',
        ),
        'existingQty' =>
        array(
            'en' => 'Existing Qty',
            'ar' => 'الكمية الموجودة',
        ),
        'dec' =>
        array(
            'en' => 'DEC',
            'ar' => 'الـ DEC',
        ),
        'coo' =>
        array(
            'en' => 'COO',
            'ar' => 'مصدر المنتج (COO)',
        ),
        'report' =>
        array(
            'en' => 'Report',
            'ar' => 'التقرير',
        ),
        'reference' =>
        array(
            'en' => 'Ref.',
            'ar' => 'المرجع',
        ),
        'description' =>
        array(
            'en' => 'Description',
            'ar' => 'الوصف',
        ),
        'loc' =>
        array(
            'en' => 'Loc.',
            'ar' => 'الموقع',
        ),
        'qty' =>
        array(
            'en' => 'QTY.',
            'ar' => 'الكمية',
        ),
        'grandTotal' =>
        array(
            'en' => 'Grand Total',
            'ar' => 'الإجمالي الكلي',
        ),
        'total' =>
        array(
            'en' => 'Total',
            'ar' => 'الإجمالي',
        ),
        'deliveryNote' =>
        array(
            'en' => 'Delivery Note',
            'ar' => 'مذكرة التسليم',
        ),
        'deliveredToParty' =>
        array(
            'en' => 'Delivered to Party:',
            'ar' => 'تم التسليم للطرف:',
        ),
        'driverName' =>
        array(
            'en' => 'Driver Name:',
            'ar' => 'اسم السائق:',
        ),
        'vehicle' =>
        array(
            'en' => 'vehicle# :',
            'ar' => 'رقم المركبة:',
        ),

        'customer' =>
        array(
            'en' => 'Customer',
            'ar' => 'العميل',
        ),
        'modelNO' =>
        array(
            'en' => 'Model No.',
            'ar' => 'الرقم الموديلي',
        ),
        'descOfGoods' =>
        array(
            'en' => 'Desc. of Goods',
            'ar' => 'وصف البضائع',
        ),
        'hscode' =>
        array(
            'en' => 'HS Code',
            'ar' => 'الكود الجمركي (HS)',
        ),
        'noOfCtn' =>
        array(
            'en' => 'No. of PKG',
            'ar' => 'عدد الكراتين',
        ),
        'qty/pcs' =>
        array(
            'en' => 'Qty/Pcs',
            'ar' => 'الكمية/القطع',
        ),
        'goodsInRemark' =>
        array(
            'en' => 'Goods are received in good condition and as per the order.',
            'ar' => 'تم استلام البضائع في حالة جيدة ووفقًا للطلب.',
        ),
        'authSign' =>
        array(
            'en' => 'Authorised Signature: ',
            'ar' => 'التوقيع المعتمد:',
        ),
        'customSign' =>
        array(
            'en' => 'CUSTOMS STAMP: ',
            'ar' => 'التوقيع المعتمد:',
        ),
        'companySign' =>
        array(
            'en' => 'STAMP & SIGN: ',
            'ar' => 'التوقيع المعتمد:',
        ),
        'receivedBy' =>
        array(
            'en' => 'Received By:',
            'ar' => 'استلمها:',
        ),
        'totalNOQty/pcs' =>
        array(
            'en' => 'Total No of Qty/Pcs: ',
            'ar' => 'العدد الإجمالي للكمية/القطع:',
        ),
        'countryOfOrigin' =>
        array(
            'en' => 'Country Of Origin:',
            'ar' => 'بلد المنشأ:',
        ),
        'hscodes' =>
        array(
            'en' => 'HS Code(s):',
            'ar' => 'الكود الجمركي (HS):',
        ),
        'totalGrossWeight' =>
        array(
            'en' => 'Total Gross Weight:',
            'ar' => 'الوزن الإجمالي القائم:',
        ),
        'totalNetWeight' =>
            array(
                'en' => 'Total Net Weight:',
                'ar' => 'الوزن الإجمالي القائم:',
            ),
        'kgs' =>
        array(
            'en' => '-kgs',
            'ar' => '-كيلوغرام',
        ),
        'invoice' =>
        array(
            'en' => 'Invoice #',
            'ar' => 'رقم الفاتورة:',
        ),
        'commercialFields' =>
        array(
            'en' => 'Pkg Count/Type',
            'ar' => 'عدد الحزم/النوع',
        ),
        'shipToParty' =>
        array(
            'en' => 'Ship To Party: ',
            'ar' => 'الطرف المستلم:',
        ),
        'billToParty' =>
        array(
            'en' => 'Bill To Party: ',
            'ar' => 'الطرف المُحاسب:',
        ),
        'commercialTitle' =>
        array(
            'en' => 'COMMERCIAL INVOICE / PACKING LIST',
            'ar' => 'فاتورة تجارية / قائمة التعبئة',
        ),
        'palletNo' =>
        array(
            'en' => 'P#',
            'ar' => 'رقم البالت (P#)',
        ),
        'up' =>
        array(
            'en' => 'U/P',
            'ar' => 'الوحدة/الحزمة (U/P)',
        ),
        'gw' =>
        array(
            'en' => 'GW (KG)',
            'ar' => 'الوزن الإجمالي (كيلوغرام)',
        ),
        'deliveryAdvice' =>
        array(
            'en' => 'Delivery Advice',
            'ar' => 'نصيحة التسليم',
        ),

        'title2' => array(
            'en' => 'FZE LIC NO.',
            'ar' => 'رقم الترخيص لشركة FZE:'
        ),
        'title3' => array(
            'en' => 'The Director,',
            'ar' => 'المدير:'
        ),
        'title4' => array(
            'en' => 'IMPORT CODE',
            'ar' => 'كود الاستيراد:'
        ),
        'title5' => array(
            'en' => 'Dept of Port & Customs',
            'ar' => 'قسم الجمارك والموانئ:'
        ),
        'title6' => array(
            'en' => 'INV NO.',
            'ar' => 'رقم الفاتورة:'
        ),

        'title8' => array(
            'en' => 'Please authorize release of the below mentioned goods from our warehouse to',
            'ar' => 'الرجاء الموافقة على إطلاق البضائع المذكورة أدناه من مستودعنا إلى'
        ),

        'title10' => array(
            'en' => 'Type of Packing',
            'ar' => 'نوع التعبئة:'
        ),

        'title12' => array(
            'en' => 'GW (Kg)',
            'ar' => 'الوزن (كغ):'
        ),
        'title13' => array(
            'en' => 'COO',
            'ar' => 'مكان المنشأ:'
        ),
        'title14' => array(
            'en' => 'Value',
            'ar' => 'القيمة:'
        ),
        'title15' => array(
            'en' => 'Total',
            'ar' => 'المجموع:'
        ),
        'title16' => array(
            'en' => '',
            'ar' => ''
        ),
        'title17' => array(
            'en' => 'Qty of Ctn',
            'ar' => 'عدد الصناديق:'
        ),
        'title18' => array(
            'en' => '',
            'ar' => ''
        ),
        'title19' => array(
            'en' => 'HS Code',
            'ar' => 'رمز النظام المنسق:'
        ),
        'title20' => array(
            'en' => 'Type of Packing',
            'ar' => 'نوع التعبئة:'
        ),
        'title21' => array(
            'en' => 'Qty',
            'ar' => 'الكمية:'
        ),
        'title22' => array(
            'en' => 'GW (Kg)',
            'ar' => 'الوزن (كغ):'
        ),
        'title23' => array(
            'en' => 'COO',
            'ar' => 'مكان المنشأ:'
        ),
        'title24' => array(
            'en' => 'Value (Currency)',
            'ar' => 'القيمة (العملة):'
        ),
        'title25' => array(
            'en' => '',
            'ar' => ''
        ),
        'title26' => array(
            'en' => 'Total',
            'ar' => 'المجموع:'
        ),
        'title27' => array(
            'en' => '',
            'ar' => ''
        ),
        'title28' => array(
            'en' => 'Qty of Ctn',
            'ar' => 'عدد الصناديق:'
        ),
        'title29' =>
        array(
            'en' => 'TRANSFER OF OWNERSHIP',
            'ar' => 'نقل الملكية',
        ),
        'title30' =>
        array(
            'en' => 'Please note that I/We ',
            'ar' => 'يرجى ملاحظة أنني/نحن',
        ),
        'title31' =>
        array(
            'en' => ' Invoice TRANSFER OF OWNERSHIP',
            'ar' => 'فاتورة نقل الملكية',
        ),
        'title32' =>
        array(
            'en' => 'No Of Pkgs.',
            'ar' => 'عدد الحزم',
        ),
        'title33' =>
        array(
            'en' => ' Gross Weight(KGS):',
            'ar' => 'الوزن الإجمالي (كيلوغرام):',
        ),
        'title34' =>
        array(
            'en' => 'Desc. of content(s)/Pcs:',
            'ar' => 'وصف المحتوى/القطع:',
        ),
        'title35' =>
        array(
            'en' => 'Value Of the Goods:',
            'ar' => 'قيمة البضائع:',
        ),
        'title36' =>
        array(
            'en' => ' Country of origin(s):',
            'ar' => 'بلد المنشأ:',
        ),
        'title37' =>
        array(
            'en' => 'I/We',
            'ar' => 'أنا/نحن',
        ),
        'title38' =>
        array(
            'en' => 'Hereby certify that as from this date, we the owner of the above mentioned goods and we undertake to pay when called upon to do so, all port storage, other charges and occurring thereon.',
            'ar' => 'نشهد بهذا أنه اعتبارًا من هذا التاريخ، نحن مالكو البضائع المذكورة أعلاه ونتعهد بأن ندفع عند الطلب جميع رسوم التخزين في الميناء وأية تكاليف أخرى.',
        ),
        'title39' =>
        array(
            'en' => 'Transferee\'s Stamp & Signature: ',
            'ar' => 'ختم وتوقيع المستفيد:',
        ),
        'customBillType' =>
        array(
            'en' => 'Custom Bill Type:',
            'ar' => 'نوع الفاتورة الجمركية:',
        ),
        'paymentMethod' =>
        array(
            'en' => 'Payment Method: ',
            'ar' => 'طريقة الدفع:',
        ),
        'paymentMethod2' =>
        array(
            'en' => 'Payment Method',
            'ar' => 'طريقة الدفع',
        ),
        'dec2' =>
        array(
            'en' => 'Declaration No./BoE No.:',
            'ar' => 'رقم البيان/رقم إذن الإفراج الجمركي:',
        ),
        'statementOfItem' =>
        array(
            'en' => 'Statement Of Item',
            'ar' => 'بيان البند',
        ),
        'exitPoint' =>
        array(
            'en' => 'Exit Point',
            'ar' => 'نقطة الخروج',
        ),
        'destination' =>
        array(
            'en' => 'Destination',
            'ar' => 'الوجهة',
        ),
        'from' =>
        array(
            'en' => 'From',
            'ar' => 'من',
        ),
        'to' =>
        array(
            'en' => 'To',
            'ar' => 'إلى',
        ),
        'itemCode' =>
        array(
            'en' => 'Item Code',
            'ar' => 'رمز البند',
        ),
        'itemDesc' =>
        array(
            'en' => 'Item Description',
            'ar' => 'وصف البند',
        ),
        'billOfEntry' =>
        array(
            'en' => 'Bill OF Entry',
            'ar' => 'إذن الإفراج الجمركي',
        ),
        'boe' =>
        array(
            'en' => 'BOE',
            'ar' => 'إذن الإفراج الجمركي (BOE)',
        ),
        'unitCost' =>
        array(
            'en' => 'Unit Cost',
            'ar' => 'تكلفة الوحدة',
        ),
        'existing' =>
        array(
            'en' => 'Existing',
            'ar' => 'الموجود',
        ),
        'totalCost' =>
        array(
            'en' => 'Total Cost',
            'ar' => 'التكلفة الإجمالية',
        ),
        'qtyOut' =>
        array(
            'en' => 'Qty. Out',
            'ar' => 'الكمية المنصرفة',
        ),
        'qtyIn' =>
        array(
            'en' => 'Qty. In',
            'ar' => 'الكمية المستلمة',
        ),
        'prevQty' =>
        array(
            'en' => 'Prev. Qty',
            'ar' => 'الكمية السابقة',
        ),
        'totalWeight' =>
        array(
            'en' => 'Total. Weight',
            'ar' => 'الوزن الإجمالي',
        ),
        'inventoryReport' =>
        array(
            'en' => 'Inventory Report',
            'ar' => 'تقرير المخزون',
        ),
        'inventory' =>
        array(
            'en' => 'Inventory',
            'ar' => 'المخزون',
        ),
        'supplier' =>
        array(
            'en' => 'Supplier',
            'ar' => 'المورد',
        ),
        'supplierInvoice' =>
        array(
            'en' => 'Supplier Invoice',
            'ar' => 'فاتورة المورد',
        ),

        'currency' => array(
            'en' => 'Currency',
            'ar' => 'العملة'
        ),
        'remark' => array(
            'en' => 'Remark',
            'ar' => 'ملاحظة'
        ),
        'quantity' => array(
            'en' => 'Quantity',
            'ar' => 'الكمية'
        ),
        'location' => array(
            'en' => 'Location',
            'ar' => 'الموقع'
        ),
        'country' => array(
            'en' => 'Country',
            'ar' => 'الدولة'
        ),
        'destPt' => array(
            'en' => 'Desti. Pt',
            'ar' => 'نقطة الوجهة'
        ),
        'cuBillType' => array(
            'en' => ' Cus.Bill Type',
            'ar' => 'نوع الفاتورة الجمركية'
        ),
        'paymentM' => array(
            'en' => 'payment Met.',
            'ar' => 'طريقة الدفع'
        ),
        'curr' => array(
            'en' => 'Curr.',
            'ar' => 'العملة'
        ),
        'typeOfDe' => array(
            'en' => 'Type Of Del.',
            'ar' => 'نوع التسليم'
        ),
        'outBound' => array(
            'en' => 'Out Bound BOE',
            'ar' => 'إذن الإفراج الجمركي الصادر'
        ),
        'delivery' => array(
            'en' => 'Delivery',
            'ar' => 'التوصيل'
        ),
        'listOfDelivery' => array(
            'en' => 'List Of Deliveries',
            'ar' => 'قائمة التوصيل'
        ),
        'totalWgt' => array(
            'en' => 'Total Wgt',
            'ar' => 'الوزن الإجمالي'
        ),
        'wgt' => array(
            'en' => 'WGT',
            'ar' => 'الوزن'
        ),
        'des' => array(
            'en' => 'Des.',
            'ar' => 'الوجهة'
        ),
        'qty/pack' => array(
            'en' => 'qty/Pck',
            'ar' => 'الكمية/العبوة'
        ),
        'totalPrice' => array(
            'en' => 'Total price',
            'ar' => 'السعر الإجمالي'
        ),
        'uPrice' => array(
            'en' => 'U.price',
            'ar' => 'سعر الوحدة'
        ),
        'decNo' => array(
            'en' => 'DEC No.',
            'ar' => 'DEC No.',
        ),
        'unit' => array(
            'en' => 'Unit',
            'ar' => 'Unit',
        ),
        'wght' => array(
            'en' => 'Wght',
            'ar' => 'Wght',
        ),
        'price' => array(
            'en' => 'Price',
            'ar' => 'Price',
        ),
        'pack' => array(
            'en' => 'Pack',
            'ar' => 'Pack',
        ),
        'rmaOut' => array(
            'en' => 'RMA Out',
            'ar' => 'RMA Out',
        ),
        'truckNo' => array(
            'en' => 'Truck No',
            'ar' => 'Truck No',
        ),
        'manifestNo' => array(
            'en' => 'Manifest No',
            'ar' => 'Manifest No',
        ),
        'diverName' => array(
            'en' => 'Driver Name',
            'ar' => 'Driver Name',
        ),
        'etd' => array(
            'en' => 'ETD',
            'ar' => 'ETD',
        ),
        'declaration' => array(
            'en' => 'Declaration',
            'ar' => 'Declaration',
        ),
        'mobno' => array(
            'en' => 'MOB No',
            'ar' => 'MOB No',
        ),
        'sealNo' => array(
            'en' => 'SEAL No',
            'ar' => 'SEAL No',
        ),
        'webNo' => array(
            'en' => 'WB No',
            'ar' => 'WB No',
        ),
        'shipper' => array(
            'en' => 'Shipper',
            'ar' => 'Shipper',
        ),
        'consignee' => array(
            'en' => 'Consignee',
            'ar' => 'Consignee',
        ),
        'dest' => array(
            'en' => 'Dest',
            'ar' => 'Dest',
        ),
        'qtytype' => array(
            'en' => 'Qty/Type',
            'ar' => 'Qty/Type',
        ),
        'netWeight' => array(
            'en' => 'Net Weight',
            'ar' => 'Net Weight',
        ),
        'value' => array(
            'en' => 'Value',
            'ar' => 'Value',
        ),
        'commudity' => array(
            'en' => 'Commudity',
            'ar' => 'Commudity',
        ),
        'grossWeight' =>
        array(
            'en' => ' GW',
            'ar' => 'الوزن الإجمالي',
        ),
        'allclients' => array(
            'en' => 'All',
            'ar' => 'All',
        ),
        'customers' => array(
            'en' => 'Customers',
            'ar' => 'Customers',
        ),
        'clients' => array(
            'en' => 'Clients',
            'ar' => 'Clients',
        ),
        'suppliers' => array(
            'en' => 'Suppliers',
            'ar' => 'Suppliers',
        ),
        'qtyPerPcs' => array(
            'en' => 'Qty/PCS',
            'ar' => 'Qty/PCS',
        ),
        'qtyPerWeight' => array(
            'en' => 'Qty/Weight',
            'ar' => 'Qty/Weight',
        ),
        'unitTypePcs' => array(
            'en' => 'PCS',
            'ar' => 'PCS',
        ),
        'unitTypeWeight' => array(
            'en' => 'Weight',
            'ar' => 'Weight',
        ),
        'descOfContent' => array(
            'en' => 'Desc. of content(s)',
            'ar' => 'Desc. of content(s)',
        ),
        'totalNOQty/unit' =>
        array(
            'en' => 'Total No of Qty/',
            'ar' => 'العدد الإجمالي للكمية/القطع:',
        ),
        'deliveredQty' =>
        array(
            'en' => 'Delivered QTY',
            'ar' => 'Delivered QTY',
        ),
        'deliveredQty' =>
        array(
            'en' => 'Delivered QTY',
            'ar' => 'Delivered QTY',
        ),
        'canceledQty' =>
        array(
            'en' => 'Canceled QTY',
            'ar' => 'Canceled QTY',
        ),
        'remainingQty' =>
        array(
            'en' => 'Remaining QTY',
            'ar' => 'Remaining QTY',
        ),
        'deliveredQtyInvoice' =>
        array(
            'en' => 'Delivered Invoice',
            'ar' => 'Delivered Invoice',
        ),
        'tcn' =>
        array(
            'en' => 'TCN / WB #',
            'ar' => 'Delivered Invoice',
        ),
        'tir' =>array(
            'en' => 'TIR CARNET #',
            'ar' => 'Delivered Invoice',
        ),
        'forwarder' =>array(
            'en' => 'Forwarder',
            'ar' => 'Forwarder',
        ),
        'decRequiredForAllItems' =>array(
            'en' => 'DEC Required For All Items',
            'ar' => 'DEC Required For All Items',
        ),
        'amount' =>array(
            'en' => 'Amount',
            'ar' => 'Amount',
        ),
        'cost' =>array(
            'en' => 'Cost',
            'ar' => 'Cost',
        ),
        'notifyParty' =>array(
            'en' => 'Notify Party',
            'ar' => 'Notify Party',
        ),

        'clients2' =>array(
            'en' => 'Client',
            'ar' => 'Client',
        ),
        'no' =>array(
            'en' => 'No',
            'ar' => 'No',
        ),
        'inv' =>array(
            'en' => 'INV #',
            'ar' => 'INV #',
        ),
        'tcn2' =>array(
            'en' => 'TCN #',
            'ar' => 'TCN #',
        ),
        'pkgTypePerCount' =>array(
            'en' => 'PKG Type/Count',
            'ar' => 'PKG Type/Count',
        ),
        'nw' =>array(
            'en' => 'NW(KG)',
            'ar' => 'NW(KG)',
        ),
        'nw2' =>array(
            'en' => 'NET Weight(KGS):',
            'ar' => 'NET Weight(KGS):',
        ),
        'reportStorage' =>array(
            'en' => 'Rent Storage Report',
            'ar' => 'Rent Storage Report',
        ),
        'payment' =>array(
            'en' => 'Payment',
            'ar' => 'Payment',
        ),
        'dueBalance' =>array(
            'en' => 'Due Balance',
            'ar' => 'Due Balance',
        ),
        'dailyValue' =>array(
            'en' => 'Daily Value',
            'ar' => 'Daily Value',
        ),
        'totalValue' =>array(
            'en' => 'Total Value',
            'ar' => 'Total Value',
        ),
        'cbmIn' =>array(
            'en' => ' CBM/In',
            'ar' => ' CBM/In',
        ),
        'cbmOut' =>array(
            'en' => 'CBM/Out',
            'ar' => 'CBM/Out',
        ),
        'cbmBalance' =>array(
            'en' => 'CBM Balance',
            'ar' => 'CBM Balance',
        ),
        'prevCbm' =>array(
            'en' => ' Previous CBM Balance',
            'ar' => ' Previous CBM Balance',
        ),
        'prevDue' =>array(
            'en' => 'Previous Due Balance',
            'ar' => 'Previous Due Balance',
        ),
        'hasFiles' =>array(
            'en' => 'Has Files',
            'ar' => 'Has Files',
        ),
        'clientMovement' =>array(
            'en' => ' Client Movement',
            'ar' => ' Client Movement',
        ),


    );


    const notificationKeys = array(
        'DO_RELEASED' =>
        array(
            'code' => 'DO_RELEASED',
            'title_ar' => 'Delivery Released ar',
            'title_en' => 'Delivery Released',
            'message_en' => 'Delivery Items with Reference: {{referenceKey}} Released',
            'message_ar' => 'Delivery Items with Reference:{{referenceKey}} ar Released',
        ),
        'Delivery_Status_UnReleased' =>
        array(
            'code' => 'Delivery_Status_UnReleased',
            'title_ar' => 'Delivery Status ar',
            'title_en' => 'Delivery Status',
            'message_en' => 'Delivery Items with Reference: {{referenceKey}} UnReleased',
            'message_ar' => 'Delivery Items with Reference:{{referenceKey}} ar UnReleased',
        ),

        'Delivery_Created' =>
        array(
            'code' => 'Delivery_Created',
            'title_ar' => 'Delivery Order ar',
            'title_en' => 'Delivery Order',
            'message_en' => 'Delivery Items with Reference: {{referenceKey}} was created',
            'message_ar' => 'Delivery Items with Reference:{{referenceKey}} ar was created',
        ),
        'Delivery_Created_mobile' =>
        array(
            'code' => 'Delivery_Created_mobile',
            'title_ar' => 'Delivery Order ar',
            'title_en' => 'Delivery Order',
            'message_en' => 'Delivery Items  was created',
            'message_ar' => 'Delivery Items  was created',
        ),
        'Delivery_Status_Deleted' =>
        array(
            'code' => 'Delivery_Status_Deleted',
            'title_ar' => 'Delivery Order ar',
            'title_en' => 'Delivery Order',
            'message_en' => 'Delivery Status with reference: {{referenceKey}} was deleted',
            'message_ar' => 'Delivery Status with reference:{{referenceKey}} ar was deleted',
        ),
        'Insert_Custom_Status' =>
        array(
            'code' => 'Insert_Custom_Status',
            'title_ar' => 'Delivery Status ar',
            'title_en' => 'Delivery Status',
            // 'message_en' => 'Delivery Status with reference: {{referenceKey}} was deleted',
            // 'message_ar' => 'Delivery Status with reference:{{referenceKey}} ar was deleted',
        ),

        'GoodsIn_Created' =>
        array(
            'code' => 'GoodsIn_Created',
            'title_ar' => 'GoodsIn Order ar',
            'title_en' => 'GoodsIn Order',
            'message_en' => 'GoodsIn Items with Reference: {{referenceKey}} was created',
            'message_ar' => 'GoodsIn Items with Reference:{{referenceKey}} ar was created',
        ),
        'Forwarder_created' =>
        array(
            'code' => 'Forwarder_created',
            'title_ar' => 'Forwarder ar',
            'title_en' => 'Forwarder',
            'message_en' => 'New Forwarder Transaction was created',
            'message_ar' => 'New Forwarder Transaction was created ar',
        ),
        'Forwarder_deleted' =>
        array(
            'code' => 'Forwarder_deleted',
            'title_ar' => 'Forwarder ar',
            'title_en' => 'Forwarder',
            'message_en' => 'Forwarder Transaction was removed',
            'message_ar' => 'Forwarder Transaction was removed ar',
        ),
    );




    public static function  getMessageWithReference($code, $lang = 'en', $transactionId = null, $defaultMessage)
    {
        $message = isset(self::notificationKeys[$code]['message_' . $lang]) ? self::notificationKeys[$code]['message_' . $lang] : $defaultMessage;

        $reference = null;
        $transaction = DB::table('transactions')
            ->where('transaction_id', $transactionId)
            ->first();
        if ($transaction) {

            $reference = $transaction->transaction_reference;
        }
        if ($reference) {
            $message = str_replace('{{referenceKey}}', $reference, $message);
        }

        return $message;
    }
}
