<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class transactiondttmp extends Model
{
    use HasFactory;

    public $timestamps = false;
    protected $primaryKey = 'transactiondttmp_id';
    protected $fillable = [
        'transactiondttmp_id',
        'transactiontmp_id',
        'item_id',
        'item_quantity',
        'supplier_id',
        'supplier_invoice_number',
        'transactiondttmp_locationid',
        'transactiondttmp_countryOfOrigin',
        'transactiontmpdt_billOfEntry',
        'transactiondttmp_price',
        'id_reference_dt',
        'raw_in_grid',
        'client_id',
        'item_weight',
        'item_qtyPerPack',
        'item_pack', 'group_id', 'palet_no',
        'transactiondttmp_nbOfCarton',
        'transactiondttmp_cellMerge',
        'item_unit',
        'transactiontmpdt_BOE', 'item_hscode',
        'transactiondttmp_priceBase',
        'transactiondttmp_fprice',
        'transactiondttmp_fpriceBase',
        'hscode', 'transactiondt_item_description',
        'total_price',
        'total_weight',
        'item_quantity_to_delivery',
        'item_quantity_to_cancel',
        'reference_from_do',
        'dt_transaction_type',
        'reference_internal_dt',
        'total_gross_weight',
        'gross_weight'
    ];

    public static function updatePriceBase($getCurrentTransaction, $transactionTmpId, $rate)
    {
        if ($getCurrentTransaction && $getCurrentTransaction->transactiontmp_rate) {
            if ($getCurrentTransaction->transactiontmp_rate != $rate) {

                $transactionDts = transactiondttmp::getFromTransactionId($transactionTmpId);
                foreach ($transactionDts as $transactionDts) {
                    transactiondttmp::where('transactiondttmp_id', '=', $transactionDts->transactiondttmp_id)->update([
                        "transactiondttmp_priceBase" => $transactionDts->transactiondttmp_price * $rate
                    ]);
                }
            }
        }
    }

    public static function getFromTransactionId($transactionTmpId)
    {
        return self::where('transactiontmp_id', '=', $transactionTmpId)
            ->get();
    }

    public static function createTransactionInternaldt($payload)
    {
        $transactionType = $payload['transactionType'];
        $transactionTmpId = $payload['transactionTmpId'];
        $transactionDtTmp = $payload['transactionDtTmp'];
        $idReference = $payload['idReference'];
        if ($transactionType == "INTERNAL_TRANSFER") {
            $transferTrans = transactiontmp::where('relatedTransferId', $transactionTmpId)
                ->first();
            $transactionDtTmp["transactiontmp_id"] = $transferTrans->transactiontmp_id;
            $transactionDtTmp["client_id"] = $transferTrans->transactiontmp_clientId;
            $transactionDtTmp["dt_transaction_type"] = 'GOODS_IN';
            $transactionDtTmp["reference_internal_dt"] = $idReference;

            unset($transactionDtTmp["id_reference_dt"]);
            //  $transactionDtTmp["id_reference_dt"]=$transferTrans->transactiontmp_id;
            $newTransactionDtTmpTrans = transactiondttmp::create($transactionDtTmp);
            $newTransactionDtTmp['transdtId'] = $newTransactionDtTmpTrans->transactiondttmp_id;
        }
    }

    public static function updateTransactionInternaldt($request, $transactionDtTmp, $transactiondttmp_id,$newQty)
    {

        if ($request->transactionType == "INTERNAL_TRANSFER") {
            $transferTrans = transactiontmp::where('relatedTransferId', $request->transactionTmpId)
                ->first();
            //     $transactionDtTmp["transactiontmp_id"] =$transferTrans->transactiontmp_id;
            unset($transactionDtTmp["id_reference_dt"]);
            $transactionDtTmp["client_id"] = $transferTrans->transactiontmp_clientId;

            //   //  $transactionDtTmp["id_reference_dt"]=$transferTrans->transactiontmp_id;
            $newTransactionDtTmp2 = transactiondttmp::where('transactiondttmp_id', '=', $request->transactiondttmp_idTransfer)
                ->update($transactionDtTmp);

                $newTransactionDtTmp2 = transactiondttmp::where('reference_internal_dt',$transactiondttmp_id)
                    ->update([
                        'item_quantity' => $newQty
                    ]);
            $newTransactionDtTmp['transdtId'] = $request->transactiondttmp_idTransfer;
        }
    }
}
