<?php

namespace App\Models;

use App\Http\Controllers\BackOffice\GoodsIn\GoodsInController;
use App\Http\Controllers\BackOffice\History\HistoryController;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class transactions extends Model
{
    use HasFactory;

    // protected $primaryKey='transaction_id';
    const emptyBoe = '-';
    const transactionTypes = array(
        'DO' =>
        array(
            'type' => 'DO',
            'internalTransfer' => 0,
            'status' => 'out',
            'ar' => 'المسلم'

        ),
        'INTERNAL_TRANSFER' =>
        array(
            'type' => 'DO',
            'internalTransfer' => 1,
            'status' => 'out',
            'ar' => 's'

        ),
        'RMA_OUT' =>
        array(
            'type' => 'RMA_OUT',
            'internalTransfer' => false,
            'status' => 'out',
            'ar' => 'المرتجع'

        ),
        'GOODS_IN' =>
        array(
            'type' => 'GOODS_IN',
            'internalTransfer' => 0,
            'status' => 'in',
            'ar' => 'الوارد'
        ),
        'RMA_IN' =>
        array(
            'type' => 'RMA_IN',
            'internalTransfer' => 0,
            'status' => 'in',
            'ar' => 'المرتجع'

        ),
        'DQ' =>
        array(
            'type' => 'DQ',
            'internalTransfer' => 0,
            'status' => 'out',
            'ar' => 'DQ'

        ),
        'TO' =>
        array(
            'type' => 'TO',
            'internalTransfer' => 0,
            'status' => 'out',
            'ar' => 'المسلم'

        ),
    );
    public $timestamps = true;
    protected $fillable = [
        'transaction_id',
        'transaction_reference',
        'transaction_date',
        'transaction_billOfEntry',
        'transaction_clientId',
        'transaction_type',
        'transaction_remark',
        'transaction_typeOfDeliveryId',
        'clientCustomer_id',
        'transaction_shipmentReference',
        'transaction_mobileReference',
        'user_id',
        'transaction_driverPhone',
        'forwarder_id',
        'transaction_driverName',
        'transaction_vehicleNumber',
        'transaction_exitPoint',
        'transaction_destinationPoint',
        'company_id',
        'transaction_paymentMethodId',
        'transaction_customBillTypeId',
        'transaction_currencyId',
        'transaction_shipmentTypeId',
        'transaction_shipById',
        'transaction_shipmentRemark',
        'transaction_supplierId',
        'transaction_supplierInvoice',
        'transaction_totalQty',
        'transaction_released',
        'transaction_releasedUser',
        'transaction_releasedDate',
        'transaction_totalPallet',
        'transaction_totalPrice',
        'transaction_totalItem',
        'transaction_BOE',
        'salesjv_id',
        "transaction_rate",
        'Invoice_type_id',
        'payment_term_id',
        'delivery_term_id',
        'exemption_type_id',
        'internal_transfer',
        'transferTo_clientId',
        'relatedTransferId',
        'transaction_released_DEC',
        'showInDocument',
        'transaction_time',
        'transaction_arrived',
        'payment_methods',
        'way_bill_no',
        'tir',
        'job_no',
        'salesjv_discount',


    ];

    public static function getTransaction($transactionId)
    {
        return self::where('transaction_id', '=', $transactionId)
            ->first();
    }

    public static function createInternalTransaction($newTransaction, $goodsInSequence)
    {
        $goodsIn = new GoodsInController();


        $transferTrans = transactiontmp::where('relatedTransferId', $newTransaction->transaction_id)
            ->first();

        if (!$transferTrans) return;

        $transactionInternalTmp = array(
            'transaction_id' => $transferTrans->transactiontmp_id,
            'transaction_reference' => $goodsInSequence,
            'transaction_date' => $transferTrans->transactiontmp_date,
            'transaction_type' => "GOODS_IN",
            'transaction_remark' => $transferTrans->transactiontmp_remark,
            'transaction_clientId' => $transferTrans->transactiontmp_clientId,
            'transaction_currencyId' => $transferTrans->transactiontmp_currencyId,
            'internal_transfer' => $transferTrans->internal_transfer,
            'user_id' => $newTransaction->user_id,
            'relatedTransferId' => $transferTrans->relatedTransferId,
            'company_id' => $transferTrans->company_id,

        );
        $newInternalTransactionTmp = transactions::create($transactionInternalTmp);

        $transactiondtsTransfer = transactiondttmp::where([
            ['transactiontmp_id', $transferTrans->transactiontmp_id]
        ])->get();

        foreach ($transactiondtsTransfer as $details) {
            $transactionDtArray = array(
                'transactiondt_id' => $details->transactiondttmp_id,
                'transaction_id' => $details->transactiontmp_id,
                'item_id' => $details->item_id,
                'client_id' => $details->relatedTransferId,
                'item_quantity' => $details->item_quantity,
                'supplier_id' => $details->supplier_id,
                'supplier_invoice_number' => $details->supplier_invoice_number,
                'transactiondt_locationid' => $details->transactiondttmp_locationid,
                'transactiondt_countryOfOrigin' => $details->transactiondttmp_countryOfOrigin,
                'transactiondt_price' => $details->transactiondttmp_price,
                'id_reference_dt' => $details->id_reference_dt,
                'transactiondt_billOfEntry' => $details->transactiontmpdt_billOfEntry,
                'raw_in_grid' => $details->raw_in_grid,
                'item_weight' => $details->item_weight,
                'item_unit' => $details->item_unit,
                'item_qtyPerPack' => $details->item_qtyPerPack,
                'item_pack' => $details->item_pack,
                'group_id' => $details->group_id,
                'palet_no' => $details->palet_no,
                'transactiondt_nbOfCarton' => $details->transactiondttmp_nbOfCarton,
                'transactiondt_cellMerge' => $details->transactiondttmp_cellMerge,
                //  'transactiondt_BOE' => $BOE,
                'client_id' => $details->client_id,
                'transactiondt_fprice' => $details->transactiondttmp_fprice,
                'transactiondt_fpriceBase' => $details->transactiondttmp_fpriceBase,
                'transactiondt_priceBase' => $details->transactiondttmp_priceBase,
                'hscode' => $details->hscode,
                'transactiondt_item_description' => $details->transactiondt_item_description,
                'reference_internal_dt' => $details->reference_internal_dt

            );
            transactionDt::create($transactionDtArray);
            $goodsIn->createClientItems($details, $newTransaction->transferTo_clientId);
            $historyController = new HistoryController();
            $date = date('Y-m-d H:i:s');
        }

        // $transactionIndex =  $historyController->insertTransactionHistoryDataByRef('Insert', $newTransaction->transaction_reference,
        // auth()->user()->id, $date,$newTransaction->transaction_type);
        transactiontmp::where('transactiontmp_id', $transferTrans->transactiontmp_id)->delete();
    }

    public static function updateInternalTransaction($newTransaction, $goodsInSequence)
    {
        $goodsIn = new GoodsInController();


        $transferTrans = transactiontmp::where('relatedTransferId', $newTransaction->transaction_id)
            ->first();

        if (!$transferTrans) return;

        transactions::where('relatedTransferId', $newTransaction->transaction_id)
        ->update(
            [
                'transaction_date' =>$newTransaction->transaction_date,
                'transaction_remark' =>$newTransaction->transaction_remark
            ]
            );
        

        $transactiondtsTransfer = transactiondttmp::leftjoin('transactiontmps','transactiontmps.transactiontmp_id','transactiondttmps.transactiontmp_id')
        ->where([
            ['transactiondttmps.transactiontmp_id', $newTransaction->transaction_id]
        ])->orwhere([
            ['relatedTransferId', $newTransaction->transaction_id]
        ])
        
        ->get();
      

        foreach ($transactiondtsTransfer as $details) {
            $transactionDtArray = array(
                'transactiondt_id' => $details->transactiondttmp_id,
                'transaction_id' => $details->transactiontmp_id,
                'item_id' => $details->item_id,
                'client_id' => $details->relatedTransferId,
                'item_quantity' => $details->item_quantity,
                'supplier_id' => $details->supplier_id,
                'supplier_invoice_number' => $details->supplier_invoice_number,
                'transactiondt_locationid' => $details->transactiondttmp_locationid,
                'transactiondt_countryOfOrigin' => $details->transactiondttmp_countryOfOrigin,
                'transactiondt_price' => $details->transactiondttmp_price,
                'id_reference_dt' => $details->id_reference_dt,
                'transactiondt_billOfEntry' => $details->transactiontmpdt_billOfEntry,
                'raw_in_grid' => $details->raw_in_grid,
                'item_weight' => $details->item_weight,
                'item_unit' => $details->item_unit,
                'item_qtyPerPack' => $details->item_qtyPerPack,
                'item_pack' => $details->item_pack,
                'group_id' => $details->group_id,
                'palet_no' => $details->palet_no,
                'transactiondt_nbOfCarton' => $details->transactiondttmp_nbOfCarton,
                'transactiondt_cellMerge' => $details->transactiondttmp_cellMerge,
                //  'transactiondt_BOE' => $BOE,
                'client_id' => $details->client_id,
                'transactiondt_fprice' => $details->transactiondttmp_fprice,
                'transactiondt_fpriceBase' => $details->transactiondttmp_fpriceBase,
                'transactiondt_priceBase' => $details->transactiondttmp_priceBase,
                'hscode' => $details->hscode,
                'transactiondt_item_description' => $details->transactiondt_item_description,
                'reference_internal_dt' => $details->reference_internal_dt

            );

            $checkIfExist =  transactionDt::where(
                'reference_internal_dt',
                $details->transactiondttmp_id
            )->first();

            if($checkIfExist){
                transactionDt::where(
                    'reference_internal_dt',
                    $details->transactiondttmp_id
                )->update([
                    'item_quantity' => $details->item_quantity,
                    'item_id' => $details->item_id,
                   // 'client_id' => $details->relatedTransferId,
                    'item_quantity' => $details->item_quantity,
                    'supplier_id' => $details->supplier_id,
                    'supplier_invoice_number' => $details->supplier_invoice_number,
                    'transactiondt_locationid' => $details->transactiondttmp_locationid,
                    'transactiondt_countryOfOrigin' => $details->transactiondttmp_countryOfOrigin,
                    'transactiondt_price' => $details->transactiondttmp_price,
                    'transactiondt_billOfEntry' => $details->transactiontmpdt_billOfEntry,
                    'raw_in_grid' => $details->raw_in_grid,
                    'item_weight' => $details->item_weight,
                    'item_unit' => $details->item_unit,
                    'item_qtyPerPack' => $details->item_qtyPerPack,
                    'item_pack' => $details->item_pack,
                    'group_id' => $details->group_id,
                    'palet_no' => $details->palet_no,
                    'transactiondt_nbOfCarton' => $details->transactiondttmp_nbOfCarton,
                    'transactiondt_cellMerge' => $details->transactiondttmp_cellMerge,
                    //  'transactiondt_BOE' => $BOE,
                  //  'client_id' => $details->client_id,
                    'transactiondt_fprice' => $details->transactiondttmp_fprice,
                    'transactiondt_fpriceBase' => $details->transactiondttmp_fpriceBase,
                    'transactiondt_priceBase' => $details->transactiondttmp_priceBase,
                    'hscode' => $details->hscode,
                    'transactiondt_item_description' => $details->transactiondt_item_description,
                ]);
            }else{
                $response =transactionDt::create($transactionDtArray);
                
            }
           
        }
        transactiontmp::where('transactiontmp_id', $transferTrans->transactiontmp_id)->delete();
    }

    //remaining qty , depend on original and tmp
    public static function remainingQty($dtId)
    {

        $totalEntry = DB::table('transaction_dts')
            ->where('transactiondt_id', $dtId)
            ->SUM('item_quantity');


        $totalExit = DB::table('transaction_dts')
            ->where('id_reference_dt', $dtId)
            ->SUM('item_quantity');

        $totalremaining = $totalEntry - $totalExit;


        return $totalremaining;
    }
}
