<?php

namespace App\Models;

use App\Http\Controllers\BackOffice\Utilities\UtilitiesController;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class transactiontmp extends Model
{
    use HasFactory;

    public $timestamps = true;
    protected $primaryKey = 'transactiontmp_id';
    protected $fillable = [
        'transactiontmp_id',
        'transaction_time',
        'transactiontmp_reference',
        'transactiontmp_date',
        'transactiontmp_driverPhone',
        'transactiontmp_billOfEntry',
        'transactiontmp_clientId',
        'transactiontmp_type',
        'transactiontmp_remark',
        'transactiontmp_typeOfDeliveryId',
        'transactiontmp_customerId',
        'transactiontmp_shipmentReference',
        'transactiontmp_mobileReference',
        'user_id',
        'clientCustomer_id',
        'forwarder_id',
        'transactiontmp_driverName',
        'transactiontmp_vehicleNumber',
        'transactiontmp_exitPoint',
        'transactiontmp_destinationPoint',
        'company_id',
        'transactiontmp_paymentMethodId',
        'transactiontmp_customBillTypeId',
        'transactiontmp_currencyId',
        'transactiontmp_shipmentTypeId',
        'transactiontmp_shipById',
        'transactiontmp_shipmentRemark',
        'transactiontmp_supplierId',
        'transactiontmp_supplierInvoice',
        'transactiontmp_enterSerial',
        'transactiontmp_totalQty',
        'transactiontmp_totalPallet',
        'transaction_totalPrice',
        'transaction_totalItem',
        'transactiontmp_BOE',
        'salesjv_id',
        "transactiontmp_rate",
        'Invoice_type_id',
        'payment_term_id',
        'delivery_term_id',
        'exemption_type_id',
        'internal_transfer',
        'transferTo_clientId',
        'relatedTransferId',
        'transaction_released_DEC',
        'showInDocument',
        'transaction_arrived',
        'payment_methods',
        'way_bill_no',
        'tir',
        'job_no',
        'salesjv_discount'
    ];

    public static function updateTransaction($transactionTmpId, $data)
    {
        self::where('transactiontmp_id', '=', $transactionTmpId)
            ->update($data);
        return self::getTransaction($transactionTmpId);
    }

    public static function getTransaction($transactionTmpId)
    {
        return self::where('transactiontmp_id', '=', $transactionTmpId)
            ->first();
    }

    public static function createInternalTransaction($payload)
    {
        $utilitiesController = new UtilitiesController();
        $transactionType=$payload['transactionType'];
        $transactionClient=$payload['transactionClient'];
        $transactionDate=$payload['transactionDate'];
        $transactionClientTo=$payload['transactionClientTo'];
        $userId=$payload['userId'];
        $transactiontmp_id=$payload['transactiontmp_id'];
        $companyId=$payload['companyId'];

        if ($transactionType == "INTERNAL_TRANSFER") {
            $client = client::where([
                ['client_id', $transactionClient]
            ])->first();
            $currencyBase = companies::select('currency')->first()->currency;
            $transactionInternalTmp = array(
                'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($transactionDate . "" . date('H:i:s')),
                'transactiontmp_type' => "GOODS_IN",
                'transactiontmp_remark' => "Transfer from " . $client->client_firstname,
                'transactiontmp_clientId' => $transactionClientTo,
                'transactiontmp_currencyId' => $currencyBase,
                'internal_transfer' => transactions::transactionTypes["$transactionType"]["internalTransfer"],
                'user_id' => $userId,

                'relatedTransferId' => $transactiontmp_id,
                'company_id' => $companyId,
            );
            transactiontmp::create($transactionInternalTmp);
            //  $this->addGoodsInInternal();
        }
    }

    public static function updateInternalTransaction($request, $companyId, $userId)
    {
        $utilitiesController = new UtilitiesController();

        if ($request->transactionType == "INTERNAL_TRANSFER") {
            $client = client::where([
                ['client_id', $request->transactionClient]
            ])->first();
            $transactionInternalTmp = array(
                'transactiontmp_date' => $utilitiesController->convertTodayToTimetsamp($request->transactionDate . "" . date('H:i:s')),
                'transactiontmp_type' => "GOODS_IN",
                'transactiontmp_remark' => "Transfer from " . $client->client_firstname,
                'transactiontmp_clientId' => $request->transactionClientTo,
                'internal_transfer' => transactions::transactionTypes["$request->transactionType"]["internalTransfer"],
                'user_id' => $userId,
                'relatedTransferId' => $request->transactionTmpId,
                'company_id' => $companyId,
            );
            transactiontmp::where('relatedTransferId', '=', $request->transactionTmpId)
                ->update($transactionInternalTmp);
        }
    }
}
