<?php


namespace App\Traits;

use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Throwable;

trait Firebase
{

    public function firebaseNotification($fcmNotification)
    {

        try {
            $fcmUrl = config('firebase.fcm_url');

            $apiKey = config('firebase.fcm_api_key');

            $http = Http::withHeaders([
                'Authorization' => 'Bearer ' . $apiKey,
                'Content-Type' => 'application/json; UTF-8'
            ])->post($fcmUrl, $fcmNotification);

            return $http->json();
        } catch (Throwable $th) {
            return 0;
        }
    }



    public function firebaseNotificationUsers($payload)
    {
        $url =config('firebase.fcm_url');


        // Send the request to Firebase Cloud Messaging (FCM)
        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->getAccessToken(), // Get OAuth2 token
            'Content-Type'  => 'application/json',
        ])->post($url, $payload);

        return $response; // Return the response
    }

    /**
     * Get OAuth 2.0 Access Token for FCM v1 API (JWT)
     * (Can use Google API Client library for this step or generate it manually)
     */
    private function getAccessToken()
    {
        if (Cache::has('firebase_access_token')) {
            // Caching firebase access token for 55 minutes,
            // instead for calling google apis for generating access token on each call.
            Log::info('Cached FB AccessToken', [
                'Cached FB AccessToken' => Cache::get('firebase_access_token')
            ]);
            return Cache::get('firebase_access_token');
        }

        $serviceAccountPath = storage_path('app/google-service-account.json');

        // Define the required scope for Firebase Cloud Messaging (FCM)
        $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

        // Create the credentials using the service account JSON and the required scope
        $credentials = new ServiceAccountCredentials($scopes, $serviceAccountPath);

        // Fetch the OAuth 2.0 access token
        $accessToken = $credentials->fetchAuthToken()['access_token'];

        Cache::put('firebase_access_token', $accessToken, now()->addMinutes(55));
        // Return the access token
        return $accessToken;
    }
}
