<?php

use App\Models\user;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('user_name', 50);
            $table->string('password', 100);
            $table->boolean('user_isActive')->default(false);
            $table->timestamp('user_lastactive');
            $table->string('user_created', 50)->nullable();
            $table->string('user_token', 100);
            $table->string('user_pushToken', 100)->nullable();
            $table->integer('user_role_id');
            $table->integer('company_id');
            $table->string('user_email', 100)->nullable();
            $table->string('user_phone', 100)->nullable();
            $table->string('name', 100)->nullable();


        });

        user::query()->create([
            'user_name' => "admin",
            'password' => bcrypt("0000"),
            'user_isActive' => true,
            'user_token' => "",
            'user_role_id' => "1",
            'company_id' => "1",
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
