<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->bigIncrements('client_id');
            $table->string('client_firstname', 50);
            $table->string('client_lastname', 50);
            $table->string('client_address', 50)->nullable();
            $table->integer('client_country');
            $table->string('client_phone', 20);
            $table->string('client_email', 50);
            $table->string('client_contact', 50);
            $table->bigInteger('client_rma_reference')->default(0);
            $table->bigInteger('client_delivery_reference')->default(0);
            $table->boolean('client_isActive')->default(true);


            $table->string('client_phone_code')->nullable();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('clients');
    }
}
