<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigInteger('transaction_id')->unsigned()->primary();
            $table->bigInteger('transaction_reference');
            $table->bigInteger('transaction_date');
            $table->bigInteger('transaction_clientId');
            $table->string('transaction_type', 20);
            $table->string('transaction_remark', 156)->nullable();
            $table->bigInteger('transaction_typeOfDeliveryId')->nullable();
            $table->bigInteger('transaction_shipById')->nullable();
            $table->bigInteger('clientCustomer_id')->nullable();
            $table->bigInteger('transaction_mobileReference')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
