<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionDtsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_dts', function (Blueprint $table) {
            $table->bigInteger('transactiondt_id')->unsigned()->primary();
            $table->bigInteger('transaction_id')->unsigned();
            $table->bigInteger('item_id');
            $table->bigInteger('item_quantity');
            $table->bigInteger('supplier_id')->index()->nullable();
            $table->bigInteger('supplier_invoice_number')->nullable();
            $table->bigInteger('transactiondt_locationid')->nullable();
            $table->string('group_id')->nullable();
            $table->string('item_qtyPerPack')->nullable();
            $table->string('palet_no')->nullable();
            $table->string('item_pack')->nullable();


            $table->foreign('transaction_id')->references('transaction_id')->on('transactions')->onDelete('CASCADE');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_dts');
    }
}
