<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionDtsnsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transaction_dtsns', function (Blueprint $table) {
            $table->bigIncrements('transactiondtsn_id')->unsigned();
            $table->bigInteger('transactiondt_id')->unsigned();
            $table->string('transaction_item_serial', 50)->nullable();
            $table->bigInteger('item_id');
            $table->string('file_name', 50);
            $table->foreign('transactiondt_id')->references('transactiondt_id')->on('transaction_dts')->onDelete('CASCADE');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_dtsns');
    }
}
