<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactiontmpsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactiontmps', function (Blueprint $table) {
            $table->bigIncrements('transactiontmp_id')->unsigned();
            $table->bigInteger('transactiontmp_reference')->nullable();
            $table->bigInteger('transactiontmp_date')->nullable();
            $table->bigInteger('transactiontmp_clientId');
            $table->string('transactiontmp_type', 20);
            $table->string('transactiontmp_remark', 156)->nullable();
            $table->bigInteger('transactiontmp_typeOfDeliveryId')->nullable();
            $table->bigInteger('transactiontmp_shipById')->nullable();

            $table->bigInteger('transactiontmp_customerId')->nullable();
            $table->bigInteger('transactiontmp_mobileReference')->nullable();
            $table->bigInteger('transactiontmp_shipmentReference')->nullable();
            $table->string('transactiontmp_billOfEntry', 64)->nullable();
            $table->bigInteger('user_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactiontmps');
    }
}
