<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactiondttmpsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactiondttmps', function (Blueprint $table) {
            $table->bigIncrements('transactiondttmp_id');
            $table->bigInteger('transactiontmp_id')->unsigned();
            $table->bigInteger('item_id');
            $table->bigInteger('item_quantity');
            $table->bigInteger('supplier_id')->index()->nullable();
            $table->bigInteger('supplier_invoice_number')->nullable();
            $table->bigInteger('transactiondttmp_locationid')->nullable();
            $table->bigInteger('transactiondttmp_countryOfOrigin')->nullable();
            $table->string('palet_no')->nullable();
            $table->boolean('isMobile')->default(false);
            $table->string('group_id')->nullable();
            $table->foreign('transactiontmp_id')->references('transactiontmp_id')->on('transactiontmps')->onDelete('CASCADE');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactiondttmps');
    }
}
