<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTransactions2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('transactions', function (Blueprint $table) {
            //  $table->bigInteger('clientCustomer_id')->nullable();
            $table->bigInteger('forwarder_id')->index()->nullable();
            $table->string('transaction_driverName', 32)->nullable();
            $table->string('transaction_vehicleNumber', 32)->nullable();
            $table->string('transaction_exitPoint', 32)->nullable();
            $table->string('transaction_destinationPoint', 32)->nullable();
            $table->bigInteger('company_id')->index()->nullable();
            $table->bigInteger('transaction_paymentMethodId')->index()->nullable();
            $table->bigInteger('transaction_customBillTypeId')->index()->nullable();
            $table->bigInteger('transaction_currencyId')->index()->nullable();
            $table->bigInteger('transaction_shipmentTypeId')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('transactions', function (Blueprint $table) {
            //
        });
    }
}
